/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<stdlib.h>
#include	<stdio.h>
#include	<sys/types.h>
#include	"r64.h"
#include	"machine/include.h"
#include	"u_file.h"

int
r64_check_level(R64_FILE * f,int level)
{
unsigned int ofs;
INTEGER64 ret;
	if ( level < 0 )
		return 0;
	if ( level >= LEVEL_OFS_LEN )
		return 0;
	if ( f->level_ofs[level] == 0 )
		return 0;
	ofs = f->level_ofs[level];
	ofs += f->level_w[level]*f->level_h[level]*ENT_UNIT_VOL(f);
	ret = u_lseek64(f->fd,0,SEEK_END);
	if (ret < ofs )
		return 0;
	return 1;
}
