/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#define STREAM_LIB

#include	"task.h"
#include	"stream.h"
#include	"utils.h"
#include	"pri_level.h"


extern SEM stream_lock;


int
s_get_socketip(STREAM * s)
{
int ret;
int pri;
	pri = push_pri(PRI_NETWORK);
	lock_task(stream_lock);
	if ( s == 0 ) {
		ret = 0;
		goto end;
	}
	if ( s->h.check_ptr != &s->h ) {
		ret = 0;
		goto end;
	}
	if ( s->h.tbl == 0 ) {
		ret = 0;
		goto end;
	}
	ret = (*s->h.tbl->get_socketip)(s);
end:
	unlock_task(stream_lock,"s_get_socketip");
	change_pri(0,pri);
	return ret;
}

