/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"utils.h"
#include	"netutils.h"
#include	"memory_debug.h"

int
_cmp(L_CHAR * a,L_CHAR *b)
{
	if ( a && b ) {
		if ( l_strcmp(a,b) )
			return -1;
	}
	else if ( a == 0 && b )
		return -1;
	else if ( a && b == 0 )
		return -1;
	return 0;
}

int
_cmp_server(L_CHAR * s1,L_CHAR * s2)
{
int my_ip;
char * _s1,*_s2;
int ret;
	_s1 = ln_copy_str(std_cm,s1);
	_s2 = ln_copy_str(std_cm,s2);
	if ( s1 && s2 ) {
		ret =  hostcmp(
			_s1,
			getHA_v4(0),
			_s2,
			getHA_v4(0));
		goto end;
	}
	my_ip = get_xllisp_site_ip().d.v4;
	if ( s1 ) {
		ret = hostcmp(
			_s1,
			getHA_v4(0),
			0,
			getHA_v4(my_ip));
		goto end;
	}
	else if ( s2 ) {
		ret = hostcmp(
			0,
			getHA_v4(my_ip),
			_s2,
			getHA_v4(0));
		goto end;
	}
	else	ret = 0;
end:
	d_f_ree(_s1);
	d_f_ree(_s2);
	return ret;
}

int
url_cmp(URL * a,URL * b)
{
	if ( _cmp(a->proto,b->proto) )
		return -1;
	if ( _cmp_server(a->server,b->server) )
		return -1;
	if ( a->port != b->port )
		return -1;
	if ( _cmp(a->db,b->db) )
		return -1;
	if ( _cmp(a->resource,b->resource) )
		return -1;
	return 0;
}

int
url_cmp_str(URL * a,URL * b)
{
	if ( _cmp(a->proto,b->proto) )
		return -1;
	if ( _cmp(a->server,b->server) )
		return -1;
	if ( a->port != b->port )
		return -1;
	if ( _cmp(a->db,b->db) )
		return -1;
	if ( _cmp(a->resource,b->resource) )
		return -1;
	return 0;
}



