/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"
#include	"associate.h"

XL_SEXP * xl_ConvertCode();
L_CHAR *cc_string(L_CHAR * str,LCZ_SET * set);

void
init_ConvertCode(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"ConvertCode"),
		get_func_prim(xl_ConvertCode,FO_NORMAL,0,2,2));
}

XL_SEXP *
xl_ConvertCode(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * type;
XL_SEXP * st;
CODE_METHOD * cm;
L_CHAR * _cm;
	_cm = get_sf_attribute(sf,l_string(std_cm,"code"));
	if ( _cm == 0 )
		cm = std_cm;
	else {
		cm = search_cm(n_string(std_cm,_cm));
		if ( cm == 0 )
			goto inv_param;
	}
	type = get_sf_attribute(sf,l_string(std_cm,"type"));
	st = gb_quote_trace(env,get_el(s,1),type);
	return convert_code(st,cm->main_code,CBF_ERR_KEEP);
/*
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"ConvertCode"),
		n_get_string("type missmatch"));
*/
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"ConvertCode"),
		n_get_string("invalid code name"));
}

