/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_CutOut();
XL_SEXP *
xl_CutOut_raw(XL_SEXP * r,int i1,int i2);


void
init_CutOut(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"CutOut"),
		get_func_prim(xl_CutOut,FO_APPLICATIVE,0,3,4));
}


XL_SEXP *
xl_CutOut_raw(XL_SEXP * r,int i1,int i2)
{
	if ( i2 < 0 ) {
	i2_ignore:
		return get_raw(&((char*)r->raw.data)[i1],
			r->raw.size - i1);
	}
	else if ( r->raw.size <= i2 ) {
		goto i2_ignore;
	}
	else {
		return get_raw(&((char*)r->raw.data)[i1],
			i2 - i1);
	}
}


XL_SEXP *
xl_CutOut(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * s1;
XL_SEXP * s2;
XL_SEXP * ss;
XL_SEXP * r;
XL_SEXP * ret;
int i, i1, i2;
int len;
	i2 = -1;
	len = list_length(s);
	ss = get_el(s,1);
	s1 = get_el(s,2);
	if ( (get_type(s1) != XLT_INTEGER) )
		goto type_missmatch;
	if ( len == 4 ) {
		s2 = get_el(s,3);
		if ( (get_type(s2) != XLT_INTEGER) )
			goto type_missmatch;
	}
	i1 = s1->integer.data;
	if ( len == 4 ) {
		i2 = s2->integer.data;
		if ( i1 > i2 ) {
			return get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_INV_PARAM,
				l_string(std_cm,"CutOut"),
				0);
		}
	}
	switch ( get_type(ss) ) {
	case XLT_PAIR:
		break;
	case XLT_RAW:
		return xl_CutOut_raw(ss,i1,i2);
	default:
		goto type_missmatch;
	}
	
	

	for ( i = 0 ; (i < i1) && (get_type(ss) == XLT_PAIR) ; i ++, ss = cdr(ss) ) ;
	if ( len == 4 ) {
		for ( r = 0 ; (i <= i2) && (get_type(ss) == XLT_PAIR) ; i ++, ss = cdr(ss) )
			r = cons(car(ss),r);
	}
	else {
		for ( r = 0 ; (get_type(ss) == XLT_PAIR) ; i ++, ss = cdr(ss) )
			r = cons(car(ss),r);
	}
	for ( ret = 0 ; get_type(r) ; r = cdr(r) )
		ret = cons(car(r),ret);
/*
	set_inh(ret);
*/
	return ret;

type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"CutOut"),
		0);
}

