/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"memory_debug.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"utils.h"

XL_SEXP * xl_GetXLTime();

void
init_GetXLTime(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"GetXLTime"),
		get_func_prim(xl_GetXLTime,FO_APPLICATIVE,0,1,1));
}



XL_SEXP *
xl_GetXLTime(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * fmt;
XL_SEXP * ret;
char * _ret;
	fmt = get_sf_attribute(sf,l_string(std_cm,"format"));
	if ( fmt == 0 )
		goto sec;
	if ( l_strcmp(fmt,l_string(std_cm,"W3C-DTF")) == 0 )
		goto w3c_dtf;
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"GetXLTime"),
		List(n_get_string("invalid format attribute"),-1));
w3c_dtf:
	_ret = get_xltime_str(get_xltime(),TFMT_W3C_DTF);
	if ( _ret == 0 )
		er_panic("xl_GetXLTime(!)");
	ret = n_get_string(_ret);
	d_f_ree(_ret);
	return ret;
sec:
	return get_integer(get_xltime(),l_string(std_cm,"sec"));
}

