/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<stdlib.h>
#include	"memory_debug.h"
#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_Touch();

void
init_Touch(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Touch"),
		get_func_prim(xl_Touch, FO_APPLICATIVE, 0, 2, 2));
}

XL_SEXP *
xl_Touch(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * file;
char *path;
int ret;
int fid;

	file = get_el(s,1);
	if(get_type(file) != XLT_STRING){
		goto type_missmatch;
	}
	path = n_string(std_cm, file->string.data);
	path = change_delim_str(path);
	ret = m_utime(path, NULL);
	if(ret == -1){
		fid = u_open(path, O_CREAT, 0644);
		if(fid==-1){
			d_f_ree(path);
			goto error_create_file;
		}
		u_close(fid);
	}
	d_f_ree(path);
	return get_integer(ret, 0);

type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Touch"),
		List(n_get_string("filename is type missmatch"),
			-1));
error_create_file:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_OPEN_FILE,
		l_string(std_cm,"Touch"),
		List(file,
			n_get_string(" can not create file "),
			-1));
}

