/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"task.h"
#include	"avt.h"
#include	<string.h>
#include	"memory_debug.h"
#include	"xl.h"
#include	"gif.h"
#include	"xlerror.h"
#include	"lock_level.h"
#include	"pri_level.h"
#include	"jpeg.h"


int ri_cmp(RAW_IMAGE * ri1,RAW_IMAGE * ri2);
RAW_IMAGE * _search_ri(L_CHAR * path);
void *
_search_ri_org(int * err,int * len,L_CHAR * path);


RAW_IMAGE_HEADER ri_root;
AVT_NODE * avt_ri_root;
SEM	ri_lock;
int ri_count;
SYS_QUEUE ri_que1;

void fetch_task(TKEY);
void ri_tick();

void
init_xl_ri()
{
	ri_lock = new_lock(LL_RAW_IMAGE);
	ri_root.ri_next = ri_root.ri_prev = (RAW_IMAGE*)&ri_root;
	ri_count = 0;
	avt_ri_root = 0;


	memset(&ri_que1,0,sizeof(SYS_QUEUE));
	ri_que1.flags = QF_STACK;
	ri_que1.gc_func = 0;
	ri_que1.gc_get = 0;
	ri_que1.key_func = fetch_task;
	ri_que1.pri = PRI_FETCH_STRONG;
	setup_queue(&ri_que1);
	
	new_tick((void(*)(int))ri_tick,30,0);

//	create_task(fetch_task,0,PRI_FETCH_STRONG);
}

void
insert_ri_ring(RAW_IMAGE * ri)
{
	ri->h.ri_prev = (RAW_IMAGE*)&ri_root;
	ri->h.ri_next = ri_root.ri_next;
	ri->h.ri_prev->h.ri_next = ri;
	ri->h.ri_next->h.ri_prev = ri;
}

void
delete_ri_ring(RAW_IMAGE * ri)
{
	ri->h.ri_prev->h.ri_next = ri->h.ri_next;
	ri->h.ri_next->h.ri_prev = ri->h.ri_prev;
}

int ri_cmp(RAW_IMAGE * ri1,RAW_IMAGE * ri2)
{
	return l_strcmp(ri1->path,ri2->path);
}

void
_insert_ri(ri_que_cf func,void * cf_data,L_CHAR * path)
{
AVT_NODE * a1, * a2;
RAW_IMAGE * ri;
URL u;
	ri = new_queue_node(sizeof(*ri));
	ri->path = ll_copy_str(path);
	ri->width = 0;
	ri->height = 0;
	ri->err = RIE_REQ;
	ri->ri_que = d_alloc(sizeof(RI_QUEUE));
	ri->ri_que->call_function = func;
	ri->ri_que->data = 0;
	ri->ri_que->ri = ri;
	ri->ri_que->next = 0;
	if( func )
		(*func)(RICT_COPY,ri->ri_que,cf_data);

	ri->ndata = 0;
	ri->ndata_len = 0;
	ri->data = 0;
	a1 = d_alloc(sizeof(*a1));
	a1->data = ri;
	a2 = avt_insert(&avt_ri_root,a1,ri_cmp);
	if ( a2 == a1 ) {
		insert_ri_ring(ri);
		ri_count ++;
	}
	else {
		if ( ri->data )
			d_f_ree(ri->data);
		if ( ri->ndata )
			d_f_ree(ri->ndata);
		d_f_ree(ri->path);
		d_f_ree(ri);
		d_f_ree(a1);
		ri = a2->data;
		delete_ri_ring(ri);
		insert_ri_ring(ri);
	}
	get_url2(&u,path);
	ri->h.h.key = get_server_key(&u,0);
	insert_queue(&ri_que1,ri,1);
	free_url(&u);
}


void
delete_ri(L_CHAR * path)
{
AVT_NODE * a1;
RAW_IMAGE ri;
RAW_IMAGE * rip;
	lock_task(ri_lock);
	ri.path = path;
	a1 = avt_delete(&avt_ri_root,&ri,ri_cmp);
	if ( a1 == 0 ) {
		unlock_task(ri_lock,"delete_ri");
		return;
	}
	rip = a1->data;
	delete_ri_ring(rip);
	d_f_ree(rip->path);
	if ( rip->data )
		d_f_ree(rip->data);
	if ( rip->ndata )
		d_f_ree(rip->ndata);
	d_f_ree(rip);
	ri_count --;
	unlock_task(ri_lock,"delete_ri");
}

RAW_IMAGE *
_search_ri(L_CHAR * path)
{
RAW_IMAGE ri, * rip;
AVT_NODE * a1;

	ri.path = path;
	a1 = avt_search(avt_ri_root,&ri,ri_cmp);
	if ( a1 == 0 ) {
		return 0;
	}
	rip = a1->data;
	delete_ri_ring(rip);
	insert_ri_ring(rip);
	return rip;
}

void *
_search_ri_org(int * err,int * len,L_CHAR * path)
{
RAW_IMAGE ri, * rip;
AVT_NODE * a1;

retry:
	ri.path = path;
	a1 = avt_search(avt_ri_root,&ri,ri_cmp);
	if ( a1 == 0 ) {
		*len = -1;
		return 0;
	}
	rip = a1->data;
	delete_ri_ring(rip);
	insert_ri_ring(rip);
	if ( rip->err > 0 ) {
		sleep_task((int)rip,ri_lock);
		lock_task(ri_lock);
		goto retry;
	}
	if ( rip->err < 0 ) {
		*len = -1;
		*err = rip->err;
		return 0;
	}
	*err = rip->err;
	*len = rip->ndata_len;
	return rip->ndata;
}



void *
get_data(int * size,XL_SEXP * data)
{
void * ret;
char * ptr;
XL_SEXP * a, * b;
int s;

	a = data;
	s = 0;
	for ( ; get_type(a) ; a = cdr(a) ) {
		b = car(a);
		if ( get_type(b) != XLT_RAW )
			continue;
		s += b->raw.size;
	}
	ret = d_alloc(s);

	ptr = ret;
	a = data;
	for ( ; get_type(a) ; a = cdr(a) ) {
		b = car(a);
		if ( get_type(b) != XLT_RAW )
			continue;
		memcpy(ptr,b->raw.data,b->raw.size);
		ptr += b->raw.size;
	}
	*size = s;
	return ret;
}

void *
get_from_network(XL_SEXP ** err,int ses,int * size,L_CHAR * path)
{
XL_SEXP * ret;
URL u;
void gc_gb_sexp();
L_CHAR * f;

	get_url2(&u,path);
	gc_push(0,0,"raw_image");
printf("request\n");
	ret = remote_session(
		gblisp_top_env0,
		ses,
		&u,
		l_string(std_cm,"standard"),
		l_string(std_cm,"user"),
		l_string(std_cm,"Get"),
		List(List(get_symbol(l_string(std_cm,"Get")),
			get_string(f=get_url_filepath(&u)),
			-1),
			-1),
		0,0,0,0);
	d_f_ree(f);
	gc_pop(ret,gc_gb_sexp);
	switch ( get_type(ret) ) {
	case XLT_ERROR:
		ss_printf("raw Image error %ls ",path);
		print_sexp(s_stdout,ret,0);
		ss_printf("\n");
		*err = ret;
		return 0;
	case XLT_PAIR:
		return get_data(size,ret);
	default:
		printf("raw image type missmatch\n");
		return 0;
	}
	return 0;
}


void *
decompress(XL_SEXP ** err,int * w,int * h,
	void * data,int src_size,
	L_CHAR * path)
{
int pref;
void * ret,*ret2;
GIF_ENV ge;
int * dt1,*dt2,*dt;
int i;
int c;
RGB4 * rgb;
	for ( pref = l_strlen(path)-1 ; pref >= 0 ; pref -- )
		if ( path[pref] == '.' )
			break;
	if ( pref < 0 )
		goto unsupport;
	if ( l_strcmp(&path[pref],l_string(std_cm,".gif")) == 0 ) {
		ret = gif_uncompress(
			w,h,
			&ge,
			data,
			src_size);
		if ( ret == 0 )
			goto unsupport;
		dt = ret;
		for ( i = 0 ; i < (*w)*(*h) ; i ++ ) {
			rgb = (RGB4*)dt;
			c = (rgb->r<<(COL_BIT-8))|
				(rgb->g<<(COL_BIT*2-8))|
				(rgb->b<<(COL_BIT*3-8));
			*dt = c;
			dt ++;
		}
	}
	else if ( l_strcmp(&path[pref],l_string(std_cm,".jpg")) == 0 ||
			l_strcmp(&path[pref],l_string(std_cm,".jpeg")) == 0 ) {
		ret = jpeg_uncompress(
			w,h,
			data,
			src_size);
		if ( ret == 0 )
			goto unsupport;
		ret2 = d_alloc((*w)*(*h)*sizeof(int));
		dt2 = (int*)ret2;
		dt1 = ret;
		for ( i = 0 ; i < (*w)*(*h) ; i ++ ) {
			rgb = (RGB4*)dt1;
			c = (rgb->r<<(COL_BIT-8))|
				(rgb->g<<(COL_BIT*2-8))|
				(rgb->b<<(COL_BIT*3-8));
			*dt2 = c;
			dt1 ++;
			dt2 ++;
		}
		free(ret);
		ret = ret2;
	}
	else {
		goto unsupport;
	}
	return ret;
unsupport:
	*w = *h = 0;
	*err = get_error(
		0,0,
		XLE_PROTO_UNDEF_RESOURCE,
		l_string(std_cm,"raw_image"),
		List(n_get_string("undefined the image data"),
			get_string(path),
			-1));
	return 0;
}

void
fetch_task(TKEY d)
{
RAW_IMAGE * ri;
void * data,* ndata;
int w,h;
int ses;
XL_SEXP * err;
XL_INTERPRETER * xli;
int s;
RI_QUEUE * rq,* rq1;
SYS_QUEUE * que;
L_CHAR * key;

	que = (SYS_QUEUE *)GET_TKEY(d);
	key = touch_qkey(que);
	if ( key == 0 )
		return;

	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);

	ses = open_session(SEST_OPTIMIZE);
	for ( ; ; ) {
		gc_push(0,0,"fetch_task");
		ri = delete_queue(que,sq_key_cond,key,0);
		if ( ri == 0 ) {
			gc_pop(0,0);
			break;
		}

		err = 0;
		ndata = get_from_network(&err,ses,&s,ri->path);
		if ( ndata == 0 ) {
			lock_task(ri_lock);
			ri->err = RIE_ERR;
			wakeup_task((int)ri);

			rq1 = ri->ri_que;
			ri->ri_que = 0;
			unlock_task(ri_lock,"get_ri");
			for ( ; rq1 ; ) {
				rq = rq1;
				rq1 = rq1->next;
				if ( rq->call_function ) {
					(*rq->call_function)(RICT_CALL,rq,0);
					(*rq->call_function)(RICT_DELETE,rq,0);
				}
				d_f_ree(rq);
			}

			gc_pop(0,0);
			continue;
		}
		data = decompress(&err,&w,&h,ndata,s,ri->path);
		if ( data == 0 ) {
			d_f_ree(ndata);

			lock_task(ri_lock);
			ri->err = RIE_ERR;
			wakeup_task((int)ri);
			rq1 = ri->ri_que;
			ri->ri_que = 0;
			unlock_task(ri_lock,"get_ri");
			for ( ; rq1 ; ) {
				rq = rq1;
				rq1 = rq1->next;
				if ( rq->call_function ) {
					(*rq->call_function)(RICT_CALL,rq,0);
					(*rq->call_function)(RICT_DELETE,rq,0);
				}
				d_f_ree(rq);
			}
			ss_printf("decompress error");
			print_sexp(s_stderr,err,0);
			ss_printf("\n");
			gc_pop(0,0);
			continue;
		}
		gc_pop(0,0);
ss_printf("DATA OK %i %i\n",w,h);
		lock_task(ri_lock);
		ri->ndata = ndata;
		ri->ndata_len = s;
		ri->data = data;
		ri->width = w;
		ri->height = h;
		ri->err = RIE_OK;
		rq1 = ri->ri_que;
		ri->ri_que = 0;
		wakeup_task((int)ri);
		unlock_task(ri_lock,"get_ri");
		for ( ; rq1 ; ) {
			rq = rq1;
			rq1 = rq1->next;
			if ( rq->call_function ) {
				(*rq->call_function)(RICT_CALL,rq,0);
				(*rq->call_function)(RICT_DELETE,rq,0);
			}
			d_f_ree(rq);
		}

		lock_task(ri_lock);
		for ( ; ri_count >= RI_COUNT_MAX ; ) {
			ri = ri_root.ri_prev;
			for ( ; ri != (RAW_IMAGE*)&ri_root ; ri = ri->h.ri_prev ) {
				if ( ri->err == RIE_REQ )
					continue;
				unlock_task(ri_lock,"get_ri");
				delete_ri(ri->path);
				lock_task(ri_lock);
				break;
			}
		}
		unlock_task(ri_lock,"get_ri");
	}

	release_qkey(que,key);
	d_f_ree(key);

	close_session(ses);
	close_self_interpreter();

}


void *
xl_get_ri(int * err,int * w,int * h,ri_que_cf func,void * cf_data,L_CHAR * path)
{
RAW_IMAGE * rip;
void * data;
RI_QUEUE * rq;

	data = 0;
	lock_task(ri_lock);
	rip = _search_ri(path);
	if ( rip == 0 ) {
		_insert_ri(func,cf_data,path);
		wakeup_task((int)&ri_root);
		data = 0;
		*err = RIE_REQ;
		goto end;
	}
	switch ( rip->err ) {
	case RIE_OK:
		data = rip->data;
		*w = rip->width;
		*h = rip->height;
		*err = RIE_OK;
		break;
	case RIE_REQ:
		if ( func == 0 )
			goto ok;
		for ( rq = rip->ri_que ; rq ; rq = rq->next ) {
			if ( rq->call_function != func )
				continue;
			if ( (*rq->call_function)(RICT_CMP,rq,cf_data) == 0 )
				goto ok;
		}
		rq = d_alloc(sizeof(*rq));
		rq->ri = rip;
		(*func)(RICT_COPY,rq,cf_data);
		rq->call_function = func;
		rq->next = rip->ri_que;
		rip->ri_que = rq;
	ok:
		*err = RIE_REQ;
		break;
	case RIE_ERR:
		*err = RIE_ERR;
		data = 0;
		break;
	default:
		er_panic("get_ri");
	}
end:
	unlock_task(ri_lock,"get_ri");
	return data;
}



void *
xl_search_ri_org(int * err,int * len,L_CHAR * path)
{
void * ret;
int w,h;
int er;
	xl_get_ri(&er,&w,&h,0,0,path);
	if ( er == RIE_REQ ) {
		lock_task(ri_lock);
		ret = _search_ri_org(&er,len,path);
		unlock_task(ri_lock,"search_ri_org");
	}
	*err = er;
	return ret;
}


void
ri_tick()
{
RAW_IMAGE * ri;
RI_QUEUE * rq;

	lock_task(ri_lock);
	for ( ri = ri_root.ri_next ; ri != (RAW_IMAGE*)&ri_root ; ri = ri->h.ri_next ) {
		if ( ri->err != RIE_REQ )
			continue;
		for ( rq = ri->ri_que ; rq ; rq = rq->next ) {
			if ( rq->call_function == 0 )
				continue;
			if ( (*rq->call_function)(RICT_TICK,rq,0) == 0 )
				continue;
			(*rq->call_function)(RICT_DELETE,rq,0);
			rq->call_function = 0;
			rq->data = 0;
		}
	}
	unlock_task(ri_lock,"ri_tick");
}


