/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"task.h"
#include	"memory_debug.h"
#include	"memory_routine.h"
#include	"xl.h"
#include	"xlerror.h"
#include	"mlong_char.h"


XLISP_ENV *
set_listbase_env(XL_SEXP * se,XLISP_ENV * target)
{
XL_SEXP * el;
XL_SEXP * t,*t2;
XLISP_ENV * ret;
int i;
XLISP_ENV * p[2];
	el = get_el_by_symbol(se,l_string(std_cm,"type"),0);
	if ( el == 0 )
		return 0;
	t = get_el(el,1);
	if ( get_type(t) != XLT_STRING )
		return 0;
	if ( l_strcmp(t->string.data,l_string(std_cm,"pair")) == 0 ) {
		i = 0;
		for ( ; get_type(se) == XLT_PAIR && i < 2 ; se = cdr(se) ) {
			el = car(se);
			if ( get_type(el) != XLT_ENV )
				continue;
			p[i++] = el->env.data;
		}
		return new_env_pair(p[0],p[1]);
	}
	else if ( l_strcmp(t->string.data,l_string(std_cm,"env")) == 0 ) {
		el = get_el_by_symbol(se,l_string(std_cm,"parent"),0);
		if ( el == 0 )
			return 0;
		t = get_el(el,1);
		switch ( get_type(t) ) {
		case XLT_NULL:
			if ( target == 0 )
				ret = new_env(0);
			else	ret = target;
			break;
		case XLT_ENV:
			if ( target == 0 )
				ret = new_env(t->env.data);
			else	ret = target;
			break;
		default:
			if ( target == 0 )
				ret = new_env(0);
			else	ret = target;
			break;
		}
		el = get_el_by_symbol(se,l_string(std_cm,"hash"),0);
		if ( el == 0 )
			return 0;
		el = cdr(el);

		for ( ; get_type(el) ; el = cdr(el) ) {
			t = car(el);
			if ( get_type(t) != XLT_PAIR )
				continue;
			t2 = get_el(t,1);
			if ( get_type(t2) != XLT_STRING )
				continue;
			set_env(ret,t2->string.data,get_el(t,2));
		}
		el = get_el_by_symbol(se,l_string(std_cm,"default-sym"),0);
		if ( el ) {
			el = get_el(el,1);
			if ( get_type(el) != XLT_PAIR )
				return ret;
			t2 = get_el(el,1);
			if ( get_type(t2) != XLT_STRING )
				return ret;
			set_default_env(ret,get_el(t,2));
		}
		return ret;
	}
	else {
		return 0;
	}
}

