#include <windows.h>
#include <shlwapi.h>
#include <REGSTR.H>
#include <shlobj.h>
#include <tlhelp32.h>

#include "..\CosmosInstaller\Name.h"

#pragma comment(lib, "shlwapi.lib")

const char *AppName="CosmosUninstaller";
static char RemoveErrorFile[MAX_PATH];

bool RemoveFolder(const char *folder)
{
	bool bRet=true;
	char SrcFolder[MAX_PATH],temp[MAX_PATH];
	strcpy(SrcFolder,folder);

	strcpy(temp,SrcFolder);
	PathAppend(temp,"*");

	WIN32_FIND_DATA wfd;
	HANDLE hFindFile = FindFirstFile(temp, &wfd);
	if (hFindFile != INVALID_HANDLE_VALUE) {
		do {
			if ((wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) > 0) 
			{
				if (wfd.cFileName[0] == '.') 
				{
					if (wfd.cFileName[1] == '\0') continue;
					if (wfd.cFileName[1] == '.' && wfd.cFileName[2] == '\0') continue;
				}
				strcpy(temp,SrcFolder);
				PathAppend(temp,wfd.cFileName);
				bRet=RemoveFolder(temp);
				if (bRet==true) 
				{
					if (RemoveDirectory(temp)==FALSE)
					{
						strcpy(RemoveErrorFile,temp);
						bRet=false;
					}
				}
				if (bRet==false) break;
			}
		} while (FindNextFile(hFindFile, &wfd));
		FindClose(hFindFile);
	}
	if (bRet==false) return bRet;

	strcpy(temp,SrcFolder);
	PathAppend(temp,"*");
	hFindFile = FindFirstFile(temp, &wfd);
	if (hFindFile != INVALID_HANDLE_VALUE) {
		do {
			if ((wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) > 0) 
			{
			}
			else 
			{
				strcpy(temp,SrcFolder);
				PathAppend(temp,wfd.cFileName);
				if (DeleteFile(temp)==FALSE)
				{
					bRet=false;
					strcpy(RemoveErrorFile,temp);
					break;
				}
			}
		} while (FindNextFile(hFindFile, &wfd));
		FindClose(hFindFile);
	}
	return bRet;
}

/*
bool DeleteDirectory(const char *lpDir)
{
	if (PathIsDirectory(lpDir)==FALSE) return true;
	char Path[MAX_PATH];
	strcpy(Path,lpDir);
	if( Path[strlen(Path)-1]=='\\')	Path[strlen(Path)-1]='\0';
	Path[strlen(Path)+1]='\0';

	SHFILEOPSTRUCT fos;
	ZeroMemory( &fos, sizeof(SHFILEOPSTRUCT) );
	fos.hwnd	= NULL;
	fos.wFunc	= FO_DELETE;
 	fos.pFrom	= Path;
	fos.fFlags	= FOF_NOCONFIRMATION | FOF_NOERRORUI; // FOF_SILENT | FOF_ALLOWUNDO;
	if( SHFileOperation( &fos ) )
	{
		return false;
	}
	return true;
}
*/

void Uninstall(const char *cosmos_path)
{
//t@C̏
	if (PathFileExists(cosmos_path) && PathIsDirectory(cosmos_path))
	{
		char tmp[MAX_PATH*2+100];
		bool bDeleteDir=RemoveFolder(cosmos_path);
		if (bDeleteDir==false)
		{
		   	if(GetUserDefaultLCID() == 1041){
				wsprintf(tmp,"\'%s\'폜ł܂łB\r\n\'%s\'ȉ蓮ō폜ĂB",RemoveErrorFile,cosmos_path);
			}
			else{
				wsprintf(tmp,"Could not delete \'%s\'. please delete the files in \r\n\'%s\' manually.",RemoveErrorFile,cosmos_path);
			}
			MessageBox(NULL,tmp,AppName,MB_OK);
		}
		else
		{
			if (RemoveDirectory(cosmos_path)==FALSE)
			{
		   		if(GetUserDefaultLCID() == 1041){
					wsprintf(tmp,"\'%s\'폜ł܂łB\r\n%sȉ蓮ō폜ĂB",cosmos_path,cosmos_path);
				}
				else{
					wsprintf(tmp,"Could not delete \'%s\'. please delete the files in \r\n\'%s\' manually.", cosmos_path, cosmos_path);
				}
				MessageBox(NULL,tmp,AppName,MB_OK);
			}
		}
	}
//V[gJbg̏
	char Path[MAX_PATH],Path2[MAX_PATH];
    LPITEMIDLIST pidl;

    HWND hWnd = NULL;
    IMalloc *pMalloc;
    SHGetMalloc( &pMalloc );

    if( SUCCEEDED(SHGetSpecialFolderLocation(hWnd,CSIDL_DESKTOPDIRECTORY,&pidl)) )
    { 
        SHGetPathFromIDList(pidl,Path);
        pMalloc->Free(pidl);
		PathAppend(Path,APP_LINKNAME);
		DeleteFile(Path);
    }
    if( SUCCEEDED(SHGetSpecialFolderLocation(hWnd,CSIDL_PROGRAMS,&pidl)) )
    { 
        SHGetPathFromIDList(pidl,Path);
        pMalloc->Free(pidl);

		PathAppend(Path,COSMOS_FOLDER);
		strcpy(Path2,Path);
		PathAppend(Path2,APP_LINKNAME);
		DeleteFile(Path2);
		strcpy(Path2,Path);
		PathAppend(Path2,UNINSTALLER_LINKNAME);
		DeleteFile(Path2);
		RemoveDirectory(Path);
    }
//WXg̏
	SHDeleteKey(HKEY_CLASSES_ROOT,ASSOC_EXT_KEY);
	SHDeleteKey(HKEY_CLASSES_ROOT,FILETYPE_KEY);
	char	szRegKey[256] ;
	wsprintf(szRegKey, "%s\\%s", REGSTR_PATH_UNINSTALL,UNINSTALLER_KEY);
	SHDeleteKey(HKEY_LOCAL_MACHINE,szRegKey);

}


BOOL IsCosmosRunning()
{
	HANDLE hSnapshot;
	PROCESSENTRY32 procent;
	BOOL ret=FALSE; // NotFound
	/* ToolhelpXibvVbg쐬 */
	hSnapshot = CreateToolhelp32Snapshot( TH32CS_SNAPPROCESS,0 );
	if ( hSnapshot != (HANDLE)-1 )
	{
		procent.dwSize = sizeof(PROCESSENTRY32);
		if ( Process32First( hSnapshot,&procent ) != FALSE )
		{
			do {
			 /* procent.szExeFileɃvZX */
				const char *ch=PathFindFileName(procent.szExeFile);
				if (stricmp(ch,APP_NAME)==0)
				{ 
					ret=TRUE;
					break;
				}
			} while ( Process32Next( hSnapshot,&procent ) != FALSE );
		}
		CloseHandle( hSnapshot );
	}
	return ret;
}


int WINAPI WinMain( HINSTANCE hInst, HINSTANCE hPrevInst,  LPSTR lpCmdLine, int intShowCmd)
{
	if (__argc==3)
	{
		if (stricmp(__argv[1],"-uninstall")==0)
		{
// cosmostH_ȊO͔F߂ȂB
			if (PathIsDirectory(__argv[2]) && stricmp(PathFindFileName(__argv[2]),COSMOS_FOLDER)==0)
			{
				int ret;
				const char*msg;
		   		if(GetUserDefaultLCID() == 1041){
					msg = APP_TITLE"ACXg[܂B\r\n"\
						"낵łH";
				}
				else{
					msg = "Do you want to uninstall "APP_TITLE"?";
				}
				ret=MessageBox(NULL, msg, AppName, MB_ICONWARNING|MB_YESNO);

				if (ret==IDYES)
				{
					char Path[MAX_PATH];
					Uninstall(__argv[2]);
					GetModuleFileName(hInst,Path,MAX_PATH);
					MoveFileEx(Path,NULL,MOVEFILE_DELAY_UNTIL_REBOOT);
		   			if(GetUserDefaultLCID() == 1041){
						msg = APP_TITLE"ACXg[܂B";
					}
					else{
						msg = "Uninstall succseeded.";
					}
					MessageBox(NULL,msg,AppName,MB_OK);
				}
			}
			return 1;
		}
		if (stricmp(__argv[1],"-copy")==0) // gRs[ċNȂB
		{
// cosmostH_ȊO͔F߂ȂB
			if (PathIsDirectory(__argv[2]) && stricmp(PathFindFileName(__argv[2]),COSMOS_FOLDER)==0)
			{
				if (IsCosmosRunning())
				{
					if(GetUserDefaultLCID() == 1041){
						MessageBox(NULL,APP_NAME"삵Ă܂B\t\n"APP_NAME"IĂsĂB",AppName,MB_OK);
					}
					else{
						MessageBox(NULL,APP_NAME" is running.\t\n Please retry uninstall after finish "APP_NAME".",AppName,MB_OK);
					}
					return 0;
				}
				char Path[MAX_PATH],TempPath[MAX_PATH];
				GetTempPath(MAX_PATH,TempPath);
				PathAppend(TempPath,"cosmos_uninstall.exe");
				GetModuleFileName(hInst,Path,MAX_PATH);
				if (CopyFile(Path,TempPath,FALSE)==TRUE)
				{
					char args[MAX_PATH+20];
					PathRemoveFileSpec(Path);
					wsprintf(args,"-uninstall \"%s\"",__argv[2]);
					ShellExecute(NULL,NULL,TempPath,args,NULL,SW_SHOW);
				}
			}
		}
	}
	return 0;
}
