// ===========================================================================
//	LAMControlImp.h				PowerPlant 2.2.1	1997-2002 Metrowerks Inc.
// ===========================================================================

#ifndef _H_LAMControlImp
#define _H_LAMControlImp
#pragma once

#include <LStdControlImp.h>

#if PP_Uses_Pragma_Import
	#pragma import on
#endif

PP_Begin_Namespace_PowerPlant

// ---------------------------------------------------------------------------

class	LAMControlImp : public LStdControlImp {
public:
						LAMControlImp( LStream* inStream = nil );

	virtual				~LAMControlImp();

	virtual Boolean		TrackHotSpot(
								SInt16			inHotSpot,
								Point			inPoint,
								SInt16			inModifiers);

	virtual void		FocusImp();
	virtual void		DrawSelf();

	virtual void		ShowSelf();
	virtual void		HideSelf();

	virtual void		ActivateSelf();
	virtual void		DeactivateSelf();

	virtual void		EnableSelf();
	virtual void		DisableSelf();

	virtual void		SetDataTag(
								SInt16			inPartCode,
								FourCharCode	inTag,
								Size			inDataSize,
								void*			inDataPtr);

	virtual void		GetDataTag(
								SInt16			inPartCode,
								FourCharCode	inTag,
								Size			inBufferSize,
								void*			inBuffer,
								Size*			outDataSize = nil) const;

	virtual void		SetTextTraitsID( ResIDT inTextTraitsID );

	virtual void		SetFontStyle( const ControlFontStyleRec& inStyleRec );

	virtual void		GetFontStyle( ControlFontStyleRec& outStyleRec ) const;

	virtual void		SetScrollViewSize( SInt32 inViewSize );
	
	virtual OSStatus	GetStructureOffsets( Rect& outOffsets ) const;

	virtual Boolean		SupportsCalcBestRect() const;

	virtual void		CalcBestControlRect(
								SInt16&			outWidth,
								SInt16&			outHeight,
								SInt16&			outBaselineOffset) const;

	virtual	void		Idle();
	
	virtual bool		IdlesAutomatically() const;

	virtual SInt16		DoKeyPress( const EventRecord& inKeyEvent );

	virtual void		BeTarget( ControlFocusPart inFocusPart );
								
	virtual void		DontBeTarget();

	virtual bool		SetKeyboardFocusPart( ControlFocusPart inFocusPart );
	
	virtual bool		ApplyForeAndBackColors() const;

	virtual void		ApplyTextColor(
								SInt16			inDepth,
								bool			inHasColor,
								bool			inIsActive);

protected:

	virtual void		MakeMacControl(
								ConstStringPtr	inTitle,
								SInt32			inRefCon);

	virtual void		RefreshControlPane();
};

PP_End_Namespace_PowerPlant


#if PP_Uses_Pragma_Import
	#pragma import reset
#endif

#endif
