/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "PP_Prefix.h"
#include "CColorView.h"
#include "CClickCheckAttachment.h"

#include "machine/v_types.h"
#include "v/v_errors.h"
#include "v/VBackColorView.h"
#include "v/VLayout.h"


short mac_ev_to_modifiers(EventModifiers mod);

static void
action_callback(EventModifiers mod, void *_obj)
{
	VBackColorView* obj = (VBackColorView*)_obj;
	obj->value_changed(mac_ev_to_modifiers(mod));
}

VExError
VBackColorView::create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg)
{
	sts.attr = 0;
	if ( flags & VSF_ATTR )
		sts.attr = s->attr;

	SPaneInfo paneInfo;
	paneInfo.superView = dynamic_cast<LView*>(nmp->get_info_this());
	if ( paneInfo.superView == 0 )
		er_panic("non-LView object cannot be parent");
	paneInfo.paneID = sts.id;
	paneInfo.width = 0;
	paneInfo.height = 0;
	paneInfo.visible = true;
	paneInfo.enabled = true;
	paneInfo.left = 0;
	paneInfo.top = 0;
	paneInfo.bindings = (SBooleanRect){false,false,false,false};
	paneInfo.userCon = (long)this;
	SViewInfo viewInfo = { (SDimension32){0,0}, {0,0}, {8,8}, false };
	int al_stk = get_app_lock();
	CColorView *v = new CColorView(paneInfo, viewInfo);
	v->SetActionCallback(action_callback, this);
	v->FinishCreate();
	info = v;
	release_app_lock(al_stk);
	return nmp->add_child_do(this);
}

void
VBackColorView::destroy_do(VObject * nmp)
{
	nmp->remove_child_do(this);
	int al_stk = get_app_lock();
	delete info;
	release_app_lock(al_stk);
	nmp->redraw();
}

VBackColorView::~VBackColorView()
{
}

VExError
VBackColorView::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = v_get_status_standard(s, &flags, info);
	VExError err2 = VObject::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	V_OP_END
	return err;
};

VExError
VBackColorView::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = v_set_status_standard(s, flags, &sts, info);
	VExError err2 = VObject::set_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);

	if ( flags & VSF_ATTR ) {
        unsigned short r,g,b,a;
        GET_RGB8_32(s->attr,r,g,b,a);
	int al_stk = get_app_lock();
        if ( a == 0x00 )
        	((CColorView*)info)->SetColor(NULL);
        else {
	        RGBColor color = {r<<8,g<<8,b<<8};
        	((CColorView*)info)->SetColor(&color);
        }
	release_app_lock(al_stk);
	}

	if ( flags & VSF_CALC_MIN ) {
		if (sts.children)
			sts.children->object->set_status(0, VSF_CALC_MIN);
		VLayout layout;
		layout.layout_in_frame(this, true);
		sts.min_size = layout.parent_min_size();
		err.subcode1 &= ~ VSF_CALC_MIN;
	}
	if ( flags & VSF_LAYOUT ) {
		VLayout layout;
		layout.layout_in_frame(this);
		layout.do_layout(this);
		err.subcode1 &= ~ VSF_LAYOUT;
	}

	V_OP_END

	if ( flags & (VSF_HOMOGEN | VSF_SPACING | VSF_ALIGN | VSF_PADDING | VSF_VISIBLE) )
		VLayout::mark(this);
	return err;
}

VExError
VBackColorView::add_child_do(VObject* child)
{
	VLayout layout;	// calc min size
	layout.layout_in_frame(this, true);
	return initial_VExError(V_ER_NO_ERR,0,0);
}

void
VBackColorView::remove_child_do(VObject* child)
{
	// do nothing
}

void
VBackColorView::child_status_changed(VObject* child, VInfo* info)
{
	// do nothing - object is marked when status is changed
}

void
VBackColorView::redraw(VRect* rect) const
{
	_V_OP_START()
	int al_stk = get_app_lock();
	if ( rect )
		info->RefreshRect((Rect){rect->t, rect->l, rect->b, rect->r});
	else
		info->Refresh();
	release_app_lock(al_stk);
	V_OP_END
}


