/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "PP_Prefix.h"

//#ifdef AAA

#include "machine/v_types2.h"
#include "LEditText.h"

#include "VReflector.h"
#include "v/VEditText.h"
#include "CClickCheckAttachment.h"
#include "LTabGroup.h"
#include "LView.h"
#include "LEditField.h"
#include "v/v_errors.h"

extern "C" {
#include "memory_debug.h"
#include "utils.h"
#include "machine/v_types.h"
extern LC_FONT_ENGINE_TYPE mac_font_engine_type;

class CEditText : public LEditText
{
public:
						CEditText(
								const SPaneInfo&	inPaneInfo,
								LCommander*			inSuperCommander,
								ConstStringPtr		inInitialText,
								ResIDT				inTextTraitsID,
								MessageT			inMessage,
								SInt16				inMaxChars,
								UInt8				inAttributes,
								TEKeyFilterFunc		inKeyFilter,
								VEditText *			mVEditText,
								bool				inPasswordField = false,
								ClassIDT			inImpID = imp_class_ID)
							: LEditText(inPaneInfo, inSuperCommander, inInitialText,
										inTextTraitsID, inMessage, inMaxChars,
										inAttributes, inKeyFilter, inPasswordField, inImpID),
							mVEditText(mVEditText)
						{
						}
protected:
	virtual void		BeTarget()		{ LEditText::BeTarget();	 mVEditText->focus_event(true);  }
	virtual void		DontBeTarget()	{ LEditText::DontBeTarget(); mVEditText->focus_event(false); }

	VEditText *			mVEditText;
};

/*
VFONT* _v_set_descriptor_get_font(const L_CHAR * descriptor,
			const LC_WRITING_STYLE * ws,
			int fsize, int *size);
*/
}

VExError
VEditText::create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg)
{
	edit_text_set *set = (edit_text_set*)arg;
	min_len = set->min_len;

	current_vf = 0;
	current_lf = 0;

	SPaneInfo paneInfo;
	paneInfo.superView = dynamic_cast<LView*>(nmp->get_info_this());
	if ( paneInfo.superView == 0 )
		er_panic("non-LView object cannot be parent");
	paneInfo.paneID = sts.id;
	paneInfo.width = 0;
	paneInfo.height = 0;
	paneInfo.visible = true;
	paneInfo.enabled = true;
	paneInfo.left = 0;
	paneInfo.top = 0;
	paneInfo.bindings = (SBooleanRect){false,false,false,false};
	paneInfo.userCon = (long)this;
	SInt8 filter = (flags & VSF_ATTR && s->attr == integer_only) ?
								keyFilter_Integer : keyFilter_PrintingChar;
	int al_stk = get_app_lock();
	LCommander *com = GetTabGroupForWindow(TGT_INSERT,paneInfo.superView,0);
	CEditText *v = new CEditText(paneInfo, com, "\p", 0, msg_DescriptorChanged,
								set->max_len, editAttr_AutoScroll,
								UKeyFilters::SelectTEKeyFilter(filter), this);
	initial_data = 0;
	v->AddAttachment(new CClickCheckAttachment);
	v->FinishCreate();
	v->AddListener(new VReflector(this));
	v->FocusDraw();
	sts.min_size = (VSize){set->min_len*12,25};
	release_app_lock(al_stk);
	
	info = v;
	return nmp->add_child_do(this);
}

void
VEditText::destroy_do(VObject * nmp)
{
	nmp->remove_child_do(this);
	int al_stk = get_app_lock();
	delete info;
	release_app_lock(al_stk);
	if ( initial_data )
		d_f_ree(initial_data);
	nmp->redraw();
}

VEditText::~VEditText()
{
}


VExError
VEditText::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = v_get_status_standard(s, &flags, info);

	if ( (flags & VSF_VALUE) && sts.attr == integer_only ) {
		int al_stk = get_app_lock();
		s->value = info->GetValue();
		release_app_lock(al_stk);
		flags &= ~VSF_VALUE;
	}
	if ( flags & VSF_DESC ) {
		long len = 1024, len2;
		char * buf = (char*)d_alloc(len);
		while ( 1 ) {
			int al_stk = get_app_lock();
			((CEditText*)info)->GetText(buf, len, &len2);
			release_app_lock(al_stk);
			if ( len > len2 )
				break;
			len += 1024;
			buf = (char*)d_re_alloc(buf, len);
		}
		buf[len2] = 0;
		if ( initial_data && strcmp(initial_data,buf) == 0 ) {
			s->descriptor = (const L_CHAR*)ll_copy_str((L_CHAR*)sts.descriptor);
			set_buffer((void*)s->descriptor);
		}
		else {
			s->descriptor = get_lc_from_machine(current_lf,current_vf, buf,strlen(buf));
		}
		d_f_ree(buf);
		flags &= ~VSF_DESC;
	}
	err.subcode1 = flags;

	VExError err2 = VObject::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	V_OP_END
	return err;
};

VExError
VEditText::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = v_set_status_standard(s, flags, &sts, info);
	VExError err2 = VObject::set_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	
	if ( flags & VSF_CALC_MIN ) {
		// min width must be specified by the user.
		// min height is specified automatically on creation.
		err.subcode1 &= ~VSF_CALC_MIN;
	}

	if ( (flags & VSF_VALUE) && sts.attr == integer_only ) {
		int al_stk = get_app_lock();
		((CEditText*)info)->SetValue(s->value);
		release_app_lock(al_stk);
		value_changed();
		err.subcode1 &= ~VSF_VALUE;
	}
	if ( flags & (VSF_WS | VSF_FSIZE) ) {
		int size = 0;
		VFONT *vf = 0;
		if ( sts.ws ) {
		LC_FONT * ff;
		L_CHAR * lc;
		L_CHAR ch = 0;
			long len = 1024;
/*
			char * buf = (char*)d_alloc(len);
			((CEditText*)info)->GetText(buf, len-1, &len);
			buf[len] = 0;
*/
			if ( flags & VSF_DESC )
				lc = (L_CHAR*)s->descriptor;
			else if ( sts.descriptor == 0 )
				lc = &ch;
			else	lc = (L_CHAR*)sts.descriptor;
//			d_f_ree(buf);
			vf = _v_set_descriptor_get_font(&ff,lc, sts.ws, sts.fsize, &size
					,&mac_font_engine_type);
			current_vf = vf;
			current_lf = ff;
		}
		if ( size <= 0 )
			size = sts.fsize;
		
		TEHandle teh = ((CEditText*)info)->GetMacTEH();

		if ( vf )
			(*teh)->txFont = vf->id;
		if ( size >= 0 )
			(*teh)->txSize = size / 10;

		FMInput	fontSpecs;
		fontSpecs.family	= (*teh)->txFont;
		fontSpecs.size		= (*teh)->txSize;
		fontSpecs.face		= (*teh)->txFace;
		fontSpecs.needBits	= false;
		fontSpecs.device	= 0;
		fontSpecs.numer.h	= 1;
		fontSpecs.numer.v	= 1;
		fontSpecs.denom.h	= 1;
		fontSpecs.denom.v	= 1;

		int al_stk = get_app_lock();
		FMOutPtr	info = ::FMSwapFont(&fontSpecs);

		(*teh)->lineHeight = (SInt16) (info->ascent + info->descent + info->leading);
		(*teh)->fontAscent = info->ascent;
		
		sts.min_size.h = (*teh)->lineHeight + 7;
		sts.min_size.w = info->widMax * min_len;

		::TECalText(teh);
		release_app_lock(al_stk);

		err.subcode1 &= ~(VSF_WS | VSF_FSIZE);
	}
	if ( flags & VSF_DESC ) {
		if ( s->descriptor ) {
			char *buf = get_mac_string((L_CHAR*)s->descriptor);
			if ( initial_data )
				d_f_ree(initial_data);
			initial_data = copy_str(buf);
			int al_stk = get_app_lock();
			((CEditText*)info)->SetText(buf, strlen(buf));
			release_app_lock(al_stk);
			if ( sts.descriptor )
				d_f_ree((void*)sts.descriptor);
			sts.descriptor = ll_copy_str((L_CHAR*)s->descriptor);
		}
		else {
			int al_stk = get_app_lock();
			((CEditText*)info)->SetText(0, 0);
			release_app_lock(al_stk);
			if ( initial_data )
				d_f_ree(initial_data);
			initial_data = 0;
			if ( sts.descriptor )
				d_f_ree((void*)sts.descriptor);
			sts.descriptor = 0;
		}
		descriptor_changed();
		err.subcode1 &= ~VSF_DESC;
	}

	V_OP_END

	if ( flags & (VSF_ALIGN | VSF_PADDING | VSF_DESC | VSF_VERTD | VSF_WS | VSF_FSIZE | VSF_VISIBLE) )
		VLayout::mark(this);
	return err;
}

void
VEditText::redraw(VRect* rect) const
{
	_V_OP_START()
	int al_stk = get_app_lock();
	if ( rect )
		info->RefreshRect((Rect){rect->t, rect->l, rect->b, rect->r});
	else
		info->Refresh();
	release_app_lock(al_stk);
	V_OP_END
}

void
VEditText::focus()
{
	int al_stk = get_app_lock();
	LCommander::SwitchTarget((CEditText*)info);
	release_app_lock(al_stk);
}

bool
VEditText::obey_command(int type)
{
bool ret;
	int al_stk = get_app_lock();
	ret = ((CEditText*)(info))->ObeyCommand(type, 0);
	release_app_lock(al_stk);
	return ret;
}


bool
VEditText::command_status(int type) const
{
	Boolean enabled, usesMark;
	UInt16 mark;
	Str255 name;
	int al_stk = get_app_lock();
	((CEditText*)(info))->FindCommandStatus(type, enabled, usesMark, mark, name);
	release_app_lock(al_stk);
	return enabled;
}

//#endif

