/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "PP_Prefix.h"
#include "LScrollerView.h"
#include "LPlacard.h"

#include "v/VScrollView.h"
#include "v/VLayout.h"



class CPlacard : public LPlacard {
public:
							CPlacard(
									const SPaneInfo&	inPaneInfo,
									const SViewInfo&	inViewInfo)
		: LPlacard(inPaneInfo, inViewInfo)
		{
		}

	virtual void			ScrollImageBy(
									SInt32				inLeftDelta,
									SInt32				inTopDelta,
									Boolean				inRefresh)
		{
			if ( inRefresh  && IsVisible() )
				Refresh();
			LPlacard::ScrollImageBy(inLeftDelta, inTopDelta, Refresh_No);
			if ( inRefresh  && IsVisible() )
				UpdatePort();
		}
};

VExError
VScrollView::create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg)
{
	sts.attr = 0;
	if ( flags & VSF_ATTR )
		sts.attr = s->attr;
	sts.size = sts.min_size = (VSize){20,20}; // initial value - to make scroll bar correctly

	SPaneInfo paneInfo;
	paneInfo.superView = dynamic_cast<LView*>(nmp->get_info_this());
	if ( paneInfo.superView == 0 )
		er_panic("non-LView object cannot be parent");
	paneInfo.paneID = sts.id;
	paneInfo.width = 20;
	paneInfo.height = 20;
	paneInfo.visible = sts.visible;
	paneInfo.enabled = sts.enabled;
	paneInfo.left = 0;
	paneInfo.top = 0;
	paneInfo.bindings = (SBooleanRect){false,false,false,false};
	paneInfo.userCon = (long)this;
	SViewInfo viewInfo = { (SDimension32){sts.size.w,sts.size.h}, {0,0}, {8,8}, false };
	int al_stk = get_app_lock();
	LScrollerView *v = new LScrollerView(paneInfo, viewInfo,
		(sts.attr&h_never)?-1:0, (sts.attr&v_never)?0:15,
		(sts.attr&v_never)?-1:0, (sts.attr&h_never)?0:15,
		16, nil, true);

	paneInfo.superView = v;
	paneInfo.paneID += 0x40000000;
	paneInfo.visible = true;
	paneInfo.enabled = true;
	paneInfo.bindings = (SBooleanRect){true,true,true,true};
	CPlacard *inview = new CPlacard(paneInfo, viewInfo);
	inview->FinishCreate();
	info = inview;

	v->InstallView(inview);
	v->ExpandSubPane(inview, true, true);

	v->FinishCreate();
	release_app_lock(al_stk);
	
	set_internal_size((VSize){0,0});
	return nmp->add_child_do(this);
}

void
VScrollView::destroy_do(VObject * nmp)
{
	nmp->remove_child_do(this);
	LPane *p = info->GetSuperView();
//	p->Hide();
	int al_stk = get_app_lock();
	delete info;
	delete p;
	release_app_lock(al_stk);
	nmp->redraw();
}

VScrollView::~VScrollView()
{
}

VExError
VScrollView::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	LScrollerView* las = dynamic_cast<LScrollerView*>(info->GetSuperView());
	VExError err = v_get_status_standard(s, &flags, las);
	VExError err2 = VObject::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	V_OP_END
	return err;
};

VExError
VScrollView::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	LScrollerView* las = dynamic_cast<LScrollerView*>(info->GetSuperView());
	VExError err = v_set_status_standard(s, flags, &sts, las);
	VExError err2 = VObject::set_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);

	if ( flags & VSF_CALC_MIN ) {
		if (sts.children)
			sts.children->object->set_status(0, VSF_CALC_MIN);
		// do nothing - min_size must be set by the user.
		err.subcode1 &= ~VSF_CALC_MIN;
	}
	if ( flags & VSF_LAYOUT ) {
		VLayout layout;
		layout.layout_in_frame(this);
		layout.do_layout(this);
		err.subcode1 &= ~VSF_LAYOUT;
	}

	V_OP_END

	if ( flags & ( VSF_HOMOGEN | VSF_SPACING | VSF_ALIGN | VSF_PADDING | VSF_VISIBLE ) )
		VLayout::mark(this);
	return err;
}


VExError
VScrollView::add_child_do(VObject* child)
{
	return initial_VExError(V_ER_NO_ERR,0,0);
}

void
VScrollView::remove_child_do(VObject* child)
{
}

void
VScrollView::child_status_changed(VObject* child, VInfo* info)
{
	// do nothing - object is marked when status is changed
}

void
VScrollView::redraw(VRect* rect) const
{
	_V_OP_START()
	int al_stk = get_app_lock();
	LScrollerView* las = dynamic_cast<LScrollerView*>(info->GetSuperView());
	if ( rect )
		las->RefreshRect((Rect){rect->t, rect->l, rect->b, rect->r});
	else
		las->Refresh();
	release_app_lock(al_stk);
	V_OP_END
}

void
VScrollView::set_internal_size(const VSize size)
{
	_V_OP_START()
	if ( size.w != V_DEFAULT_SIZE )
		internal_size.w = size.w;
	if ( size.h != V_DEFAULT_SIZE )
		internal_size.h = size.h;
	set_internal_size_do(internal_size);
	V_OP_END
}

void
VScrollView::set_internal_size_do(const VSize size)
{
	int al_stk = get_app_lock();
	dynamic_cast<LView*>(info)->ResizeImageTo(size.w, size.h, true);
	release_app_lock(al_stk);
}

VSize
VScrollView::get_internal_size_cur()
{
	_V_OP_START(internal_size)
	SDimension16 size;
	int al_stk = get_app_lock();
	dynamic_cast<LView*>(info)->GetFrameSize(size);
	if ( size.width < internal_size.w )
		size.width = internal_size.w;
	if ( size.height < internal_size.h )
		size.height = internal_size.h;
	release_app_lock(al_stk);
	V_OP_END
	return (VSize){size.width, size.height};
}
