/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "PP_Prefix.h"
#include "LSeparatorLine.h"

#include "v/VSeparator.h"

VInfo*
make_LSeparatorLine(const VObjectStatus *s, VObject* obj,VInfo * p_info);


class CNoHitSeparatorLine : public LSeparatorLine
{
public:
						CNoHitSeparatorLine(
								const SPaneInfo&	inPaneInfo)
		: LSeparatorLine(inPaneInfo)
	{
	}
	
	virtual Boolean		IsHitBy(SInt32		inHorizPort,
								SInt32		inVertPort)
	{
		return FALSE;
	}
};

VInfo*
make_LSeparatorLine(const VObjectStatus *s, VObject* obj,VInfo * p_info)
{
	SPaneInfo paneInfo;
	paneInfo.superView = dynamic_cast<LView*>(p_info);
	if ( paneInfo.superView == 0 )
		er_panic("non-LView object cannot be parent");
	paneInfo.paneID = s->id;
	paneInfo.width = 0;
	paneInfo.height = 0;
	paneInfo.visible = true;
	paneInfo.enabled = true;
	paneInfo.left = 0;
	paneInfo.top = 0;
	paneInfo.bindings = (SBooleanRect){false,false,false,false};
	paneInfo.userCon = (long)obj;
	int al_stk = get_app_lock();
	CNoHitSeparatorLine *v = new CNoHitSeparatorLine(paneInfo);
	v->FinishCreate();
	release_app_lock(al_stk);
	return v;
}


void
VSeparator::destroy_do(VObject * nmp)
{
	nmp->remove_child_do(this);
	int al_stk = get_app_lock();
	delete info;
	release_app_lock(al_stk);
	nmp->redraw();
}

VSeparator::~VSeparator()
{
}

VExError
VSeparator::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	
	if ( flags & VSF_SIZE ) {
		s->size = sts.size;
		flags &= ~VSF_SIZE;
	}
	if ( flags & VSF_POSITION ) {
		s->position = sts.position;
		flags &= ~VSF_POSITION;
	}
	
	VExError err = v_get_status_standard(s, &flags, info);
	VExError err2 = VObject::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	V_OP_END
	return err;
};

VExError
VSeparator::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = v_set_status_standard(s, flags & ~(VSF_SIZE|VSF_POSITION), &sts, info);

	if ( flags & VSF_SIZE ) {
		int al_stk = get_app_lock();
		if ( get_type() == VHSeparator::object_type ) {
			if ( s->size.w != sts.size.w )
				info->ResizeFrameTo(s->size.w, sts.min_size.h, true);
		}
		else {
			if ( s->size.h != sts.size.h )
				info->ResizeFrameTo(sts.min_size.w, s->size.h, true);
		}
		release_app_lock(al_stk);
		sts.size = s->size;	// used in VSF_POSITION
	}
	if ( flags & VSF_POSITION ) {
		VPoint np = s->position;
		if ( get_type() == VHSeparator::object_type )
			np.y = s->position.y + (sts.size.h - sts.min_size.h)/2;
		else
			np.x = s->position.x + (sts.size.w - sts.min_size.w)/2;
		if ( s->position.x != sts.position.x || s->position.y != sts.position.y ) {
			int al_stk = get_app_lock();
			info->PlaceInSuperImageAt(np.x, np.y, true);
			release_app_lock(al_stk);
		}
	}

	VExError err2 = VObject::set_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);

	if ( flags & VSF_CALC_MIN ) {
		sts.min_size = (VSize){1,1};
		err.subcode1 &= ~ VSF_CALC_MIN;
	}

	V_OP_END

	if ( flags & ( VSF_HOMOGEN | VSF_SPACING | VSF_ALIGN | VSF_PADDING | VSF_VISIBLE ) )
		VLayout::mark(this);
	return err;
}

void
VSeparator::redraw(VRect* rect) const
{
	_V_OP_START()
	int al_stk = get_app_lock();
	if ( rect )
		info->RefreshRect((Rect){rect->t, rect->l, rect->b, rect->r});
	else
		info->Refresh();
	release_app_lock(al_stk);
	V_OP_END
}

VExError
VHSeparator::create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg)
{
	info = make_LSeparatorLine(s,this,nmp->get_info_this());
	return nmp->add_child_do(this);
}

VExError
VVSeparator::create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg)
{
	info = make_LSeparatorLine(s,this,nmp->get_info_this());
	return nmp->add_child_do(this);
}
