/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef _H_CWindowMenuAttachment
#define _H_CWindowMenuAttachment
#pragma once

#include <LAttachment.h>
#include <LMenu.h>

class CWindowMenuAttachment : public LAttachment
{
public:
					CWindowMenuAttachment();
	
	void			SetupMenu(LMenu *menu);
	void			UpdateMenu();
	void			SetEnabled(bool enabled) { menuEnabled = enabled; }
	
	static CWindowMenuAttachment *	GetMain() { return sMain; }
	
protected:
	virtual	void	ExecuteSelf(MessageT inMessage, void* ioParam);
	void			ClearMenu();
	WindowRef		GetWindowByItemNum(UInt16 num);

	LMenu *			mWindowMenu;
	struct WindowList {
		WindowRef	window;
		UInt16		item_num;
		WindowList	*next;
	} *	mWindowList;
	
	UInt16	num, first;
	static CWindowMenuAttachment *sMain;
	bool menuEnabled;
};

#endif