/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_TYPES_H___
#define ___V_TYPES_H___

#define NeedFunctionPrototypes 1
#include "gb_windows.h"

#include	"graph.h"
#include	"long_char.h"




typedef I_POINT VPOINT;
typedef I_RECT VRECT;
typedef struct verror {
	int		err1;
	int		err2;
} VERROR;

typedef struct vtext_ind {
	int					mode;
#define VT_TRANS			1
#define VT_BACKGROUND		2
	LC_WRITING_STYLE *	ws;
 	int					size;
	int					dir;
	int					st_x;
	int					st_y;
	L_CHAR *			data;
	int					length;
	unsigned long		color;
	unsigned long		background;
	VRECT				minrect;
} VTEXT_IND;



typedef struct {
	HINSTANCE hinst;
} Display;

typedef HWND Window;

typedef struct {
	int id;
} Visual;
typedef struct {
	int id;
} Colormap;

typedef HDC GC;

typedef struct vobj_header {
	int			type;
	union vobject *		next;
	struct vwindow *	win;
	int			(*handler)(/* obj, cmd, ...*/);
	/* cmd */
#define VE_REDRAW	1
#define VE_BUTTON	2
#define VE_MAX		3

#define VES_BUTTON_PRESS	1
#define VES_BUTTON_RELEASE	2
#define VES_BUTTON_MOTION	3
} VOBJ_HEADER;

/*
typedef struct vimage {
	VOBJ_HEADER		_h;
	long *			buf;
	int			x;
	int			y;
	int			w;
	int			h;
	HBITMAP		ximage;
	char *dib_buffer;
} VIMAGE;
*/

typedef struct vimage {
	VOBJ_HEADER		_h;
/*	long *			buf; */

	char *			buf_8;
	short *			buf_16;
	long *			buf_32;
	int			x;
	int			y;
	int			w;
	int			h;
	int			w_border;

	int			select_flag;
		/* 1 --> select */
		/* 0 --> not select */
	VPOINT			select[2];

	HBITMAP 		ximage;
	char *dib_buffer;
} VIMAGE;

typedef struct vtext {
	VOBJ_HEADER		_h;
	VTEXT_IND		in;
	HFONT			id;
} VTEXT;

typedef union vobject {
	VOBJ_HEADER	header;
#define VT_IMAGE	1
#define VT_TEXT		2
	VIMAGE		vimage;
	VTEXT		vtext;
} VOBJECT;

typedef struct v_map_tbl {
	unsigned int *		map[3];
#define GB2M_R	0
#define GB2M_G	1
#define GB2M_B	2
	int			pixel_bits;
	char			red_shift;
	char			green_shift;
	char			blue_shift;
	unsigned long		red_mask;
	unsigned long		green_mask;
	unsigned long		blue_mask;
	unsigned long		red_mul;
	unsigned long		green_mul;
	unsigned long		blue_mul;
} V_MAP_TBL;

typedef LOGFONTW VFONT;
VFONT *get_win_gui_vfont();

typedef struct vdisplay {
	int			(*err_handler)();
	struct vwindow *	win_list;
	void			(*handler[VE_MAX])();
	WCT *			wct;

	struct vdisplay *	next;
/*
	Display *		d;
	Window			r; 
	Visual *		visual;
	Colormap		cmap;
	V_MAP_TBL		gb2m_map;

	VFONT                   jisx0201;
    VFONT                   jisx0208_1978;
    VFONT                   jisx0208_1983;
    VFONT                   jisx0208_1990;
    VFONT                   jisx0212_1990;
	VFONT                   iso8859_1;
	VFONT                   iso8859_2;
	VFONT                   iso8859_3;
	VFONT                   iso8859_4;
	VFONT                   iso8859_5;
	VFONT                   iso8859_6;
	VFONT                   iso8859_7;
	VFONT                   iso8859_8;
	VFONT                   iso8859_9;
	VFONT                   iso8859_10;
	VFONT                   iso8859_11;
	VFONT                   iso8859_12;
	VFONT                   iso8859_13;
	VFONT                   iso8859_14;
	VFONT                   iso8859_15;

    WCT *                   font_work;
    int                     font_flag;
*/
    int                     depth;
	LC_FONT_ENGINE          fe;

} VDISPLAY;

#define GET_RGB_MAP(tbl,d)	\
	{				\
	(tbl).map[0] = (d)->gb2m_map[0];	\
	(tbl).map[1] = (d)->gb2m_map[1];	\
	(tbl).map[2] = (d)->gb2m_map[2];	\
	}

#define GB2MCOLOR(tbl,f)	\
	((tbl).map[0][(f)&COL_MASK]|			\
		(tbl).map[1][((f)>>COL_BIT)&COL_MASK]|	\
		(tbl).map[2][((f)>>(COL_BIT*2))&COL_MASK])

#define MCOLOR2GB(r,g,b,tbl,f)	\
	{							\
		(r) = ((((unsigned long)(f))&(tbl).red_mask)	\
				>>(tbl).red_shift)		\
				*(tbl).red_mul;			\
		(g) = ((((unsigned long)(f))&(tbl).green_mask)	\
				>>(tbl).green_shift)		\
				*(tbl).green_mul;		\
		(b) = ((((unsigned long)(f))&(tbl).blue_mask)	\
				>>(tbl).blue_shift)		\
				*(tbl).blue_mul;		\
	}

#define GB2MCOLOR_D(d,f)	GB2MCOLOR(d->gb2m_map,f)

typedef struct vwindow {
	struct vwindow *	next;
	VOBJECT *		obj_list;

	VDISPLAY *		d;
	Window 			w;
} VWINDOW;

typedef struct vwindow_attributes {
	int			x;
	int			y;
	int			w;
	int			h;
} VWINDOW_ATTRIBUTES;

VWINDOW * _get_vwin(VDISPLAY *,Window);

extern HWND ghWnd;
extern HDC ghBufferDC;
extern HBITMAP ghBufferImage,ghBufferImageOld;

extern DWORD gdwThreadID;

#define	MYMSG_INVRECT	(WM_USER + 1)

#define CB_MACHINE_ORDER	CB_MSB_FIRST



VDISPLAY *
v_open_disp(VERROR * err);

void
v_get_string_pic(
	LC_STRING_PIC * p,
	int 		dir,
	LCF_SET *	str,
	int len);



/* 
Windows 32bit bitmap consists of RGBQUAD structure(4byte size) array, 
but PEN,TEXT or BRUSH color is set by COLORREF(unsigned long typedef).
Memory image of RGBQUAD and COLORREF is not same.
For speed of raster operation, treat RGBQUAD as MCOLOR.
*/
COLORREF RGBQUADToCOLORREF(RGBQUAD rgbq);


#endif
