/**********************************************************************

Copyright (C) 2003-2004
Hirohisa MORI <joshua@nichibun.ac.jp>
Tomohito Nakajima <nakajima@zeta.co.jp>

This program is free software; you can redistribute it
and/or modify it under the terms of the GLOBALBASE
Library General Public License (G-LGPL) as published by

http://www.globalbase.org/

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

**********************************************************************/


#include "lc_encode.h"
#include "machine/lc_util.h"
#include "machine/gb_windows.h"
#include "memory_debug.h"


int l_get_lf_count(const L_CHAR *str){
	int count =0;
	for(; *str; ++str){
		if(*str == 0x0a){
			++count;
		}
	}
	return count;
}

wchar_t *l2w(const L_CHAR *lstr)
{
	wchar_t *ret=0;
	l2native(0, &ret, lstr);
	return ret;
}

L_CHAR *w2l(const wchar_t *wstr)
{
L_CHAR *ret;
L_CHAR *ptr;
int len;
	if(wstr==0){
		return 0;
	}

	len = lstrlenW(wstr);
	ret = d_alloc((len+1) * sizeof(L_CHAR));
	ptr = ret;
	for(; *wstr; ++wstr){
		*ptr = *wstr;
	}
	*ptr = 0;
	return ret;
}

void l2w_(wchar_t *ws, int ws_buff_len, const L_CHAR *ls){
	int i;
	int out;
	L_CHAR *ls_unicode;
	LCZ_SET set[] = {
		{0,LCZM_2B_TYPE},
		{LCC_ERROR,0}
	};
	
	ls_unicode = code_convert_with_combine(
		(L_CHAR*)ls, l_strlen((L_CHAR*)ls), set, 0);
	
	for(out=0,i=0; out<ws_buff_len && ls_unicode[i]; ++i){
		if(ls_unicode[i] == 0x0a){
			ws[out++] = 0x0a;
			if(out<ws_buff_len)
				ws[out++] = 0x0d;
		}
		else{
			ws[out++] = (wchar_t)(ls_unicode[i] & 0xffff);
		}
	}

	if(out==ws_buff_len){
		ws[out-1]=0;
	}
	else{
		ws[out]=0;
	}

	d_f_ree(ls_unicode);
}


void l2native(char **cstrp, wchar_t **wstrp, const L_CHAR *str)
{
	wchar_t *wstr;
	int buffer_len; 
	if(cstrp){
		*cstrp = 0;
	}
	if(wstrp){
		*wstrp = 0;
		
		// support unicode only now.
		
		buffer_len = l_strlen((L_CHAR*)str) + l_get_lf_count(str) + 1;
		wstr = *wstrp = (wchar_t *)d_alloc(buffer_len*sizeof(wchar_t));
		l2w_(wstr, buffer_len, str);
	}
	/*
	switch(*str & mask){
		case LCZ_2BC_UNICODE_v1_1_JP:
		case LCZ_2BC_UNICODE_v1_1_TW:
		case LCZ_2BC_UNICODE_v1_1_CN:
		case LCZ_2BC_UNICODE_v1_1_KR:
		case LCZ_2BC_UNICODE_v2_0_JP:
		case LCZ_2BC_UNICODE_v2_0_TW:
		case LCZ_2BC_UNICODE_v2_0_CN:
		case LCZ_2BC_UNICODE_v2_0_KR:
		case LCZ_2BC_UNICODE_v3_0_JP:
		case LCZ_2BC_UNICODE_v3_0_TW:
		case LCZ_2BC_UNICODE_v3_0_CN:
		case LCZ_2BC_UNICODE_v3_0_KR:
		case LCZ_2BC_UNICODE_v1_1_UN:
		case LCZ_2BC_UNICODE_v2_0_UN:
		case LCZ_2BC_UNICODE_v3_0_UN:
		case LCZ_2BC_UNICODE_v1_1_UN_CN:
		case LCZ_2BC_UNICODE_v2_0_UN_CN:
		case LCZ_2BC_UNICODE_v3_0_UN_CN:
			{
				// unicode
			}
			break;
		default:
			{
				// nativecode
			}
	}
	*/
}
	
void v_min_text_size(HDC hdc, const L_CHAR *str, SIZE *size)
{
	int len;
	int i;
	char *cstr=0;
	wchar_t *wstr=0;
	SIZE s;
	int substr_len;
	int h=0;
	int w=0;

	l2native(&cstr, &wstr, str);
	if(wstr){
		len = wcslen(wstr);
		for(i=0; i<len; ++i){
			if(wstr[i] == L'\r'){
				wstr[i] = L'\0';
			}
		}
		for(i=0; i<len; ++i){
			substr_len = wcslen(&wstr[i]);
			GetTextExtentPoint32W(hdc, &wstr[i], substr_len, &s);
			h += s.cy;
			w = max(w, s.cx);
			for(; wstr[i] && i<len; ++i)
				;
			if(i<len && wstr[i] == L'\n')
				++i;
		}
	}
	else if(cstr){
		len = strlen(cstr);
		for(i=0; i<len; ++i){
			if(cstr[i] == L'\r'){
				cstr[i] = L'\0';
			}
		}
		for(i=0; i<len; ++i){
			substr_len = strlen(&cstr[i]);
			GetTextExtentPoint32A(hdc, &cstr[i], substr_len, &s);
			h += s.cy;
			w = max(w, s.cx);
			for(; cstr[i] && i<len; ++i)
				;
			if(i<len && cstr[i] == L'\n')
				++i;
		}
	}
	size->cx = w;
	size->cy = h;

	if(cstr)
		d_f_ree(cstr);
	if(wstr)
		d_f_ree(wstr);
}
