/**********************************************************************

	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomohito Nakajima <nakajima@zeta.co.jp>
	Tomoki Sekiyama <sekiyama@yahoo.co.jp>

	This program is free software; you can redistribute it
	and/or modify it under the terms of the GLOBALBASE
	Library General Public License (G-LGPL) as published by

	http://www.globalbase.org/

	This program is distributed in the hope that it will be
	useful, but WITHOUT ANY WARRANTY; without even the
	implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE.

**********************************************************************/


#include "v/VButton.h"
#include "VApplication.h"
#include "vobject_main.h"


HWND CreateButtonWindow(int exStyle, int style, HWND hwnd, int id);

static void v_radio_group_select(VRadioGroupInfo grp)
{
	grp->select();
}

static void v_radio_button_value_changed(VObject *obj,MSG *msg){
	VRadioButton* radio = dynamic_cast<VRadioButton*>(obj);
	if ( radio == 0 ) er_panic("v_radio_button_value_changed");
	radio->get_radio_group()->select();
	radio->value_changed();
}

VExError 
VRadioButton::create_do(const VObjectStatus* s, int flags, VObject *parent, void * arg)
{
	radio_group = 0;
	
	DWORD style=WS_CHILD | BS_RADIOBUTTON | WS_TABSTOP;
	if(!s->enabled){
		style |= WS_DISABLED;
	}
	if(s->visible){
		style |= WS_VISIBLE;
	}
	
	/* find container window that will own this button.*/
	VContainerInfo *container_info = VInfo::get_container_info(parent);
	int id = container_info->get_next_control_id();
	HWND hwnd = v_serialized_exec_func(CreateButtonWindow, 0, style, container_info->get_hwnd(), id);
	info = new VInfo(this, hwnd, id);
	
	/* set event handlers */
	info->add_message_handler(
		new OnCommand(::v_radio_button_value_changed));
	init_group_list();
	return parent->add_child_do(this);
}

void
VRadioButton::destroy_do(VObject *parent)
{
	delete_group_list();
	VButton::destroy_do(parent);
}

VRadioButton::~VRadioButton()
{
}

VExError
VRadioButton::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = initial_VExError(V_ER_NO_ERR,flags,0);

	if ( flags & VSF_VALUE ) {
		s->value = v_serialized_exec_func(_SendMessage,
			info->get_hwnd(), BM_GETCHECK , 0 , 0);
		flags &= ~VSF_VALUE;
	}

	VExError err2 = VButton::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);

	V_OP_END
	return err;
};

VExError
VRadioButton::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VSize last_size = sts.min_size;
	VExError err = VButton::set_status(s,flags);

	if ( flags & VSF_VALUE ) {
		v_serialized_exec_sub(SendMessage,
			info->get_hwnd(), BM_SETCHECK, s->value ? BST_CHECKED : BST_UNCHECKED, 0);
		if ( s->value && radio_group )
			v_serialized_exec_sub(v_radio_group_select, radio_group);
		flags &= ~VSF_VALUE;
	}

	if( flags & (VSF_DESC | VSF_VERTD | VSF_FSIZE | VSF_WS) ) {
		sts.min_size.w += 16;
	}
	
	V_OP_END
	
	if ( (flags & (VSF_ALIGN | VSF_PADDING | VSF_VISIBLE)) ||
		 (flags & (VSF_DESC | VSF_WS | VSF_FSIZE)) &&
			(sts.min_size.w != last_size.w ||
			 sts.min_size.h != last_size.h) )
		VLayout::mark(this);
	return err;
}


VRadioGroupInfo_::~VRadioGroupInfo_()
{
	remove();
}

void
VRadioGroupInfo_::insert(VRadioGroupInfo_ *grp)
{
	remove();
	if ( grp ) {
		next = grp->next;
		prev = grp;
		if ( prev )
			prev->next = this;
		if ( next )
			next->prev = this;
	}
	else
		next = prev = 0;
	if ( next )
		selected = next->selected;
	else if ( prev )
		selected = prev->selected;
	if ( selected != this )
		SendMessage(radio, BM_SETCHECK, BST_UNCHECKED, 0);
}

void
VRadioGroupInfo_::remove()
{
	if ( next )
		next->prev = prev;
	if ( prev )
		prev->next = next;
	next = prev = 0;
	selected = this;
	SendMessage(radio, BM_SETCHECK, BST_CHECKED, 0);
}

void
VRadioGroupInfo_::select()
{
	if ( selected == this )
		return;
	VInfo::get_from_hwnd(selected->radio)->get_obj()->value_changed();
	SendMessage(radio, BM_SETCHECK, BST_CHECKED, 0);
	SendMessage(selected->radio, BM_SETCHECK, BST_UNCHECKED, 0);

	VRadioGroupInfo target;
	for ( target = prev ; target ; target = target->prev )
		target->selected = this;
	for ( target = next ; target ; target = target->next )
		target->selected = this;
}


static void v_radio_button_set_radio_group(
		VRadioGroupInfo a, VRadioGroupInfo b, bool selected)
{
	a->insert(b);
	if ( selected )
		a->select();
}

void
VRadioButton::set_radio_group(VRadioButton *group)
{
	v_serialized_exec_sub(v_radio_button_set_radio_group,
		get_radio_group(), group->get_radio_group(), sts.value!=0);
	insert_group_list(group);
}

VRadioGroupInfo
VRadioButton::get_radio_group()
{
	if ( radio_group == 0 )
		radio_group = new VRadioGroupInfo_(info->get_hwnd());
	return radio_group;
}
