/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"utils.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"mx_format.h"
#include	"ppm_types.h"
#include	"progressive.h"


XL_SEXP * gb_gmxExportPNM();

void
init_gmxExportPNM(XLISP_ENV * env0,XLISP_ENV * env1)
{
	set_env(env1,l_string(std_cm,"gmxExportPNM"),
		get_func_prim(gb_gmxExportPNM,FO_APPLICATIVE,0,4,8));
}



XL_SEXP *
gb_gmxExportPNM(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
PPM_INFO ppm;
XL_SEXP * filename;
int step;
int h;
unsigned int * buffer;
unsigned char * write_buffer,*wbp;
unsigned char * col;
unsigned int * bp;
unsigned int cc;
int w;
MX_ENTRY * mx_e;
L_CHAR * id;
XL_SEXP * _x,*_y;
XL_SEXP * _ww,*_hh;
XL_SEXP * ch;
INTEGER64 x,y,ww,hh;
MX_CACHE_PARAM p;
INTEGER64 * target;
int level;
XL_SEXP * _level;
int ds_ch;
int i;
/*
int gn_tree_node,gn_create,gn_wait;
*/

int prog_id,stage_id;
XL_SEXP * ret;
int flags;

	mx_e = 0;
	filename = get_el(s,1);
	if ( get_type(filename) != XLT_STRING )
		goto type_missmatch;
	id = get_sf_attribute(sf,l_string(std_cm,"id"));
	if ( id == 0 )
		goto inv_param;
	ch = get_el(s,2);
	if ( get_type(ch) != XLT_INTEGER )
		goto type_missmatch;
	_level = get_el(s,3);
	if ( get_type(_level) != XLT_INTEGER )
		goto type_missmatch;
	level = _level->integer.data;
	
	switch ( list_length(s) ) {
	case 4:
		mx_e = search_mx_entry_by_id(atoi(n_string(std_cm,id)));
		if ( mx_e == 0 )
			goto inv_param;
		x = y = 0;
		ww = mx_e->c.m->pixel_size[0];
		hh = mx_e->c.m->pixel_size[1];
		break;
	case 8:
		_x = get_el(s,4);
		_y = get_el(s,5);
		switch ( get_type(_x) ) {
		case XLT_INTEGER:
			x = _x->integer.data;
			break;
		case XLT_FLOAT:
			x = _x->floating.data;
			break;
		default:
			goto type_missmatch;
		}
		switch ( get_type(_y) ) {
		case XLT_INTEGER:
			y = _y->integer.data;
			break;
		case XLT_FLOAT:
			y = _y->floating.data;
			break;
		default:
			goto type_missmatch;
		}
		_ww = get_el(s,6);
		_hh = get_el(s,7);
		switch ( get_type(_ww) ) {
		case XLT_INTEGER:
			ww = _ww->integer.data;
			break;
		case XLT_FLOAT:
			ww = _ww->floating.data;
			break;
		default:
			goto type_missmatch;
		}
		switch ( get_type(_hh) ) {
		case XLT_INTEGER:
			hh = _hh->integer.data;
			break;
		case XLT_FLOAT:
			hh = _ww->floating.data;
			break;
		default:
			goto type_missmatch;
		}
		mx_e = search_mx_entry_by_id(atoi(n_string(std_cm,id)));
		if ( mx_e == 0 )
			goto inv_param;
		break;
	default:
		goto inv_param;
	}
	if ( x+ww > mx_e->c.m->pixel_size[0] ) {
		ww = mx_e->c.m->pixel_size[0] - x;
		if ( ww <= 0 )
			goto inv_param;
	}
	if ( y+hh > mx_e->c.m->pixel_size[1] ) {
		hh = mx_e->c.m->pixel_size[1] - y;
		if ( hh <= 0 )
			goto inv_param;
	}
	ww = ww>>(mx_e->c.m->dim_divide[0]*level);
	hh = hh>>(mx_e->c.m->dim_divide[1]*level);
	ppm.pi_fd = u_open64(n_string(std_cm,filename->string.data),O_CREAT|O_TRUNC|O_RDWR,0644);
	if ( ppm.pi_fd < 0 ) {
		goto cannot_open;
	}
	ppm.pi_width = ww;
	ppm.pi_height = hh;
	ppm.pi_max = 255;
ss_printf("pi_width(1) = %i %lli\n",ppm.pi_width,ww);
	write_header(&ppm);
	
ss_printf("pi_width(2) = %i\n",ppm.pi_width);
	step = 3;
	col = mxc_alloc(&mx_e->c,step*ppm.pi_width);
	buffer = mxc_alloc(&mx_e->c,sizeof(int)*ppm.pi_width);
	write_buffer = mxc_alloc(&mx_e->c,3*ppm.pi_width);
	target = mxc_alloc(&mx_e->c,sizeof(INTEGER64)*3);
	target[0] = level;
	target[1] = x;
	target[2] = y;
ss_printf("pi_width(3) = %i\n",ppm.pi_width);
	
	lseek(ppm.pi_fd,ppm.pi_offset,SEEK_SET);

	flush_mx_cache(&mx_e->c,0);
/*
	gn_tree_node = mx_e->c.gn_tree_node;
	gn_create = mx_e->c.gn_create;
	gn_wait = mx_e->c.gn_wait;

	mx_e->c.gn_tree_node = GN_NODE;
	mx_e->c.gn_create = GN_READ_ONLY;
	mx_e->c.gn_wait = GN_ERROR_NORETRY;
*/
	push_gn(&mx_e->c,
		GN_NODE,
		GN_READ_ONLY,
		GN_ERROR_NORETRY);

	set_matrix_env(mx_e->c.m,"create-node","disable");

	p = mx_e->p;
	p.dc = target;
	p.ofs = 0;
	p.data_ptrs[0] = 0;
	p.data_ptrs[1] = 0;
	p.data_ptrs[2] = mxc_alloc(&mx_e->c,sizeof(int*));
	p.data_ptrs[3] = 0;
	p.data_ix = mxc_alloc(&mx_e->c,sizeof(MX_CACHE_PARAM_IX)*mx_e->c.m->p.channel_nos);
	for ( i = 0 ; i < mx_e->c.ds_len ; i ++ ) {
		if ( mx_e->c.access_ch[i] == ch->integer.data ) {
			p.data_ix[i].x = 0;
			p.data_ix[i].p = 2;
			ds_ch = i;
		}
		else {
			p.data_ix[i].x = MXC_INVALID;
			p.data_ix[i].p = 0;
		}
	}
	p.vector_len = ww;
	
	((unsigned int**)p.data_ptrs[2])[0] = buffer;

	prog_id = new_progressive(l_string(std_cm,"ExportPNM"),l_string(std_cm,".progressive"),0);
	stage_id = new_stage(prog_id,l_string(std_cm,"ExportPNM"),-1,0);

	next_stage(prog_id,stage_id,ppm.pi_height,0);

	ret = 0;
	flags = set_xli_flags(0,XIF_CATCH,XIF_CATCH);

	for ( h = 0 ; h < ppm.pi_height ; h ++ ) {
//ss_printf("h = %i/%i   \n",h,ppm.pi_height);

		ret = xli_break_check(s,10);
		if ( get_type(ret) == XLT_ERROR )
			break;

		set_stage(prog_id,0,h,0);

		bp = buffer;
		for ( w = 0 ; w < ww ; w ++ )
			*bp++ = 0xff;
		read_mx_cache_vector(&p);
		wbp = write_buffer;
		bp = buffer;
		for ( w = 0 ; w < ww ; w ++ ) {
			cc = *bp++;
			if ( cc&0xff ) {
				*wbp++ = 0x0ff;
				*wbp++ = 0x0ff;
				*wbp++ = 0x0ff;
			}
			else {
				*wbp++ = (cc>>24)&0x0ff;
				*wbp++ = (cc>>16)&0x0ff;
				*wbp++ = (cc>>8)&0x0ff;
			}
		}
		u_write(ppm.pi_fd,write_buffer,ww*3);
		target[2] += ((INTEGER64)1)<<(target[0]*mx_e->c.m->dim_divide[0]);
	}
	
	next_stage(prog_id,0,0,0);
	close_progressive(prog_id,0);
	
/*
	mx_e->c.gn_tree_node = gn_tree_node;
	mx_e->c.gn_create = gn_create;
	mx_e->c.gn_wait = gn_wait;
*/
	pop_gn(&mx_e->c);

	mxc_free(&mx_e->c,col);
	mxc_free(&mx_e->c,buffer);
	mxc_free(&mx_e->c,target);
	mxc_free(&mx_e->c,write_buffer);
	mxc_free(&mx_e->c,p.data_ptrs[2]);
	flush_mx_cache(&mx_e->c,0);
	return ret;

type_missmatch:
	if ( mx_e )
		flush_mx_cache(&mx_e->c,0);
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gmxExportPNM"),
		0);
cannot_open:
	if ( mx_e )
		flush_mx_cache(&mx_e->c,0);
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_OPEN_FILE,
		l_string(std_cm,"gmxExportPNM"),
		List(n_get_string("cannot open the file"),
			filename,
			-1));
inv_param:
	if ( mx_e )
		flush_mx_cache(&mx_e->c,0);
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxExportPNM"),
		List(n_get_string("invalida parameter (attribute id)"),
			-1));
/*
permission_error:
	flush_mx_cache(&mx_e->c,0);
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_PERMISSION_DENIED,
		l_string(std_cm,"gmxExportPNM"),
		n_get_string("file path"));
*/
}

