/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"gbacrp.h"
#include	"gbmp.h"

XL_SEXP * gb_MPstatus();
XL_SEXP *
gb_MPquetop(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV* a,XL_SYM_FIELD * sf);
extern int cpu_nos;
extern int regist_time;

int test_status;

void
init_MPstatus(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"MPstatus"),
		get_func_prim(gb_MPstatus,FO_APPLICATIVE,0,1,1));
	set_env(env,l_string(std_cm,"MPquetop"),
		get_func_prim(gb_MPquetop,FO_APPLICATIVE,0,1,2));
}

XL_SEXP *
gb_MPquetop(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV* a,XL_SYM_FIELD * sf)
{
XL_SEXP * _len;
int len;
	if ( list_length(s) == 1 )
		len = 10;
	else {
		_len = get_el(s,1);
		if ( get_type(_len) != XLT_INTEGER )
			goto type_missmatch;
		len = _len->integer.data;
	}
	return get_que_info(len);

type_missmatch:

	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"MPquetop"),
		n_get_string("type missmatch"));
}



XL_SEXP *
gb_MPstatus(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV* a,XL_SYM_FIELD * sf)
{
TQ_STATISTICS w;
int i;
XL_SEXP * ret;
unsigned int t;
XL_SEXP * cpu;
XL_SEXP * gv_cpu();

test_status = 1;
	cpu = gv_cpu();
test_status = 2;
	tick_que_statistics(&w);
test_status = 3;
	ret = 0;
	for ( i = TQT_MAX-1 ; i >= 0 ; i -- )
		ret = cons(
			List(get_integer(i,0),
				get_integer(w.tqt_cnt[i],0),
				-1),
			ret);
test_status = 4;
	ret = cons(n_get_symbol("events"),ret);
test_status = 5;
	t = get_comesoon() - get_xltime();
test_status = 6;
	ret = List(
		List(n_get_symbol("comesoon"),
			get_integer(t,l_string(std_cm,"sec")),
			-1),
		List(n_get_symbol("regist-time"),
			get_integer(regist_time,l_string(std_cm,"sec")),
			-1),
		cons(n_get_symbol("cindex"),get_cindex_que()),
		cons(n_get_symbol("active-task"),cpu),
		ret,
		-1);
test_status = 8;
	return cons(n_get_symbol("status"),ret);

/*
type_missmatch:

test_status = 9;

	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"MPstatus"),
		n_get_string("type missmatch"));
*/
}

