/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "xl.h"
#include "win_flame.h"
#include "gbview.h"
#include "radar.h"
#include "xlerror.h"

XL_SEXP * xl_gv_flame_open();
void gv_flame_radar_indicate_event();
void call_gv_flame_event();

void
init_gv_flame_open(XLISP_ENV * env)
{
	set_env(env, l_string(std_cm,"gv-flame-open"),
			get_func_prim(xl_gv_flame_open,FO_APPLICATIVE,0,1,1));
}

XL_SEXP *
xl_gv_flame_open(
		XLISP_ENV * e,
		XL_SEXP * s,
		XLISP_ENV * a_e,
		XL_SYM_FIELD * sf)
{
GBVIEW_FLAME * gf;
GBVIEW_STATUS sts;

	gf = wf_open();

	sts.flags = SF_EVENT|SF_DEFAULT_WS;
	sts.event = call_gv_flame_event;
	sts.event_user_arg = (void*)gf->id;
	sts.default_ws = get_ws(l_string(std_cm,"DefaultStyle"));
	wf_set_status(gf,&sts);

	rc_set_indicate_event((RADAR_CACHE*)gf->radar_ptr,
		gv_flame_radar_indicate_event, (void*)gf->id);
	return get_integer(gf->id,0);
}
