/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"pri_level.h"
#include	"gbview.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"win_flame.h"
#include	"gb.h"
#include	"radar.h"
#include	"lock_level.h"
#include	"memory_debug.h"

/*
#define GVHA_PATH_DEBUG
#define GVHA_LOADING_STATUS
*/

#define TOLL	5
#define ACCESS_TIME_LIMIT	20
#define SIZE_LIST_AVG_RATE	0.9
#define SIZE_LIST_AVG_LIMIT	0.01
#define SIZE_TICK_MAX		10
#define SIZE_TICK_INTERVAL	6

#define ECT_UPDATE_TIMEOUT	15
#define FRAME_LOADING_TIMEOUT	20

typedef struct gvha_status {
	int			status;
#define GVHA_STS_OK		0
#define GVHA_STS_NOT_SUPPORT	-1
#define GVHA_STS_NO_CRD_ID	-2
#define GVHA_STS_TARGET_CRD_IS_NOT_LOADED	-3
#define GVHA_STS_TARGET_VCT_IS_NOT_LOADED	-4
#define GVHA_STS_POINT_OUTOF_BOUND		-5
#define GVHA_STS_MARK_UPDATE_ERROR		-6
#define GVHA_STS_INFORMATION_TAG_REQUIRED	-7
#define GVHA_STS_INFORMATION_UPDATE_ERROR	-8
#define GVHA_STS_NO_OBJECT			-9
#define GVHA_STS_CANNOT_CREATE_TMPFILE		-10
#define GVHA_STS_SAVE_ERROR			-11
#define GVHA_STS_NOT_NEED_SAVE			-12
	int			session_id;
	XL_SEXP *		err_message;
} GVHA_STATUS;

typedef struct gvha_vct_set {
	struct gvha_coordinate *	c_info;
	RESOURCE *			crd;
	RESOURCE *			vct;
	XLISP_ENV *			env;
} GVHA_VCT_SET;

typedef struct gvha_coordinate {
	struct gvha_coordinate *	next;
	int				id;
	L_CHAR *			url;
	L_CHAR *			edit_target;
	L_CHAR *			save_path;
	int				vct_objCode;
	unsigned			save_lock:1;
} GVHA_COORDINATE;

typedef struct gvha_pos {
	struct gvha_pos *		next;

	L_CHAR * 			target;
	GB_POINT			center;
	double				rotate;
	double				resolution;
} GVHA_POS;


typedef struct gvha_ids {
	int		org_id;
	int		gf_id;
	L_CHAR *	crd;
	int		status;
#define IDSS_INVISIBLE	0x00000000
#define IDSS_VISIBLE	0x00000001
#define IDSS_B		0x00000002
#define IDSS_L		0x00000004
} GVHA_IDS;

#define IDS_ORG	1
#define IDS_GF	2

typedef struct gvha_query {
	unsigned	mode:10;
#define GVHA_NREQ_FRAME_CACHE	0x100
#define GVHA_MODE_MOVE		1
#define GVHA_MODE_INFO1		2
#define GVHA_MODE_INFO2		3
#define GVHA_MODE_RSS		4
#define GVHA_MODE_RSS_SHORT	5
#define GVHA_MODE_RSS_TINNY	6
#define GVHA_MODE_RSS_LARGE	7

#define GVHA_MODE_ECT_LOW	8

#define GVHA_MODE_ECT_OPEN	(9|GVHA_NREQ_FRAME_CACHE)
#define GVHA_MODE_ECT_INSERT	10
#define GVHA_MODE_ECT_UPDATE	(11|GVHA_NREQ_FRAME_CACHE)
#define GVHA_MODE_ECT_DELETE	(12|GVHA_NREQ_FRAME_CACHE)
#define GVHA_MODE_ECT_MOVE	13
#define GVHA_MODE_ECT_SAVE	(14|GVHA_NREQ_FRAME_CACHE)
#define GVHA_MODE_ECT_CLOSE	(15|GVHA_NREQ_FRAME_CACHE)
#define GVHA_MODE_ECT_OBJECT	(16|GVHA_NREQ_FRAME_CACHE)

#define GVHA_MODE_ECT_HIGH	17


	unsigned	complete:1;
	GVHA_POS	pos;
	GVHA_IDS *	layer;
	int		layer_len;
	GVHA_IDS *	crd;
	int		crd_len;
	I_POINT		move;
	double		zoom;
	I_POINT		win_size;
	int		n;

	unsigned	force_dirty:1;

/* edit query */

	I_POINT		e_position;
	int		e_sessionId;
	char *		e_information;
	int		e_objCode;
	int		e_vct;
	char *		e_vct_byname;
	int		e_markTransparent;
	char *		e_markImg;
} GVHA_QUERY;

typedef struct gvha_frame_size {
	struct gvha_frame_size *	next;
	I_POINT				win_size;
	int				count;
	double				avg_count;
	int				recommended;
	int				real;
} GVHA_FRAME_SIZE;

#define SF_COUNT		0x00000001
#define SF_REAL_INS		0x00000002
#define SF_REAL_DEL		0x00000004

typedef struct gvha_frame_cache {
	struct gvha_frame_cache *	next;
	GVHA_IDS *			layer;
	int				layer_len;
	GVHA_POS *			pos;

	I_POINT				win_size;
	GBVIEW_FLAME *			gf;

	void *				image;
	int				image_len;

	GBVIEW_STATUS			c_sts;
	GBVIEW_STATUS			sts;
	LOADING_STATUS			ls;
	unsigned int			update;
	int				all;

	int				complete_cnt;

	INTEGER64			access_time;
	INTEGER64			internal_access_time;
	int				i_interval;

	unsigned 			mv_lock:1;
	unsigned			lock:1;
} GVHA_FRAME_CACHE;

typedef struct gvha_set {
	L_CHAR *		path_name;
	struct gvha_set *	next;

	GVHA_COORDINATE *	coord_list;
	QUERY_THREAD *		cond_list;
	GVHA_FRAME_CACHE *	processed_cache;
	int			processed_cache_size;
	int			max_processed_cache_size;
	GVHA_FRAME_SIZE *	size_list;
	double			size_list_avg_count;
	int			gvha_session_id;
} GVHA_SET;

SEM	gvha_lock;
GVHA_SET *	gvha_set_list;
int frame_loading_flag;

XLISP_ENV * HTTP_setup_env;

XL_SEXP * xl_Coordinate();
XL_SEXP * xl_Condition();
XL_SEXP * xl_Cache();

XL_SEXP *
_xl_GET(
	XLISP_ENV * e,XL_SEXP * s,XLISP_ENV * ae,XL_SYM_FIELD * sf,
	GVHA_FRAME_CACHE * out_c);
XL_SEXP *
_xl_GET_call(
	XLISP_ENV * e,XL_SEXP * s,XLISP_ENV * ae,XL_SYM_FIELD * sf);
XL_SEXP * xl_GET();
XL_SEXP * xl_POST();

void gv_flame_radar_indicate_event();
void call_gv_flame_event();

GVHA_FRAME_CACHE *
search_gvha_frame_cache_no_access(
	GVHA_FRAME_CACHE * root,I_POINT sz);
void gvha_flush_pos(GVHA_FRAME_CACHE * c,int *);
char *
get_next_target(GVHA_SET*,GVHA_FRAME_CACHE * c,L_CHAR * path,int mode);
void unlock_frame_lock(GVHA_FRAME_CACHE * c);
void gvha_frame_size_tick();
void gvha_insert_pos(GVHA_FRAME_CACHE * c);


void
get_gvha_vct(GVHA_SET*,GVHA_STATUS * sts,GVHA_VCT_SET*,int vct,char*vct_byname);
GB_POINT
get_gvha_mark_point(GVHA_STATUS * sts,GVHA_FRAME_CACHE * c,GVHA_VCT_SET * vs,I_POINT display_ptr);
int
gvha_gen_code(GVHA_STATUS * sts,GVHA_VCT_SET * vs);
void
gbha_update_mark(GVHA_STATUS * sts,GVHA_VCT_SET * vs,int code,GB_POINT ptr,char * mark_url,int markTransparent);
void
gvha_update_information(GVHA_STATUS * sts,GVHA_VCT_SET * vs,int code,char * info);
void
gbha_delete_mark(GVHA_STATUS * sts,GVHA_VCT_SET * vs,int code);
void
frame_loading_tick();
void
loading_status_cal(GVHA_FRAME_CACHE  *c);


void
locked_wf_status(GBVIEW_FLAME * gf,GBVIEW_STATUS * sts)
{
	for ( ; ; ) {
		wf_status(gf,sts);
		if ( sts->current_ls == 0 )
			break;
		if ( (sts->current_ls->flags & WFF_FREE) == 0 )
			break;
		wf_free_status(sts);
		sleep_sec(1);
	}
}

void
init_gv_http_agent(XLISP_ENV * e0,XLISP_ENV * e1)
{
XLISP_ENV * http_e0,* http_e1;
XL_SEXP * http_s0,* http_s1;


	gvha_lock = new_lock(LL_GV_HTTP_AGENT);

	http_e0 = new_env(e0);
	HTTP_setup_env = http_e1 = new_env(http_e0);
	http_s0 = get_env(http_e0);
	http_s1 = get_env(http_e1);

	set_env(e0,l_string(std_cm,"HTTP"),http_s0);
	set_env(e0,l_string(std_cm,"HTTPSetup"),http_s1);

	set_env(http_e1,l_string(std_cm,"Coordinate"),
		get_func_prim(xl_Coordinate,FO_APPLICATIVE,0,3,5));
	set_env(http_e1,l_string(std_cm,"Condition"),
		get_func_prim(xl_Condition,FO_APPLICATIVE,0,2,2));
	set_env(http_e1,l_string(std_cm,"Cache"),
		get_func_prim(xl_Cache,FO_APPLICATIVE,0,1,1));

	set_env(http_e0,l_string(std_cm,"_GET_call"),
		get_func_prim(_xl_GET_call,FO_APPLICATIVE,0,1,1));
	set_env(http_e0,l_string(std_cm,"GET"),
		get_func_prim(xl_GET,FO_APPLICATIVE,0,1,1));
	set_env(http_e0,l_string(std_cm,"POST"),
		get_func_prim(xl_POST,FO_APPLICATIVE,0,2,-1));

	new_tick(gvha_frame_size_tick,SIZE_TICK_INTERVAL,0);
}

GVHA_SET *
_new_gvha_set(L_CHAR * path)
{
GVHA_SET * ret;
	ret = d_alloc(sizeof(*ret));
	memset(ret,0,sizeof(*ret));
	ret->path_name = ll_copy_str(path);
	ret->next = gvha_set_list;
	gvha_set_list = ret;
	return ret;
}

GVHA_SET *
_search_gvha_set(L_CHAR * path)
{
GVHA_SET * ret;
	for ( ret = gvha_set_list ; ret ; ret = ret->next ) {
		if ( l_strcmp(ret->path_name,path) == 0 )
			return ret;
	}
	return 0;
}

GVHA_SET *
new_gvha_set(L_CHAR * path)
{
GVHA_SET * ret;
	lock_task(gvha_lock);
	ret = _search_gvha_set(path);
	if ( ret == 0 )
		ret = _new_gvha_set(path);
	else	ret = 0;
	unlock_task(gvha_lock,"new_gvha_set");
	return ret;
}

GVHA_SET *
search_gvha_set(L_CHAR * path)
{
GVHA_SET * ret;
	lock_task(gvha_lock);
	ret = _search_gvha_set(path);
	unlock_task(gvha_lock,"new_gvha_set");
	return ret;
}

GVHA_SET *
search_gvha_set_URL(L_CHAR * path)
{
GVHA_SET * ret;
L_CHAR * _path;
int cnt;
L_CHAR * q,* p;
	_path = ll_copy_str(path);
	cnt = 0;
	if ( _path[0] != '/' ) {
		if ( memcmp(_path,l_string(std_cm,"http://"),
				7*sizeof(L_CHAR))  ) {
			ret = 0;
			goto end;
		}
		for ( p = _path ; *p ; p ++ ) {
			if ( *p == '/' )
				cnt ++;
			if ( cnt >= 3 )
				break;
		}
		if ( cnt < 3 ) {
			ret = 0;
			goto end;
		}
	}
	else	p = _path;
	for ( q = p ; *q && *q != '?' ; q ++ );
	if ( *q )
		*q = 0;
	ret = search_gvha_set(p);
end:
	d_f_ree(_path);
	return ret;
}

GVHA_SET *
setup_gvha_set(XLISP_ENV * env)
{
XL_SEXP * ha_path;
GVHA_SET * ret;
	ha_path = eval(env,n_get_symbol("HttpAgent_path"));
	if ( ha_path == 0 )
		return 0;
	if ( get_type(ha_path) != XLT_STRING )
		return 0;
	ret = search_gvha_set(ha_path->string.data);
	if  ( ret )
		return ret;
	return new_gvha_set(ha_path->string.data);
}


GVHA_FRAME_SIZE *
_search_gvha_frame_size(GVHA_SET * g_set,I_POINT sz,int cnt_flag)
{
GVHA_FRAME_SIZE * ret;
	for ( ret = g_set->size_list ; ret ; ret = ret->next ) {
		if ( ret->win_size.x != sz.x )
			continue;
		if ( ret->win_size.y != sz.y )
			continue;
		goto ok;
	}
	ret = d_alloc(sizeof(*ret));
	memset(ret,0,sizeof(*ret));
	ret->win_size = sz;
	ret->next = g_set->size_list;
	g_set->size_list = ret;
ok:
	if ( cnt_flag & SF_COUNT ){
		ret->count ++;
	}
	if ( cnt_flag & SF_REAL_INS ) {
		ret->real ++;
	}
	if ( cnt_flag & SF_REAL_DEL ) {
		ret->real --;
		if ( ret->real < 0 )
			ret->real = 0;
	}
	return ret;
}

GVHA_FRAME_SIZE *
search_gvha_frame_size(GVHA_SET * g_set,I_POINT sz,int cnt_flag)
{
GVHA_FRAME_SIZE * ret;
	lock_task(gvha_lock);
	ret = _search_gvha_frame_size(g_set,sz,cnt_flag);
	unlock_task(gvha_lock,"search_gvha");
	return ret;
}

void
_set_size_list_avg_count(GVHA_SET * g_set)
{
GVHA_FRAME_SIZE * s, ** sp;
double acc;
double rec;
	acc = 0;
	for ( sp = &g_set->size_list ; *sp ; ) {
		s = *sp;
		s->avg_count = (1-SIZE_LIST_AVG_RATE)*s->count
			+ SIZE_LIST_AVG_RATE * s->avg_count;
		s->count = 0;
		if ( s->avg_count < SIZE_LIST_AVG_LIMIT &&
				s->real == 0 ) {
			*sp = s->next;
			d_f_ree(s);
			continue;
		}
		acc += s->avg_count;
		sp = &s->next;
	}
	g_set->size_list_avg_count = acc;
	for ( s = g_set->size_list ; s ; s = s->next ) {
		rec = s->avg_count / acc * g_set->processed_cache_size;
		if ( rec > g_set->processed_cache_size - 0.5 )
			s->recommended = g_set->processed_cache_size;
		else	s->recommended = rec;
/*
ss_printf("SS (%i %i) %f %i %i\n",
s->win_size.x,s->win_size.y,
s->avg_count,s->recommended,s->real);
*/
	}
}

void
set_size_list_avg_count(GVHA_SET * g_set)
{
	lock_task(gvha_lock);
	_set_size_list_avg_count(g_set);
	unlock_task(gvha_lock,"size_list_avg_count");
}

GVHA_FRAME_SIZE *
_search_gvha_frame_size_max(GVHA_SET * g_set)
{
GVHA_FRAME_SIZE * max, * ret;
	max = 0;
	for ( ret = g_set->size_list ; ret ; ret = ret->next ) {
		if ( max == 0 || 
				max->recommended - max->real
				< ret->recommended - ret->real )
			max = ret;
	}
	if ( max == 0 )
		return 0;
	if ( max->recommended - max->real <= 0 )
		return 0;
	return max;
}

GVHA_FRAME_SIZE *
search_gvha_frame_size_max(GVHA_SET * g_set)
{
GVHA_FRAME_SIZE * ret;
	lock_task(gvha_lock);
	ret = _search_gvha_frame_size_max(g_set);
	unlock_task(gvha_lock,"size_list_avg_count");
	return ret;
}

void
gvha_frame_size_tick_set(GVHA_SET * g_set,int *fp_flag)
{
GVHA_FRAME_SIZE * s;
int cnt;
GVHA_FRAME_CACHE * c;
//char * tmp;
	set_size_list_avg_count(g_set);
	for ( cnt = 0 ; cnt < SIZE_TICK_MAX ; cnt ++ ) {
		s = search_gvha_frame_size_max(g_set);
		if ( s == 0 )
			break;
		c = search_gvha_frame_cache_no_access(
				g_set->processed_cache,
				s->win_size);
		if ( c == 0 )
			break;
		search_gvha_frame_size(g_set,c->win_size,SF_REAL_DEL);
		search_gvha_frame_size(g_set,s->win_size,SF_REAL_INS);
		c->sts.width = s->win_size.x;
		c->sts.height = s->win_size.y;
		c->sts.flags = SF_WIDTH|SF_HEIGHT;
		wf_set_status(c->gf,&c->sts);
		locked_wf_status(c->gf,&c->sts);
		gvha_flush_pos(c,fp_flag);
/*
		tmp = get_next_target(c,_dir,GVHA_MODE_RSS);
		if ( tmp )
			d_f_ree(tmp);
*/
		gvha_insert_pos(c);
		c->win_size = s->win_size;
		unlock_frame_lock(c);
	}
}

void
gvha_frame_size_tick()
{
GVHA_SET * g_set;
	for ( g_set = gvha_set_list ; g_set ; ) {
		gvha_frame_size_tick_set(g_set,0);
		lock_task(gvha_lock);
		g_set = g_set->next;
		unlock_task(gvha_lock,"gvha_frame_size_tick_set");
	}
}

void
_insert_gvha_coordinate(GVHA_SET * g_set,int id,L_CHAR * url,L_CHAR * edit_target,L_CHAR * save_path)
{
GVHA_COORDINATE * c;
LOAD_RESOURCE_WORK * wp;
	c = d_alloc(sizeof(*c));
	memset(c,0,sizeof(*c));
	c->id = id;
	c->url = ll_copy_str(url);
	if ( edit_target ) {
		c->edit_target = ll_copy_str(edit_target);
		wp = new_lrw(0);
		wp->res_flags = RF_UNCACHE|RF_FORCE_LOAD_CHI|RF_EDIT|RF_INHERIT;
		get_url2(&wp->url,c->url);
		wp = new_lrw(wp);
		get_url2(&wp->url,c->edit_target);
		wp->res_flags = RF_UNCACHE|RF_FORCE_LOAD_CHI|RF_EDIT|RF_INHERIT;
		load_resource_list(wp,Q_PRI_RADAR,1);
	}
	else	c->edit_target = 0;
	if ( save_path ) 
		c->save_path = ll_copy_str(save_path);
	else	c->save_path = 0;
	c->vct_objCode = 0;
	c->next = g_set->coord_list;
	g_set->coord_list = c;
}

void
gvha_save_lock(GVHA_COORDINATE * c)
{
	lock_task(gvha_lock);
	for ( ; c->save_lock ; ) {
		sleep_task((int)c,gvha_lock);
		lock_task(gvha_lock);
	}
	c->save_lock = 1;
	unlock_task(gvha_lock,"gvha_save_lock");
}

void
gvha_save_unlock(GVHA_COORDINATE * c)
{
	lock_task(gvha_lock);
	c->save_lock = 0;
	wakeup_task((int)c);
	unlock_task(gvha_lock,"gvha_save_unlock");
}

void
insert_gvha_coordinate(GVHA_SET * g_set,int id,L_CHAR * url,L_CHAR * edit_target,L_CHAR * save_path)
{
	lock_task(gvha_lock);
	_insert_gvha_coordinate(g_set,id,url,edit_target,save_path);
	unlock_task(gvha_lock,"insert_gvha_coordinate");
}


int
gvha_ids_cmp_org(GVHA_IDS * ids1,int len1,GVHA_IDS * ids2,int len2)
{
int i,j;


	for ( i = 0 ; i < len1 ; i ++ ) {
		for ( j = 0 ; j < len2 ; j ++ ) {
			if ( ids1[i].org_id == ids2[j].org_id ) {
				if ( ids1[i].status != ids2[j].status )
					return -1;
				break;
			}
		}
	}
	for ( j = 0 ; j < len2 ; j ++ ) {
		for ( i = 0 ; i < len1 ; i ++ ) {

			if ( ids1[i].org_id == ids2[j].org_id ) {
				if ( ids1[i].status != ids2[j].status )
					return -1;
				break;
			}
		}
		if ( i == len1 ) {
			if ( ids2[j].status )
				return -1;
		}
	}
	return 0;
}

int
gvha_ids_cmp_gf(GVHA_IDS * ids1,int len1,GVHA_IDS * ids2,int len2)
{
int i,j;
	if ( len1 != len2 )
		return -1;
	for ( i = 0 ; i < len1 ; i ++ ) {
		for ( j = 0 ; j < len2 ; j ++ ) {
			if ( ids1[i].gf_id == ids2[j].gf_id ) {
				if ( ids1[i].status != ids2[j].status )
					return -1;
			}
		}
	}
	return 0;
}

double
gvha_pos_cmp(GVHA_POS * p1,GVHA_POS * p2,int radius)
{
double dd;
double ret;


	if ( l_strcmp(p1->target,p2->target) )
		return -1;
	dd = p1->resolution - p2->resolution;
	if ( dd < 0 )
		dd = - dd;
	ret = (dd * radius)/p1->resolution;
	dd = p1->rotate - p2->rotate;
	if ( dd < 0 )
		dd = - dd;
	ret += (dd * radius);
	dd = (p1->center.x - p2->center.x) * p1->resolution;
	if ( dd < 0 )
		dd = - dd;
	ret += dd;
	dd = (p1->center.y - p2->center.y) * p1->resolution;
	if ( dd < 0 )
		dd = - dd;
	ret += dd;

	return ret;
}

void
free_gvha_pos(GVHA_POS * p)
{
	if ( p->target )
		d_f_ree(p->target);
}

void
free_gvha_ids(GVHA_IDS * ids,int len)
{
int i;
	for ( i = 0 ; i < len ; i ++ ) {
		if ( ids[i].crd )
			d_f_ree(ids[i].crd);
	}
}

void
free_gvha_query(GVHA_QUERY * q)
{
	free_gvha_pos(&q->pos);
	if ( q->layer ) {
		free_gvha_ids(q->layer,q->layer_len);
		d_f_ree(q->layer);
	}
	if ( q->crd ) {
		free_gvha_ids(q->crd,q->crd_len);
		d_f_ree(q->crd);
	}
	if ( q->e_information ) {
		d_f_ree(q->e_information);
	}
	if ( q->e_markImg )
		d_f_ree(q->e_markImg);
	if ( q->e_vct_byname )
		d_f_ree(q->e_vct_byname);
}

GVHA_FRAME_CACHE *
_search_gvha_frame_cache(
	GVHA_FRAME_CACHE ** root,
	GVHA_QUERY * q,
	int layer_flag,int complete_flag)
{
GVHA_FRAME_CACHE ** rp, * ret, ** rpp, ** rpp_crd;
GVHA_POS * p;
double dist,d;
double dist_crd,dist_crd_2;
int ws_flag;
int tim;
int lf;

lf = layer_flag;
	ws_flag = layer_flag & 0x4;
	layer_flag &= 3;


retry:
	if ( layer_flag == 2 ) {
		if ( *root == 0 )
			return 0;
		dist = -1;
		rpp = 0;

		dist_crd = -1;
		rpp_crd = 0;
		for ( rp = root ; (*rp) ; rp = &(*rp)->next ) {
			if ( (*rp)->mv_lock )
				continue;
			if ( complete_flag && (*rp)->complete_cnt )
				continue;
			if ( ws_flag == 0 ) {
				if ( (*rp)->win_size.x != q->win_size.x )
					continue;
				if ( (*rp)->win_size.y != q->win_size.y )
					continue;
			}
			tim = get_xltime() - (*rp)->access_time;
			if ( tim < ACCESS_TIME_LIMIT ) {
				tim = TOLL*(ACCESS_TIME_LIMIT - tim);
				if ( tim < 1 )
					tim = 1;
			}
			else	tim = 1;
			for ( p = (*rp)->pos ; p ; p = p->next ) {
				d = gvha_pos_cmp(p,&q->pos,
					q->win_size.x + q->win_size.y);
				if ( d < 0 ) {
					if ( dist_crd == -1 ||
							tim < dist_crd ) {
						rpp_crd = rp;
						dist_crd = tim;
					}
				}
				else {
					d *= tim;
					if ( dist == -1 || d < dist ) {
						rpp = rp;
						dist = d;
					}
				}
			}
		}
		if ( rpp )
			rp = rpp;
		else	rp = rpp_crd;
	}
	else {
		rpp_crd = 0;
		dist_crd = 0;
		for ( rp = root ; *rp ; rp = &(*rp)->next ) {
			if ( (*rp)->mv_lock )
				continue;
			if ( complete_flag && (*rp)->complete_cnt )
				continue;
			if ( ws_flag == 0 ) {
				if ( (*rp)->win_size.x != q->win_size.x )
					continue;
				if ( (*rp)->win_size.y != q->win_size.y )
					continue;
			}
			dist_crd_2 = -1;
			for ( p = (*rp)->pos ; p ; p = p->next ) {
				d = gvha_pos_cmp(p,&q->pos,
					 q->win_size.x + q->win_size.y);
				if ( d < 0 )
					continue;
				if ( dist_crd_2 < 0 || dist_crd_2 > d )
					dist_crd_2 = d;
			}
			if ( dist_crd_2 < 0  )
				continue;
			if ( layer_flag == 0 )
				goto ok;
			if ( gvha_ids_cmp_org(q->layer,q->layer_len,
					(*rp)->layer,
					(*rp)->layer_len) )
				continue;
		ok:
			if ( rpp_crd == 0 || dist_crd > dist_crd_2 ) {
				rpp_crd = rp;
				dist_crd = dist_crd_2;
			}
		}
		if ( dist_crd < TOLL*0.1 )
			rp = rpp_crd;
		else	rp = 0;
	}
	if ( rp == 0 )
		return 0;
	if ( (*rp) == 0 )
		return 0;
	ret = *rp;
	*rp = ret->next;
	ret->next = *root;
	*root = ret;
ss_printf("RET %i - %i\n",ret->gf->id,lf);
	for ( ; ret->lock ; ) {
		if ( ret->mv_lock )
			goto retry;
		if ( complete_flag && ret->complete_cnt )
			goto retry;
		sleep_task((int)ret,gvha_lock);
		lock_task(gvha_lock);
	}
	ret->lock = 1;
	ret->access_time = get_xltime();
	return ret;
}

GVHA_FRAME_CACHE *
search_gvha_frame_cache(
	GVHA_FRAME_CACHE ** root,
	GVHA_QUERY * q,int layer_flag,int c_flag)
{
GVHA_FRAME_CACHE * ret;
	lock_task(gvha_lock);
	ret = _search_gvha_frame_cache(root,q,layer_flag,c_flag);
	unlock_task(gvha_lock,"insert_gvha_coordinate");
	return ret;
}

GVHA_FRAME_CACHE *
_search_gvha_frame_cache_no_access(
	GVHA_FRAME_CACHE * root,I_POINT sz)
{
GVHA_FRAME_CACHE * rp, * ret;

retry:
	ret = 0;
	for ( rp = root ; rp ; rp = rp->next ) {
			if ( rp->mv_lock )
				continue;
			if ( rp->win_size.x == sz.x &&
					rp->win_size.y == sz.y )
				continue;
			if ( ret == 0 ||
					ret->access_time > rp->access_time )
				ret = rp;
		}
	if ( ret == 0 )
		return 0;
	for ( ; ret->lock ; ) {
		if ( ret->mv_lock )
			goto retry;
		sleep_task((int)ret,gvha_lock);
		lock_task(gvha_lock);
	}
	ret->lock = 1;
	return ret;
}

GVHA_FRAME_CACHE *
search_gvha_frame_cache_no_access(
	GVHA_FRAME_CACHE * root,I_POINT sz)
{
GVHA_FRAME_CACHE * ret;
	lock_task(gvha_lock);
	ret = _search_gvha_frame_cache_no_access(root,sz);
	unlock_task(gvha_lock,"insert_gvha_coordinate");
	return ret;
}

void
unlock_frame_lock(GVHA_FRAME_CACHE * c)
{
	lock_task(gvha_lock);
	c->lock = 0;
	c->mv_lock = 0;
	wakeup_task((int)c);
	unlock_task(gvha_lock,"c");
}


int
lock_mv_lock(GVHA_FRAME_CACHE * c)
{
int ret;
	lock_task(gvha_lock);
	if ( c->complete_cnt ) {
		ret = -1;
		goto finish;
	}
	c->mv_lock = 1;
	wakeup_task((int)c);
	ret = 0;
finish:
	unlock_task(gvha_lock,"c");
	return ret;
}

void
complete_lock(GVHA_FRAME_CACHE * c)
{
	lock_task(gvha_lock);
	c->complete_cnt ++;
	wakeup_task((int)c);
	unlock_task(gvha_lock,"c");
}

void
complete_unlock(GVHA_FRAME_CACHE * c)
{
	lock_task(gvha_lock);
	c->complete_cnt --;
	if ( c->complete_cnt < 0 )
		er_panic("complete_unlock");
	wakeup_task((int)c);
	unlock_task(gvha_lock,"c");
}

char *
get_str_len(char ** ptr,char * ch,char * inp,char * delimit)
{
char * ret;
int len;
int dlen;
	dlen = strlen(delimit);
	for ( len = 0 ; inp[len] ; len ++ ) {
		if ( memcmp(&inp[len],delimit,dlen) == 0 )
			break;
	}
	*ch = inp[len];
	ret = d_alloc(len+1);
	memcpy(ret,inp,len);
	ret[len] = 0;
	if ( inp[len] == 0 )
		*ptr = &inp[len];
	else	*ptr = &inp[len+1];
	return ret;
}

char *
get_str(char ** ptr,char * ch,char * inp,char * list)
{
char * ret;
int len;
char * lp;
	for ( len = 0 ; inp[len] ; len ++ ) {
		for ( lp = list ; *lp ; lp ++ )
			if ( inp[len] == *lp )
				goto next;
	}
next:
	ret = d_alloc(len+1);
	memcpy(ret,inp,len);
	ret[len] = 0;
	*ch = inp[len];
	if ( inp[len] == 0 )
		*ptr = &inp[len];
	else	*ptr = &inp[len+1];
	return ret;
}

L_CHAR * 
get_crd_by_id(GVHA_SET * g_set,int id)
{
GVHA_COORDINATE * c;
	for ( c = g_set->coord_list ; c ; c = c->next )
		if ( c->id == id )
			return ll_copy_str(c->url);
	return 0;
}

int
get_id_by_crd(GVHA_SET * g_set,L_CHAR * crd)
{
GVHA_COORDINATE * c;
	for ( c = g_set->coord_list ; c ; c = c->next )
		if ( l_strcmp(c->url,crd) == 0 )
			return c->id;
	return -1;
}

int
get_id_by_edit_target(GVHA_SET * g_set,L_CHAR * crd)
{
GVHA_COORDINATE * c;
	for ( c = g_set->coord_list ; c ; c = c->next ) {
		if ( c->edit_target == 0 )
			continue;
		if ( l_strcmp(c->edit_target,crd) == 0 )
			return c->id;
	}
	return -1;
}


char *
get_str_list(GVHA_IDS ** ids,int * len,char *dir)
{
char * str;
int _len;
GVHA_IDS * ret;
char * p;
char ch;
	ret = 0;
	_len = 0;
	for ( ; *dir ; ) {
		if ( *dir == '&' ) {
			dir ++;
			break;
		}
		str = get_str(&dir,&ch,dir,"[");
		if ( ch != '[' ) {
			*ids = 0;
			*len = 0;
			return dir;
		}
		ret = d_re_alloc(ret,(_len+1)*sizeof(GVHA_IDS));
		memset(&ret[_len],0,sizeof(GVHA_IDS));
		if ( '0' <= str[0] && str[0] <= '9' ) {
			ret[_len].org_id = atoi(str);
		}
		else {
			ret[_len].crd = nl_copy_str(std_cm,str);
		}
		d_f_ree(str);
		str = get_str(&dir,&ch,dir,"]");
		if ( ch != ']' ) {
			*ids = 0;
			*len = 0;
			return dir;
		}
		for ( p = str ; *p ; p ++ ) {
			switch ( *p ) {
			case '0':
				break;
			case '1':
				ret[_len].status |= IDSS_VISIBLE;
				break;
			case 'B':
				ret[_len].status |= IDSS_B;
				break;
			case 'L':
				ret[_len].status |= IDSS_L;
				break;
			}
		}
		d_f_ree(str);
		_len ++;
	}
	*len = _len;
	*ids = ret;
	return dir;
}


int
strcmp_ws(int * sp,char * a,char * b)
{
int len;
int ret;
	len = strlen(b);
	ret = memcmp(a,b,len);
	*sp = len;
	return ret;
}

int
get_gvha_query(GVHA_SET * g_set,GVHA_QUERY * q,char * dir)
{
char * str;
char ch;
int i;
int sz;
	memset(q,0,sizeof(*q));
	q->zoom = 1;
	q->mode = GVHA_MODE_MOVE;
	q->e_markTransparent = C_TRANSPARENT;
	for ( ; *dir && *dir != '?' ; dir ++ );
	if ( *dir == 0 )
		return -1;
	dir++;
	for ( ; *dir ; ) {
//ss_printf("TARGET = %s\n",dir);
		if ( strcmp_ws(&sz,dir,"position") == 0 ) {
			dir += sz;
			if ( *dir != '=' )
				return -26;
			dir ++;
			str = get_str(&dir,&ch,dir,"_");
			q->e_position.x = atoi(str);
			d_f_ree(str);
			str = get_str(&dir,&ch,dir,"&");
			q->e_position.y = atoi(str);
			d_f_ree(str);
		}
		else if ( strcmp_ws(&sz,dir,"sessionId") == 0 ) {
			dir += sz;
			if ( *dir != '=' )
				return -27;
			dir ++;
			str = get_str(&dir,&ch,dir,"&");
			q->e_sessionId = atoi(str);
			d_f_ree(str);
		}
		else if ( strcmp_ws(&sz,dir,"information") == 0 ) {
			dir += sz;
			if ( *dir != '=' )
				return -28;
			dir ++;
			str = get_str(&dir,&ch,dir,"&");
			q->e_information = convert_percent(str,0);
			d_f_ree(str);
		}
		else if ( strcmp_ws(&sz,dir,"objCode") == 0 ) {
			dir += sz;
			if ( *dir != '=' )
				return -29;
			dir ++;
			str = get_str(&dir,&ch,dir,"&");
			q->e_objCode = atoi(str);
			d_f_ree(str);
		}
		else if ( strcmp_ws(&sz,dir,"vct") == 0 ) {
			dir += sz;
			if ( *dir != '=' )
				return -30;
			dir ++;
			str = get_str(&dir,&ch,dir,"&");
			q->e_vct = atoi(str);
			if ( q->e_vct == 0 )
				q->e_vct_byname = convert_percent(str,0);
			d_f_ree(str);
		}
		else if ( strcmp_ws(&sz,dir,"markImg") == 0 ) {
			dir += sz;
			if ( *dir != '=' )
				return -31;
			dir ++;
			str = get_str(&dir,&ch,dir,"&");
			q->e_markImg = convert_percent(str,0);
			d_f_ree(str);
		}
		else if ( strcmp_ws(&sz,dir,"markTransparent") == 0 ) {
			dir += sz;
			if ( *dir != '=' )
				return -32;
			dir ++;
			str = get_str(&dir,&ch,dir,"&");
			sscanf(str,"%x",&q->e_markTransparent);
			d_f_ree(str);
		}
		else switch ( *dir ) {
		case 't':
			dir++;
			if ( *dir != '=' )
				return -2;
			dir ++;
			str = get_str_len(&dir,&ch,dir,"_a_");
			if ( '0' <= str[0] && str[0] <= '9' ) {
				q->pos.target = get_crd_by_id(g_set,atoi(str));
				if ( q->pos.target == 0 )
					return -3;
			}
			else {
				q->pos.target = 
					nl_copy_str(&utf8_cm,convert_percent(str,0));
			}
			d_f_ree(str);
			if ( *dir == 0 )
				return -4;
			switch ( *dir ) {
			case 'a':
				dir++;
				if ( *dir != '_' )
					return -22;
				dir++;
				str = get_str(&dir,&ch,dir,"_");
				sscanf(str,REAL1_F,&q->pos.center.x);
				d_f_ree(str);
				if ( *dir == 0 )
					return -5;
				str = get_str(&dir,&ch,dir,"_");
				sscanf(str,REAL1_F,&q->pos.center.y);
				d_f_ree(str);
				if ( *dir == 0 )
					return -6;
				str = get_str(&dir,&ch,dir,"_");
				sscanf(str,"%lf",&q->pos.rotate);
				d_f_ree(str);
				if ( *dir == 0 )
					return -7;
				str = get_str(&dir,&ch,dir,"&");
				sscanf(str,"%lf",&q->pos.resolution);
				d_f_ree(str);
				break;
			default:
				return -8;
			}
			break;
		case 'm':
			dir++;
			switch ( *dir ) {
			case 'v':
				dir ++;
				if ( *dir != '=' )
					return -9;
				dir ++;
				str = get_str(&dir,&ch,dir,"_");
				sscanf(str,"%i",&q->move.x);
				d_f_ree(str);
				if ( *dir == 0 )
					return -10;
				str = get_str(&dir,&ch,dir,"&");
				sscanf(str,"%i",&q->move.y);
				d_f_ree(str);
				break;
			case 'd':
				dir ++;
				if ( *dir != '=' )
					return -11;
				dir ++;
				str = get_str(&dir,&ch,dir,"&");
				if ( strcmp(str,"move") == 0 )
					q->mode = GVHA_MODE_MOVE;
				else if ( strcmp(str,"info1") == 0 )
					q->mode = GVHA_MODE_INFO1;
				else if ( strcmp(str,"info2") == 0 )
					q->mode = GVHA_MODE_INFO2;
				else if ( strcmp(str,"rss") == 0 )
					q->mode = GVHA_MODE_RSS;
				else if ( strcmp(str,"rss_short") == 0 )
					q->mode = GVHA_MODE_RSS_SHORT;
				else if ( strcmp(str,"rss_tinny") == 0 )
					q->mode = GVHA_MODE_RSS_TINNY;
				else if ( strcmp(str,"open") == 0 )
					q->mode = GVHA_MODE_ECT_OPEN;
				else if ( strcmp(str,"insert") == 0 )
					q->mode = GVHA_MODE_ECT_INSERT;
				else if ( strcmp(str,"update") == 0 )
					q->mode = GVHA_MODE_ECT_UPDATE;
				else if ( strcmp(str,"delete") == 0 )
					q->mode = GVHA_MODE_ECT_DELETE;
				else if ( strcmp(str,"emove") == 0 )
					q->mode = GVHA_MODE_ECT_MOVE;
				else if ( strcmp(str,"save") == 0 )
					q->mode = GVHA_MODE_ECT_SAVE;
				else if ( strcmp(str,"close") == 0 )
					q->mode = GVHA_MODE_ECT_CLOSE;
				else if ( strcmp(str,"object") == 0 )
					q->mode = GVHA_MODE_ECT_OBJECT;
				else if ( strcmp(str,"rss_large") == 0 )
					q->mode = GVHA_MODE_RSS_LARGE;
				else	return -12;
				d_f_ree(str);
				break;
			default:
				return -13;
			}
			break;
		case 'r':
			dir ++;
			if ( *dir != '=' )
				return -14;
			dir ++;
			str = get_str(&dir,&ch,dir,"&");
			sscanf(str,"%lf",&q->pos.rotate);
			d_f_ree(str);
			break;
		case 'z':
			dir ++;
			if ( *dir != '=' )
				return -15;
			dir ++;
			str = get_str(&dir,&ch,dir,"&");
			sscanf(str,"%lf",&q->zoom);
			d_f_ree(str);
			break;
		case 'l':
			dir ++;
			if ( *dir != '=' )
				return -21;
			dir ++;
			dir = get_str_list(&q->layer,&q->layer_len,dir);
			break;
		case 'c':
			dir ++;
			if ( *dir != '=' )
				return -16;
			dir ++;
			dir = get_str_list(&q->crd,&q->crd_len,dir);
			if ( q->crd_len == 0 )
				return -17;
			for ( i = 0 ; i < q->crd_len ; i ++ )
				q->crd[i].crd 
					= get_crd_by_id(g_set,q->crd[i].org_id);
			break;
		case 'p':
			dir ++;
			if ( *dir != '=' )
				return -18;
			dir ++;
			str = get_str(&dir,&ch,dir,"&");
			q->complete = atoi(str);
			d_f_ree(str);
			break;
		case 's':
			dir ++;
			if ( *dir != '=' )
				return -19;
			dir ++;
			str = get_str(&dir,&ch,dir,"_");
			q->win_size.x = atoi(str);
			d_f_ree(str);
			str = get_str(&dir,&ch,dir,"&");
			q->win_size.y = atoi(str);
			d_f_ree(str);
			break;
		case 'n':
			dir ++;
			if ( *dir != '=' )
				return -23;
			dir ++;
			str = get_str(&dir,&ch,dir,"&");
			q->n = atoi(str);
			d_f_ree(str);
			break;
		default:
			return -20;
			break;
		}
		if ( *dir == 0 )
			break;
	}
	return 0;
}


GVHA_FRAME_CACHE *
new_frame_cache(GVHA_SET * g_set,GVHA_QUERY * q)
{
GBVIEW_FLAME * gf;
GBVIEW_STATUS sts;
GVHA_FRAME_CACHE * ret, * r;
QUERY_THREAD * qt, * qt2, * qt3;
int _ret;
int len;
int i;

	gf = wf_open();

	wf_init_status(&sts);
	sts.flags = SF_DEFAULT_WS|SF_WIDTH|SF_HEIGHT;
//	sts.event = call_gv_flame_event;
//	sts.event_user_arg = (void*)gf->id;
	sts.default_ws = get_ws(l_string(std_cm,"DefaultStyle"));
	sts.width = q->win_size.x;
	sts.height = q->win_size.y;
	wf_set_status(gf,&sts);
/*
	rc_set_indicate_event((RADAR_CACHE*)gf->radar_ptr,
		gv_flame_radar_indicate_event, (void*)gf->id);
*/
	qt = copy_q_thread(g_set->cond_list);
	len = 0;
	for ( qt2 = qt ; qt2 ; qt2 = qt2->next , len ++ )
		qt2->id = 0;

	_ret = rc_insert_q_thread((RADAR_CACHE*)gf->radar_ptr,qt);
	

	ret = d_alloc(sizeof(*ret));
	memset(ret,0,sizeof(*ret));
	ret->gf = gf;
	ret->layer = d_alloc(len * sizeof(GVHA_IDS));
	memset(ret->layer,0,sizeof(GVHA_IDS)*len);
	ret->layer_len = len;
	ret->win_size.x = q->win_size.x;
	ret->win_size.y = q->win_size.y;
	ret->access_time = get_xltime();

	i = 0;
	for ( qt2 = qt , qt3 = g_set->cond_list ; 
			qt3 ; qt2 = qt2->next , qt3 = qt3->next , i ++ ) {
		ret->layer[i].org_id = qt3->id;
		ret->layer[i].gf_id = qt2->id;
		if ( qt2->flags & QTF_ACTIVE )
			ret->layer[i].status = IDSS_VISIBLE;
		else	ret->layer[i].status = 0;
	}

	free_query_thread(qt);

	lock_task(gvha_lock);
	ret->next = 0;
	if ( g_set->processed_cache ) {
		r = g_set->processed_cache;
		for ( ; r->next ; r = r->next );
		r->next = ret;
	}
	else {
		g_set->processed_cache = ret;
	}
	g_set->processed_cache_size ++;
	_search_gvha_frame_size(g_set,ret->win_size,SF_COUNT|SF_REAL_INS);
	unlock_task(gvha_lock,"new_frame_cache");
/*
ss_printf("INSERT FRAME LOADING\n");
	if ( frame_loading_flag == 0 ){
		new_tick(frame_loading_tick,0,0);
		frame_loading_flag = 1;
	}
*/
	return ret;
}


XL_SEXP *
xl_Coordinate(
	XLISP_ENV * e,XL_SEXP * s,XLISP_ENV * ae,XL_SYM_FIELD * sf)
{
XL_SEXP * _id;
XL_SEXP * _url;
XL_SEXP * _edit_target,* _save_path;
L_CHAR * edit_target,* save_path;
GVHA_SET * g_set;

	g_set = setup_gvha_set(e);
	if ( g_set == 0 )
		goto sys_error1;
	_id = get_el(s,1);
	_url = get_el(s,2);
	if ( get_type(_id) != XLT_INTEGER )
		goto type_missmatch;
	if ( get_type(_url) != XLT_STRING )
		goto type_missmatch;

	if ( list_length(s) == 5 ) {
		_edit_target = get_el(s,3);
		if ( get_type(_edit_target) != XLT_STRING )
			goto type_missmatch;
		edit_target = _edit_target->string.data;
		_save_path = get_el(s,4);
		if ( get_type(_save_path) != XLT_STRING )
			goto type_missmatch;
		save_path = _save_path->string.data;
	}
	else {
		edit_target = 0;
		save_path = 0;
	}
	insert_gvha_coordinate(g_set,_id->integer.data,_url->string.data,edit_target,save_path);
	return 0;

sys_error1:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_UNDEF_NAME,
		l_string(std_cm,"HTTP/Coordinate"),
		n_get_string("HttpAgent_path is not defined or invalid"));
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"HTTP/Coordinate"),
		0);
}




XL_SEXP *
xl_Condition(
	XLISP_ENV * e,XL_SEXP * s,XLISP_ENV * ae,XL_SYM_FIELD * sf)
{
XL_SEXP * cnd;
QUERY_THREAD * qth, * n, * n2;
GVHA_SET * g_set;

	g_set = setup_gvha_set(e);
	if ( g_set == 0 )
		goto sys_error1;
	cnd = get_el(s,1);
	qth = sexp_to_q_thread(cnd);
	if ( qth == 0 )
		goto type_missmatch;
	lock_task(gvha_lock);
	for ( n = qth ; n ; n = n->next ) {
		for ( n2 = g_set->cond_list ; n2 ; n2 = n2->next )
			if ( n->id == n2->id )
				goto id_error;
	}
	for ( n = qth ; n->next ; n = n->next );
	n->next = g_set->cond_list;
	g_set->cond_list = qth;
	unlock_task(gvha_lock,"insert_gvha_coordinate");
	return 0;

sys_error1:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_UNDEF_NAME,
		l_string(std_cm,"HTTP/Condition"),
		n_get_string("HttpAgent_path is not defined or invalid"));
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"HTTP/Condition"),
		0);
id_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_DUP_DEFINITION,
		l_string(std_cm,"HTTP/Condition"),
		n_get_string("duplicate id"));
}


void
set_wakeup_time(INTEGER64 * wt,INTEGER64 target)
{
	if ( *wt == 0 ) {
		*wt = target;
	}
	else if ( *wt > target ) {
		*wt = target;
	}
}

void
frame_loading_task()
{
XL_INTERPRETER * xli;
GVHA_FRAME_CACHE * c;
GVHA_SET * gs;
INTEGER64 n;
INTEGER64 wt;
GB_RECT rr;
GBVIEW_PLANE gbp;
INTEGER64 loop_time;

	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);

	loop_time = get_xltime();
	wt = 0;
	for ( ; get_xltime() - loop_time < 2 ; ) {
		lock_task(gvha_lock);
		n = get_xltime();
		for ( gs = gvha_set_list ; gs ; gs = gs->next ) {
			c = gs->processed_cache;
			for ( ; c ; c = c->next ) {
				if ( n - c->access_time < FRAME_LOADING_TIMEOUT ) {
					set_wakeup_time(&wt,c->access_time 
						+ FRAME_LOADING_TIMEOUT);
					continue;
				}
				if ( c->internal_access_time + c->i_interval > n ) {
					set_wakeup_time(&wt,
						c->internal_access_time + c->i_interval);
					continue;
				}
				if ( c->lock ) {
					set_wakeup_time(&wt,
						n + FRAME_LOADING_TIMEOUT);
					continue;
				}
				goto internal;
			}
		}
		unlock_task(gvha_lock,"frame_loading_task");
		break;
	internal:
		c->lock = 1;
		unlock_task(gvha_lock,"frame_loading_task");

ss_printf("FRAME LOADING %i\n",c->gf->id);
		rr.tl.x = rr.tl.y = 0;
		rr.br.x = c->win_size.x;
		rr.br.y = c->win_size.y;

		get_rc_loading_status(
			(RADAR_CACHE*)c->gf->radar_ptr,&c->ls.rc);
		wf_free_status(&c->sts);
		locked_wf_status(c->gf,&c->sts);
		c->ls.wf = c->sts.loading_status;
		loading_status_cal(c);


		set_redraw_rect(c->gf,&rr);

		if ( ! wf_redraw(c->gf,&gbp,
				0,0,c->win_size.x,c->win_size.y) )
			er_panic("GVHA_MODE_MOVE");

		wf_free_plane(&gbp);

wf_wakeup(c->gf);

		
		lock_task(gvha_lock);

		c->internal_access_time = get_xltime();
		if ( c->ls.wf.dirty ) {
ss_printf("DIRTY\n");
			c->i_interval --;
			if ( c->i_interval <= 0 )
				c->i_interval = 1;
			set_wakeup_time(&wt,
				c->internal_access_time + c->i_interval);
		}
		else {
			if ( c->i_interval <= 0 )
				c->i_interval = 1;
			c->i_interval *= 2;
			if ( c->i_interval >= FRAME_LOADING_TIMEOUT )
				c->i_interval = FRAME_LOADING_TIMEOUT;
			set_wakeup_time(&wt,
				c->internal_access_time + c->i_interval);
		}
		unlock_task(gvha_lock,"frame_loading_task");
		unlock_frame_lock(c);
	}
	close_self_interpreter();

ss_printf("TICK=2 %lli ===================================================\n",wt);
	if ( wt ){
		n = get_xltime();
ss_printf("TICK %i\n",(int)(wt-n));
		if ( wt <= n )
			new_tick(frame_loading_tick,-1,0);
		else	new_tick(frame_loading_tick,(int)-(wt-n),0);
	}
}



void
frame_loading_tick()
{
ss_printf("FRAME LOADING TICK--\n");
	create_task(frame_loading_task,0,PRI_FETCH);
}


typedef struct _Cache_WORK {
	int		_g;
	XLISP_ENV *	e;
	XL_SEXP * 	s;
	XLISP_ENV *	ae;
	XL_SYM_FIELD *	sf;
	GVHA_QUERY	q;
	int		get_flag;
	GVHA_SET *	g_set;
} Cache_WORK;


void
Cache_thread(TKEY d)
{
Cache_WORK * w;
GVHA_FRAME_CACHE *c;
XL_SEXP * ret, * sym;
XL_INTERPRETER * xli;
	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);

	gc_push(0,0,"cache_thread");

	w = (Cache_WORK*)GET_TKEY(d);

	ret = 0;
	ret = cons(get_env(w->e),ret);
	ret = cons(w->s,ret);
	if ( w->ae )
		ret = cons(get_env(w->ae),ret);
	sym = n_get_symbol("d");
	sym->symbol.field = w->sf;
	ret = cons(sym,ret);

	lock_task(gvha_lock);
	w->get_flag = 1;
	wakeup_task((int)w);
	unlock_task(gvha_lock,"cache_thread");

	for ( ; w->_g ; w->_g -- ) {
		c = new_frame_cache(w->g_set,&w->q);
		ret = _xl_GET(w->e,w->s,w->ae,w->sf,c);
		if ( get_type(ret) == XLT_ERROR )
			break;
		sleep_sec(5);
	}
	free_gvha_query(&w->q);
	d_f_ree(w);

	gc_pop(0,0);

	close_self_interpreter();
}


XL_SEXP *
xl_Cache(
	XLISP_ENV * e,XL_SEXP * s,XLISP_ENV * ae,XL_SYM_FIELD * sf)
{
GVHA_FRAME_CACHE * c;
L_CHAR * g;
XL_SEXP * ret;
L_CHAR * dir;
int rcode;
Cache_WORK * w;
GVHA_SET * g_set;

	g_set = setup_gvha_set(e);
	if ( g_set == 0 )
		goto sys_error1;
	w = d_alloc(sizeof(*w));
	g = get_sf_attribute(sf,l_string(std_cm,"generate"));
	if ( g == 0 )
		w->_g = 1;
	else {
		w->_g = atoi(n_string(std_cm,g));
		if ( w->_g == 0 )
			w->_g = 1;
	}
	dir = get_sf_attribute(sf,l_string(std_cm,"dir"));
	if ( dir == 0 )
		goto sys_error;
	rcode = get_gvha_query(g_set,&w->q,n_string(std_cm,dir));
	if ( rcode < 0 )
		goto invalid_url;
	c = new_frame_cache(g_set,&w->q);
	ret = _xl_GET(e,s,ae,sf,c);
	if ( get_type(ret) == XLT_ERROR )
		return ret;
	w->_g --;
	if ( w->_g <= 0 ) {
		free_gvha_query(&w->q);
		d_f_ree(w);
	}
	else {
		w->g_set = g_set;
		w->e = e;
		w->s = s;
		w->ae = ae;
		w->sf = sf;
		w->get_flag = 0;
		create_task(Cache_thread,(int)w,PRI_FETCH);
		lock_task(gvha_lock);
		for ( ; w->get_flag == 0 ; ) {
			sleep_task((int)w,gvha_lock);
			lock_task(gvha_lock);
		}
		unlock_task(gvha_lock,"Cache_thread");
	}
	return 0;
sys_error1:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_UNDEF_NAME,
		l_string(std_cm,"HTTP/Cashe"),
		n_get_string("HttpAgent_path is not defined or invalid"));
sys_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_FIELD_NAME,
		l_string(std_cm,"gbview/Cache"),
		n_get_string("dir attribute is required"));
invalid_url:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_FIELD_NAME,
		l_string(std_cm,"gbview/Cache"),
		List(n_get_string("invalid URL"),
			get_integer(rcode,0),-1));
}

void
change_layer(GVHA_SET * g_set,GVHA_FRAME_CACHE * c,GVHA_QUERY * q)
{
QUERY_THREAD * qt, * qt2, * del;
QUERY_THREAD ** pp;
int i,j;
int cg;
	qt = copy_q_thread(g_set->cond_list);
	i = 0;

	for ( qt2 = qt ; qt2 ; qt2 = qt2->next , i ++ ) {
		qt2->flags = 0;
		qt2->id = c->layer[i].gf_id;
		cg = 0;


		for ( j = 0 ; j < q->layer_len ; j ++ ) {
			if ( c->layer[i].org_id != q->layer[j].org_id )
				continue;
			if ( (q->layer[j].status & IDSS_VISIBLE)
				!= (c->layer[i].status & IDSS_VISIBLE) )
				cg = 1;
			else	cg = 0;
			if ( q->layer[j].status & IDSS_VISIBLE )
				c->layer[i].status |= IDSS_VISIBLE;
			else	c->layer[i].status &= ~IDSS_VISIBLE;
			break;
		}
		if ( j == q->layer_len ) {
			if ( c->layer[i].status & IDSS_VISIBLE )
				cg = 1;
			c->layer[i].status &= ~IDSS_VISIBLE;
		}
		if ( cg ) {
			if ( c->layer[i].status & IDSS_VISIBLE )
				qt2->flags = QTF_ACTIVE;
			else	qt2->flags = 0;
			qt2->mask = QTF_ACTIVE;
		}
		else {
			qt2->flags = 0;
			qt2->mask = 0;
		}
	}
	del = 0;
	for ( pp = &qt ; *pp ; ) {
		qt2 = *pp;
		if ( qt2->mask == 0 ) {
			*pp = qt2->next;
			qt2->next = del;
			del = qt2;
			continue;
		}
		pp = &qt2->next;
	}
	free_query_thread(del);

#ifdef GVHA_LOADING_STATUS
ss_printf("QT=\n");
for ( qt2 = qt ; qt2 ; qt2 = qt2->next )
ss_printf("QT %i %x:%x\n",qt2->id,qt2->flags,qt2->mask);
#endif

	if ( qt ) {
		rc_set_q_thread((RADAR_CACHE*)c->gf->radar_ptr,qt);
		q->force_dirty = 1;
	}

	free_query_thread(qt);
#ifdef GVHA_LOADING_STATUS
qt = rc_get_q_thread((RADAR_CACHE*)c->gf->radar_ptr);
print_sexp(s_stdout,q_thread_to_sexp(qt,QTH_MAXIMUM_INFO),0);
ss_printf("\n");
free_query_thread(qt);
#endif

}

void
loading_status_cal(GVHA_FRAME_CACHE  *c)
{
int i;
int all;
LOADING_STATUS * ls;
unsigned int now;
	ls = &c->ls;

	all = 0;
	all += ls->rc.search_loading;
#ifdef GVHA_LOADING_STATUS
ss_printf("rc.search_loading = %i\n",ls->rc.search_loading);
#endif
	all += ls->rc.layer_management;
#ifdef GVHA_LOADING_STATUS
ss_printf("rc.layer_management = %i\n",ls->rc.layer_management);
#endif
	all += ls->rc.change_base_coord;
#ifdef GVHA_LOADING_STATUS
ss_printf("rc.change_base_cord = %i\n",ls->rc.change_base_coord);
#endif
	all += ls->rc.ri.d.beam;
#ifdef GVHA_LOADING_STATUS
ss_printf("rc.ri.d.beam = %i\n",ls->rc.ri.d.beam);
#endif
	for ( i = CRT_MAX ; i >= 0 ; i -- ) {
		all += ls->rc.ri.d.loading_res[i];
#ifdef GVHA_LOADING_STATUS
ss_printf("rc.ri.d.loading_res[%i] = %i\n",i,ls->rc.ri.d.loading_res[i]);
#endif
	}
	for ( i = CRT_MAX ; i >= 0 ; i -- ) {
		all += ls->rc.ri.d.ready_res[i];
#ifdef GVHA_LOADING_STATUS
ss_printf("rc.ri.d.ready_res[%i] = %i\n",i,ls->rc.ri.d.ready_res[i]);
#endif
	}
	all += ls->rc.ri.d.load_to_beam;
#ifdef GVHA_LOADING_STATUS
ss_printf("rc.ri.d.load_to_beam = %i\n",ls->rc.ri.d.load_to_beam);
#endif
	all += ls->rc.ri.d.beam_to_resource;
#ifdef GVHA_LOADING_STATUS
ss_printf("rc.ri.d.beam_to_resource = %i\n",ls->rc.ri.d.beam_to_resource);
#endif
	all += ls->rc.ri.d.retrieve1;
#ifdef GVHA_LOADING_STATUS
ss_printf("rc.ri.d.retrieve1 = %i\n",ls->rc.ri.d.retrieve1);
#endif
	all += ls->rc.ri.d.retrieve2;
#ifdef GVHA_LOADING_STATUS
ss_printf("rc.ri.d.retrieve2 = %i\n",ls->rc.ri.d.retrieve2);
#endif

	all += ls->wf.draw;
#ifdef GVHA_LOADING_STATUS
ss_printf("rc.wf.draw = %i - Resouce Check %i %i\n",ls->wf.draw,
	s_check_resource3(),s_check_resource2());
#endif
	all += ls->wf.exit;
#ifdef GVHA_LOADING_STATUS
ss_printf("rc.wf.exit = %i\n",ls->wf.exit);
#endif
	all += ls->wf.load_structure;
#ifdef GVHA_LOADING_STATUS
ss_printf("rc.wf.load_structure = %i\n",ls->wf.load_structure);
#endif
	all += ls->wf.data_request;
#ifdef GVHA_LOADING_STATUS
ss_printf("rc.wf.data_request = %i\n",ls->wf.data_request);
#endif
	all += ls->wf.indicate_request;
#ifdef GVHA_LOADING_STATUS
ss_printf("rc.wf.indicate_request = %i\n",ls->wf.indicate_request);
#endif
	all += ls->wf.indicate;
#ifdef GVHA_LOADING_STATUS
ss_printf("rc.wf.indicate = %i\n",ls->wf.indicate);
#endif
	all += ls->wf.raw_image_request;
#ifdef GVHA_LOADING_STATUS
ss_printf("rc.wf.raw_image_request = %i\n",ls->wf.raw_image_request);
#endif
	now = get_xltime();
	if ( c->update > now )
		all += c->update - now;
	c->all = all;
}


char *
get_next_target(GVHA_SET * g_set,GVHA_FRAME_CACHE * c,L_CHAR * path,int mode)
{
char * _path;
char * base,* str,* _base;
char ch;
int id;
int p;
int len;
int i;
WF_ID wfid;
GBVIEW_LAYER_STATUS * ls;
//GVHA_POS * gp, * gp2;
//double d;
XL_SEXP * url;
int port;
L_CHAR * site;
	url = eval(HTTP_setup_env,
			n_get_symbol("url"));
	if ( get_type(url) != XLT_STRING ) {
		port = get_my_port();
		site = get_xllisp_site();
		if ( site ) {
			if ( port == 0 ) {
				base = d_alloc(100);
				sprintf(base,"http://%s",
					n_string(std_cm,site));
			}
			else {
				base = d_alloc(100);
				sprintf(base,"http://%s:%i",
					n_string(std_cm,site),
					port);
			}
			goto make_base;
		}
		else {
			base = get_str(&_path,
				&ch,n_string(std_cm,path),"?");
		}
	}
	else {
		base = copy_str(n_string(std_cm,url->string.data));
	make_base:
		p = strlen(base);
		if ( base[p-1] == '/' )
			p--;
		base = d_re_alloc(base,
			p + strlen(_base = n_string(std_cm,path))+10);
		_base = get_str(&_path,&ch,_base,"?");
		strcpy(&base[p],_base);
	}
	p = strlen(base);
	base = d_re_alloc(base,p+2);
	base[p] = '?';
	p++;
	wfid = c->sts.current;
/*
	for ( ls = c->sts.layers ; ls ; ls = ls->next )
		if ( ls->id == wfid )
			break;
*/
	ls = c->sts.current_ls;
	if ( ls == 0 ) {
		d_f_ree(base);
		base = copy_str("http://www.globalbase.org/");
		return base;
	}
	id = get_id_by_crd(g_set,ls->entry_url);
ss_printf("ENTRY URL %ls == %i\n",ls->entry_url,id);
	if ( id < 0 ) {
		str = convert_percent_reverse(n_string(std_cm,ls->entry_url));
		base = d_re_alloc(base,p+(len=strlen(str))+100);
		sprintf(&base[p],"s=%i_%i&t=%s_a_%f_%f_%f_%f&l=",
			c->win_size.x,
			c->win_size.y,
			str,
			c->sts.flame_base_center.x,
			c->sts.flame_base_center.y,
			c->sts.flame_base_rotate,
			c->sts.flame_base_resolution);
		d_f_ree(str);
	}
	else {
		base = d_re_alloc(base,p+100);
		sprintf(&base[p],"s=%i_%i&t=%i_a_%f_%f_%f_%f&l=",
			c->win_size.x,
			c->win_size.y,
			id,
			c->sts.flame_base_center.x,
			c->sts.flame_base_center.y,
			c->sts.flame_base_rotate,
			c->sts.flame_base_resolution);
	}

/*
	gp = d_alloc(sizeof(*gp));
	gp->center = c->sts.flame_base_center;
	gp->rotate = c->sts.flame_base_rotate;
	gp->resolution = c->sts.flame_base_resolution;
	gp->target = ll_copy_str(ls->entry_url);

	lock_task(gvha_lock);
	for ( gp2 = c->pos ; gp2 ; gp2 = gp2->next ) {
		d = gvha_pos_cmp(gp,gp2,c->win_size.x + c->win_size.y);
		if ( d < 0 )
			continue;
		if ( d < TOLL )
			break;
	}
	if ( gp2 ) {
		d_f_ree(gp->target);
		d_f_ree(gp);
	}
	else {
		gp->next = c->pos;
		c->pos = gp;
	}
	unlock_task(gvha_lock,"return_rdf");
*/
	gvha_insert_pos(c);

	p = strlen(base);
	for ( i = 0 ; i < c->layer_len ; i ++ ) {
		if ( (c->layer[i].status & IDSS_VISIBLE) == 0 )
			continue;
		base = d_re_alloc(base,p+30);
		sprintf(&base[p],"%i%%5B1%%5D",c->layer[i].org_id);
		p = strlen(base);
	}
	base = d_re_alloc(base,p+50);
	switch ( mode ) {
	case GVHA_MODE_MOVE:
		break;
	case GVHA_MODE_INFO1:
		sprintf(&base[p],"&md=info1");
		break;
	case GVHA_MODE_INFO2:
		sprintf(&base[p],"&md=info2");
		break;
	case GVHA_MODE_RSS:
		sprintf(&base[p],"&md=rss");
		break;
	case GVHA_MODE_RSS_SHORT:
		sprintf(&base[p],"&md=rss_short");
		break;
	case GVHA_MODE_RSS_TINNY:
		sprintf(&base[p],"&md=rss_tinny");
		break;
	case GVHA_MODE_RSS_LARGE:
		sprintf(&base[p],"&md=rss_large");
		break;
	default:
		er_panic("get_next_taerget");
	}
	p = strlen(base);
	if ( c->ls.wf.dirty == 0 && c->all == 0 ) {
		base = d_re_alloc(base,p+10);
		sprintf(&base[p],"&p=1");
	}
	return base;
}


XL_SEXP *
gvha_format_HTML(XL_SEXP * inp)
{
STREAM * st;
XL_SEXP * ret;


	st = s_open_string_write(&int_cm);
	if ( get_type(inp) == XLT_PAIR ) {
		if ( get_type(car(inp)) == XLT_SYMBOL ) {
			print_sexp(st,inp,PF_HTML|PF_TEXT);
		}
		else {
			print_sexp(st,inp,PF_HTML|PF_TEXT|PF_MULTI_ROOT);
		}
	}
	else {
		print_sexp(st,inp,PF_HTML|PF_TEXT);
	}
	ret = List(n_get_symbol("htmldata"),get_string(s_get_l_string(st)),-1);
	s_close(st);
	return ret;
}

XL_SEXP *
plot_element_area_list(GVHA_SET * g_set,GVHA_FRAME_CACHE * c,int mode)
{
GBVIEW_PLOT_ELEMENT * el, * el_1;
XL_SEXP * area, * ret;
char name[10],coords[100];
int area_i;
char code[10];
RESOURCE * r;
OBJ * obj;
int res_crd_id;
RESOURCE * locked_r;

	if ( mode == GVHA_MODE_RSS_TINNY )
		return 0;
	el = wf_all_plot_element(c->gf);
	if ( el == 0 )
		return 0;
	gc_push(0,0,"peal");

	area_i = 1;
	ret = 0;
	locked_r = 0;
	for ( el_1 = el ; el_1 ; el_1 = el_1->next ) {
		area = n_get_symbol("area");
		sprintf(name,"area%i",area_i++);
		sprintf(coords,"%i,%i,%i,%i",
			(int)el_1->rect.tl.x,
			(int)el_1->rect.tl.y,
			(int)el_1->rect.br.x,
			(int)el_1->rect.br.y);
		sprintf(code,"%i",el_1->code&MAIN_CODE);
		if ( el_1->ref )
			set_attribute(area,
				l_string(std_cm,"href"),
				el_1->ref);
		set_attribute(area,
			l_string(std_cm,"coords"),
			l_string(std_cm,coords));
		set_attribute(area,
			l_string(std_cm,"shape"),
			l_string(std_cm,"rect"));
		set_attribute(area,
			l_string(std_cm,"name"),
			l_string(std_cm,name));
		set_attribute(area,
			l_string(std_cm,"objCode"),
			l_string(std_cm,code));
			
		r = search_resource_by_no(el_1->rno);
		if ( r == 0 )
			goto simple;
		res_crd_id = get_id_by_edit_target(g_set,get_url_str2(&r->h.entry));
		if ( res_crd_id < 0 ) {
			set_attribute(area,
				l_string(std_cm,"resource"),
				get_url_str2(&r->h.entry));
		}
		else {
			sprintf(code,"%i",res_crd_id);
			set_attribute(area,
				l_string(std_cm,"resource"),
				l_string(std_cm,code));
		}
		if ( mode == GVHA_MODE_RSS_SHORT )
			goto simple;

		if ( r->h.type != RT_DRAW_GB )
			goto simple;

		if ( r != locked_r ) {
			if ( locked_r )
				unlock_pdb_lock(locked_r);
			lock_pdb_lock(r,0);
			locked_r = r;
		}
		obj = search_obj(r,el_1->code&MAIN_CODE);
		if ( obj == 0 ) {
//			unlock_pdb_lock(r);
			goto simple;
		}
		if ( obj->h.info_org == 0 ) {
//			unlock_pdb_lock(r);
			goto simple;
		}
		if ( obj->h.info_card == 0 )
			ret = cons(List(area,obj->h.info_org,-1),ret);
		else	ret = cons(List(area,obj->h.info_org,
				gvha_format_HTML(format_HTML(obj->h.info_card)),-1)
				,ret);
//		unlock_pdb_lock(r);
		continue;
	simple:
		ret = cons(List(area,-1),ret);
	}

	if ( locked_r )
		unlock_pdb_lock(locked_r);

	ret = List(cons(n_get_symbol("gb:html-map"),ret),-1);

	gc_pop(ret,gc_gb_sexp);
	return ret;
}


XL_SEXP *
get_layers_info(GBVIEW_STATUS * sts,int mode)
{
XL_SEXP * ret;
GBVIEW_LAYER_STATUS * ls;
XL_SEXP * sym;
char buf[10];

	if ( mode == GVHA_MODE_RSS_TINNY )
		return 0;
	ret = 0;
	for ( ls = sts->layers ; ls ; ls = ls->next ) {
		sym = n_get_symbol("layer");
		sprintf(buf,"%i",ls->id);
		set_attribute(sym,l_string(std_cm,"id"),l_string(std_cm,buf));
		set_attribute(sym,l_string(std_cm,"entry_url"),ls->entry_url);
		set_attribute(sym,l_string(std_cm,"target_url"),ls->target_url);
		sprintf(buf,"0x%x",ls->flags);
		set_attribute(sym,l_string(std_cm,"flags"),l_string(std_cm,buf));
		ret = cons(List(sym,-1),ret);
	}
	return reverse(ret);
}

XL_SEXP *
return_rdf(GVHA_SET * g_set,GVHA_QUERY * q,GVHA_FRAME_CACHE * c,L_CHAR *path,int * fp_flag)
{
XL_SEXP * ret,* sym,* sym2;
XL_SEXP * cur, * channel, * item, * item2;
char * next_target;
char * rss_target;
WARP_POINT * wp;

	if ( fp_flag && *fp_flag )
		gvha_flush_pos(c,fp_flag);
	next_target = get_next_target(g_set,c,path,GVHA_MODE_MOVE);
	rss_target = get_next_target(g_set,c,path,GVHA_MODE_RSS);
	if ( next_target == 0 || rss_target == 0 ) {
		return 0;
	}
//ss_printf("rr %s\n",next_target);

	sym = n_get_symbol("rdf:li");
	set_attribute(sym,
		l_string(std_cm,"rdf:resource"),
		l_string(std_cm,next_target));

	if ( c->c_sts.reference ) {
		sym2 = n_get_symbol("rdf:li");
		set_attribute(sym2,
			l_string(std_cm,"rdf:resource"),
			c->c_sts.reference);
		cur = List(n_get_symbol("rdf:Seq"),
			List(sym,-1),List(sym2,-1),-1);

	}
	else {
		cur = List(n_get_symbol("rdf:Seq"),
			List(sym,-1),-1);
	}

	sym = n_get_symbol("channel");
	set_attribute(sym,
		l_string(std_cm,"rdf:about"),
		l_string(std_cm,rss_target));

	channel = List(sym,
		List(n_get_symbol("title"),
			n_get_string("GLOBALBASE HTTP GATEWAY"),
			-1),
		List(n_get_symbol("link"),
			n_get_string(next_target),
			-1),
		List(n_get_symbol("description"),
			n_get_string("GLOBALBASE HTTP GATEWAY"),
			-1),
		List(n_get_symbol("items"),
			cur,-1),
		-1);

	sym = n_get_symbol("item");
	set_attribute(sym,
		l_string(std_cm,"rdf:about"),
		l_string(std_cm,next_target));

	switch ( q->mode ) {
	case GVHA_MODE_RSS_LARGE:
		wp = rc_get_warp_point(c->gf->radar_ptr,WPT_CRD);

		item = List(sym,
			List(n_get_symbol("title"),
				n_get_string("GLOBALBASE HTTP GATEWAY"),
				-1),
			List(n_get_symbol("link"),
				n_get_string(next_target),
				-1),
			List(n_get_symbol("description"),
				n_get_string("GLOBALBASE HTTP GATEWAY"),
				-1),
			List(n_get_symbol("gb:status1"),
				get_integer(c->all,0),
				-1),
			List(n_get_symbol("gb:status2"),
				get_integer(c->ls.wf.dirty|q->force_dirty,0),
				-1),
			List(n_get_symbol("gb:status-n"),
				get_integer(q->n,0),
				-1),
			cons(n_get_symbol("gb:status-layers"),
				get_layers_info(&c->sts,q->mode)),
			cons(n_get_symbol("gb:status-projection-type"),
				get_integer(c->sts.flame_base_display_map_type,0)),
			List(n_get_symbol("gb:status-warppoint"),
				wp2sexp(wp),-1),
			-1);
		free_warp_point(wp);
		break;
	default:
		item = List(sym,
			List(n_get_symbol("title"),
				n_get_string("GLOBALBASE HTTP GATEWAY"),
				-1),
			List(n_get_symbol("link"),
				n_get_string(next_target),
				-1),
			List(n_get_symbol("description"),
				n_get_string("GLOBALBASE HTTP GATEWAY"),
				-1),
			List(n_get_symbol("gb:status1"),
				get_integer(c->all,0),
				-1),
			List(n_get_symbol("gb:status2"),
				get_integer(c->ls.wf.dirty|q->force_dirty,0),
				-1),
			List(n_get_symbol("gb:status-n"),
				get_integer(q->n,0),
				-1),
			cons(n_get_symbol("gb:status-layers"),
				get_layers_info(&c->sts,q->mode)),
			cons(n_get_symbol("gb:status-projection-type"),
				get_integer(c->sts.flame_base_display_map_type,0)),
			-1);
		break;
	}
	item = append(item,
		plot_element_area_list(g_set,c,q->mode));

	if ( c->c_sts.reference ) {
		sym2 = n_get_symbol("item");
		set_attribute(sym2,
			l_string(std_cm,"rdf:about"),
			c->c_sts.reference);

		item2 = List(sym2,
			List(n_get_symbol("title"),
				n_get_string("GLOBALBASE HTTP GATEWAY"),
				-1),
			List(n_get_symbol("link"),
				get_string(c->c_sts.reference),
				-1),
			List(n_get_symbol("description"),
				n_get_string("click reference"),
				-1),
			-1);
	}

	sym = n_get_symbol("rdf:RDF");
	set_attribute(sym,
		l_string(std_cm,"xml:lang"),
		l_string(std_cm,"ja"));
	set_attribute(sym,
		l_string(std_cm,"xmlns:gb"),
		l_string(std_cm,
			"http://www.globalbase.org/spec/http-rss/0.1/"));
	set_attribute(sym,
		l_string(std_cm,"xmlns:rdf"),
		l_string(std_cm,
		"http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
	set_attribute(sym,
		l_string(std_cm,"xmlns"),
		l_string(std_cm,"http://purl.org/rss/1.0/"));
	ret = List(sym,channel,item,-1);
	d_f_ree(next_target);
	d_f_ree(rss_target);
	sym = n_get_symbol("?xml");
	set_attribute(sym,
		l_string(std_cm,"version"),
		l_string(std_cm,"1.0"));

	set_attribute(sym,
		l_string(std_cm,"encoding"),
		l_string(std_cm,"UTF-8"));

	sym = List(sym,-1);
	ret = List(sym,ret,-1);

	sym = n_get_symbol("text/xml");
	set_attribute(sym,
		l_string(std_cm,"Cache-Control"),
		l_string(std_cm,"private"));
	set_attribute(sym,
		l_string(std_cm,"Expire"),
		l_string(std_cm,"-1"));

	return List(sym,ret,-1);
}

void
gvha_flush_pos(GVHA_FRAME_CACHE * c,int * fp_flag)
{
GVHA_POS * p;

ss_printf("FLUSH-POS %i\n",c->gf->id);
	for ( ; c->pos ; ) {
		p = c->pos;
		c->pos = p->next;
		d_f_ree(p->target);
		d_f_ree(p);
	}
	if ( fp_flag )
		*fp_flag = 0;
}


void
gvha_insert_pos(GVHA_FRAME_CACHE * c)
{
GVHA_POS * gp,*gp2;
double d;
	gp = d_alloc(sizeof(*gp));
	gp->center = c->sts.flame_base_center;
	gp->rotate = c->sts.flame_base_rotate;
	gp->resolution = c->sts.flame_base_resolution;
	gp->target = ll_copy_str(c->sts.current_ls->entry_url);

	lock_task(gvha_lock);
	for ( gp2 = c->pos ; gp2 ; gp2 = gp2->next ) {
		d = gvha_pos_cmp(gp,gp2,c->win_size.x + c->win_size.y);
		if ( d < 0 )
			continue;
		if ( d < TOLL*0.1 )
			break;
	}
	if ( gp2 ) {
		d_f_ree(gp->target);
		d_f_ree(gp);
	}
	else {
		gp->next = c->pos;
		c->pos = gp;
	}
	unlock_task(gvha_lock,"return_rdf");
}


XL_SEXP *
return_gvha_status(GVHA_STATUS * code)
{
XL_SEXP * ret;
XL_SEXP * sym;
char buf[10];
XL_SEXP * header;
	ret = cons(n_get_symbol("gvha-status"),0);
	switch ( code->status ) {
	case GVHA_STS_OK:
		sym = n_get_symbol("result");
		set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,"ok"));
		ret = cons(List(sym,-1),ret);
		break;
	case GVHA_STS_NOT_SUPPORT:
		sym = n_get_symbol("result");
		set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,"NotSupport"));
		ret = cons(List(sym,n_get_string("not support mode (md)"),-1),ret);
		break;
	case GVHA_STS_NO_CRD_ID:
		sym = n_get_symbol("result");
		set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,"NoCrdID"));
		ret = cons(List(sym,n_get_string("Undefined coordinate ID"),-1),ret);
		break;
	case GVHA_STS_TARGET_CRD_IS_NOT_LOADED:
		sym = n_get_symbol("result");
		set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,"TargetCrdIsNotLoaded"));
		ret = cons(List(sym,n_get_string("Target coordinate is not loaded on the memory"),-1),ret);
		break;
	case GVHA_STS_TARGET_VCT_IS_NOT_LOADED:
		sym = n_get_symbol("result");
		set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,"TargetVctIsNotLoaded"));
		ret = cons(List(sym,n_get_string("Target vector data is not loaded on the memory"),-1),ret);
		break;
	case GVHA_STS_POINT_OUTOF_BOUND:
		sym = n_get_symbol("result");
		set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,"PointOutOfBound"));
		ret = cons(List(sym,n_get_string("Given point is out of bound"),-1),ret);
		break;
	case GVHA_STS_MARK_UPDATE_ERROR:
		sym = n_get_symbol("result");
		set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,"MarkUpdateError"));
		ret = cons(List(sym,n_get_string("Cannot update the mark"),-1),ret);
		break;
	case GVHA_STS_INFORMATION_TAG_REQUIRED:
		sym = n_get_symbol("result");
		set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,"InformationTagRequired"));
		ret = cons(List(sym,n_get_string("Information tag is required in the information data"),-1),ret);
		break;
	case GVHA_STS_INFORMATION_UPDATE_ERROR:
		sym = n_get_symbol("result");
		set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,"InformationUpdateError"));
		ret = cons(List(sym,n_get_string("Cannot update the information"),-1),ret);
		break;
	case GVHA_STS_NO_OBJECT:
		sym = n_get_symbol("result");
		set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,"ThereisNoObject"));
		ret = cons(List(sym,n_get_string("There is no object"),-1),ret);
		break;
	case GVHA_STS_CANNOT_CREATE_TMPFILE:
		sym = n_get_symbol("result");
		set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,"CannotCreateTempFile"));
		ret = cons(List(sym,n_get_string("Cannot create temporaly file for save"),-1),ret);
		break;
	case GVHA_STS_SAVE_ERROR:
		sym = n_get_symbol("result");
		set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,"SaveError"));
		ret = cons(List(sym,n_get_string("Cannot save the file"),-1),ret);
		break;
	case GVHA_STS_NOT_NEED_SAVE:
		sym = n_get_symbol("result");
		set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,"NotNeedSave"));
		ret = cons(List(sym,n_get_string("The file is not updated...Not need to save."),-1),ret);
		break;
	default:
		sprintf(buf,"%i",code->status);
		sym = n_get_symbol("result");
		set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,buf));
		ret = cons(List(sym,n_get_string("unknown error"),-1),ret);
		break;
	}
	if ( code->session_id ) {
		sprintf(buf,"%i",code->session_id);
		sym = n_get_symbol("session");
		set_attribute(sym,l_string(std_cm,"id"),l_string(std_cm,buf));
		ret = cons(List(sym,-1),ret);
	}
	if ( code->err_message )
		ret = cons(code->err_message,ret);
	ret = reverse(ret);

	sym = n_get_symbol("?xml");
	set_attribute(sym,
		l_string(std_cm,"version"),
		l_string(std_cm,"1.0"));

	set_attribute(sym,
		l_string(std_cm,"encoding"),
		l_string(std_cm,"UTF-8"));

	header = List(sym,-1);


	sym = n_get_symbol("text/xml");
	set_attribute(sym,
		l_string(std_cm,"Cache-Control"),
		l_string(std_cm,"private"));
	set_attribute(sym,
		l_string(std_cm,"Expire"),
		l_string(std_cm,"-1"));
	ret = List(sym,List(header,ret,-1),-1);

ss_printf("retult code = ");
print_sexp(s_stdout,ret,0);
ss_printf("\n");
	return ret;
}

void
get_gvha_vct(GVHA_SET * g_set,GVHA_STATUS * sts,GVHA_VCT_SET * vs,int vct,
		char * vct_byname)
{
GVHA_COORDINATE * cc;
URL u;
	lock_task(gvha_lock);
	if ( vct ) {
		for ( cc = g_set->coord_list ; cc ; cc = cc->next )
			if ( cc->id == vct )
				break;
		if ( cc == 0 ) {
			sts->status = GVHA_STS_NO_CRD_ID;
			sts->err_message = List(n_get_symbol("ErrID"),
					get_integer(vct,0),-1);
			goto end;
		}
		vs->c_info = cc;
	
		get_url2(&u,cc->url);
		vs->crd = search_resource_by_entry(&u);
		free_url(&u);
		if ( vs->crd == 0 ) {
			sts->status = GVHA_STS_TARGET_CRD_IS_NOT_LOADED;
			goto end;
		}
		get_url2(&u,cc->edit_target);
		vs->vct = search_resource_by_entry(&u);
		free_url(&u);
		if ( vs->vct == 0 ) {
			sts->status = GVHA_STS_TARGET_VCT_IS_NOT_LOADED;
			goto end;
		}
		vs->env = new_env_pair(vector_env,gblisp_top_env0);
		set_env(vs->env,l_string(std_cm,"__resource"),get_ptr(vs->vct,0));
	}
	else {
		vs->c_info = 0;
		get_url2(&u,l_string(std_cm,vct_byname));
		vs->crd = 0;
		vs->vct = search_resource_by_entry(&u);
		free_url(&u);
		if ( vs->vct == 0 ) {
			sts->status = GVHA_STS_TARGET_VCT_IS_NOT_LOADED;
			goto end;
		}
		vs->env = new_env_pair(vector_env,gblisp_top_env0);
		set_env(vs->env,l_string(std_cm,"__resource"),get_ptr(vs->vct,0));
	}
end:
	unlock_task(gvha_lock,"get_gvha_vct");
}



GB_POINT
get_gvha_mark_point(GVHA_STATUS * sts,GVHA_FRAME_CACHE * c,GVHA_VCT_SET * vs,I_POINT display_ptr)
{
GB_POINT ret;
GBVIEW_STATUS wf_sts;
INDICATE * in;
XL_SEXP * in_list;
	in_list = 0;
	wf_indicate(c->gf,0,display_ptr.x,display_ptr.y,0);
	locked_wf_status(c->gf,&wf_sts);
	for ( in = wf_sts.indicate ; in ; in = in ->next ) {
		in_list = cons(get_string(get_url_str2(&in->url)),in_list);
		if ( url_cmp_str(&in->url,&vs->vct->h.entry) == 0 )
			break;
	}
	in_list = cons(n_get_symbol("indicate"),in_list);
	if ( in == 0 ) {
		sts->status = GVHA_STS_POINT_OUTOF_BOUND;
		sts->err_message = List(
				get_integer(display_ptr.x,0),
				get_integer(display_ptr.y,0),
				get_string(get_url_str2(&vs->vct->h.entry)),
				in_list,
				-1);
		goto end;
	}
	ret = in->result[0];
end:
	wf_free_status(&wf_sts);
	return ret;
}

int
gvha_gen_code(GVHA_STATUS * sts,GVHA_VCT_SET * vs)
{
unsigned int objCode;
OBJ * obj;
	for ( ; ; ) {
		lock_task(gvha_lock);
		objCode = vs->c_info->vct_objCode + 0x100;
		if ( objCode == 0 )
			objCode = 0x100;
		vs->c_info->vct_objCode = objCode;
		unlock_task(gvha_lock,"gvha_gen_code");
		obj = search_obj(vs->vct,objCode);
		if ( obj == 0 )
			break;
	}
	return objCode;
}

void
gbha_update_mark(GVHA_STATUS * sts,GVHA_VCT_SET * vs,int code,GB_POINT ptr,char * mark_url,int markTransparent)
{
XL_SEXP * sym;
XL_SEXP * cmd;
XL_SEXP * ret;
char buf[10];
	gc_push(0,0,"");
	sym = n_get_symbol("mark");
	if ( mark_url )
		set_attribute(sym,l_string(std_cm,"img"),l_string(std_cm,mark_url));
	sprintf(buf,"%i",code);
	set_attribute(sym,l_string(std_cm,"code"),l_string(std_cm,buf));
	sprintf(buf,"#%x",markTransparent);
	set_attribute(sym,l_string(std_cm,"transparent"),l_string(std_cm,buf));
	cmd = List(sym,get_floating(ptr.x,0),get_floating(ptr.y,0),-1);
	ret = eval(vs->env,cmd);
	if ( get_type(ret) == XLT_ERROR ) {
		sts->status = GVHA_STS_MARK_UPDATE_ERROR;
		sts->err_message = ret;
		goto end;
	}
	set_resource_dirty(vs->vct);
end:
	gc_pop(0,0);
}

void
gbha_delete_mark(GVHA_STATUS * sts,GVHA_VCT_SET * vs,int code)
{
OBJ * obj;
	lock_pdb_lock(vs->vct,0);
	obj = search_obj(vs->vct,code);
	if ( obj == 0 ) {
		sts->status = GVHA_STS_NO_OBJECT;
		goto end;
	}
	free_object(vs->vct,obj);
	set_resource_dirty(vs->vct);
end:
	unlock_pdb_lock(vs->vct);
}

void
gvha_update_information(GVHA_STATUS * sts,GVHA_VCT_SET * vs,int code,char * info)
{
XL_SEXP * sym;
XL_SEXP * cmd;
XL_SEXP * ret;
char buf[10];
STREAM * st;
L_CHAR * scheme;
	gc_push(0,0,"");
	st = s_open_string_read(info,&utf8_cm,strlen(info),0);
	cmd = init_parse(st,l_string(std_cm,"information"),l_string(std_cm,"information"));
	cmd = car(cmd);
	sym = car(cmd);
	if ( get_type(sym) != XLT_SYMBOL ) {
		sts->err_message = cmd;
		sts->status = GVHA_STS_INFORMATION_TAG_REQUIRED;
		goto end;
	}
	if ( l_strcmp(sym->symbol.data,l_string(std_cm,"information")) ) {
		sts->err_message = cmd;
		sts->status = GVHA_STS_INFORMATION_TAG_REQUIRED;
		goto end;
	}
/*
prev:
	cmd = cons(sym = n_get_symbol("information"),cmd);
	goto next;
next:
*/
	scheme = get_sf_attribute(sym->symbol.field,l_string(std_cm,"scheme"));
	if ( scheme == 0 && vs->vct->draw_gb.ischeme ) {
		set_attribute(sym,l_string(std_cm,"scheme"),vs->vct->draw_gb.ischeme->scheme);
	}
	sprintf(buf,"%i",code);
	set_attribute(sym,l_string(std_cm,"code"),l_string(std_cm,buf));
	ret = eval(vs->env,cmd);
	if ( get_type(ret) == XLT_ERROR ) {
		sts->status = GVHA_STS_INFORMATION_UPDATE_ERROR;
		sts->err_message = ret;
		goto end;
	}
	set_resource_dirty(vs->vct);
end:
	gc_pop(0,0);
}


void
gvha_object(GVHA_STATUS * sts,GVHA_VCT_SET * vs,int code)
{
OBJ * obj;
CODE_METHOD * cm;
	cm = search_cm("UTF-8");
	if ( cm == 0 )
		er_panic("aa");
#ifdef GVHA_PATH_DEBUG
ss_printf("obj-1 %p\n",vs->vct);
#endif
	if ( lock_pdb_lock(vs->vct,0) < -1 ) {
		sts->status = GVHA_STS_OK;
		sts->err_message = List(n_get_symbol("gvha-object"),-1);
		goto end2;
	}
#ifdef GVHA_PATH_DEBUG
ss_printf("obj-2\n");
#endif
	obj = search_obj(vs->vct,code);
#ifdef GVHA_PATH_DEBUG
ss_printf("obj-3\n");
#endif
	if ( obj == 0 ) {
		sts->status = GVHA_STS_NO_OBJECT;
		goto end;
	}
	sts->status = GVHA_STS_OK;
	if ( obj->h.info_org == 0 ) {
		sts->err_message = List(n_get_symbol("gvha-object"),-1);
	}
	else if ( obj->h.info_card == 0 )
		sts->err_message = List(n_get_symbol("gvha-object"),
				convert_code(obj->h.info_org,cm->main_code,CBF_ERR_QUESTION),
				-1);
	else
		sts->err_message = List(n_get_symbol("gvha-object"),
			convert_code(obj->h.info_org,cm->main_code,CBF_ERR_QUESTION),
			convert_code(gvha_format_HTML(format_HTML(obj->h.info_card)),
					cm->main_code,CBF_ERR_QUESTION),
			-1);
end:
	unlock_pdb_lock(vs->vct);
end2:	;
}

void
gvha_save(GVHA_STATUS * sts,GVHA_VCT_SET * vs)
{
STREAM * st;
char * tmp_path;
int len;
int tmp_no;
SAVE_ST_WORK stw;
int p;
XL_SEXP * ret;

	gvha_save_lock(vs->c_info);
	if ( check_resource_dirty(vs->vct) == 0 ) {
		sts->status = GVHA_STS_NOT_NEED_SAVE;
		
		gvha_save_unlock(vs->c_info);
		return;
	}
	reset_resource_dirty(vs->vct);
	tmp_path = ln_copy_str(&utf8_cm,vs->c_info->save_path);
	len = strlen(tmp_path);
	tmp_path = d_re_alloc(tmp_path,len+10);
	tmp_no = 1;
	for ( ; ; ) {
		sprintf(&tmp_path[len],"%i",tmp_no);
		st = s_open_file(tmp_path,O_RDONLY);
		if ( st ) {
			s_close(st);
			tmp_no ++;
			continue;
		}
		break;
	}
	st = s_open_file(tmp_path,O_RDWR|O_CREAT,0644);
	if ( st == 0 ) {
		set_resource_dirty(vs->vct);
		sts->status = GVHA_STS_CANNOT_CREATE_TMPFILE;

		gvha_save_unlock(vs->c_info);
		return;
	}
	
	stw.st = st;
	save_resource_st(vs->vct,&stw);
	
	s_close(st);
	rename(tmp_path,n_string(&utf8_cm,vs->c_info->save_path));

	for ( p = len-1 ; p >= 0 && tmp_path[p] != '/' ; p -- );
	if ( p < 0 ) {
		tmp_path[0] = '.';
		p = 1;
	}
	tmp_path[p] = 0;
	ret = Shell_target(l_string(std_cm,"xl"),
		l_string(std_cm,"direct"),
		gblisp_top_env0,
		cons(n_get_symbol("Target"),
		sexp_commands(std_cm,
			"<Define> ^cur-dir ",tmp_path,"</Define>\n",
			"<Load option=\"exec\">makefile.xl</Load>",
			0)));
	if ( get_type(ret) == XLT_ERROR ) {
		set_resource_dirty(vs->vct);
		sts->status = GVHA_STS_SAVE_ERROR;
		sts->err_message = ret;
	}
	gvha_save_unlock(vs->c_info);
}


XL_SEXP *
_xl_GET(
	XLISP_ENV * e,XL_SEXP * s,XLISP_ENV * ae,XL_SYM_FIELD * sf,
	GVHA_FRAME_CACHE * out_c)
{
L_CHAR * _dir;
char * _dir_1,* _dir_2;
GVHA_QUERY q;
GVHA_FRAME_CACHE * c;
XL_SEXP * ret;
int c_flag;
int retry_cnt;
I_POINT from,to;
GB_RECT rr;
GBVIEW_PLANE gbp;
char * err_msg;
int rcode;
char * tmp;
int flush_pos;
int sts_load;
XL_SEXP * sym;
GVHA_STATUS gs;
int m_code;
GB_POINT m_ptr;
GVHA_VCT_SET vs;
CODE_METHOD * cm;
GB_RECT o_rect1;
GVHA_SET * g_set;
int err;

	memset(&q,0,sizeof(q));
	sts_load = 0;
	flush_pos = 0;
	retry_cnt = 5;
	c_flag = 0;
	_dir = get_sf_attribute(sf,l_string(std_cm,"dir"));
	if ( _dir == 0 )
		goto sys_error;
	g_set = search_gvha_set_URL(_dir);
#ifdef GVHA_PATH_DEBUG
ss_printf("g_set = %p R%ls\n",g_set,_dir);
#endif
	if ( g_set == 0 )
		goto sys_error2;
	_dir_1 = ln_copy_str(std_cm,_dir);
	_dir_2 = convert_percent(_dir_1,"[]");
	err_msg = 0;
	rcode = get_gvha_query(g_set,&q,_dir_2);
	d_f_ree(_dir_1);
	d_f_ree(_dir_2);
	if ( rcode < 0 ) {
		err_msg = "query parsing";
#ifdef GVHA_PATH_DEBUG
ss_printf("ERR %s\n",err_msg);
#endif
		goto invalid_url;
	}
	if ( q.mode == GVHA_MODE_MOVE && q.pos.target == 0 ) {
		err_msg = "query parsing target=0 mode undef";
#ifdef GVHA_PATH_DEBUG
ss_printf("ERR %s\n",err_msg);
#endif
		goto invalid_url;
	}
	if ( q.mode & GVHA_NREQ_FRAME_CACHE ) {
		c = 0;
#ifdef GVHA_PATH_DEBUG
ss_printf("NOREQ_FRAME_CACHE\n");
#endif
		goto finish2;
	}
	if ( out_c ) {
		c = out_c;
		goto warp;
	}
retry:

#ifdef GVHA_PATH_DEBUG
ss_printf("SEARCH\n");
#endif

	c = search_gvha_frame_cache(
			&g_set->processed_cache,
			&q,1,c_flag);
#ifdef GVHA_PATH_DEBUG
ss_printf("S-1\n");
#endif
	if ( c )
		goto move;
	c = search_gvha_frame_cache(
			&g_set->processed_cache,
			&q,0,c_flag);
#ifdef GVHA_PATH_DEBUG
ss_printf("S-2\n");
#endif
	if ( c ) {
#ifdef GVHA_PATH_DEBUG
ss_printf("S-3\n");
#endif
		if ( GVHA_MODE_ECT_LOW <= q.mode &&
				q.mode <= GVHA_MODE_ECT_HIGH )
			goto move;
		else	goto change_layer;
	}
	c = search_gvha_frame_cache(
			&g_set->processed_cache,
			&q,2,c_flag);

	if ( c == 0 ) {
#ifdef GVHA_PATH_DEBUG
ss_printf("S-4\n");
#endif

		c = search_gvha_frame_cache(
			&g_set->processed_cache,
			&q,2+4,c_flag);
		if ( c ) {
#ifdef GVHA_PATH_DEBUG
ss_printf("S-5\n");
#endif
			search_gvha_frame_size(g_set,c->win_size,SF_REAL_DEL);
			search_gvha_frame_size(g_set,q.win_size,SF_REAL_INS);
			c->sts.width = q.win_size.x;
			c->sts.height = q.win_size.y;
			c->sts.flags = SF_WIDTH|SF_HEIGHT;
			wf_set_status(c->gf,&c->sts);
			locked_wf_status(c->gf,&c->sts);
			gvha_flush_pos(c,&flush_pos);
			tmp = get_next_target(g_set,c,_dir,GVHA_MODE_RSS);
			if ( tmp )
				d_f_ree(tmp);
			c->win_size = q.win_size;
			unlock_frame_lock(c);
			goto retry;
		}
#ifdef GVHA_PATH_DEBUG
ss_printf("S-6\n");
#endif
		if ( retry_cnt <= 0 )
			goto busy_err;
		retry_cnt --;
		sleep_sec(1);
		goto retry;
	}
#ifdef GVHA_PATH_DEBUG
ss_printf("S-7\n");
#endif
	if ( lock_mv_lock(c) < 0 ) {
		c_flag = 1;
		goto retry;
	}
warp:

#ifdef GVHA_PATH_DEBUG
ss_printf("POS (%f %f) %f %f %ls\n",
q.pos.center.x,
q.pos.center.y,
q.pos.resolution,
q.pos.rotate,
q.pos.target);
#endif

	flush_pos = 1;
	err = rc_warp((RADAR_CACHE*)c->gf->radar_ptr,
		WT_CENTER,0,
		&q.pos.center,
		q.pos.resolution,
		q.pos.rotate,
		q.pos.target,0,1);
		
#ifdef GVHA_PATH_DEBUG
ss_printf("POS-AFTER (%f %f) %f %f --- %i\n",
c->gf->flame_base_center.x,
c->gf->flame_base_center.y,
c->gf->flame_base_resolution,
c->gf->flame_base_rotate,
err);
if ( c->gf->flame_base )
ss_printf("POS-AFTER2 %ls\n",get_url_str2(&c->gf->flame_base->draw->h.entry));
#endif

change_layer:

#ifdef GVHA_PATH_DEBUG
ss_printf("CHANGE LAYER\n");
#endif
	if ( lock_mv_lock(c) < 0 ) {
		c_flag = 1;
		goto retry;
	}
//	flush_pos = 1;
	change_layer(g_set,c,&q);
move:

#ifdef GVHA_PATH_DEBUG
ss_printf("MOVE\n");
#endif
	if ( q.move.x == 0 && q.move.y == 0 )
		goto zoom;

	if ( lock_mv_lock(c) < 0 ) {
		c_flag = 1;
		goto retry;
	}

#ifdef GVHA_PATH_DEBUG
ss_printf("MOVE-1\n");
#endif
	flush_pos = 1;

	to.x = c->win_size.x/2;
	to.y = c->win_size.y/2;
	from.x = q.move.x + to.x;
	from.y = q.move.y + to.y;
	if ( from.x < 0 )
		from.x = 0;
	else if ( from.x >= c->win_size.x )
		from.x = c->win_size.x-1;
	if ( from.y < 0 )
		from.y = 0;
	else if ( from.y >= c->win_size.y )
		from.y = c->win_size.y-1;

	wf_move(c->gf,from,to);

zoom:

#ifdef GVHA_PATH_DEBUG
ss_printf("ZOOM\n");
#endif
	if ( q.zoom == 1 )
		goto finish;
	if ( lock_mv_lock(c) < 0 ) {
		c_flag = 1;
		goto retry;
	}

#ifdef GVHA_PATH_DEBUG
ss_printf("ZOOM-1\n");
#endif
	flush_pos = 1;

	wf_zoom(c->gf,0,q.zoom);
finish:

#ifdef GVHA_PATH_DEBUG
ss_printf("FINISH %x\n",c);
#endif
	c_flag = 0;
	if ( q.complete ) {
		complete_lock(c);
		unlock_frame_lock(c);
		c_flag = 1;
		for ( ; ; ) {
			get_rc_loading_status(
				(RADAR_CACHE*)c->gf->radar_ptr,&c->ls.rc);
			wf_free_status(&c->sts);
			sts_load = 1;
			locked_wf_status(c->gf,&c->sts);
			c->ls.wf = c->sts.loading_status;
			loading_status_cal(c);

#ifdef GVHA_PATH_DEBUG
ss_printf("COMPLETE %i %i\n",c->all,c->ls.wf.dirty);
#endif
			if ( c->all == 0 )
				break;

			sleep_sec(1);
		}
	}
finish2:

#ifdef GVHA_PATH_DEBUG
if ( c )
ss_printf("MODE %i ==> %i\n",c->gf->id,q.mode);
else
ss_printf("MODE xx ==> %i\n",q.mode);
#endif

	switch ( q.mode ) {
	case GVHA_MODE_MOVE:
#ifdef GVHA_PATH_DEBUG
if ( c )
ss_printf("MOVE FM = %i\n",c->gf->id);
#endif
		rr.tl.x = rr.tl.y = 0;
		rr.br.x = c->win_size.x;
		rr.br.y = c->win_size.y;

		set_redraw_rect(c->gf,&rr);

		if ( ! wf_redraw(c->gf,&gbp,
				0,0,c->win_size.x,c->win_size.y) )
			er_panic("GVHA_MODE_MOVE");
		ret = _gbp2list(&gbp, l_string(std_cm,"jpeg"),80);

		wf_free_plane(&gbp);

		locked_wf_status(c->gf,&c->sts);
#ifdef GVHA_PATH_DEBUG
if ( c )
ss_printf("MOVE DIRTY = %i\n",c->sts.loading_status.dirty);
#endif
		sym = n_get_symbol("image/jpeg");
		set_attribute(sym,
			l_string(std_cm,"Expires"),
			l_string(std_cm,"-1"));
		set_attribute(sym,
			l_string(std_cm,"Cache-Control"),
			l_string(std_cm,"private"));
		ret = List(sym,get_el(ret,3),
			-1);
		break;
	case GVHA_MODE_INFO1:
		wf_free_status(&c->c_sts);
		wf_click(c->gf,&c->c_sts,0,q.move.x,q.move.y);

		get_rc_loading_status(
			(RADAR_CACHE*)c->gf->radar_ptr,&c->ls.rc);
		wf_free_status(&c->sts);
		sts_load = 1;
		locked_wf_status(c->gf,&c->sts);
		c->ls.wf = c->sts.loading_status;
		loading_status_cal(c);

		ret = return_rdf(g_set,&q,c,_dir,&flush_pos);
#ifdef GVHA_PATH_DEBUG
if ( c )
ss_printf("RSS INFO1 FM = %i\n",c->gf->id);
#endif
		wf_free_status(&c->c_sts);
		break;
	case GVHA_MODE_INFO2:
		err_msg = "info2 unsupport";
		goto invalid_url;
	case GVHA_MODE_RSS:
	case GVHA_MODE_RSS_SHORT:
	case GVHA_MODE_RSS_TINNY:
	case GVHA_MODE_RSS_LARGE:
		get_rc_loading_status(
			(RADAR_CACHE*)c->gf->radar_ptr,&c->ls.rc);
		wf_free_status(&c->sts);
		sts_load = 1;
		locked_wf_status(c->gf,&c->sts);
		c->ls.wf = c->sts.loading_status;
		loading_status_cal(c);

		ret = return_rdf(g_set,&q,c,_dir,&flush_pos);
#ifdef GVHA_PATH_DEBUG
if ( c )
ss_printf("RSS FM = %i\n",c->gf->id);
/*
print_sexp(s_stdout,ret,0);
ss_printf("\n");
*/
#endif
		break;
	case GVHA_MODE_ECT_OPEN:
		memset(&gs,0,sizeof(gs));
		gs.status = GVHA_STS_OK;
		for ( ; gs.session_id == 0 ; )
			gs.session_id = g_set->gvha_session_id ++;
		ret = return_gvha_status(&gs);
		break;
	case GVHA_MODE_ECT_INSERT:
		memset(&gs,0,sizeof(gs));
		get_gvha_vct(g_set,&gs,&vs,q.e_vct,q.e_vct_byname);
		if ( gs.status )
			goto insert_end;
		m_ptr = get_gvha_mark_point(&gs,c,&vs,q.e_position);
		if ( gs.status )
			goto insert_end;
		m_code = gvha_gen_code(&gs,&vs);
		if ( gs.status )
			goto insert_end;
		gbha_update_mark(&gs,&vs,m_code,m_ptr,q.e_markImg,q.e_markTransparent);
		if ( gs.status )
			goto insert_end;
		gvha_update_information(&gs,&vs,m_code,q.e_information);
		if ( gs.status )
			goto insert_end;
		if ( get_object_minrect2(&o_rect1,vs.vct,m_code) == 0 ) {
			wf_insert_dirty_rect(vs.vct,
				&o_rect1,
				WFF_PLOT_DIRTY,10,10);
			c->update = get_xltime() + ECT_UPDATE_TIMEOUT;
		}
		gs.err_message = get_integer(m_code,0);
	insert_end:
#ifdef GVHA_PATH_DEBUG
ss_printf("insert_end 1\n");
#endif
		ret = return_gvha_status(&gs);
#ifdef GVHA_PATH_DEBUG
ss_printf("insert_end 2\n");
#endif
		break;
	case GVHA_MODE_ECT_DELETE:
		memset(&gs,0,sizeof(gs));
		get_gvha_vct(g_set,&gs,&vs,q.e_vct,q.e_vct_byname);
		if ( gs.status )
			goto insert_end;
		get_object_minrect2(&o_rect1,vs.vct,m_code);

		gbha_delete_mark(&gs,&vs,q.e_objCode);
		
		if ( o_rect1.tl.x <= o_rect1.br.x ) {
			wf_insert_dirty_rect(vs.vct,
				&o_rect1,
				WFF_PLOT_DIRTY,10,10);
			c->update = get_xltime() + ECT_UPDATE_TIMEOUT;
		}
		goto insert_end;

	case GVHA_MODE_ECT_UPDATE:
		memset(&gs,0,sizeof(gs));
		get_gvha_vct(g_set,&gs,&vs,q.e_vct,q.e_vct_byname);
		if ( gs.status )
			goto insert_end;

		get_object_minrect2(&o_rect1,vs.vct,m_code);

		gvha_update_information(&gs,&vs,q.e_objCode,q.e_information);
		if ( gs.status )
			goto insert_end;

		if ( o_rect1.tl.x <= o_rect1.br.x )
			wf_insert_dirty_rect(vs.vct,
				&o_rect1,
				WFF_PLOT_DIRTY,10,10);
		if ( get_object_minrect2(&o_rect1,vs.vct,m_code) == 0 ) {
			wf_insert_dirty_rect(vs.vct,
				&o_rect1,
				WFF_PLOT_DIRTY,10,10);
			c->update = get_xltime() + ECT_UPDATE_TIMEOUT;
		}

		goto insert_end;

	case GVHA_MODE_ECT_MOVE:
		memset(&gs,0,sizeof(gs));
		get_gvha_vct(g_set,&gs,&vs,q.e_vct,q.e_vct_byname);
		if ( gs.status )
			goto insert_end;
		m_ptr = get_gvha_mark_point(&gs,c,&vs,q.e_position);
		if ( gs.status )
			goto insert_end;

		get_object_minrect2(&o_rect1,vs.vct,m_code);

		gbha_update_mark(&gs,&vs,q.e_objCode,m_ptr,q.e_markImg,q.e_markTransparent);
		if ( gs.status )
			goto insert_end;

		if ( o_rect1.tl.x <= o_rect1.br.x )
			wf_insert_dirty_rect(vs.vct,
				&o_rect1,
				WFF_PLOT_DIRTY,10,10);
		if ( get_object_minrect2(&o_rect1,vs.vct,m_code) == 0 ) {
			wf_insert_dirty_rect(vs.vct,
				&o_rect1,
				WFF_PLOT_DIRTY,10,10);
			c->update = get_xltime() + ECT_UPDATE_TIMEOUT;
		}
		goto insert_end;

	case GVHA_MODE_ECT_SAVE:
		memset(&gs,0,sizeof(gs));
		get_gvha_vct(g_set,&gs,&vs,q.e_vct,q.e_vct_byname);
		if ( gs.status )
			goto insert_end;
		gvha_save(&gs,&vs);
		goto insert_end;
	case GVHA_MODE_ECT_CLOSE:
		memset(&gs,0,sizeof(gs));
		gs.status = GVHA_STS_OK;
		ret = return_gvha_status(&gs);
		break;
	case GVHA_MODE_ECT_OBJECT:
#ifdef GVHA_PATH_DEBUG
ss_printf("GVHA_MODE_ECT_OBJECT\n");
#endif
		memset(&gs,0,sizeof(gs));
		get_gvha_vct(g_set,&gs,&vs,q.e_vct,q.e_vct_byname);
#ifdef GVHA_PATH_DEBUG
ss_printf("GVHA_MODE_ECT_OBJECT 2\n");
#endif
		if ( gs.status )
			goto insert_end;
#ifdef GVHA_PATH_DEBUG
ss_printf("GVHA_MODE_ECT_OBJECT 3\n");
#endif
		gvha_object(&gs,&vs,q.e_objCode);
#ifdef GVHA_PATH_DEBUG
ss_printf("GVHA_MODE_ECT_OBJECT 4\n");
#endif
		goto insert_end;
	default:
		er_panic("xl_GET");
	}

#ifdef GVHA_PATH_DEBUG
if ( c )
ss_printf("LAST-1 = %i\n",c->gf->id);
else
ss_printf("LAST-1 = xx\n");
#endif
	if ( c ) {
		if ( flush_pos )
			gvha_flush_pos(c,&flush_pos);
		if ( sts_load == 0 || flush_pos )
			locked_wf_status(c->gf,&c->sts);
		tmp = get_next_target(g_set,c,_dir,GVHA_MODE_RSS);
		if ( tmp )
			d_f_ree(tmp);


		free_gvha_query(&q);
		if ( c_flag )
			complete_unlock(c);
		else	unlock_frame_lock(c);

		search_gvha_frame_size(g_set,q.win_size,SF_COUNT);
	}
	else {
		free_gvha_query(&q);
	}
#ifdef GVHA_PATH_DEBUG
if ( c )
ss_printf("LAST-2 = %i\n",c->gf->id);
else
ss_printf("LAST-2 = xx\n");
#endif
	
	{
	XL_SEXP * xml,*xml_sym;
	L_CHAR * encode;
		xml = car(get_el(ret,1));
		if ( get_type(xml) != XLT_PAIR )
			goto rett;
		xml_sym = car(xml);
		if ( get_type(xml_sym) != XLT_SYMBOL )
			goto rett;
		encode = get_sf_attribute(xml_sym->symbol.field,l_string(std_cm,"encoding"));
		if ( encode ) {
			cm = search_cm(n_string(std_cm,encode));
			gc_push(0,0,"convert");
			if ( cm )
				ret = convert_code(ret,cm->main_code,CBF_ERR_QUESTION);
			gc_pop(ret,gc_gb_sexp);
		}
	}
rett:
#ifdef GVHA_PATH_DEBUG
if ( c )
ss_printf("LAST-3 %i = %i\n",get_tid(),c->gf->id);
else
ss_printf("LAST-3 %i = xx\n",get_tid());
#endif

	return ret;

sys_error:
#ifdef GVHA_PATH_DEBUG
ss_printf("SYS_ERROR\n");
#endif
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_FIELD_NAME,
		l_string(std_cm,"gbview/GET"),
		n_get_string("dir attribute is required"));
sys_error2:
#ifdef GVHA_PATH_DEBUG
ss_printf("SYS_ERROR 2\n");
#endif
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_FIELD_NAME,
		l_string(std_cm,"gbview/GET"),
		n_get_string("corresponding gvha set is not defined (dir)"));
busy_err:
#ifdef GVHA_PATH_DEBUG
ss_printf("BUSY_ERROR 2\n");
#endif
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_BUSY,
		l_string(std_cm,"gbview/GET"),
		n_get_string("home page is BUSY"));
invalid_url:
#ifdef GVHA_PATH_DEBUG
ss_printf("INV URL 2\n");
#endif
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_FIELD_NAME,
		l_string(std_cm,"gbview/GET"),
		List(n_get_string("invalid URL"),
			n_get_string(err_msg),
			get_integer(rcode,0),-1));
}

XL_SEXP *
_xl_GET_call(
	XLISP_ENV * e,XL_SEXP * s,XLISP_ENV * ae,XL_SYM_FIELD * sf)
{
XL_SEXP * ret;

	ret =  _xl_GET(e,s,ae,sf,0);
	return ret;
}

XL_SEXP *
xl_GET(
	XLISP_ENV * e,XL_SEXP * s,XLISP_ENV * ae,XL_SYM_FIELD * sf)
{
XL_SEXP * sym;
XL_SEXP * xl_Thread();
XL_SEXP * ret;


	sym = n_get_symbol("_GET_call");
	sym->symbol.field = sf;
	s = cons(sym,cdr(s));
	ret = xl_Thread(e,
		List(n_get_symbol("Thread"),s,-1),
		ae,0);
	return ret;
}


XL_SEXP *
xl_POST(
	XLISP_ENV * e,XL_SEXP * s,XLISP_ENV * ae,XL_SYM_FIELD * sf)
{
XL_SEXP * sym;
XL_SEXP * xl_Thread();
XL_SEXP * r;
char * buf;
L_CHAR * _dir;
L_CHAR * _buf;
int len;
XL_SEXP * ret;

	sym = n_get_symbol("_GET_call");
	r = get_el(s,1);
	if ( get_type(r) != XLT_RAW )
		goto type_missmatch;
	for ( ; sf ; sf = sf->next ) {
		if ( l_strcmp(sf->name,l_string(std_cm,"dir")) == 0 ) {
			buf = d_alloc(r->raw.size+1);
			memcpy(buf,r->raw.data,r->raw.size);
			buf[r->raw.size] = 0;
			_buf = l_string(std_cm,buf);
			d_f_ree(buf);
			_dir = ll_copy_str(sf->data);
			len = l_strlen(_dir);
			_dir = d_re_alloc(_dir,(len+r->raw.size+10)*sizeof(L_CHAR));
			_dir[len] = '?';
			memcpy(&_dir[len+1],_buf,(l_strlen(_buf)+1)*sizeof(L_CHAR));
			set_attribute(sym,sf->name,_dir);
			d_f_ree(_dir);
		}
		else {
			set_attribute(sym,sf->name,sf->data);
		}
	}
	s = cons(sym,0);
	ret = xl_Thread(e,
		List(n_get_symbol("Thread"),s,-1),
		ae,0);
	return ret;

type_missmatch:
	return get_error(
	s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gbview/GET"),
		List(n_get_string("type missmatch"),-1));
}


