/**********************************************************************
 
	Copyright (C) 2008- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___SPIDERING_H___
#define ___SPIDERING_H___

#include	"lc_encode.h"
#include	"pdb64_basic.h"
#include	"favt64.h"

/*
	universal directory
	
	root
	root.addr
	root.addr.ipv4
	root.addr.ipv6
	root.queue
	root.queue.myurl
	root.queue.url
	root.data
*/

#define LC_SECC_HEADER		(LCZ_1BC_SECC|0xff)
#define LC_SECC_TERMINATOR	(0x7fffffff)

#define LC_SECC_INFO_START	(LCZ_2BC_SECC_INFO|0x0001)
#define LC_SECC_INFO_END	(LCZ_2BC_SECC_INFO|0xfffe)

#define LC_SECC_READDIR		(LCZ_2BC_SECC_INFO|0x0002)
#define LC_SECC_AGENT		(LCZ_2BC_SECC_INFO|0x0003)

#define LC_SECC_EMPTY_FROM	(LCZ_2BC_SECC_INFO|0xffff)
#define LC_SECC_EMPTY_TO	(LCZ_2BC_SECC_INFO|0x0000)

/*
	HEADER INFO_START
	....
	TERMINATOR INFO_END

	TERMINATOR EMPTY_FROM
	....
	HEADER EMPTY_TO
*/

#define LC_SECC_ENTRY		(LCZ_2BC_SECC_INFO|0x0003)


typedef struct spidering_fundamental_core {
	INTEGER64		create_time;
	INTEGER64		modify_time;
	INTEGER64		next_refresh_time;
#define DEFAULT_REFRESH_INTERVAL	3600
	INTEGER64		life_expire_time;
#define DEFAULT_LIFE_INTERVAL	(DEFAULT_REFRESH_INTERVAL*10)
	/* 0 = dont delete */
	int			refresh_interval;
	int			life_interval;
	int			type;

#define NT_SYSTEM	1
#define NT_OWNED	2
#define NT_CACHE	4

} SPIDERING_FUNDAMENTAL_CORE;

/*
	ADDRESS DATA
	root.addr.ipv4.[NUM][NUM][NUM][NUM][NUM][NUM][NUM][NUM]
	root.addr.ipv6.[NUM][NUM][NUM][NUM][NUM][NUM][NUM][NUM].....
	[NUM] = LCZ_2BC_SECC_NO 0 to 15 (4bit)
	(addr + portNo.(16bit) + proxyPortNo.(16bit))
*/

typedef struct host_addr_port {
	HOST_ADDR		a;
} HOST_ADDR_PORT;

typedef struct spidering_addr_cache {
	HOST_ADDR_PORT		addr[16][16];
	int			fundamental_services_nos[16][32];
} SPIDERING_ADDR_CACHE;

typedef struct spidering_addr_node {
	int			fundamental_services_flags;
#define FSF_SPIDERING		0x00000001
#define FSF_XLS			0x00000002
#define FSF_HTTP		0x00000004
} SPIDERIGN_ADDR_NODE;

typedef struct spidering_url_cache {
	int			hops;
	L_CHAR *		owner;
} SPIDERING_URL_CACHE;

typedef struct spidering_query_header {
	HOST_ADDR_PORT			orgin;
	HOST_ADDR_PORT			src;
	HOST_ADDR_PORT			dest;
	int				type;
#define SQT_ADDR_LIST_REQUEST		1
#define SQT_ADDR_LIST_REQUEST_REPLY	2
#define SQT_ADDR_LIST_RESIST		3
#define SQT_ADDR_LIST_RESIST_REPLY	4
	unsigned int			id;
} SPIDERING_QUERY_HEADER;

typedef struct spidering_data_query_header {
	SPIDERING_QUERY_HEADER		sqh;
} SPIDERING_DATA_QUERY_HEADER;

typedef struct spidering_data_cache {
	HOST_ADDR_PORT		perfect_cache;
	HOST_ADDR_PORT		span_from;
	HOST_ADDR_PORT		span_to;
	SPIDERING_DATA_QUERY_HEADER *	query_list;
} SPIDERING_DATA_CACHE;


/* ADDRESS LIST QUERY */

typedef struct addr_list_query_request {
	SPIDERING_QUERY_HEADER		sqh;
	int				level;
} ADDR_LIST_QUERY_REQUEST;

typedef struct addr_list_query_reply {
	SPIDERING_QUERY_HEADER		sqh;
	SPIDERING_ADDR_CACHE		rep_data;
} ADDR_LIST_QUERY_REPLY;

typedef struct addr_list_resist {
	SPIDERING_QUERY_HEADER		sqh;
} ADDR_LIST_RESIST;

typedef struct addr_list_resist_reply {
	SPIDERING_QUERY_HEADER		sqh;
	int				err;
} ADDR_LIST_RESIST_REPLY;


/* ON DISK */



typedef struct pn64_search_fundamental_info {
	PN64_HEADER			h;
	SPIDERING_FUNDAMENTAL_CORE	c;
} PN64_SEARCH_FUNDAMENTAL_INFO;


typedef struct spidering_refresh_queue {
	PN64_HEADER			h;
	INTEGER64			next;
	L_CHAR				d[1];
	/* URL L_CHAR */
} SPIDERING_REFRESH_QUEUE;

typedef struct spidering_refresh_favt {
	INTEGER64		refresh_time;
	INTEGER64		que_head;
	INTEGER64		que_tail;
} SPIDERING_REFRESH_FAVT;

typedef struct spidering_string_favt {
	INTEGER64		fofs;
	L_CHAR			str[1];
} SPIDERING_STRING_FAVT;

typedef struct pn64_spidering_header {
	PN64_HEADER			h;
	int				version;
#define SP_VERSION		1
	int				dummy;
#define SP_REFRESH_QUE_MAX	4
	INTEGER64			refresh_que[SP_REFRESH_QUE_MAX];
	INTEGER64			data_que;
} PN64_SPIDERING_HEADER;


/* WORK AREA */

typedef struct sp_lock_list {
	struct sp_lock_list *		next;
	L_CHAR *			path;
	L_CHAR *			parent;

#define SPLT_DELETE			0
#define SPLT_INSERT			1
#define SPLT_READDIR			2
#define SPLT_OP				3
#define SPLT_MAX			4

	int				cnt[SPLT_MAX];
/*
	DELETE path
		DELETE	path* NG
		INSERT	path* NG
		READDIR	path* NG
		READDIR parentof(path) NG
		OP	path* NG
	INSERT parent path
		DELETE	partof(path) NG
		READDIR path NG
		READDIR parent NG
		INSERT	parent ... NG
	READDIR path (list of path etc.)
		DELETE	partof(path) NG
		DELETE chldrenof(path) NG
		INSERT	path path*
	OP	path
		DELETE	partof(path) NG
		INSERT parent path NG
*/

} SP_LOCK_LIST;

typedef struct sp_lock_op_list {
	struct sp_lock_op_list *	next;
	L_CHAR *			path;
	L_CHAR *			ext;
	INTEGER64			fofs;
	PN64_HEADER			h;
} SP_LOCK_OP_LIST;

typedef struct spidering_work_area {
	struct spidering_work_area *	next;
	PDB64 *				pdb_fd;
	int				favt64_err;
	INTEGER64			header_fofs;
	PN64_SPIDERING_HEADER		cache_header;
	FAVT64_ROOT *			rt_refresh_que[SP_REFRESH_QUE_MAX];
	FAVT64_ROOT *			rt_data_que;
	SP_LOCK_LIST *			sp_lock_list;
	SP_LOCK_OP_LIST *		sp_lock_op_list;
	int				op_cnt;
} SPIDERING_WORK_AREA;

typedef struct sp_readdir_list {
	struct sp_readdir_list *	next;
	L_CHAR *			path;
} SP_READDIR_LIST;

typedef struct spidering_agent {
	struct spidering_agent *	next;
	struct spidering_agent *	iid_next;
	L_CHAR *			name;
	int				type;
#define SPAT_NULL			0
#define SPAT_INNER			1
#define SPAT_OUTER			2
	int				err;
	int				access_lock;
	union {
		struct {
			L_CHAR *			agent_core;
			L_CHAR *			loading_file;
			int				iid;
		}			outer;
		struct {
			XLISP_ENV *			env;
		}			inner;
	} d;
} SPIDERING_AGENT;

SPIDERING_WORK_AREA *
open_spcache(int * errp,L_CHAR * filename);
int
create_sp_path(SPIDERING_WORK_AREA * wa,L_CHAR* path,int type);
void
init_spcache();
void
close_all_spcache();
L_CHAR *
get_sp_parent_path(PN64_SEARCH_FUNDAMENTAL_INFO ** infp,SPIDERING_WORK_AREA * wa,L_CHAR * path);
void *
get_sp_data(INTEGER64 * fofs,SPIDERING_WORK_AREA * wa,L_CHAR * path,L_CHAR * ext);
void
free_sp_readdir_list(SP_READDIR_LIST * lst);
SP_READDIR_LIST *
readdir_sp_list(SPIDERING_WORK_AREA * wa,L_CHAR * path);
SP_READDIR_LIST *
readdir_sp_list_all(SPIDERING_WORK_AREA * wa);

void
init_gb_SPdatabasePath(XLISP_ENV * env);
void
init_gb_SPcd(XLISP_ENV * env1,XLISP_ENV * env0);
void
init_gb_SPls(XLISP_ENV * env);
void
init_gb_SPdefineAgent(XLISP_ENV * env);
void
init_gb_SPdeletePath(XLISP_ENV * env);
void
init_gb_SPcreatePath(XLISP_ENV * env);



void
init_sp_function(XLISP_ENV * env0,XLISP_ENV * env1);
SPIDERING_AGENT*
new_sp_agent(L_CHAR * name);
XL_SEXP *
call_sp_agent(SPIDERING_AGENT * spa,XL_SEXP * cmd);
void
set_sp_agent_type(SPIDERING_AGENT * spa,int type);
SPIDERING_AGENT*
new_outer_sp_agent(L_CHAR * name,L_CHAR * core,L_CHAR * loading);
int
create_sp_path_auth(SPIDERING_WORK_AREA * wa,L_CHAR* path,int type);
int
delete_sp_path_auth(SPIDERING_WORK_AREA * wa,L_CHAR* path);
int
finish_sp_operation_auth(SPIDERING_WORK_AREA * wa,L_CHAR* path,L_CHAR * ext,void * data);
void *
start_sp_operation_auth(int * err_p,SPIDERING_WORK_AREA * wa,L_CHAR* path,L_CHAR * ext,int wait_flag);
int
delete_sp_operation_auth(SPIDERING_WORK_AREA * wa,L_CHAR * path,L_CHAR * ext,int wait_flag);

SPIDERING_AGENT *
search_sp_agent_by_iid(int iid);



extern SPIDERING_WORK_AREA * wa_list;
extern XLISP_ENV * sp_env;


/********************************************************

	Spidering Agent Command Format
	
********************************************************/
/*

Fundamental Format
([Command agent="" sender="" ] .....)

sender :: sender who invokes this command.
this attribute is generated by the gbsp agent. the attribute genetated by other agents is ignored and replaced by the gbsp agent.
agent :: target agent

(SPcreatePath "path")

Create spidering path named "path". Agent who is parent of "path" estimate this command.

(SPdeletePath "path")


(SPpermitAgent "path" "agent" info)
(SPfirbitAgent "path" "agent")
(SPreadAgentData "path" "agent") Return info
(SPwriteAgentData "path" "agent" info)
(SPdeleteAgentData "path" "agent")

(SPrefreshTrigger "path")

*/

/*
	Commands for SP
	

(SPdefineAgent "name" "core-binary" "loading file")

*/


#endif


