/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


/*
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <dirent.h>
*/
#include "machine/include.h"

#include <ft2build.h>
#include FT_FREETYPE_H

int ft_error_code;
#define FT_ASSERT(a)	ft_error_code = a;\
	do if ( ft_error_code ) { \
	printf("FreeType2 Error: %s  [Code = %d]\n", #a, ft_error_code); \
	return 1; \
	} while ( 0 )

FT_Library library;
FILE *out;
int bin_out;



int
secure_closedir(DIR * d)
{
int er;

r2:
	er = closedir(d);
	if ( er < 0 && errno == EINTR )
		goto r2;
	if ( er < 0 && (errno == EIO || errno == ENOSPC) ) {
		sleep(2);
		goto r2;
	}
	return er;
}



void
bin_out_write_str(char * str)
{
short len;
	len = strlen(str)+1;
	write(bin_out,&len,sizeof(len));
	write(bin_out,str,len);
}

void
bin_out_write_int(int * list,int len)
{
short _len;
	_len = len*sizeof(int);
	write(bin_out,&_len,sizeof(_len));
	write(bin_out,list,_len);
}

int
create_index(char *path)
{
	int i, n = 0;
	int * size_list;
	FT_Face face;
	do {
		printf("%s\n", path);
		FT_ASSERT( FT_New_Face(library, path, n, &face) );
		/*
		printf("face #%3d ", n);
		printf("[ %s ] [ %s ]    ", face->family_name, face->style_name);
		printf("fixed : ");
		for ( i = 0 ; i < face->num_fixed_sizes ; i++ )
			printf("%d ", face->available_sizes[i].height);
		printf("\n");
		*/

		if ( !(face->family_name && face->style_name) )
			goto end;

		fprintf(out, "<FontRec>\n");
		fprintf(out, "\t<path>^\"%s\"</path>\n", path);
		bin_out_write_str(path);

		fprintf(out, "\t<face>%d</face>\n", n);
		bin_out_write_int(&n,1);

		fprintf(out, "\t<family>^\"%s\"</family><style>^\"%s\"</style>\n",
			face->family_name, face->style_name);
		bin_out_write_str(face->family_name);
		bin_out_write_str(face->style_name);

		fprintf(out, "\t<size>");
		if ( FT_IS_SCALABLE(face) ) {
			fprintf(out, "-1 ");
			size_list = malloc(sizeof(int));
			size_list[0] = -1;
			bin_out_write_int(size_list,1);
		}
		else  {
			size_list = malloc(sizeof(int)*face->num_fixed_sizes);
			for ( i = 0 ; i < face->num_fixed_sizes ; i++ ) {
				fprintf(out, "%d ", 
					face->available_sizes[i].height);
				size_list[i] = face->available_sizes[i].height;
			}
			bin_out_write_int(size_list,face->num_fixed_sizes);
		}
		fprintf(out, "</size>\n");
		fprintf(out, "</FontRec>\n\n");
	end:
		n++;
	} while ( face->num_faces < n );
	
	FT_Done_Face(face);
	return 0;
}


char * _copy_str(char * arg);

char * _copy_str(char * arg)
{
char * ret;
int len;
	len = strlen(arg);
	ret = malloc(len + 1);
	memcpy(ret,arg,len+1);
	return ret;
}

int
main(int argc, char* argv[])
{
	int i,st;
	struct dirent *de;
	struct stat f_stat;
	DIR *d;
	char * target;
	int p;
		
	if ( argc < 2 ) {
		fprintf(stderr, "usage %s directory\n", argv[0]);
		fprintf(stderr, "usage %s -d directory\n", argv[0]);
		exit(1);
	}
	FT_ASSERT( FT_Init_FreeType(&library) );
	
	out = fopen("font_index.xl", "w");
	if ( ! out ) {
		perror("font_index.xml");
	}
	bin_out = open("font_index.bn",O_CREAT|O_RDWR|O_TRUNC,0644);
	if ( bin_out < 0 ) {
		perror("font_index.bn");
	}
	
	fprintf(out, "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n\n");
	fprintf(out, "<Env1 type=\"raw\">\n");
	//fprintf(out, "<Define>^font-index\n<quote><FontIndex>\n");
	
	if ( strcmp(argv[1],"-d") == 0 )
		st = 2;
	else 	st = 1;
	target = 0;
	for ( i = st ; i < argc ;
			( target && target != argv[i] ?
				free(target) : 0),
			i++
			) {
		if ( st == 1 )
			target = argv[i];
		else {
			target = _copy_str(argv[i]);
			for ( p = strlen(target)-1 ; p >= 0 ; p -- )
				if ( target[p] == '/' ) {
					target[p] = 0;
					break;
				}
			if ( p < 0 ) {
				target[0] = '.';
				target[1] = 0;
			}
		}
		d = opendir(target);
		if ( ! d ) {
			perror(target);
			continue;
		}
		while ( (de = readdir(d)) != 0 ) {
			char path[1024], r_path[PATH_MAX+1];
			snprintf(path, sizeof(path), "%s%s%s", 
				target, target[strlen(target)-1]=='/'?"":"/", de->d_name);
			realpath(path, r_path);
			r_path[PATH_MAX] = 0;
			if ( stat(r_path, &f_stat) < 0 ) {
				perror(de->d_name);
				continue;
			}
			if ( S_ISREG(f_stat.st_mode) && de->d_name[0] != '.' ) {
				create_index(r_path);
			}
		}
		secure_closedir(d);
	}
	
	//fprintf(out, "</FontIndex></quote>\n</Define>\n");
	//fprintf(out, "<PrintStd>^font-index</PrintStd>\n");
	fprintf(out, "</Env1>\n");
	fclose(out);

	close(bin_out);

	return 0;
}

