/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef VPF_GEOGRAPHIC_REFERENCE_TABLE_H___
#define VPF_GEOGRAPHIC_REFERENCE_TABLE_H___

typedef struct {
	LONG id;
	char data_type[4];
	char units[4];
	char ellipsoid_name[16];
	char ellipsoid_detail[51];
	char vert_datum_name[16];
	char vert_datum_code[5];
	char sound_datum_name[16];
	char sound_datum_code[5];
	char geo_datum_name[16];
	char geo_datum_code[5];
	char projection_name[21];
	char projection_code[3];
	SHORT_FLOAT parameter1;
	SHORT_FLOAT parameter2;
	SHORT_FLOAT parameter3;
	SHORT_FLOAT parameter4;
	SHORT_FLOAT false_origin_x;
	SHORT_FLOAT false_origin_y;
	SHORT_FLOAT false_origin_z;
	char reg_pt_table[13];
	char diag_pt_table[13];
}GEOGRAPHIC_REFERENCE_RECORD;

void geographic_reference_record_delete(GEOGRAPHIC_REFERENCE_RECORD *tbl);
BOOL geographic_reference_record_read(VPF_TABLE *table, FILE *fp, VPF_LIST *cols_info);

#endif

