/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<string.h>
#include	"stream.h"
#include	"memory_debug.h"
#include	"netmapper.h"
#include	"xlerror.h"


XL_SEXP * xl_Netlist();
void
calc_estimate(
	double * d_p,
	double * wt_p,
	NETLIST_WORK * w,
	NETLIST_TIN * t,
	GB_POINT * plist);

void
init_Netlist(XLISP_ENV* env)
{
	set_env(env,l_string(std_cm,"Netlist"),
		get_func_prim(xl_Netlist,FO_APPLICATIVE,0,2,2));
}

XL_SEXP * 
insert_src(NETLIST_VERTEX * v,XL_SEXP * el,XL_SEXP * x,XL_SEXP * y,XL_SEXP * s,NETLIST_WORK * w)
{
NETLIST_SRC * src,** sp;
int e_type;
	if ( get_type(el) != XLT_STRING )
		goto invalid_header_name;

	src = d_alloc(sizeof(*s));
	if ( el->string.data[0] == 0 )
		return 0;
	if ( v->point_name && l_strcmp(v->point_name,el->string.data) == 0 )
		return 0;

	src->filename = ll_copy_str(el->string.data);
	src->fileheader = ll_copy_str(w->fileheader);
	src->floating = 0;
	switch ( get_type(x) ) {
	case XLT_ERROR:
		return x;
	case XLT_FLOAT:
		src->ptr.x = x->floating.data;
		break;
	case XLT_INTEGER:
		src->ptr.x = x->integer.data;
	case XLT_STRING:
		src->ptr.x = 0;
		if ( x->string.data[0] == 0 || l_strcmp(x->string.data,l_string(std_cm,"-")) == 0 ) {
			src->floating = 1;
			w->floating = 1;
		}
		else	sscanf(n_string(std_cm,x->string.data),REAL1_F,&src->ptr.x);
		break;
	case XLT_NULL:
		src->ptr.x = 0;
		break;
	default:
		e_type = get_type(x);
		goto invalid_point;
	}
	switch ( get_type(y) ) {
	case XLT_ERROR:
		return y;
	case XLT_FLOAT:
		src->ptr.y = y->floating.data;
		break;
	case XLT_INTEGER:
		src->ptr.y = y->integer.data;
		break;
	case XLT_STRING:
		src->ptr.y = 0;
		if ( y->string.data[0] == 0 || l_strcmp(y->string.data,l_string(std_cm,"-")) == 0 ) {
			src->floating = 1;
			w->floating = 1;
		}
		else	sscanf(n_string(std_cm,y->string.data),REAL1_F,&src->ptr.y);
		break;
	case XLT_NULL:
		src->ptr.y = 0;
		break;
	default:
		e_type = get_type(y);
		goto invalid_point;
	}
	src->next = 0;
	sp = &v->src_list;
	for ( ; *sp ; sp = &(*sp)->next );
	*sp = src;
	return 0;
invalid_header_name:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"Netlist"),
		List(n_get_string("string point name or filename is required"),
			n_get_string("data line No. is"),
			get_integer(el->h.line,0),-1));
invalid_point:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"Netlist"),
		List(n_get_string("type missmatch point coordinate (floating or integer)"),
			n_get_string("data line No. is"),
			get_integer(el->h.line,0),get_integer(e_type,0),-1));
}


XL_SEXP *
insert_vertex(NETLIST_WORK * w,XL_SEXP * lin,XL_SEXP * s)
{
NETLIST_VERTEX * v;
XL_SEXP * name,*x,*y;
XL_SEXP * ret;

ss_printf("INSERT VERTEX\n");
	name = car(lin);
	if ( get_type(name) != XLT_STRING ) {
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_INV_PARAM,
			l_string(std_cm,"Netlist"),
			List(n_get_string("type missmatch first POINT name"),
				n_get_string("data line No. is"),
				get_integer(lin->h.line,0),-1));
	}
	for ( v = w->vertex ; v ; v = v->next )
		if ( l_strcmp(v->point_name,name->string.data) == 0 )
			break;
	if ( v == 0 ) {
		v = d_alloc(sizeof(*v));
		memset(v,0,sizeof(*v));
		v->next = w->vertex;
		w->vertex = v;
	}
	for ( ; get_type(lin) == XLT_PAIR ; ) {
		name = car(lin);
		lin = cdr(lin);
		if ( get_type(lin) == XLT_PAIR ) {
			x = car(lin);
			lin = cdr(lin);
			y = car(lin);
			lin = cdr(lin);
		}
		else {
			x = n_get_string("0");
			y = n_get_string("0");
		}
		ret = insert_src(v,name,x,y,s,w);
		if ( get_type(ret) == XLT_ERROR )
			return ret;
	}
	if ( v->point_name == 0 )
		v->point_name = ll_copy_str(v->src_list->filename);
	return 0;
}


XL_SEXP *
insert_tin(NETLIST_WORK * w,XL_SEXP * ln,XL_SEXP * s)
{
NETLIST_TIN * tin;
int ptr;
XL_SEXP * ptr_name;
NETLIST_VERTEX * v;
NETLIST_SRC * s1, * s2;
XL_SEXP * _line;

ss_printf("INSERT TIN\n");
	_line = ln;
	ptr = 0;
	tin = d_alloc(sizeof(*tin));
	memset(tin,0,sizeof(*tin));
	for ( ; get_type(ln) == XLT_PAIR ; ) {
		if ( ptr > 2 )
			break;
		ptr_name = car(ln);
		if ( get_type(ptr_name) == XLT_NULL ) {
			ln = cdr(ln);
			continue;
		}
		if ( get_type(ptr_name) != XLT_STRING ) {
			return get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_INV_PARAM,
				l_string(std_cm,"Netlist"),
				List(n_get_string("type missmatch first TIN POINT name"),
					n_get_string("data line No. is"),
					get_integer(_line->h.line,0),-1));
		}
		if ( l_strcmp(ptr_name->string.data,l_string(std_cm,"")) == 0 ) {
			ln = cdr(ln);
			continue;
		}
		for ( v = w->vertex ; v ; v = v->next )
			if ( l_strcmp(v->point_name,ptr_name->string.data) == 0 )
				break;
ss_printf("TIN-%ls %p\n",ptr_name->string.data,v);
		if ( v == 0 ) {
			return get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_INV_PARAM,
				l_string(std_cm,"Netlist"),
				List(n_get_string("type missmatch first TIN POINT is not exist"),
					get_string(ptr_name->string.data),
					n_get_string("data line No. is"),
					get_integer(_line->h.line,0),-1));
		}
		tin->vertex[ptr] = v;
		ln = cdr(ln);
		ptr++;
	}
ss_printf("TIN-ptr %i\n",ptr);
	if ( ptr == 0 )
		return 0;
	if (  ptr < 3 ) {
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_INV_PARAM,
			l_string(std_cm,"Netlist"),
			List(n_get_string("too few TIN POINTst"),
				n_get_string("data line No. is"),
				get_integer(_line->h.line,0),-1));
	}
	for ( s1 = tin->vertex[0]->src_list->next ; s1 ; s1 = s1->next ) {
		tin->selects[0] = s1;
		for ( ptr = 1 ; ptr < 3 ; ptr ++ ) {
			for ( s2 = tin->vertex[ptr]->src_list->next ; s2 ; s2 = s2->next )
{
ss_printf("== %i %ls %ls\n",ptr,s1->filename,s2->filename);
				if ( l_strcmp(s1->filename,s2->filename) == 0 )
						break;
}
			if ( s2 == 0 )
				goto next;
			tin->selects[ptr] = s2;
		}
		if ( ptr == 3 )
			break;
	next:	;
	}
	if ( tin->selects[0] == 0 || tin->selects[1] == 0 || tin->selects[2] == 0 )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_INV_PARAM,
			l_string(std_cm,"Netlist"),
			List(n_get_string("correspond TIN POINT file is not exist"),
				get_string(tin->vertex[0]->point_name),
				get_string(tin->vertex[1]->point_name),
				get_string(tin->vertex[2]->point_name),
				n_get_string("data line No. is"),
				get_integer(_line->h.line,0),-1));
	tin->next = w->tins;
	w->tins = tin;
	return 0;
}

void
output_triangle(STREAM * st,NETLIST_WORK * w,NETLIST_TIN * t,NETLIST_POINT_LIST ** pp)
{
NETLIST_VERTEX * v;
int ptr;
NETLIST_POINT_LIST * ppp;

double d,wt;

	calc_estimate(&d,&wt,w,t,0);

	for ( ptr = 0 ; ptr < 3 ; ptr ++ ) {
		v = t->vertex[ptr];
		for ( ppp = *pp ; ppp ; ppp = ppp->next )
			if ( l_strcmp(ppp->name,v->point_name) == 0 )
				goto next;
		ppp = d_alloc(sizeof(*ppp));
		ppp->name = ll_copy_str(v->point_name);
		ppp->next = *pp;
		*pp = ppp;
		s_printf(st,"  <point-map>%ls\n",v->point_name);
		s_printf(st,"     <list> %f %f </list>\n",
					t->selects[ptr]->ptr.x,
					t->selects[ptr]->ptr.y);
		s_printf(st,"     <list> %f %f </list>\n",
					v->src_list->ptr.x,
					v->src_list->ptr.y);
		s_printf(st,"  </point-map>\n");
	next:	;
	}
	s_printf(st,"  <triangle-map> %ls %ls %ls </triangle-map>\n",
		t->vertex[0]->point_name,
		t->vertex[1]->point_name,
		t->vertex[2]->point_name);
	s_printf(st,"<!--\n");
	s_printf(st,"POINT STATUS %p %i %i %i\n",
		t,
		t->vertex[0]->valid,
		t->vertex[1]->valid,
		t->vertex[2]->valid);
	if ( t->pseudo_angle > 1 )
		s_printf(st,"PSEUDO-ANGLE REVERSE %g %g %g %i\n",t->pseudo_angle,t->t1,t->t2,t->rf);
	else	s_printf(st,"PSEUDO-ANGLE FORWARD %g %g %g %i\n",t->pseudo_angle,t->t1,t->t2,t->rf);
	s_printf(st,"MATRIX %g %g : %g\n",t->a.matrix[0][0],t->a.matrix[0][1],t->a.org.x);
	s_printf(st,"MATRIX %g %g : %g\n",t->a.matrix[1][0],t->a.matrix[1][1],t->a.org.y);
	s_printf(st,"\n");
	s_printf(st,"DISTANCE RATE %g %g %g (%g:%g)\n",t->dr[0],t->dr[1],t->dr[2],t->od,t->od2);
	s_printf(st,"-->\n");
}

void
output_point_list(STREAM * st,NETLIST_WORK * w)
{
NETLIST_VERTEX * v;
	for ( v = w->vertex ; v ; v = v->next ) {
		if ( v->valid == 0 )
			continue;
		s_printf(st,"%ls\t%i\t%.9g\t%.9g\n",
			v->point_name,
			(int)v->src_list->floating,
			v->src_list->ptr.x,
			v->src_list->ptr.y);
	}
}

void
input_point_list(FILE * fd,NETLIST_WORK * w)
{
NETLIST_VERTEX * v;
char * buffer;
char pname[100];
GB_POINT ptr;
int f;
L_CHAR * n;
	for ( v = w->vertex ; v ; v = v->next )
		v->valid = 0;
	buffer = d_alloc(1000);
	for ( ; ; ) {
		if ( fgets(buffer,1000,fd) == 0 )
			break;
		sscanf(buffer,"%s\t%i\t" REAL1_F "\t" REAL1_F "\n",
			pname,&f,&ptr.x,&ptr.y);
		n = l_string(std_cm,pname);
		for ( v = w->vertex ; v ; v = v->next )
			if ( l_strcmp(v->point_name,n) == 0 )
				break;
		if ( v == 0 ) {
			ss_printf("POINT %s IS IGNORED\n",pname);
			continue;
		}
		if ( v->src_list->floating == 0 ) {
			ss_printf("POINT %s NON FLOATING POINT\n",pname);
			continue;
		}
		v->src_list->ptr = ptr;
		v->valid = VV_USE;
	}
	d_f_ree(buffer);
}

void
clear_point_list(NETLIST_POINT_LIST ** pp)
{
NETLIST_POINT_LIST * p;
	for ( ; *pp ; ) {
		p = *pp;
		*pp = p->next;
		d_f_ree(p->name);
		d_f_ree(p);
	}
}

XL_SEXP * 
save_mapfile(NETLIST_WORK * w,XL_SEXP * s)
{
NETLIST_TIN * t1,*t2;
STREAM * st;
char * filename;
int len,len2;
L_CHAR * _filename;
XL_SEXP * ret;
NETLIST_POINT_LIST * pp;

ss_printf("save\n");
	pp = 0;
	len = l_strlen(w->save_dir);
	for ( t1 = w->tins ; t1 ; t1 = t1->next ) {
//ss_printf("TIN\n");
		if ( t1->save_flag )
			continue;
		t1->save_flag = 1;
		_filename = t1->selects[0]->filename;
		len2 = l_strlen(_filename);
		filename = d_alloc((len + len2)*sizeof(L_CHAR)+10);
		sprintf(filename,"%s/%s.map",
			n_string(std_cm,w->save_dir),
			n_string(std_cm,_filename));
		st = s_open_file(filename,O_CREAT|O_TRUNC|O_RDWR,0644);
		if ( st == 0 ) {
			ret = get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_OPEN_FILE,
				l_string(std_cm,"Netlist"),
				List(n_get_string("cannot open the file "),
					n_get_string(filename),
					-1));
			d_f_ree(filename);
			return ret;
		}
		s_printf(st,"<?xl version=\"0.1\" encoding=\"UTF-8\"?>\n");
		s_printf(st,"<map>\n");
		s_printf(st,"  <meta>\n");
		s_printf(st,"    <file type=\"xl\"/>\n");
		s_printf(st,"    <src>%ls%ls%ls%ls</src>\n",
					w->src_filename_before,
					t1->selects[0]->fileheader,
					t1->selects[0]->filename,
					w->src_filename_after);
		s_printf(st,"    <dest>%ls</dest>\n",w->dest_filename);
		s_printf(st,"    <dp>1</dp>\n");
		s_printf(st,"  </meta>\n");
		output_triangle(st,w,t1,&pp);
		for ( t2 = t1->next ; t2 ; t2 = t2->next ) {
			if ( t2->save_flag )
				continue;
			if ( l_strcmp(t2->selects[0]->filename,t1->selects[0]->filename) )
				continue;
			t2->save_flag = 1;
			output_triangle(st,w,t2,&pp);
		}
		s_printf(st,"</map>\n");
		s_close(st);
		clear_point_list(&pp);
	}
	return 0;
}

void
print_neighbour(NETLIST_TIN * t)
{
int i;
	for (  i = 0 ; i < 3 ; i ++ ) {
		if ( t->nh[i] == 0 )
			continue;
		ss_printf("\t%ls %ls %ls\n",
			t->nh[i]->vertex[0]->point_name,
			t->nh[i]->vertex[1]->point_name,
			t->nh[i]->vertex[2]->point_name);
	}
	ss_printf("\t%ls %ls %ls\n",
		t->vertex[0]->point_name,
		t->vertex[1]->point_name,
		t->vertex[2]->point_name);
}

void
list_neignbour(NETLIST_WORK * w)
{
NETLIST_TIN * t1,*t2;
int i;
int j,k;
NETLIST_VERTEX *v,*v2;
int er;
	for ( t1 = w->tins ; t1 ; t1 = t1->next ) {
		for ( t2 = t1->next ; t2 ; t2 = t2->next ) {
			for ( j = 0 ; j < 3 ; j ++ ) {
				for ( k = 0 ; k < 3 ; k ++ )
					if ( t1->vertex[j] == t2->vertex[k] ) {
						v = t1->vertex[j];
						goto ok1;
					}
			}
			continue;
		ok1:
			for ( j = 0 ; j < 3 ; j ++ ) {
				if ( t1->vertex[j] == v )
					continue;
				for ( k = 0 ; k < 3 ; k ++ ) {
					if ( t2->vertex[j] == v )
						continue;
					if ( t1->vertex[j] == t2->vertex[k] ) {
						v2 = t1->vertex[j];
						goto ok2;
					}
				}
			}
			continue;
		ok2:
/*
ss_printf("OK (%p) %ls %ls %ls - (%p) %ls %ls %ls\n",
t1,
t1->vertex[0]->point_name,
t1->vertex[1]->point_name,
t1->vertex[2]->point_name,
t2,
t2->vertex[0]->point_name,
t2->vertex[1]->point_name,
t2->vertex[2]->point_name);
*/
			er = 0;
			for ( i = 0 ; i < 3 && t1->nh[i] ; i ++ ) {
				if ( (t1->nh_v1[i] == v && 
					t1->nh_v2[i] == v2) ||
					(t1->nh_v1[i] == v2 &&
					t1->nh_v2[i] == v) ) {
					
					ss_printf("TRIPLE EDGE %ls %ls\n",
						v->point_name,
						v2->point_name);
					er = 1;
				}
			}
			for ( i = 0 ; i < 3 && t2->nh[i] ; i ++ ) {
				if ( (t2->nh_v1[i] == v && 
					t2->nh_v2[i] == v2) ||
					(t2->nh_v1[i] == v2 &&
					t2->nh_v2[i] == v) ) {
					
					ss_printf("TRIPLE EDGE %ls %ls\n",
						v->point_name,
						v2->point_name);
					er = 1;
				}
			}
			for ( i = 0 ; i < 3 && t1->nh[i] ; i ++ );
			if ( i == 3 || er ) {
				ss_printf("TOO MANY NEIGHBOUR (%p) %ls %ls %ls\n\t(%p) %ls %ls %ls\n",
					t1,
					t1->vertex[0]->point_name,
					t1->vertex[1]->point_name,
					t1->vertex[2]->point_name,
					t2,
					t2->vertex[0]->point_name,
					t2->vertex[1]->point_name,
					t2->vertex[2]->point_name);
				print_neighbour(t1);
				
				exit(1);
			}
			t1->nh[i] = t2;
			t1->nh_v1[i] = v;
			t1->nh_v2[i] = v2;

			for ( i = 0 ; i < 3 && t2->nh[i] ; i ++ );
			if ( i == 3 ) {
				ss_printf("TOO MANY NEIGHBOUR (%p) %ls %ls %ls\n\t (%p )%ls %ls %ls\n",
					t2,
					t2->vertex[0]->point_name,
					t2->vertex[1]->point_name,
					t2->vertex[2]->point_name,
					t1,
					t1->vertex[0]->point_name,
					t1->vertex[1]->point_name,
					t1->vertex[2]->point_name);
				print_neighbour(t2);
				exit(1);
			}
			t2->nh[i] = t1;
			t2->nh_v1[i] = v;
			t2->nh_v2[i] = v2;
			if ( er )
				exit(1);
		}
	}
}

void
optimize_get_data(GB_POINT * plist,double * dlist,int * dangle,NETLIST_WORK * w,int len)
{
NETLIST_VERTEX * v;
int i,j,k;
NETLIST_TIN * t;
int * clist;
GB_POINT p1,p2;
double ang,a,b,c;
	i = 0;
	for ( v = w->vertex ; v ; v = v->next ) {
		if ( v->src_list->floating == 0 ) {
			v->plist_ofs = -1;
			continue;
		}
		v->plist_ofs = i;
		plist[i++] = v->src_list->ptr;
	}
	clist = d_alloc(sizeof(int)*len);
	memset(clist,0,sizeof(int)*len);
	memset(dlist,0,sizeof(double)*len);
	for ( t = w->tins ; t ; t = t->next ) {
		for ( i = 0 ; i < 3 ; i ++ ) {
			j = i-1;
			if ( j < 0 )
				j = 2;
			k = i+1;
			if ( k >= 3 )
				k = 0;
			if ( t->vertex[i]->plist_ofs < 0 )
				continue;
			dlist[t->vertex[i]->plist_ofs] += (distance(
					t->vertex[i]->src_list->ptr,
					t->vertex[j]->src_list->ptr) +
				distance(
					t->vertex[i]->src_list->ptr,
					t->vertex[k]->src_list->ptr));
			clist[t->vertex[i]->plist_ofs] ++;
			
			p1 = p_sub(t->vertex[j]->src_list->ptr,t->vertex[i]->src_list->ptr);
			p2 = p_sub(t->vertex[k]->src_list->ptr,t->vertex[i]->src_list->ptr);
			
			b=(c=inner(p1,p2))/(a=sqrt(inner(p1,p1))*sqrt(inner(p2,p2)));
			if ( b >= 1  )
				ang = 0;
			else if ( b <= -1 )
				ang = M_PI;
			else	ang = acos(b);
			for ( ; ang < 0 ; ang += 2*M_PI );
			for ( ; ang >= 2*M_PI ; ang -= 2*M_PI );
			if ( ang >= M_PI )
				ang = 2*M_PI - ang;
			if ( ang == 1/200 )
				dangle[t->vertex[i]->plist_ofs] = 4000;
			else	dangle[t->vertex[i]->plist_ofs] = 2*ceil(2*M_PI/ang);
		}
	}
	for ( i = 0 ; i < len ; i ++ ) {
		if ( clist[i] == 0 )
			continue;
		dlist[i] /= clist[i];
	}
	d_f_ree(clist);
}

void
optimize_store_data(GB_POINT * plist,NETLIST_WORK * w,int len)
{
NETLIST_VERTEX * v;
int i;
	i = 0;
	for ( v = w->vertex ; v ; v = v->next ) {
		if ( v->src_list->floating == 0 )
			continue;
		if ( distance(w->center,plist[i]) > w->radius ) {
			ss_printf("CENTER %f %f - %f %f - %f\n",
				w->center.x,w->center.y,
				plist[i].x,plist[i].y,
				w->radius);
			er_panic("STORE OVER\n");
		}
		v->src_list->ptr = plist[i++];
	}
}

typedef struct file_list {
	struct file_list *	next;
	L_CHAR *		name;
	double			m;
	double			min;
	double			max;
	int			cnt;
} FILE_LIST;

FILE_LIST*
search_mapping_file(FILE_LIST * rt,L_CHAR * name)
{
FILE_LIST * ret;
	for ( ret = rt ; ret ; ret = ret->next ) {
		if ( l_strcmp(ret->name,name) == 0 )
			return ret;
	}
	ret = d_alloc(sizeof(*ret));
	memset(ret,0,sizeof(*ret));
	ret->name = name;
	return ret;
}

void
free_mapping_file(FILE_LIST * rt)
{
FILE_LIST * f;
	for ( ; rt ; ) {
		f = rt;
		rt = rt->next;
		d_f_ree(f);
	}
}

double
pseudo_angle(double t1,double t2)
{
double d1,d2;
	if ( t1 == 0 && t2 == 0 )
		return 0;
	if ( t1 < 0 )
		d1 = -t1;
	else	d1 = t1;
	if ( t2 < 0 )
		d2 = -t2;
	else	d2 = t2;
	if ( d1 < d2 )
		return t1/t2;
	else	return t2/t1;
}

void
print_status(NETLIST_WORK * w)
{
NETLIST_VERTEX * v;
int valid;

	for ( valid = 1 ; valid < VV_MAX ; valid ++ ) {
		ss_printf("VALID ");
		for ( v = w->vertex ; v ; v = v->next ) {
			if ( v->valid != valid )
				continue;
			ss_printf("(%ls:%i:%i)",
				v->point_name,
				v->src_list->floating,
				v->valid);
		}
		ss_printf("\n");
	}
}

void
middle_point(NETLIST_WORK * w,NETLIST_VERTEX * v)
{
NETLIST_TIN * t;
int i,j,k;
GB_POINT p;
int cnt;
	p.x = p.y = 0;
	cnt = 0;
	for ( t = w->tins ; t ; t = t->next ) {
		for ( i = 0 ; i < 3 ; i ++ )
			if ( t->vertex[i] == v ) {
				j = i-1;
				if ( j < 0 )
					j += 3;
				k = i+1;
				if ( k >= 3 )
					k -= 3;
				if ( t->vertex[j]->valid != VV_NOTUSE ) {
					cnt ++;
					p = p_add(p,t->vertex[j]->src_list->ptr);
				}
				if ( t->vertex[k]->valid != VV_NOTUSE ) {
					cnt ++;
					p = p_add(p,t->vertex[k]->src_list->ptr);
				}
			}
	}
	p.x /= cnt;
	p.y /= cnt;
	v->src_list->ptr = p;
}


int
set_valid(NETLIST_WORK * w,double estimate)
{
NETLIST_TIN * t;
int i;
int ret;
int lock_release;
int ucnt;
	ret = 0;
	lock_release = 0;
	for ( t = w->tins ; t ; t = t->next ) {
		for ( i = 0 ; i < 3 ; i ++ ) {
			if ( t->vertex[i]->valid == VV_LOCK ) {
				lock_release = 1;
				t->vertex[i]->valid = VV_USE;
			}
		}
	}
	if ( lock_release ) {
		print_status(w);
		return 1;
	}
	if ( estimate >= PA_LEVEL ) {
		return -1;
	}
	for ( t = w->tins ; t ; t = t->next ) {
		ucnt = 0;
		for ( i = 0 ; i < 3 ; i ++ )
			if ( t->vertex[i]->valid == VV_USE )
				ucnt ++;
		if ( ucnt == 2 )
			goto ok;
		continue;
	ok:
		for ( i = 0 ; i < 3 ; i ++ )
			if ( t->vertex[i]->valid == 0 ) {
				t->vertex[i]->valid = VV_NEW;
				middle_point(w,t->vertex[i]);
				ret ++;
			}
/*
		if ( ret )
			break;
*/
	}
	for ( t = w->tins ; t ; t = t->next ) {
		ucnt = 0;
		for ( i = 0 ; i < 3 ; i ++ )
			if ( t->vertex[i]->valid == VV_NEW )
				ucnt ++;
		if ( ucnt <= 1 )
			continue;
		for ( i = 0 ; i < 3 ; i ++ )
			if ( t->vertex[i]->valid == VV_NEW ) {
				t->vertex[i]->valid = 0;
				break;
			}
	}
	w->total_vertex = 0;
	w->valid_tin = 0;
	if ( ret ) {
		for ( t = w->tins ; t ; t = t->next ) {
			for ( i = 0 ; i < 3 ; i ++ ) {
				switch ( t->vertex[i]->valid ) {
				case VV_USE:
					t->vertex[i]->valid = VV_LOCK;
					w->total_vertex ++;
					break;
				}
			}
		}
	}
	for ( t = w->tins ; t ; t = t->next ) {
		for ( i = 0 ; i < 3 ; i ++ ) {
			switch ( t->vertex[i]->valid ) {
			case VV_NEW:
				t->vertex[i]->valid = VV_USE;
				w->total_vertex ++;
				break;
			}
		}
		for ( i = 0 ; i < 3 ; i ++ )
			if ( t->vertex[i]->valid == 0 )
				goto next;
		w->valid_tin ++;
	next:	;
	}
ss_printf("RET %i\n",ret);
	print_status(w);
	return ret;
}

int test_ofs;
int test_flag;

void
check_mr(NETLIST_WORK * w)
{
NETLIST_VERTEX * v;
GB_RECT r;
	r.tl.x = r.tl.y = 0;
	r.br.x = r.br.y = -1;
	for ( v = w->vertex ; v ; v = v->next ) {
		if ( v->valid == 0 )
			continue;
		insert_rect(&r,v->src_list->ptr);
	}
	ss_printf("(%f %f) - (%f %f)\n",r.tl.x,r.tl.y,r.br.x,r.br.y);
}

int
check_nan(double d)
{
typedef union nn {
	double	d;
	INTEGER64	i;
} NN;
NN dd;
	dd.d = d;
	if ( dd.i == 9221120237041090561LL )
		return -1;
	return 0;
}

void
calc_estimate(
	double * d_p,
	double * wt_p,
	NETLIST_WORK * w,
	NETLIST_TIN * t,
	GB_POINT * plist)
{
double d;
GB_POINT trg[3];
int i,er;
AFFEN2D a;
double dst[3];
double org[3];
double omax,omin;
double od;
double tt,dd,ee;
double t1,t2;
int target;
double left,right,ml;
double ctr,af;

	if ( plist == 0 ) {
		trg[0] = t->vertex[0]->src_list->ptr;
		trg[1] = t->vertex[1]->src_list->ptr;
		trg[2] = t->vertex[2]->src_list->ptr;
	}
	else {
		for ( i = 0 ; i < 3 ; i ++ ) {
			if ( t->vertex[i]->plist_ofs < 0 || t->vertex[i]->valid == VV_LOCK )
				trg[i] = t->vertex[i]->src_list->ptr;
			else
				trg[i] = plist[t->vertex[i]->plist_ofs];
		}
	}
	er = get_matrix(&a,
		t->selects[0]->ptr,	trg[0],
		t->selects[1]->ptr,	trg[1],
		t->selects[2]->ptr,	trg[2]);
/*
ss_printf("V--- %i %f %f - %f %f - %f %f ----- %f %f - %f %f - %f %f * %ls %ls %ls\n",
er,
trg[0].x,
trg[0].y,
trg[1].x,
trg[1].y,
trg[2].x,
trg[2].y,

t->selects[0]->ptr.x,
t->selects[0]->ptr.y,
t->selects[1]->ptr.x,
t->selects[1]->ptr.y,
t->selects[2]->ptr.x,
t->selects[2]->ptr.y,
t->vertex[0]->point_name,
t->vertex[1]->point_name,
t->vertex[2]->point_name
);
*/
	*wt_p = (distance(trg[0],trg[1]) + distance(trg[1],trg[2]) + distance(trg[2],trg[0])) + 0.001;
	w->dist += (dst[0]=distance(trg[0],trg[1])) + (dst[1]=distance(trg[1],trg[2])) 
			+ (dst[2]=distance(trg[2],trg[0]));
	org[0] = distance(t->selects[0]->ptr,t->selects[1]->ptr);
	org[1] = distance(t->selects[1]->ptr,t->selects[2]->ptr);
	org[2] = distance(t->selects[2]->ptr,t->selects[0]->ptr);

	if ( org[0] == 0 || org[1] == 0 || org[2] == 0 ) {
		ss_printf("NAN %ls %ls %ls %f %f %f\n",
			t->vertex[0]->point_name,
			t->vertex[1]->point_name,
			t->vertex[2]->point_name,
			org[0],org[1],org[2]);
		exit(1);
	}
	dst[0] /= org[0];
	dst[1] /= org[1];
	dst[2] /= org[2];
	
	t->dr[0] = dst[0];
	t->dr[1] = dst[1];
	t->dr[2] = dst[2];
	
	omin = omax = dst[0];
	if ( dst[1] < omin )
		omin = dst[1];
	if ( dst[2] < omin )
		omin = dst[2];
	if ( dst[1] > omax )
		omax = dst[1];
	if ( dst[2] > omax )
		omax = dst[2];
	
	if ( dst[0] || dst[1] || dst[2] ) 
		od = (omax - omin)/(dst[0] + dst[1] + dst[2]);
	else	od = 1;

	left = a.matrix[0][0]*a.matrix[0][0] +
		a.matrix[1][0]*a.matrix[1][0];
	right = a.matrix[0][1]*a.matrix[0][1] +
		a.matrix[1][1]*a.matrix[1][1];
	ml = a.matrix[0][0]*a.matrix[0][1] +
		a.matrix[1][0]*a.matrix[1][1];
	ctr = (left + right)/2;
	
	af = sqrt( ((left-right)/2)*((left-right)/2) + ml*ml );

	if ( ctr == 0 )
		od = 1;
	else if ( ctr-af < 0 )
		od = (sqrt(ctr+af))/sqrt(ctr)*0.5;
	else	od = (sqrt(ctr+af)-sqrt(ctr-af))/sqrt(ctr)*0.5;
	t->od = od;
	t->od2 = sqrt(ctr);
	
	w->dist_cnt += 3;
/*
	if ( dst[0] > w->max_dist )
		return dst[0]/w->max_dist*5;
	if ( dst[1] > w->max_dist )
		return dst[1]/w->max_dist*5;
	if ( dst[2] > w->max_dist )
		return dst[2]/w->max_dist*5;

	if ( distance(w->center,trg[0]) > w->radius )
		er_panic("OPT OVER 0\n");
	if ( distance(w->center,trg[1]) > w->radius )
		er_panic("OPT OVER 1\n");
	if ( distance(w->center,trg[2]) > w->radius )
		er_panic("OPT OVER 2\n");
*/
	tt = a.matrix[0][0] + a.matrix[1][1];
	dd = a.matrix[0][0] * a.matrix[1][1] -
		a.matrix[1][0] * a.matrix[0][1];
	ee = tt*tt - 4*dd;
	if ( ee > 0 ) {
		t1 = tt + sqrt(tt*tt - 4*dd);
		t2 = tt - sqrt(tt*tt - 4*dd);
		target = 1;
	}
	else {
		tt = a.matrix[0][0] - a.matrix[1][1];
		dd = -dd;
		t1 = tt + sqrt(tt*tt - 4*dd);
		t2 = tt - sqrt(tt*tt - 4*dd);
		target = -1;
	}
	d = pseudo_angle(t1,t2);
	d = (d-target)*(d-target);
/*
	if ( od > 0.5 ) {
		d = od*PA_LEVEL;
	}
	else {
*/
		if ( d < PA_LEVEL )
			d = od*PA_LEVEL;
		else
			d += 0.1* od*PA_LEVEL;
/*
	}
*/

	d = d*d;
	t->pseudo_angle = d;
	t->t1 = t1;
	t->t2 = t2;
	t->rf = target;
	t->a = a;
	
/*
if ( 
l_strcmp(t->vertex[0]->point_name,l_string(std_cm,"W-K7")) == 0 ||
l_strcmp(t->vertex[1]->point_name,l_string(std_cm,"W-K7")) == 0 ||
l_strcmp(t->vertex[2]->point_name,l_string(std_cm,"W-K7")) == 0
) {
ss_printf("\t\ttt = %f dd = %f d = %f t1 = %f t2 = %f\n",tt,dd,d,t1,t2);
ss_printf("V--- %i %f %f - %f %f - %f %f ----- %f %f - %f %f - %f %f\n",
er,
trg[0].x,
trg[0].y,
trg[1].x,
trg[1].y,
trg[2].x,
trg[2].y,

t->selects[0]->ptr.x,
t->selects[0]->ptr.y,
t->selects[1]->ptr.x,
t->selects[1]->ptr.y,
t->selects[2]->ptr.x,
t->selects[2]->ptr.y);
ss_printf("MATRIX %f %f %f %f\n",
a.matrix[0][0],
a.matrix[0][1],
a.matrix[1][0],
a.matrix[1][1]);
}
*/
	*d_p = d;
}

int
neighbour_illeagal(NETLIST_TIN * t)
{
NETLIST_TIN * t2;
int i,j;

	for ( j = 0 ; j < 3 ; j ++ )
		if ( t->vertex[j]->valid == VV_NOTUSE )
			return 0;
	for ( i = 0 ; i < 3 ; i ++ ) {
		t2 = t->nh[i];
		if ( t2 == 0 )
			continue;
		for ( j = 0 ; j < 3 ; j ++ )
			if ( t2->vertex[j]->valid == VV_NOTUSE )
				goto next;
		if ( t2->od2 == 0 )
			goto ee;
		if ( t->od2 == 0 )
			goto ee;
		if ( t2->od2/t->od2 > NB_LEVEL )
			goto ee;
		if ( t->od2/t2->od2 > NB_LEVEL )
			goto ee;
	next:	;
	}
	return 0;
ee:

	return -1;
}

double
neibour_total(NETLIST_WORK * w)
{
NETLIST_TIN * t,*t2;
int i;
double d,m;
int cnt;
	m = 0;
	cnt = 0;
	for ( t = w->tins ; t ; t = t->next )
		t->od2_flag = 0;
	for ( t = w->tins ; t ; t = t->next ) {
		for ( i = 0 ; i < 3 ; i ++ ) {
			t2 = t->nh[i];
			if ( t2 == 0 )
				continue;
			if ( t2->od2_flag )
				continue;
			if ( t2->od2 == 0 )
				goto in;
			if ( t->od2 == 0 )
				goto in;
			if ( t2->od2/t->od2 > NB_LEVEL )
				goto in;
			if ( t->od2/t2->od2 > NB_LEVEL )
				goto in;
			continue;
		in:
			d = (t2->od2 - t->od2);
			if ( d < 0 )
				m += sqrt(-d);
			else	m += sqrt(d);
			cnt ++;
		}
		t->od2_flag = 1;
	}
//ss_printf("NT %g\n",m/cnt);
	if ( cnt == 0 )
		return 0;
	return m/cnt;
}

double
optimize_mapping_1(GB_POINT * plist,NETLIST_WORK * w,int len,int mode)
{
NETLIST_TIN * t;
double d;
double wt;
int i;

double			m;
double			wm;
double			min;
double			max;
int			cnt;
double			w_cnt;
double			add_max;
double			nt;

	m = 0;
	wm = 0;
	min = 10;
	max = -1;
	cnt = 0;
	w_cnt = 0;
	add_max = 0;
	
	w->dist = 0;
	w->dist_cnt = 0;
	for ( t = w->tins ; t ; t = t->next ) {
		for ( i = 0; i < 3 ; i ++ )
			if ( t->vertex[i]->valid == 0 )
				goto cnt;
/***/
		calc_estimate(&d,&wt,w,t,plist);
		wm += d * wt;
		w_cnt += wt;
		
		if ( d >= PA_LEVEL )
			add_max += d;

		m += d;
		if ( min > d ) 
			min = d;
		if ( max < d ) {
			max = d;
			w->reverse = t;
		}
		cnt ++;
	cnt:	;
	}
	nt = neibour_total(w);
{
static INTEGER64 tim;
INTEGER64 t;
t = get_xltime();
if ( t != tim ) {
ss_printf("max = %g %g %g %g %g %g\n",add_max,nt,max,min,m/cnt,wm/w_cnt);
tim = t;
}}
	if ( add_max )
		add_max += nt;
	w->dist /= w->dist_cnt;
	w->max = max;
	switch ( mode ) {
	case 1:
		return max;
	case 0:
		return m/cnt;
	case 2:
		return wm/w_cnt;
	case 3:
		return add_max + 0.1*m/cnt;
	}
	return 0;
}

void
set_save_flag(NETLIST_WORK * w)
{
NETLIST_TIN * t;
int i;

	for ( t = w->tins ; t ; t = t->next ) {
		for ( i = 0 ; i < 3 ; i ++ ) {
			if ( t->vertex[i]->valid == 0 ) {
				t->save_flag = 1;
				break;
			}
		}
	}
}

int
count_tins(NETLIST_WORK * w,int count)
{
NETLIST_TIN * t;
int i;
int c;
	if ( count < 0 )
		return 1;
	c = 0;
	for ( t = w->tins ; t ; t = t->next ) {
		for ( i = 0 ; i < 3 ; i ++ )
			if ( t->vertex[0]->valid == VV_NOTUSE )
				goto next;
		c ++;
	next:	;
	}
	ss_printf("COUNT = %i %i\n",c,count);
	if ( c >= count )
		return 0;
	return 1;
}

void
optimize_mapping(NETLIST_WORK * w)
{
NETLIST_VERTEX * v;
GB_POINT p,q;
GB_RECT r;
int cnt;
REAL1 pitch;
GB_POINT * plist;
double * dlist;
GB_POINT * pibot;
GB_POINT * jmp;
GB_POINT * next;
int *dangle;
int nf;
int nf_f;
int len,i;
int j,k;
double estimate,e,ee;
int nf_cnt;
int mode;
int pibot_len;
double kk;
FILE * fd;
int rret;
int return_mode = 1;
int loop_time;
NETLIST_TIN * t1;
GB_POINT direct,pbackup;
	if ( w->floating == 0 )
		return;
	list_neignbour(w);

	
	loop_time = LOOP_TIME;
ss_printf("OPT START\n");
	mode = 3;
	p.x = p.y = 0;
	r.tl.x = r.tl.y = 0;
	r.br.x = r.br.y = -1;
	cnt = 0;
	for ( v = w->vertex ; v ; v = v->next ) {
		if ( v->src_list->floating )
			continue;
		p = p_add(p,v->src_list->ptr);
		insert_rect(&r,v->src_list->ptr);
		cnt ++;
	}
	p.x /= cnt;
	p.y /= cnt;
	w->center = p_add(r.br,r.tl);
	w->center.x *= 0.5;
	w->center.y *= 0.5;
	len  = 0;
	pitch = ((r.br.x - r.tl.x) + (r.br.y - r.tl.y))/2;
	w->radius = pitch*w->_radius;
	w->max_dist = pitch*2;
	w->dist = 0;
	w->dist_cnt = 0;
ss_printf("RADIUS = %f\n",w->radius);

	fd = fopen("points.txt","r+");
	if ( fd == 0 ) {
		ss_printf("NO POINTS.TXT\n");
		for ( v = w->vertex ; v ; v = v->next ) {
			if ( v->src_list->floating == 0 ) {
				v->valid = VV_USE;
ss_printf("floating off %ls\n",v->point_name);
				v->plist_ofs = -1;
				continue;
			}
			q.x = pitch*rand()/RAND_MAX + pitch*0.5;
			q.y = pitch*rand()/RAND_MAX + pitch*0.5;
			v->src_list->ptr = p_add(p,q);
			v->plist_ofs = len;
			v->opt_no = len ++;
			v->valid = 0;
		}
	}
	else {
		ss_printf("LOADING...... POINTS.TXT\n");
		input_point_list(fd,w);
		fclose(fd);
		for ( v = w->vertex ; v ; v = v->next ) {
			if ( v->src_list->floating == 0 ) {
				v->valid = VV_USE;
				v->plist_ofs = -1;
				continue;
			}
			if ( v->valid ) {
				v->plist_ofs = len;
				v->opt_no = len ++;
				continue;
			}
			q.x = pitch*rand()/RAND_MAX + pitch*0.5;
			q.y = pitch*rand()/RAND_MAX + pitch*0.5;
			v->src_list->ptr = p_add(p,q);
			v->plist_ofs = len;
			v->opt_no = len ++;
			v->valid = 0;
		}
	}
print_status(w);
	plist = d_alloc(sizeof(GB_POINT)*len);
	dlist = d_alloc(sizeof(double)*len);
	next = d_alloc(sizeof(GB_POINT)*len);
	pibot = d_alloc(sizeof(GB_POINT)*len);
	jmp = d_alloc(sizeof(GB_POINT)*len);
	dangle = d_alloc(sizeof(int)*len);
retry:
	nf_f = 0;
	kk = 1;
	pitch = MAX_PITCH;
ss_printf("DIST = %f\n",w->dist);
/*
	if ( w->dist < pitch )
		pitch = w->dist;
*/
	optimize_get_data(plist,dlist,dangle,w,len);
	memcpy(pibot,plist,sizeof(GB_POINT)*len);
	estimate = optimize_mapping_1(plist,w,len,mode);
	nf_cnt = 0;
	pibot_len = 0;
	for ( ; ; ) {
/*
ss_printf("A %f %i\n",w->max,mode);
if ( w->max >= PA_LEVEL )
ss_printf("REVERSE %ls %ls %ls\n",
w->reverse->vertex[0]->point_name,
w->reverse->vertex[1]->point_name,
w->reverse->vertex[2]->point_name);
*/
		nf = 0;

		e = optimize_mapping_1(plist,w,len,mode);
		for ( t1 = w->tins ; t1 ; t1 = t1->next ) {
			if ( neighbour_illeagal(t1) == 0 )
				t1->nh_flag = 0;
			else	t1->nh_flag = 1;
		}
		for ( t1 = w->tins ; t1 ; t1 = t1->next ) {
			if ( t1->nh_flag == 0 )
				continue;
			for ( k = 0 ; k < 3 ; k ++ ) {
				i = t1->vertex[k]->plist_ofs;
				optimize_get_data(plist,dlist,dangle,w,len);
				pbackup = plist[i];
				for ( j = 0 ; j < dangle[i] ; j ++ ) {
					direct.x = cos(j*2*M_PI/dangle[i])*dlist[i];
					direct.y = sin(j*2*M_PI/dangle[i])*dlist[i];
//ss_printf("D %g %g\n",direct.x,direct.y);
					plist[i] = p_add(pbackup,direct);
					if ( distance(plist[i],w->center) > w->radius )
						continue;
					e = optimize_mapping_1(plist,w,len,mode);
					if ( (e >= 0 && estimate > e) ) {
						memcpy(next,plist,sizeof(GB_POINT)*len);
						ee = estimate;
						estimate = e;
						nf = 1;
					}
				}
			}
		}


		for ( i = 0 ; i < len ; i ++ ) {
			optimize_get_data(plist,dlist,dangle,w,len);
			plist[i].x += pitch*dlist[i];
			if ( distance(plist[i],w->center) > w->radius )
				continue;
			e = optimize_mapping_1(plist,w,len,mode);
			if ( (e >= 0 && estimate > e) ) {
				memcpy(next,plist,sizeof(GB_POINT)*len);
				ee = estimate;
				estimate = e;
				nf = 1;
			}
		}
		for ( i = 0 ; i < len ; i ++ ) {
			optimize_get_data(plist,dlist,dangle,w,len);
			plist[i].x -= pitch*dlist[i];
			if ( distance(plist[i],w->center) > w->radius )
				continue;
			e = optimize_mapping_1(plist,w,len,mode);
			if ( (e >= 0 && estimate > e) ) {
				memcpy(next,plist,sizeof(GB_POINT)*len);
				ee = estimate;
				estimate = e;
				nf = 1;
			}
		}
		for ( i = 0 ; i < len ; i ++ ) {
			optimize_get_data(plist,dlist,dangle,w,len);
			plist[i].y += pitch*dlist[i];

			if ( distance(plist[i],w->center) > w->radius )
				continue;
			e = optimize_mapping_1(plist,w,len,mode);
			if ( (e >= 0 && estimate > e) ) {
				memcpy(next,plist,sizeof(GB_POINT)*len);
				ee = estimate;
				estimate = e;
				nf = 1;
			}
		}
		for ( i = 0 ; i < len ; i ++ ) {
			optimize_get_data(plist,dlist,dangle,w,len);
			plist[i].y -= pitch*dlist[i];
			if ( distance(plist[i],w->center) > w->radius )
				continue;
			e = optimize_mapping_1(plist,w,len,mode);
			if ( (e >= 0 && estimate > e) ) {
				memcpy(next,plist,sizeof(GB_POINT)*len);
				ee = estimate;
				estimate = e;
				nf = 1;
			}
		}

ss_printf("ESTIMATE = %g %g -- %i %i -- %i %i * %i %f %f\n",
pitch,estimate,pibot_len,len,w->total_vertex,w->valid_tin,nf,w->dist,w->radius);
		if ( nf == 0 ) {
			kk = 1;
			nf_cnt = 0;
			pitch *= 0.5;
			if ( pitch < w->target_pitch )
				break;
		}
		else {
			nf_f = 1;
			ee = ee - estimate;
			if ( ee < 0 )
				ee = -ee;
			if ( ee / estimate < 0.000001 ) {
ss_printf("SMALL E %g %f\n",ee/estimate,kk);
//				pitch *= 1.001;
				kk *= 1.001;
				if ( kk >= 1.05 ) {
ss_printf("R %i %f %f %f\n",return_mode,pitch,DELTA_PITCH,estimate);
					if ( return_mode == 1 && pitch < DELTA_PITCH && estimate < PA_LEVEL )
{ss_printf("RETURN MODE BREAK\n");
						break;
}
					pitch = MAX_PITCH;
					kk = 1;
				}

			}
//			else kk = 1;
			optimize_store_data(next,w,len);
			for ( i = 0 ; i < len ; i ++ ) {
				jmp[i].x = 3*next[i].x - 2*pibot[i].x;
				jmp[i].y = 3*next[i].y - 2*pibot[i].y;
				if ( distance(jmp[i],w->center) > w->radius )
					goto non_jmp;
			}
			e = optimize_mapping_1(jmp,w,len,mode);
			if ( (e >= 0 && estimate > e) ) {
				optimize_store_data(jmp,w,len);
				memcpy(pibot,next,sizeof(GB_POINT)*len);
				estimate = e;
				pibot_len = 0;
ss_printf("==============================================JMP\n");
			}
			else {
			non_jmp:
				if ( pibot_len >= 20 ) {
					memcpy(pibot,next,sizeof(GB_POINT)*len);
					pibot_len = 0;
				}
				else	pibot_len ++;
			}
		}
	}

	if ( count_tins(w,TINS_NOS) == 0 ) {
ss_printf(">>> NF_F %i ESTIMATE %g\n",nf_f,estimate);
		return_mode = 0;
		if ( nf_f == 0 )
			goto end;
		rret = 0;
		if ( estimate >= PA_LEVEL )
			goto end;
		goto retry;
	}
	rret=set_valid(w,estimate);
	if ( loop_time > 0 ) {
		loop_time --;
		if ( loop_time == 0 )
			goto end;
	}
	if ( rret == 0 && nf_f ) {
		return_mode = 0;
		goto retry;
	}
	if ( nf_f && estimate >= PA_LEVEL ) {
		if ( rret == 0 )
			return_mode = 0;
		goto retry;
	}
	if ( rret == 0 || (rret < 0 && nf_f == 0) || loop_time == 0  ) {
	STREAM * st;
	end:
		ss_printf("RRET = %i %i %i\n",rret,nf_f,loop_time);
		st = s_open_file("points.txt",O_CREAT|O_TRUNC|O_RDWR,0644);
		if ( st == 0 )
			return;
		output_point_list(st,w);
		s_close(st);
		check_mr(w);
		set_save_flag(w);
		return;
	}

	goto retry;
}

XL_SEXP *
mapping_list(NETLIST_WORK * w)
{
	return 0;
}

XL_SEXP * 
xl_Netlist(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
NETLIST_WORK w;
L_CHAR * src;
L_CHAR * dest;
L_CHAR * save;
XL_SEXP * ret;
L_CHAR * p;
XL_SEXP * inp;
XL_SEXP * line;
XL_SEXP * el;
XL_SEXP * d;
L_CHAR fh;
int tin_mode;
L_CHAR * radius;

	ret = 0;
	memset(&w,0,sizeof(w));

	w.target_pitch = DEFAULT_TARGET_PITCH;

	radius = get_sf_attribute(sf,l_string(std_cm,"radius"));
	if ( radius == 0 )
		w._radius = 20;
	else	w._radius = atoi(n_string(std_cm,radius));

	src = get_sf_attribute(sf,l_string(std_cm,"src"));
	if ( src == 0 ) {
		ret = n_get_string("src attribute is required");
		goto invalid_param;
	}
	dest = get_sf_attribute(sf,l_string(std_cm,"dest"));
	if ( dest == 0 ) {
		ret = n_get_string("dest attribute is required");
		goto invalid_param;
	}
	save = get_sf_attribute(sf,l_string(std_cm,"save"));
	w.src_filename_before = ll_copy_str(src);
	for ( p = w.src_filename_before ; *p && *p != '*' ; p ++ );
	if ( *p == 0 ) {
		ret = n_get_string("src attribute requires URL path including wild car \"*\"");
		goto invalid_param;
	}
	*p = 0;
	w.src_filename_after = p+1;
	w.dest_filename = dest;
	w.save_dir = save;
	fh = 0;
	w.fileheader = &fh;
	inp = get_el(s,1);
	tin_mode = 0;
	for ( ; get_type(inp) == XLT_PAIR ; inp = cdr(inp) ) {
		line = car(inp);
print_sexp(s_stdout,line,0);
ss_printf("\n");
		el = car(line);
		if ( get_type(el) != XLT_STRING )
			continue;
		if ( el->string.data[0] == '#' )
			continue;
		if ( el->string.data[0] == 0 && tin_mode == 0 )
			continue;
		if ( l_strcmp(el->string.data,l_string(std_cm,"tin")) == 0 ) {
			tin_mode = 1;
			continue;
		}
		if ( l_strcmp(el->string.data,l_string(std_cm,"point")) == 0 ) {
			tin_mode = 0;
			continue;
		}
		if ( l_strcmp(el->string.data,l_string(std_cm,"fileheader")) == 0 ) {
			d = get_el(line,1);
			if ( get_type(d) != XLT_STRING ) {
				ret = n_get_string("invalid fileheader");
				goto invalid_param;
			}
			w.fileheader = d->string.data;
		}
		if ( tin_mode == 0 )
			ret = insert_vertex(&w,line,s);
		else	ret = insert_tin(&w,line,s);
		if ( get_type(ret) == XLT_ERROR )
			return ret;
	}
	optimize_mapping(&w);
	if ( w.save_dir ) {
		ret = save_mapfile(&w,s);
		if ( get_type(ret) == XLT_ERROR )
			return ret;
	}
	return mapping_list(&w);
invalid_param:

	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"Netlist"),
		ret);
}


