/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef __SVG2GB_H__
#define __SVG2GB_H__

#include "xl2pdb_p.h"
#include "svgtypes.h"
#include "svgfuncs.h"


typedef struct svg_point_list {
	SVG_POINT	p;
	int		flags;
} SVG_POINT_LIST;

typedef struct svg2gb_context{
	SVG_LAYER *current_layer;
	SVG_LAYER *root_layer;
	
	int point_buff_size;
	SVG_POINT_LIST *point_buff;
	int point_count;
	SVG_COLOR current_fill_color;
	SVG_COLOR current_stroke_color;
	L_CHAR *current_id;

	int		digit;
}SVG2GB_CONTEXT;

typedef struct svg2gb_outputpp_info{
	char filename_pp[260];
	char filename_inf[260];
/*	char filename_vct[260]; */
}SVG2GB_OUTPUTPP_INFO;

typedef struct svg2gb_outputvct_info{
	char filename[260];
	char scheme[260];
	char card_file[260];
	char onmap_file[260];
	char visible_resolution[32];
}SVG2GB_OUTPUTVCT_INFO;


void svg2gb_init();
void svg2gb_clean();

SVG2GB_CONTEXT *svg2gb_get_context();
void svg2gb_make_context();
void svg2gb_free_context();
SVG_LAYER *svg_get_current_layer(SVG2GB_CONTEXT *ctx);

void svg2gb_on_convert_polygon(SVG2GB_CONTEXT *ctx, int closeFlag);


/* xl2pdb_p origin funcs */
PDB_POLYGON2D *search_pdb_avt(L_CHAR * name,L_CHAR * subname);
void insert_pdb_avt(PDB_POLYGON2D * p);
void insert_sn_avt(PDB_POLYGON2D * p);
void setup_minrect();
void numbering();
void output_info(SVG2GB_OUTPUTPP_INFO *o);
PDB_POLYGON2D *remove_poly_from_pdb_p_list(PDB_POLYGON2D *poly);
void remove_poly_from_pdb_p_avt(PDB_POLYGON2D *poly);
void output_vct(SVG2GB_OUTPUTVCT_INFO *o);

typedef struct pdb_mark_tags__{
	struct pdb_mark_tags__ *next;
	XL_SEXP *sexp;
	XL_SEXP *info;
	L_CHAR *name;
	L_CHAR *subname;
}PDB_MARK_TAGS;

extern PDB_MARK_TAGS *pdb_mark_tags;


void init_function(XLISP_ENV *e0,XLISP_ENV *e1,int argc,char ** argv);
void svg2gb_init();
void init_svg(XLISP_ENV *e0);
void init_g(XLISP_ENV *e0);
void init_path(XLISP_ENV *e0);
void init_OutputPP(XLISP_ENV *e0);
void init_information(XLISP_ENV *e0);
void init_ConnectPath(XLISP_ENV *e0);
void gc_pdb_p_list();
void gc_pdb_mark_tags();
void lod_control();
void make_tree();
void save_pdb(SVG2GB_OUTPUTPP_INFO *info);

void init_text(XLISP_ENV * env);
void init_mark(XLISP_ENV * env);
void init_foreignObject(XLISP_ENV * env);
void init_switch(XLISP_ENV * env);

PDB_MARK_TAGS *
get_mark(XL_SEXP ** retp,XL_SYM_FIELD * sf,XL_FILE * file,int line);

extern GB_RECT_F minrect;
extern CODE_INDEX *code_index;

#endif
