/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"machine/include.h"
#include	"r64_types.h"
#include	"r64.h"

int
r64_ctl(R64_FILE * f,int cmd,...)
{
va_list p;
int a;

#ifdef VA2
	va_start(p);
#else
	va_start(p,cmd);
#endif
	switch ( cmd ) {
	case R64_SET_RCTYPE:
		a = va_arg(p,int);
		if ( a != RC_BACK && a != RC_NEAR ) {
			r64_error = E_PAR;
			return -1;
		}
		f->rc_type = a;
		break;
	case R64_SET_BACKGROUND_COLOR:
		{
		unsigned char * buf;
			buf = va_arg(p,unsigned char *);
			memcpy(f->background,buf,ENT_UNIT_VOL(f));
		}
		break;
	default:
		r64_error = E_PAR;
		return -1;
	}
	r64_error = E_OK;
	return 0;
}
