/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"utils.h"
#include	"xl.h"
#include	"memory_debug.h"

XL_SEXP * xl_Prefix();

void
init_Prefix(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Prefix"),
		get_func_prim(xl_Prefix,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_Prefix(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
XL_SEXP * path;
L_CHAR * buf;
XL_SEXP * ret;
int p;
L_CHAR * mode;
	mode = get_sf_attribute(sf,l_string(std_cm,"mode"));
	path = get_el(s,1);
	switch ( get_type(path) ) {
	case XLT_ERROR:
		return path;
	case XLT_STRING:
		buf = ll_copy_str(path->string.data);
		break;
	default:
		goto type_missmatch;
	}
	p = l_strlen(buf);
	if ( p == -1 ) {
		d_f_ree(buf);
		return n_get_string("");
	}
	p --;
	for ( ; p >= 0 && buf[p] != '.' && buf[p] != '/' ; p -- );
	if ( p < 0 || buf[p] == '/' ) {
		d_f_ree(buf);
		return n_get_string("");
	}
	if ( mode && l_strcmp(mode,l_string(std_cm,"file")) == 0 ) {
		buf[p] = 0;
		ret = get_string(buf);
	}
	else	ret = get_string(&buf[p]);
	d_f_ree(buf);
	return ret;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Prefix"),
		0);
}
