/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<stdio.h>
#include	<fcntl.h>
#include	"utils.h"
#include	"memory_routine.h"
#include	"memory_debug.h"
#include	"xl.h"
#include	"xlerror.h"

void gc_gb_sexp();

/*
(save "filename" <int:open_mode> <int:access_mode> "raw/gblisp" <list:datalist>)
<Save option="raw/xl" oflag="creat/trunc" mode="permission flags">
filename exp</Save>
*/

typedef struct csv_field_list {
	struct csv_field_list *		next;
	L_CHAR *			title;
	int				type;
	L_CHAR *			symbol;
	XL_SEXP *			data;
	int				flags;
} CSV_FIELD_LIST;

void
init_Save(XLISP_ENV * env)
{
extern XL_SEXP * xl_Save();
	set_env(env,l_string(std_cm,"Save"),
		get_func_prim(xl_Save,FO_APPLICATIVE,0,3,4));
}


L_CHAR *
csv_convert_string(L_CHAR * str)
{
L_CHAR * ptr;
int flag;
int len;
L_CHAR *ret;

	flag = 0;
	for ( ptr = str ; *ptr ; ptr++ )
		if ( *ptr == '"' || *ptr == ',' ) {
			flag = 2;
			break;
		}
	len = l_strlen(str);
	if ( flag ) {
		ret = d_alloc(sizeof(L_CHAR)*(len+flag+1));
		memcpy(&ret[1],str,sizeof(L_CHAR)*(len+1));
		ret[0] = '"';
		ret[len+1] = '"';
		ret[len+2] = 0;
	}
	else	ret = ll_copy_str(str);

	for ( ptr = ret ; *ptr ; ptr ++ ) {
		switch ( *ptr ) {
		case '\n':
		case '\r':
			*ptr = ' ';
			break;
		case '\t':
			*ptr = ' ';
		}
	}

	return ret;
}


void
xl_save_csv_pat1(STREAM * st,XL_SEXP * s,CSV_FIELD_LIST * fl)
{
XL_SEXP * el;
XL_SEXP * sym,* d;
CSV_FIELD_LIST * f2;
int type;
L_CHAR * str;
	for ( f2 = fl ; f2 ; f2 = f2->next ) {
		if ( f2->title )
			s_printf(st,"%ls",f2->title);
		if ( f2->next )
			s_printf(st,",");
		else	s_printf(st,"\n\n");
	}
	for ( ; get_type(s) == XLT_PAIR ; s = cdr(s) ) {
		el = car(s);
		for ( f2 = fl ; f2 ; f2->data = 0 , f2 = f2->next );
		switch ( type = get_type(el) ) {
		case XLT_PAIR:
			sym = car(el);
			if ( get_type(sym) != XLT_SYMBOL )
				break;
			for ( f2 = fl ; f2  ;f2 = f2->next )
				if ( f2->type == XLT_PAIR )
					break;
			if ( f2 )
				f2->data = sym;
			el = cdr(el);
			for ( ;  get_type(el) == XLT_PAIR ; el = cdr(el) ) {
				d = car(el);
				if ( get_type(d) != XLT_PAIR ) {
					for ( f2 = fl ; f2 ; f2 = f2->next ) {
						if ( f2->type != get_type(d) )
							continue;
						if ( f2->data )
							continue;
						break;
					}
					if ( f2 == 0 )
						continue;
					f2->data = d;
					continue;
				}
				sym = car(d);
				if ( get_type(sym) != XLT_SYMBOL )
					continue;
				for ( f2 = fl ; f2 ; f2 = f2->next ) {
					if ( f2->symbol == 0 )
						continue;
					if ( l_strcmp(f2->symbol,sym->symbol.data) )
						continue;
					if ( f2->data )
						continue;
					break;
				}
				if ( f2 == 0 )
					continue;
				f2->data = get_el(d,1);
			}
			break;
		default:
			for ( f2 = fl ; f2 && f2->type != type ; f2 = f2->next );
			if ( f2 == 0 )
				break;
			for ( ; f2 && f2->data && f2->type == type ; f2 = f2->next );
			if ( f2 == 0 )
				break;
			if ( f2->type != type )
				break;
			f2->data = el;
			break;
		}
		for ( f2 = fl ; f2 ; f2 = f2->next ) {
			if ( f2->data == 0 )
				goto next;
			switch ( get_type(f2->data) ) {
			case XLT_SYMBOL:
				s_printf(st,"%ls",f2->data->symbol.data);
				break;
			case XLT_STRING:
				str = csv_convert_string(f2->data->string.data);
				s_printf(st,"%ls",str);
				d_f_ree(str);
				break;
			case XLT_FLOAT:
				s_printf(st,"%f",f2->data->floating.data);
				break;
			case XLT_INTEGER:
				s_printf(st,I64_FORMAT,f2->data->integer.data);
				break;
			case XLT_ERROR:
				s_printf(st,"!!ERROR!!");
				break;
			default:
				s_printf(st,"!!D(%i)!!",get_type(f2->data));
			}
		next:
			if ( f2->next )
				s_printf(st,",");
			else	s_printf(st,"\n");
		}
	}
}

CSV_FIELD_LIST *
csv_generate_field_list(XL_SEXP * s)
{
XL_SEXP * el,*d,*sym;
CSV_FIELD_LIST * ret, ** p, * n;
CSV_FIELD_LIST * f;
char buf[20];
	ret = 0;
	p = &ret;

	n = d_alloc(sizeof(*n));
	memset(n,0,sizeof(*n));
	n->title = nl_copy_str(std_cm,"RECORD-TYPE");
	n->type = XLT_PAIR;
	*p = n;
	p = &n->next;

	for ( ; get_type(s) == XLT_PAIR ; s = cdr(s) ) {
		for ( f = ret ; f ; f = f->next )
			f->flags = 0;
		el = car(s);
		if ( get_type(el) != XLT_PAIR ) {
			n = d_alloc(sizeof(*n));
			memset(n,0,sizeof(*n));
			sprintf(buf,"tp%i",get_type(el));
			n->title = nl_copy_str(std_cm,buf);
			n->type = get_type(el);
			*p = n;
			p = &n->next;
			continue;
		}
		sym = car(el);
		if ( get_type(sym) != XLT_SYMBOL )
			continue;
		el = cdr(el);
		for ( ; get_type(el) == XLT_PAIR ; el = cdr(el) ) {
			d = car(el);
			if ( get_type(d) != XLT_PAIR ) {
				for ( f = ret ; f ; f = f->next ) {
					if ( f->type != get_type(d) )
						continue;
					if ( f->flags )
						continue;
					break;
				}
				if ( f == 0 ) {
					n = d_alloc(sizeof(*n));
					memset(n,0,sizeof(*n));
					sprintf(buf,"tp%i",get_type(d));
					n->title = nl_copy_str(std_cm,buf);
					n->symbol = 0;
					n->flags = 1;
					n->type = get_type(d);
					*p = n;
					p = &n->next;
				}
				continue;
			}
			sym = car(d);
			if ( get_type(sym) != XLT_SYMBOL )
				continue;
			for ( f = ret ; f ; f = f->next ) {
				if ( f->symbol == 0 )
					continue;
				if ( l_strcmp(f->symbol,sym->symbol.data) )
					continue;
				if ( f->flags )
					continue;
				break;
			}
			if ( f == 0 ) {
				n = d_alloc(sizeof(*n));
				memset(n,0,sizeof(*n));
				n->title = ll_copy_str(sym->symbol.data);
				n->symbol = ll_copy_str(sym->symbol.data);
				n->flags = 1;
				*p = n;
				p = &n->next;
			}
		}
	}
	return ret;
}

CSV_FIELD_LIST *
csv_get_field_list(XL_SEXP * s)
{
XL_SEXP * el,*sym,*d;
L_CHAR * _title;
L_CHAR * _symbol;
int _type;
CSV_FIELD_LIST * ret,**p,*n;
	ret = 0;
	p = &ret;
	for ( ; get_type(s) == XLT_PAIR ; s = cdr(s) ) {
		el = car(s);
		if ( get_type(el) != XLT_PAIR )
			continue;
		sym = car(el);
		if ( get_type(sym) != XLT_SYMBOL )
			continue;
		_title = sym->symbol.data;
		d = get_el(el,1);
		switch ( get_type(d) ) {
		case XLT_STRING:
			_symbol = d->string.data;
			_type = XLT_PAIR;
			break;
		case XLT_SYMBOL:
			_symbol = d->symbol.data;
			_type = XLT_PAIR;
			break;
		case XLT_INTEGER:
			_symbol = 0;
			_type = d->integer.data;
			break;
		default:
			continue;
		}
		n = d_alloc(sizeof(*n));
		memset(n,0,sizeof(*n));
		n->title = ll_copy_str(_title);
		n->symbol = ll_copy_str(_symbol);
		n->type = _type;
		*p =n;
		p = &n->next;
	}
	return ret;
}


void
free_csv_field_list(CSV_FIELD_LIST * f)
{
CSV_FIELD_LIST * n;
	for ( ; f ; ) {
		n = f->next;
		if ( f->title )
			d_f_ree(f->title);
		if ( f->symbol )
			d_f_ree(f->symbol);
		d_f_ree(f);
		f = n;
	}
}

int
xl_save_write(STREAM * st,XL_SEXP * s)
{
int size,er;
char * ptr;
	ptr = s->raw.data;
	size = s->raw.size;
	for ( ; size ; ) {
		er = s_write(st,ptr,size);
		if ( er < 0 )
			return -1;
		size -= er;
		ptr += er;
	}
	return 0;
}

XL_SEXP *
xl_Save(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * arg_env,XL_SYM_FIELD * sf)
{
XL_SEXP * ss, * ss1;
int mode,p;
int type;
STREAM * st;
L_CHAR * filename;
int inv_arg;
char * tmp,* ptr1, * ptr2;
int end_flag;
int ps_flags;
L_CHAR * encode;
CSV_FIELD_LIST * f;

	mode = 0;
	p = 0600;
	ps_flags = PF_MULTI_ROOT;
	encode = 0;
	for ( ; sf ; sf = sf->next ) {
		if ( l_strcmp(sf->name,l_string(std_cm,"option"))
				== 0 ) {
			if ( l_strcmp(sf->data,
					l_string(std_cm,"raw")) == 0 )
				type = 0;
			else if ( l_strcmp(sf->data,
					l_string(std_cm,"xl")) == 0 )
				type = 1;
			else if ( l_strcmp(sf->data,
					l_string(std_cm,"csv")) == 0 )
				type = 2;
			else	goto inv_param;
		}
		else if ( l_strcmp(sf->name,l_string(std_cm,"oflag"))
				== 0 ) {
			tmp = n_string(std_cm,sf->data);
			end_flag = 0;
			for ( ptr1 = tmp ; ptr1 ; ) {
				for ( ptr2 = ptr1 ;
						*ptr2 &&
						*ptr2 != ':';
						ptr2 ++ );
				if ( *ptr2 == 0 )
					end_flag = 1;
				*ptr2 = 0;
				if ( strcmp(ptr1,"creat") == 0 )
					mode |= O_CREAT;
				else if ( strcmp(ptr1,"trunc") == 0 )
					mode |= O_TRUNC;
				else if ( strcmp(ptr1,"append") == 0 )
					mode |= O_APPEND;
				else {
					goto inv_param;
				}
				if ( end_flag )
					break;
				ptr1 = ptr2+1;
			}
		}
		else if ( l_strcmp(sf->name,l_string(std_cm,"mode"))
				== 0 ) {
			sscanf(n_string(std_cm,sf->data),"%i",&p);
		}
		else if ( l_strcmp(sf->name,
				l_string(std_cm,"format.mode")) == 0 ) {
			if ( l_strcmp(sf->data,
					l_string(std_cm,"lisp")) == 0 ) {
				ps_flags &= ~PFM_FORMAT;
				ps_flags |= PF_LISP;
			}
			else if ( l_strcmp(sf->data,
					l_string(std_cm,"xml")) == 0 ) {
				ps_flags &= ~PFM_FORMAT;
				ps_flags |= PF_XML;
			}
			else if ( l_strcmp(sf->data,
					l_string(std_cm,"html")) == 0 ) {
				ps_flags &= ~PFM_FORMAT;
				ps_flags |= PF_HTML;
			}
		}
		else if ( l_strcmp(sf->name,
				l_string(std_cm,"format.indent")) == 0 ) {
			if ( l_strcmp(sf->data,
					l_string(std_cm,"on")) == 0 ) {
				ps_flags |= PF_INDENT;
			}
			else if ( l_strcmp(sf->data,
					l_string(std_cm,"off")) == 0 ) {
				ps_flags &= ~PF_INDENT;
			}
		}
		else if ( l_strcmp(sf->name,
				l_string(std_cm,"format.multiroot")) == 0 ) {
			if ( l_strcmp(sf->data,
					l_string(std_cm,"on")) == 0 ) {
				ps_flags |= PF_MULTI_ROOT;
			}
			else if ( l_strcmp(sf->data,
					l_string(std_cm,"off")) == 0 ) {
				ps_flags &= ~PF_MULTI_ROOT;
			}
		}
		else if ( l_strcmp(sf->name,
				l_string(std_cm,"format.text")) == 0 ) {
			if ( l_strcmp(sf->data,
					l_string(std_cm,"on")) == 0 ) {
				ps_flags |= PF_TEXT;
			}
			else if ( l_strcmp(sf->data,
					l_string(std_cm,"off")) == 0 ) {
				ps_flags &= ~PF_TEXT;
			}
		}
		else if ( l_strcmp(sf->name,
				l_string(std_cm,"encoding")) == 0 ) {
			encode = sf->data;
		}
	}

	ss = get_el(s,1);
	switch ( get_type(ss) ) {
	case XLT_ERROR:
		return ss;
	case XLT_STRING:
		filename = ss->string.data;
		break;
	default:
		inv_arg = 1;
		goto typemissmatch;
	}
	st = s_open_file(n_string(std_cm,filename),mode|O_RDWR,p);
	if ( st == 0 )
		goto access_error;
	if ( encode )
		set_encoding_st(st,encode);
	switch ( type ) {
	case 0:
		ss = get_el(s,2);
		switch ( get_type(ss) ) {
		case XLT_ERROR:
			s_close(st);
			return ss;
		case XLT_PAIR:
			break;
		default:
			s_close(st);
			inv_arg = 5;
			goto typemissmatch;
		}
		for ( ; get_type(ss) ;
				gc_push(ss,gc_gb_sexp,"Save"),
				ss = cdr(ss),
				gc_pop(ss,gc_gb_sexp)
				 ) {
			ss1 = car(ss);
			switch ( get_type(ss1) ) {
			case XLT_ERROR:
				s_close(st);
				return ss1;
			case XLT_RAW:
				if ( xl_save_write(st,ss1) < 0 ) {
					s_close(st);
					goto access_error;
				}
				break;
			default:
				inv_arg = 6;
				goto typemissmatch;
			}
		}
		s_close(st);
		return 0;
	case 1:
		ss = get_el(s,2);
		if ( get_type(ss) == XLT_ERROR ) {
			s_close(st);
			return ss;
		}
		print_sexp(st,ss,ps_flags);
		s_close(st);
		return 0;
	case 2:
		if ( list_length(s) == 3 )
			f = csv_generate_field_list(get_el(s,2));
		else	f = csv_get_field_list(get_el(s,3));
		xl_save_csv_pat1(st,get_el(s,2),f);
		s_close(st);
		free_csv_field_list(f);
		return 0;
	default:
		er_panic("gb_save(1)");
	}
access_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_OPEN_FILE,
		l_string(std_cm,"Save"),
		list(	n_get_string("cannot access the file"),
			get_string(filename),
			0));
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"Save"),
		list(	n_get_string("invalid parameter"),
			0));
typemissmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Save"),
		list(	n_get_string("save:type missmatch"),
			get_integer(inv_arg,0),
			0));
}

