/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"xl.h"
#include	"text_render.h"
#include	"tr_lang.h"
#include	"memory_debug.h"
#include	"ex_utils.h"
#include	"xlerror.h"


XL_SEXP *
ex_ja_line_end_escape_delim(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * delim;
XL_SEXP * ptr;
JA_WORK * jaw;
L_CHAR * opt;
	opt = get_sf_attribute(sf,l_string(std_cm,"option"));
	delim = get_sf_attribute(sf,l_string(std_cm,"data"));
	if ( delim == 0 )
		goto parameter;
	ptr = eval(env,n_get_symbol("___work"));
	if ( ptr == 0 )
		goto internal_error;
	jaw = ptr->ptr.ptr;
	jaw->line_end_escape_delim = ex_option_copy(
		jaw->line_end_escape_delim,
		delim,opt);
	return 0;
parameter:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"line-end-escape-delimiter"),
		0);
internal_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SYSTEM_INTERNAL,
		l_string(std_cm,"line-end-escape-delimiter"),
		n_get_string("perhaps you exec outside of ja env."));
}


XL_SEXP *
ex_ja_line_top_escape_delim(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * delim;
XL_SEXP * ptr;
JA_WORK * jaw;
L_CHAR * opt;
	delim = get_sf_attribute(sf,l_string(std_cm,"data"));
	opt = get_sf_attribute(sf,l_string(std_cm,"option"));
	if ( delim == 0 )
		goto parameter;
	ptr = eval(env,n_get_symbol("___work"));
	if ( ptr == 0 )
		goto internal_error;
	jaw = ptr->ptr.ptr;
	jaw->line_top_escape_delim = ex_option_copy(
			jaw->line_top_escape_delim,
			delim,opt);
	return 0;
parameter:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"line-top-escape-delimiter"),
		0);
internal_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SYSTEM_INTERNAL,
		l_string(std_cm,"line-top-escape-delimiter"),
		n_get_string("perhaps you exec outside of ja env."));
}


XL_SEXP *
ex_ja_writing_dir(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
int dir;
L_CHAR * _dir;
XL_SEXP * ptr;
JA_WORK * jaw;
	_dir = get_sf_attribute(sf,l_string(std_cm,"data"));
	if ( _dir == 0 )
		goto parameter1;
	dir = get_writing_dir(_dir);
	if ( dir < 0 )
		goto parameter2;
	ptr = eval(env,n_get_symbol("___work"));
	if ( ptr == 0 )
		goto internal_error;
	jaw = ptr->ptr.ptr;
	jaw->dir = dir;
	return 0;
parameter1:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"line-top-escape-delimiter"),
		n_get_string("data attribute is required"));
parameter2:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"line-top-escape-delimiter"),
		n_get_string("invalid data format"));
internal_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SYSTEM_INTERNAL,
		l_string(std_cm,"line-top-escape-delimiter"),
		n_get_string("perhaps you exec outside of ja env."));
}


void
init_ex_ja(XLISP_ENV * env)
{
XLISP_ENV * e;
	e = new_env(env);
	e->e.work = &ja_render;
	set_env(e,l_string(std_cm,"writing-direction"),
		get_func_prim(ex_ja_writing_dir,FO_APPLICATIVE,0,1,1));
	set_env(e,l_string(std_cm,"line-top-escape-delimiter"),
		get_func_prim(ex_ja_line_top_escape_delim,FO_APPLICATIVE,0,1,1));
	set_env(e,l_string(std_cm,"line-end-escape-delimiter"),
		get_func_prim(ex_ja_line_end_escape_delim,FO_APPLICATIVE,0,1,1));
	set_env(env,l_string(std_cm,"ja"),
		get_func_prim(ex_body,FO_NORMAL,e,1,-1));
}



