/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"xl.h"
#include	"xlerror.h"

XL_SEXP *
binary(BINARY_TABLE bt[XLT_MAX][XLT_MAX],XLISP_ENV * env,
       XL_SEXP * s1,XL_SEXP * s2,XL_FILE * file,int line)
{
BINARY_TABLE * tp;
int type1,type2;
	type1 = get_type(s1);
	type2 = get_type(s2);
	if ( type1 == XLT_ERROR )
		return s1;
	if ( type2 == XLT_ERROR )
		return s2;
	tp = &bt[type1][type2];
	if ( tp->binary == 0 ) {
		if ( s1 == 0 && s2 == 0 )
			return get_error(
				file,
				line,
				XLE_SEMANTICS_TYPE_MISSMATCH,
				l_string(std_cm,"binary expression(1)"),
				0);
		if ( s1 == 0 )
			return get_error(
				file,
				line,
				XLE_SEMANTICS_TYPE_MISSMATCH,
				l_string(std_cm,"binary expression(2)"),
				0);
		else	return get_error(
				file,
				line,
				XLE_SEMANTICS_TYPE_MISSMATCH,
				l_string(std_cm,"binary expression(3)"),
				0);
	}
	if ( tp->conv1 )
		s1 = (*tp->conv1)(s1);
	if ( tp->conv2 )
		s2 = (*tp->conv2)(s2);
	if ( s1 )
		return inherit((*tp->binary)(env,s1,s2),s1);
	else if ( s2 )
		return inherit((*tp->binary)(env,s1,s2),s2);
	else	return (*tp->binary)(env,s1,s2);
}
