/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"


XL_SEXP *
lt_null(XLISP_ENV * env,XL_SEXP * s1,XL_SEXP * s2)
{
	return get_integer(0,0);
}

XL_SEXP *
lt_diff(XLISP_ENV * env,XL_SEXP * s1,XL_SEXP * s2)
{
int t1,t2;
	t1 = get_type(s1);
	t2 = get_type(s2);
	if ( t1 < t2 )
		return get_integer(1,0);
	else	return get_integer(0,0);
}

XL_SEXP *
lt_sym(XLISP_ENV * env,XL_SEXP * s1,XL_SEXP * s2)
{
	if ( l_strcmp(s1->symbol.data,s2->symbol.data) < 0 )
		return get_integer(1,0);
	else	return get_integer(0,0);
}

XL_SEXP *
lt_pair(XLISP_ENV * env,XL_SEXP * s1,XL_SEXP * s2)
{
extern BINARY_TABLE lt_t[XLT_MAX][XLT_MAX];
extern BINARY_TABLE equ_t[XLT_MAX][XLT_MAX];
XL_SEXP * ret;
	for ( ; ; ) {
		if ( get_type(s1) != XLT_PAIR || 
				get_type(s2) != XLT_PAIR ) {
			return binary(
				lt_t,
				env,
				s1,
				s2,
				0,0);
		}
		ret = binary(
			equ_t,
			env,
			car(s1),
			car(s2),
			0,0);
		switch ( get_type(ret) ) {
		case XLT_ERROR:
			return ret;
		case XLT_INTEGER:
			if ( ret->integer.data == 0 )
				return binary(
					lt_t,
					env,
					car(s1),
					car(s2),
					0,0);
			break;
		default:
			er_panic("leq_pair");
		}
		s1 = cdr(s1);
		s2 = cdr(s2);
	}
}

XL_SEXP *
lt_str(XLISP_ENV * env,XL_SEXP * s1,XL_SEXP * s2)
{
	if ( l_strcmp(s1->string.data,s2->string.data) < 0 )
		return get_integer(1,0);
	else	return get_integer(0,0);
}


XL_SEXP *
lt_int(XLISP_ENV * env,XL_SEXP * s1,XL_SEXP * s2)
{
int i1,i2;
	if ( equ_conv_int(env,&i1,&i2,s1,s2) < 0 )
		return get_error(
			s1->h.file,
			s1->h.line,
			XLE_SEMANTICS_UNIT_MISSMATCH,
			l_string(std_cm,"< or >"),
			0);
	if ( i1 < i2 )
		return get_integer(1,0);
	else	return get_integer(0,0);
}

XL_SEXP *
lt_float(XLISP_ENV * env,XL_SEXP * s1,XL_SEXP * s2)
{
double i1,i2;
	if ( equ_conv_float(env,&i1,&i2,s1,s2) < 0 )
		return get_error(
			s1->h.file,
			s1->h.line,
			XLE_SEMANTICS_UNIT_MISSMATCH,
			l_string(std_cm,"< or >"),
			0);
	if ( i1 < i2 )
		return get_integer(1,0);
	else	return get_integer(0,0);
}

XL_SEXP *
gb_lt(XLISP_ENV * e,XL_SEXP * s)
{
extern BINARY_TABLE lt_t[XLT_MAX][XLT_MAX];
	return binary(
		lt_t,
		e,
		get_el(s,1),
		get_el(s,2),
		s->h.file,s->h.line);
}
