/**********************************************************************
 
	Copyright (C) 2007 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"xlerror.h"
#include	"authentification.h"

AUTH_SERVICE *
new_auth_service_localhost_root(AUTH_SERVICE* service)
{
AUTH_SERVICE * ret;
	ret = new_auth_service_header(service,at_tbl(AT_FIX_USER_PASSWD));
	ret->lr.keyfile = 0;
	return ret;
}

void
free_auth_service_localhost_root(AUTH_SERVICE * s)
{
AUTH_LOCALHOST_ROOT_KEYFILE * k;
	free_auth_service_header(s);
	for ( ; s->lr.keyfile ; ) {
		k = s->lr.keyfile;
		s->lr.keyfile = k->next;
		d_f_ree(k);
	}
	d_f_ree(s);
}


AUTH_SERVICE *
parse_info_localhost_root(AUTH_SERVICE* sv,XL_SEXP* s,XL_SYM_FIELD* sf)
{
AUTH_SERVICE * ret;
	ret = new_auth_service_header(sv,at_tbl(AT_FIX_USER_PASSWD));
	ret->lr.keyfile = 0;
	return ret;
}


void
server_send_sexp_localhost_root(AUTH_SERVICE*sv,XL_SEXP *sym)
{
char buf[30];
	if ( sv->lr.keyfile == 0 )
		return;
	sprintf(buf,"%u",sv->lr.keyfile->filename);
	set_attribute(sym,l_string(std_cm,"filename"),l_string(std_cm,buf));
}

void
client_recv_sexp_localhost_root(AUTH_SERVICE*sv,XL_SEXP *sym)
{
L_CHAR * key;
AUTH_LOCALHOST_ROOT_KEYFILE * k;
	k = d_alloc(sizeof(*k));
	memset(k,0,sizeof(*k));
	key = get_sf_attribute(sym->symbol.field,l_string(std_cm,"filename"));
	if ( key )
		sscanf(n_string(std_cm,key),"%u",&k->filename);
	key = get_sf_attribute(sym->symbol.field,l_string(std_cm,"key"));
	if ( key )
		sscanf(n_string(std_cm,key),"%u",&k->key);
	k->next = sv->lr.keyfile;
	sv->lr.keyfile = k;
}


AUTH_LOCALHOST_ROOT_KEYFILE *
create_localhost_root_keyfile()
{
char * pf;
AUTH_LOCALHOST_ROOT_KEYFILE * ret;
int fd;
int len;
char * filename;
	pf = get_tmp_dir();
	if ( pf == 0 )
		return 0;
	len = strlen(pf);
	filename = d_alloc(len+200);
	
	ret = d_alloc(sizeof(*ret));
	ret->key = rand()+ (((unsigned int)rand())<<16);
	for ( ; ; ) {
		ret->filename = rand()+ (((unsigned int)rand())<<16);
		sprintf(filename,"%s/%u",pf,ret->filename);
		fd = u_open(filename,O_CREAT|O_RDWR|O_EXCL,0600);
		if ( fd >= 0 )
			break;
	}
	u_write(fd,&ret->key,sizeof(ret->key));
	u_close(fd);
	d_f_ree(filename);
	return ret;
}

int 
get_localhost_root_keyfile(AUTH_RESULT * lr)
{
char * pf;
int fd;
int len;
char * buffer;
	pf = get_tmp_dir();
	if ( pf == 0 )
		return 0;
	len = strlen(pf);
	buffer = d_alloc(len+100);
	sprintf(buffer,"%s/%u",pf,lr->lr.filename);
	fd = u_open(buffer,O_RDONLY,0600);
	if ( fd < 0 )
		return -1;
	u_read(fd,&lr->lr.key,sizeof(lr->lr.key));
	u_close(fd);
	d_f_ree(buffer);
	return 0;
}

void
clear_keyfile(AUTH_LOCALHOST_ROOT_KEYFILE * k)
{
char * pf;
int len;
char * buffer;
	pf = get_tmp_dir();
	if ( pf == 0 )
		return;
	len = strlen(pf);
	buffer = d_alloc(len+100);
	sprintf(buffer,"%s/%u",pf,k->filename);
	u_unlink(buffer);
	d_f_ree(buffer);
}

AUTH_RESULT *
authentification_localhost_root(AUTH_CONNECTION_SET * set,AUTH_SERVICE * s,int type)
{
AUTH_RESULT * r;
AUTH_LOCALHOST_ROOT_KEYFILE * k,**kp;

	if ( type == 0 ) {
		k = create_localhost_root_keyfile();
		if ( k == 0 ) {
			r = new_auth_result_localhost_root(s,0,0);
			r->h.status = ARS_DENY;
			return r;
		}
		k->auth_gc_no = set->server_set->auth_gc_no;
		k->next = s->lr.keyfile;
		s->lr.keyfile = k;
		return 0;
	}
	for ( r = set->server_result ; r ; r = r->h.next ) {
		if ( r->h.service != s )
			continue;
		if ( r->h.status != ARS_NONE )
			return 0;
		r->h.status = ARS_DENY;
		for ( kp = &s->lr.keyfile ; *kp ; kp = &(*kp)->next ) {
			k = *kp;
			if ( r->lr.filename != k->filename )
				continue;
			if ( r->lr.key == k->key )
				r->h.status = ARS_ACCEPT;
			*kp = k->next;
			clear_keyfile(k);
			d_f_ree(k);
			break;
		}
		return 0;
	}
	return 0;
}

AUTH_RESULT * 
new_auth_result_localhost_root(AUTH_SERVICE * s,AUTH_RESULT * r,int service_copy_flag)
{
AUTH_RESULT * ret;
	ret = d_alloc(sizeof(*ret));
	memset(ret,0,sizeof(*ret));
	if ( service_copy_flag )
		ret->h.service = (*s->h.tbl->new_auth_service)(s);
	else	ret->h.service = s;
	ret->h.status = ARS_NONE;
	if ( r ) {
		*ret = *r;
		if ( s )
			ret->h.service = s;
	}
	return ret;
}

void 
free_auth_result_localhost_root(AUTH_RESULT * res,int service_flag)
{
	if ( service_flag )
		(*res->h.service->h.tbl->free_auth_service)(res->h.service);
	d_f_ree(res);
}

XL_SEXP * 
send_result_info_localhost_root(AUTH_RESULT * r)
{
XL_SEXP * ret, * sym;
char buf[20];
	ret = get_result_header_sexp(r);
	sym = car(ret);

	sprintf(buf,"%u",r->lr.filename);
	set_attribute(sym,l_string(std_cm,"filename"),l_string(std_cm,buf));
	sprintf(buf,"%u",r->lr.key);
	set_attribute(sym,l_string(std_cm,"key"),l_string(std_cm,buf));
	return ret;
}

AUTH_RESULT * 
recv_result_info_localhost_root(AUTH_SET_SERVER * set,XL_SEXP * s)
{
AUTH_SERVICE * sv;
XL_SEXP * sym;
AUTH_RESULT lr;
L_CHAR * key;
	sym = car(s);
	sv = get_service_header(set,s);
	if ( sv == 0 )
		return 0;
	memset(&lr,0,sizeof(lr));
	key = get_sf_attribute(sym->symbol.field,l_string(std_cm,"filename"));
	if ( key )
		sscanf(n_string(std_cm,key),"%u",&lr.lr.filename);
	key = get_sf_attribute(sym->symbol.field,l_string(std_cm,"key"));
	if ( key )
		sscanf(n_string(std_cm,key),"%u",&lr.lr.key);
	return new_auth_result_localhost_root(sv,&lr,0);
}

void
set_authentification_result_localhost_root(AUTH_RESULT * res,XL_SEXP *sv)
{
XL_SEXP * sym;
L_CHAR * key;
	sym = car(sv);
	key = get_sf_attribute(sym->symbol.field,l_string(std_cm,"filename"));
	if ( key )
		sscanf(n_string(std_cm,key),"%u",&res->lr.filename);
	key = get_sf_attribute(sym->symbol.field,l_string(std_cm,"key"));
	if ( key )
		sscanf(n_string(std_cm,key),"%u",&res->lr.key);
}

void
client_transaction_localhost_root(AUTH_SERVICE* sv,AUTH_RESULT* res)
{

	if ( sv->lr.keyfile == 0 ) {
		res->h.status = ARS_DENY;
		return;
	}
	res->lr.filename = sv->lr.keyfile->filename;
	if ( get_localhost_root_keyfile(res) < 0 )
		res->h.status = ARS_DENY;
	else if ( res->h.status == ARS_REQUIRED )
			res->h.status = ARS_SEND_PERMIT;
}

char ** 
get_result_members_localhost_root(AUTH_RESULT * res)
{
static char * members[] = {"filename","key",0};
	return members;
}

void
gc_service_localhost_root(AUTH_CONNECTION_SET * set,AUTH_SERVICE * sv,int gc_no)
{
AUTH_LOCALHOST_ROOT_KEYFILE * k,**kp;
	for ( kp = &sv->lr.keyfile ; *kp ; ) {
		k = *kp;
		if ( k->auth_gc_no != gc_no ) {
			kp = &(*kp)->next;
			continue;
		}
		*kp = k->next;
		clear_keyfile(k);
		d_f_ree(k);
	}
}







