/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#define STREAM_LIB
//#define LIBRARY
//#define S_FILE_LIBRARY

#include	"memory_debug.h"
#include	"lock_level.h"
#include	"pri_level.h"
#include	"task.h"
#include	"stream.h"
#include	"s_buf.h"
#include	"xl.h"
#include	"XLoHTTP.h"
#include	"xlerror.h"
#include	"client.h"

#define WRITE_ABORT_INTERVAL	240

typedef struct eu_list {
	struct eu_list *	next;
	int			ret;
	STREAM *		st;
	HTTP_INFO *		info;
	XL_INTERPRETER *	xli;
} EU_LIST;

SEM ha_lock;
HTTP_AGENT_LIST * ha_root;
EU_LIST * eu_list_root;

HTTP_ERR he200 = {200,"OK"};
HTTP_ERR he404 = {404,"Not Found"};
HTTP_ERR he500 = {500,"Internal Server Error"};
HTTP_ERR he503 = {503,"Service Unavailable"};

int leftcmp(char* a,char*b);

void exec_url_task();
void tick_http_agent();
int lock_ha_access(HTTP_AGENT_LIST * a,int ret_flag);
void unlock_ha_access(HTTP_AGENT_LIST * a);
int output_server_header_by_info(STREAM * s,HTTP_INFO * info);
void output_error_print(STREAM * s,HTTP_ERR * e,char * msg,XL_SEXP * s_msg);
void _initialize_remote(HTTP_AGENT_LIST * a);
void return_code(STREAM * st,HTTP_INFO * of,XL_SEXP * snd);
int _exec_url(HTTP_INFO * info,STREAM * st,XL_INTERPRETER * xli);
EU_LIST *  _delete_eu_list();
EU_LIST * delete_eu_list();
void _insert_eu_list(EU_LIST * inp);
void insert_eu_list(EU_LIST * inp);



void
init_http_agent()
{


	ha_lock = new_lock(LL_HTTP_AGENT);
//	create_task(exec_url_task,PRI_USER_INTERFACE,0);
	new_tick((void(*)(int))tick_http_agent,10,10);
}

void
gc_http_agent()
{
HTTP_AGENT_LIST * al;
	for ( al = ha_root ; al ; al = al->next ) {
		gc_gblisp_env(al->env);
		gc_gb_sexp(al->initialize);
	}
}


int
leftcmp(char* a,char*b)
{
int len;
	len = strlen(b);
	return memcmp(a,b,len);
}


HTTP_AGENT_LIST *
insert_http_agent_list(
	char * path,
	int type,
	XLISP_ENV * env,
	L_CHAR* remote_url,
	HTTP_AGENT_LIST * alias,
	XL_SEXP * initialize,
	int timeout)
{
HTTP_AGENT_LIST * ret;
	lock_task(ha_lock);
	ret = d_alloc(sizeof(*ret));
	memset(ret,0,sizeof(*ret));
	ret->access_tid = 0;
	ret->type = type;
	ret->path = copy_str(path);
	ret->env = env;
	ret->next = ha_root;
	ret->timeout = timeout;
	if ( alias ) {
		for ( ; alias->alias_list_next ; alias = alias->alias_list_next );
		ret->alias_root = alias;
		ret->alias_list_next = alias->alias_list;
		alias->alias_list = ret;
		ret->iid = -1;
	}
	else {
		if ( remote_url ) {
			ret->remote_url = ll_copy_str(remote_url);
			ret->iid = -1;
		}
		else {
			ret->remote_url = 0;
			ret->iid = 0;
		}
	}
	ret->initialize = initialize;

	ha_root = ret;
	unlock_task(ha_lock,"insert_http_agent_list");
	return ret;
}

HTTP_AGENT_LIST * 
search_http_agent_list(char *path)
{
HTTP_AGENT_LIST * ret;
int len;
	lock_task(ha_lock);
	ret = 0;
	for ( ret = ha_root ; ret ; ret = ret->next ) {
		if ( strcmp(ret->path,path) == 0 )
			break;
		len = strlen(ret->path);
		if ( memcmp(ret->path,path,len) )
			continue;
		if ( path[len] == '?' )
			break;
		if ( ret->path[len-1] == '/' && ret->type == HAT_PROXY )
			break;
	}
	unlock_task(ha_lock,"insert_http_agent_list");
	return ret;
}

int
lock_ha_access(HTTP_AGENT_LIST * a,int ret_flag)
{
int ret;
	lock_task(ha_lock);
	if ( a->alias_root )
		a = a->alias_root;
	ret = 0;
	if ( a->access_tid && ret_flag ) {
		ret = -1;
		goto end;
	}
	for ( ; a->access_tid ; ) {
		sleep_task((int)a,ha_lock);
		lock_task(ha_lock);
	}
	a->access_tid = get_tid();
end:
	unlock_task(ha_lock,"lock_ha_access");
	return ret;
}

void
unlock_ha_access(HTTP_AGENT_LIST * a)
{
	lock_task(ha_lock);
	if ( a->alias_root )
		a = a->alias_root;
	a->access_tid = 0;
	wakeup_task((int)a);
	unlock_task(ha_lock,"lock_ha_access");
}

int
output_server_header_by_info(STREAM * s,HTTP_INFO * info)
{
	if ( info->err2.code )
		s_printf(s,"HTTP/1.1 %i %s\r\n",
			info->err2.code,info->err2.msg);
	else	s_printf(s,"HTTP/1.1 %i OK\r\n",info->err);
	s_printf(s,"Date: Fri, 20 Sep 2002 09:36:44 GMT\r\n");
	s_printf(s,"Server: LANDSCAPE GLOBALBASE SERVER\r\n");
	if ( info->flags & XoHINF_F_KEEP_ALIVE )
		s_printf(s,"Connection: keep-alive\r\n");
	else	s_printf(s,"Connection: close\r\n");
	if ( info->content_type )
		s_printf(s,"Content-Type: %s\r\n",info->content_type);
	else	s_printf(s,"Content-Type: text/html\r\n");
	if ( info->content_length >= 0 )
		s_printf(s,"Content-Length: %i\r\n",info->content_length);
	if ( info->flags & XoHINF_F_CACHE_OFF ) {
		s_printf(s,"Expires: -1\r\n");
		s_printf(s,"Cache-Control: no-cache\r\n");
		s_printf(s,"Pragma: no-cache\r\n");
	}
	s_printf(s,"\r\n");
	return 0;
}


void
output_error_print(STREAM * s,HTTP_ERR * e,char * msg,XL_SEXP * s_msg)
{
	s_printf(s,"<HTML>\n\r");
	s_printf(s,"<HEAD>\n\r");
	s_printf(s,"<TITLE>LANDSCAPE HTTP AGENT ERROR</TITLE>\n\r");
	s_printf(s,"</HEAD>\n\r");
	s_printf(s,"<BODY>\n\r");
	s_printf(s,"<HR>\n\r");
	s_printf(s,"HTTP Status: %i %s\n\r",e->code,e->msg);
	s_printf(s,"<HR>\n\r");
	s_printf(s,"Message: %s<BR>\n\r",msg);
	s_printf(s,"XL Code:");
	print_sexp(s,s_msg,0);
	s_printf(s,"\n\r<BR>\n\r");
	s_printf(s,"<HR>\n\r");
	s_printf(s,"</BODY>\n\r");
	s_printf(s,"</HTML>\n\r");
}

void
_invalid_all(HTTP_AGENT_LIST * a)
{
HTTP_AGENT_LIST * a_target;
	if ( a->alias_root )
		a_target = a->alias_root;
	else	a_target = a;
	a_target->iid = -1;
	for ( a = a_target->alias_list ; a ; a = a->alias_list_next )
		a->iid = -1;
}

void
invalid_all(HTTP_AGENT_LIST * a)
{
	lock_ha_access(a,0);
	_invalid_all(a);
	unlock_ha_access(a);
}

void
__initialize_remote(HTTP_AGENT_LIST * aa)
{
XL_INTERPRETER * xli;
URL u;
XL_SEXP * ret;
XL_SEXP * ptr;
HTTP_AGENT_LIST * a_target;


	if ( aa->alias_root )
		a_target = aa->alias_root;
	else	a_target = aa;

	if ( aa->type == HAT_PROXY )
		return;
	if ( a_target->type == HAT_PROXY )
		return;
	if( aa->iid > 0 ) {
		return;
	}
	if ( a_target->iid > 0 )
		goto next;

	get_url2(&u,a_target->remote_url);

	xli = new_xl_interpreter();
	xli->a_type = XLA_CONNECT;
	xli->env = a_target->env;
	xli->port = u.port;
	xli->environment = 1;
	xli->hostname = ll_copy_str(u.server);
	xli->connection_timeout = -1;

	free_url(&u);

	a_target->iid = setup_i(xli);


	if ( a_target->iid < 0 )
		return;
	ret = remote_query(
			a_target->iid,a_target->env,0,
			List(n_get_symbol("SetAgent"),
				get_string(u.agent),
				n_get_string("user"),
				-1));
	if ( get_type(ret) == XLT_ERROR ) {
		close_interpreter(a_target->iid);
		ss_printf("INIT ERR");
		print_sexp(s_stdout,ret,0);
		ss_printf("\n");
		_invalid_all(a_target);
		return;
	}
next:

	ret = remote_query(
		a_target->iid,aa->env,0,
		List(n_get_symbol("Define"),
			n_get_symbol("HttpAgent_path"),
			n_get_string(aa->path),
			-1));
	if ( get_type(ret) == XLT_ERROR ) {
		aa->iid = -1;
		ss_printf("REMOTE ERR ");
		print_sexp(s_stdout,ret,0);
		ss_printf("\n");
		return;
	}
	for ( ptr = aa->initialize ; get_type(ptr) == XLT_PAIR ;
			ptr = cdr(ptr) ) {
		ret = remote_query(
			a_target->iid,aa->env,0,car(ptr));
		if ( get_type(ret) == XLT_ERROR ){
			aa->iid = -1;
			ss_printf("REMOTE ERR ");
			print_sexp(s_stdout,ret,0);
			ss_printf("\n");
			return;
		}
	}
	if ( aa->alias_root == 0 ) {
		aa->iid = a_target->iid;
	}
}

void
_initialize_remote(HTTP_AGENT_LIST * a)
{
HTTP_AGENT_LIST * org;
	if ( a->alias_root )
		org = a->alias_root;
	else	org = a;
	if ( org->iid < 0 ) {
		__initialize_remote(org);
		if ( org->iid < 0 )
			return;
	}
	for ( a = org->alias_list ; a ; a = a->alias_list_next )
		_initialize_remote(a);
}

void
initialize_remote(HTTP_AGENT_LIST * a)
{
	lock_ha_access(a,0);
	_initialize_remote(a);
	unlock_ha_access(a);
}

void
return_code(STREAM * st,HTTP_INFO * of,XL_SEXP * snd)
{
XL_SEXP * sym;
XL_SEXP * data;
char * ctype;
char * err_msg;
int ret_len;
L_CHAR * cc;
	sym = car(snd);
	data = 0;
	if ( get_type(sym) != XLT_SYMBOL ) {
		err_msg = "symbol required";
		goto sys_err;
	}
	ctype = n_string(std_cm,sym->symbol.data);
	memset(of,0,sizeof(*of));
	cc = get_sf_attribute(sym->symbol.field,
			l_string(std_cm,"Cache-Control"));
	if ( cc == 0 ) {
		of->flags |= 0;
	}
	else if ( l_strcmp(cc,l_string(std_cm,"private")) == 0 ) {
		of->flags |= XoHINF_F_CACHE_OFF;
	}
	else {
		of->flags |= 0;
	}
	of->content_type = ctype;
	of->content_length = -1;
	of->err2 = he200;
	if ( strcmp(ctype,"text/html") == 0 ) {
		data = get_el(snd,1);
		if ( get_type(data) == XLT_STRING ) {
			output_server_header_by_info(st,of);
			s_printf(st,"%ls",data->string.data);
		}
		else {
			output_server_header_by_info(st,of);
			print_sexp(st,data,
				PF_MULTI_ROOT|PF_HTML|PF_INDENT);
		}
	}
	else if ( strcmp(ctype,"text/xml") == 0 ) {
		data = get_el(snd,1);
		if ( get_type(data) == XLT_STRING ) {
			output_server_header_by_info(st,of);
			s_printf(st,"%ls",data->string.data);
		}
		else {
		XL_SEXP * xml,* xml_sym;
		L_CHAR * encode;
		CODE_METHOD * cm;
			output_server_header_by_info(st,of);
			xml = car(data);
			if ( get_type(xml) != XLT_PAIR )
				goto prt;
			xml_sym = car(xml);
			if ( get_type(xml_sym) != XLT_SYMBOL )
				goto prt;
			encode = get_sf_attribute(xml_sym->symbol.field,l_string(std_cm,"encoding"));
			if ( encode == 0 ) {
				cm = s_get_cm(st);
				if ( cm == 0 )
					goto prt;
				set_attribute(xml_sym,
					l_string(std_cm,"encoding"),
					l_string(std_cm,cm->name));
			}
			else {
				cm = search_cm(n_string(std_cm,encode));
				if ( cm == 0 )
					goto prt;
				s_set_cm(st,cm);
			}
		prt:
			print_sexp(st,data,
				PF_MULTI_ROOT|PF_XML|PF_INDENT);
		}
	}
	else if ( strcmp(ctype,"image/jpeg") == 0 ) {
		data = get_el(snd,1);
		if ( get_type(data) != XLT_RAW ) {
			err_msg = "XLT_RAW is required";
			goto sys_err;
		}
		output_server_header_by_info(st,of);
		en_do(&ret_len,s_write,st,data->raw.data,data->raw.size);
	}
	else if ( strcmp(ctype,"image/gif") == 0 ) {
		data = get_el(snd,1);
		if ( get_type(data) != XLT_RAW ) {
			err_msg = "XLT_RAW is required";
			goto sys_err;
		}
		output_server_header_by_info(st,of);
		en_do(&ret_len,s_write,st,data->raw.data,data->raw.size);
	}
	s_close(st);
	return;
sys_err:
	of->err2 = he500;
	output_server_header_by_info(st,of);
	output_error_print(st,&of->err2,err_msg,data);
	s_close(st);
}


char *
convert_percent_reverse(char * inp)
{
char * ret;
int len;
char * p,*q;
char ch1,ch2;

	len = strlen(inp);
	ret = d_alloc(len*5 + 1);
	p = inp;
	q = ret;
	for ( ; *p ; p ++ ) {
		if ( '0' <= *p && *p <= '9' )
			*q ++ = *p;
		else if ( 'a' <= *p && *p <= 'z' )
			*q ++ = *p;
		else if ( 'A' <= *p && *p <= 'Z' )
			*q ++ = *p;
		else {
			*q ++ = '%';
			ch1 = ((*p)>>4)&0xf;
			ch2 = (*p) & 0xf;
			if ( ch1 < 10 )
				*q ++ = ch1 + '0';
			else	*q ++ = ch1 - 10 + 'A';
			if ( ch2 < 10 )
				*q ++ = ch2 + '0';
			else	*q ++ = ch2 - 10 + 'A';
		}
	}
	*q = 0;
	return ret;
}


char *
convert_percent(char * inp,char * limited_list)
{
char * ret;
char * p,* q;
L_CHAR ch,_ch;
int cnt;
char * r;
char * pp;
int uf;
int lim;
void * w;
unsigned char utf_buf[8];
int len;
	w = (*utf8_cm.open)();
	ret = d_alloc(strlen(inp)+1);
	q = ret;
	p = inp;
	for ( ; ; ) {
		switch ( *p ) {
		case 0:
			*q = 0;
			break;
		case '%':
			pp = p;
			p ++;
			ch = 0;
			cnt = 0;
			if ( *p == 'u' ) {
				uf = 1;
				p ++;
				lim = 4;
			}
			else {
				uf = 0;
				lim = 2;
			}
			for ( ; cnt < lim ; p ++ , cnt ++ ) {
				if ( *p == 0 )
					break;
				if ( '0' <= *p && *p <= '9' )
					_ch = *p - '0';
				else if ( 'a' <= *p && *p <= 'f' )
					_ch = *p - 'a' + 10;
				else if ( 'A' <= *p && *p <= 'F' )
					_ch = *p - 'A' + 10;
				else break;
				ch = (ch << 4) + _ch;
			}
			if ( limited_list ) {
				for ( r = limited_list ; *r && *r != ch ; r ++ );
				if ( *r == 0 ) {
					for ( ; pp != p ; )
						*q++ = *pp++;
				}
				else {
					goto conv;
				}
			}
			else {
			conv:
				if ( uf == 0 ) {
					*q++ = ch;
					if ( ch == 0 )
						break;
					if ( *p == 0 ) {
						*q = 0;
						break;
					}
				}
				else {
					len = (*utf8_cm.to_external)(utf_buf,w,ch);
					for ( cnt = 0 ; cnt < len ; cnt ++ )
						*q++ = utf_buf[cnt];
					if ( ch == 0 )
						break;
					if ( *p == 0 ) {
						*q = 0;
						break;
					}
				}
			}
			continue;
		default:
			*q++ = *p++;
			continue;
		}
		break;
	}
	(*utf8_cm.close)(0,w);
	return ret;
}


typedef struct do_proxy_close_t {
	STREAM * st;
	STREAM * con;
} DO_PROXY_CLOSE_T;
void
do_proxy_close(int data)
{
DO_PROXY_CLOSE_T * t;
	t = (DO_PROXY_CLOSE_T*)data;
ss_printf("do_proxy_close\n");
	s_close(t->st);
	s_close(t->con);
}

int
do_proxy(HTTP_AGENT_LIST * aa,HTTP_INFO * info,STREAM * st)
{
HTTP_INFO o_info;
STREAM * con;
int err;
URL remote;
char * buffer;
DO_PROXY_CLOSE_T t;
int er;
char * str,*target;
char * ptr;
int size;

	if ( strcmp(info->method,"GET") ) {
		memset(&o_info,0,sizeof(o_info));
		o_info.content_length = -1;
		o_info.err2 = he503;
		output_server_header_by_info(st,&o_info);
		s_close(st);
		return 0;
	}
	get_url2(&remote,aa->remote_url);
	if ( remote.server == 0 ) {
		memset(&o_info,0,sizeof(o_info));
		o_info.content_length = -1;
		o_info.err2 = he503;
		output_server_header_by_info(st,&o_info);
		s_close(st);
		free_url(&remote);
		return 0;
	}
	if ( remote.port == 0 )
		remote.port = 80;
	str = copy_str(&info->dir[strlen(aa->path)]);
	target = d_alloc(strlen(str)+strlen(n_string(std_cm,aa->remote_url))+3);
	strcpy(target,n_string(std_cm,aa->remote_url));
	strcpy(&target[strlen(n_string(std_cm,aa->remote_url))],str);
	d_f_ree(str);
	
	con = new_connection(&err,
		n_string(std_cm,remote.server),
		0,
		remote.port,
		0,0);
	if ( con == 0 ) {
		memset(&o_info,0,sizeof(o_info));
		o_info.content_length = -1;
		o_info.err2 = he503;
		output_server_header_by_info(st,&o_info);
		s_close(st);
		free_url(&remote);
		d_f_ree(target);
		return 0;
	}
	s_printf(con,"%s %s HTTP/1.0\r\n",
		info->method,target);
	if ( info->content_type )
		s_printf(con,"Content-Type: %s\r\n",info->content_type);
	s_printf(con,"Host: %s:%i\r\n",remote.server,remote.port);
	s_printf(con,"\r\n");
	buffer = d_alloc(1000);
	t.st = st;
	t.con = con;
//ss_printf("LOAD %x %x %i\n",t.st,t.con,con->file.fid);
	s_set_write_abort(st,WAT_CLOSE,WRITE_ABORT_INTERVAL);
	for ( ; ; ) {
		new_tick(do_proxy_close,-WRITE_ABORT_INTERVAL,(int)&t);
		er = s_read(con,buffer,1000);
		if ( er <= 0 ) {
ss_printf("CON END er=%i\n",er);
			del_tick_with_data(do_proxy_close,(int)&t);
			break;
		}
		del_tick_with_data(do_proxy_close,(int)&t);
		size = er;
		ptr = buffer;
		for ( ; size ; ) {
			er = s_write(st,ptr,size);
			if ( er < 0 )
				break;
			if ( er == 0 ) {
ss_printf("WRITE ER=0\n");
				sleep_sec(1);
			}
			size -= er;
			ptr += er;
		}
		if ( er < 0 )
{
ss_printf("ST END er=%i\n",er);
			break;
}
	}
ss_printf("END\n");
	s_close(st);
	s_close(con);
	free_url(&remote);
	d_f_ree(target);

	return 0;
}

int
_exec_url(HTTP_INFO * info,STREAM * st,XL_INTERPRETER * xli)
{
HTTP_AGENT_LIST * aa,* a_target;
XL_SEXP * sym;
char buf[10];
XL_SEXP * ret;
HTTP_INFO o_info;
char * _dir;
XL_SEXP * cmd = 0;
	if ( info->dir == 0 )
		return -1;
 	_dir = copy_str(info->dir);
ss_printf("DIR(%s) = %s\n",info->method,_dir);
	if ( strcmp(_dir,"/cgi-bin/download.cgi") == 0 ) {
		d_f_ree(_dir);
		return 2;
	}
	if ( strcmp(_dir,"/cgi-bin/upload.cgi") == 0 ) {
		d_f_ree(_dir);
		return 2;
	}
	if ( leftcmp(_dir,"/cgi-bin/xlsv") == 0 ) {
		d_f_ree(_dir);
		return 2;
	}
	aa = search_http_agent_list(_dir);
	if ( aa == 0 ) {
		memset(&o_info,0,sizeof(o_info));
		o_info.err2 = he404;
		output_server_header_by_info(st,&o_info);
		output_error_print(st,&o_info.err2,info->dir,0);
		s_close(st);
		d_f_ree(_dir);
		return 0;
	}
	if ( aa->alias_root )
		a_target = aa->alias_root;
	else	a_target = aa;

	if ( a_target->type == HAT_PROXY || aa->type == HAT_PROXY ) {
		return do_proxy(a_target,info,st);
	}

	sym = n_get_symbol(info->method);
	sprintf(buf,"%i",info->http_ver);
	set_attribute(sym,
		l_string(std_cm,"http_ver"),
		l_string(std_cm,buf));
	sprintf(buf,"%i",info->http_rev);
	set_attribute(sym,
		l_string(std_cm,"http_rev"),
		l_string(std_cm,buf));
	set_attribute(sym,
		l_string(std_cm,"dir"),
		l_string(std_cm,_dir));
	if ( info->content_type ) {
		set_attribute(sym,
			l_string(std_cm,"Content-Type"),
			l_string(std_cm,info->content_type));
	}
	else {
		set_attribute(sym,
			l_string(std_cm,"Content-Type"),
			l_string(std_cm,""));
	}
	sprintf(buf,"%i",info->content_length);
	set_attribute(sym,
		l_string(std_cm,"Content-Length"),
		l_string(std_cm,buf));
	if ( info->charset ) {
		set_attribute(sym,
			l_string(std_cm,"Accept-Charset"),
			l_string(std_cm,info->charset));
	}
	else {
		set_attribute(sym,
			l_string(std_cm,"Accept-Charset"),
			l_string(std_cm,""));
	}
	if ( info->content_length > 0 ) {
	char * buf;
	char * ptr;
	int size;
	int er;
		buf = d_alloc(info->content_length);
		size = info->content_length;
		ptr = buf;
		for ( ; size ; ) {
			er = s_read(st,ptr,size);
			if ( er <= 0 )
				break;
			size -= er;
			ptr += er;
		}
		cmd = List(sym,get_raw(buf,info->content_length - size),
			   -1);
		d_f_ree(buf);
	}
	else {
		cmd = List(sym,-1);
	}
	if ( aa->iid ) {
	int retry_cnt;
		if ( aa->iid < 0 || a_target->iid < 0 )
			goto init;
		retry_cnt = 2;
	retry:
		ret = remote_query(
			a_target->iid,aa->env,0,List(n_get_symbol("HTTP"),
						List(n_get_symbol("Define"),
							n_get_symbol("HttpAgent_path"),
							n_get_string(aa->path),
							-1),
						cmd,
						-1));
		if ( get_type(ret) == XLT_ERROR ) {
			if ( ret->err.code == XLE_PROTO_INV_IID ) {
				invalid_all(aa);
				if ( retry_cnt > 0 ) {
				init:
					initialize_remote(aa);
					initialize_remote(a_target);
					retry_cnt --;
					goto retry;
				}
			}
		}
	}
	else {
		ret = eval(aa->env,cmd);
	}
	switch ( get_type(ret) ) {
	case XLT_ERROR:
		memset(&o_info,0,sizeof(o_info));
		o_info.content_length = -1;
		o_info.err2 = he503;
		output_server_header_by_info(st,&o_info);
		output_error_print(st,&o_info.err2,info->dir,ret);
		s_close(st);
		d_f_ree(_dir);
		return 0;
	case XLT_PAIR:
		return_code(st,&o_info,ret);
		d_f_ree(_dir);
		return 0;
	default:
		memset(&o_info,0,sizeof(o_info));
		o_info.content_length = -1;
		o_info.err2 = he500;
		output_server_header_by_info(st,&o_info);
		output_error_print(st,&o_info.err2,info->dir,ret);
		s_close(st);
		d_f_ree(_dir);
		return 0;
	}
	d_f_ree(_dir);
	return 0;
}

EU_LIST * 
_delete_eu_list()
{
EU_LIST * ret;
	for ( ; eu_list_root == 0 ; ) {
		sleep_task((int)&eu_list_root,ha_lock);
		lock_task(ha_lock);
	}
	ret = eu_list_root;
	eu_list_root = ret->next;
	return ret;
}

EU_LIST *
delete_eu_list()
{
EU_LIST * ret;
	lock_task(ha_lock);
	ret = _delete_eu_list();
	unlock_task(ha_lock,"delete_eu_list");
	return ret;
}

void
_insert_eu_list(EU_LIST * inp)
{
	inp->ret = 0xffff;
	inp->next = eu_list_root;
	eu_list_root = inp;
	wakeup_task((int)&eu_list_root);
	for ( ; inp->ret == 0xffff; ) {
		sleep_task((int)inp,ha_lock);
		lock_task(ha_lock);
	}
}

void
insert_eu_list(EU_LIST * inp)
{
	lock_task(ha_lock);
	_insert_eu_list(inp);
	unlock_task(ha_lock,"delete_eu_list");
}

void
exec_url_task()
{
XL_INTERPRETER*xli;
EU_LIST * eu;
	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);

	for ( ; ; ) {
		eu = delete_eu_list();
		gc_push(0,0,"exec_url");
		eu->ret = _exec_url(eu->info,eu->st,eu->xli);
		gc_pop(0,0);
		wakeup_task((int)eu);
	}

	close_self_interpreter();

}


int
exec_url(HTTP_INFO * info,STREAM * st,XL_INTERPRETER * from_xli)
{
//EU_LIST eu;
int ret;
XL_INTERPRETER * xli;

	if ( get_my_xli() == 0 ) {
		xli = new_xl_interpreter();
		xli->a_type = XLA_SELF;
		setup_i(xli);
	}

	gc_push(0,0,"exec_url");
	ret = _exec_url(info,st,from_xli);
	gc_pop(0,0);

/*
	eu.info = info;
	eu.st = st;
	eu.ret = 0xffff;
	insert_eu_list(&eu);
	return eu.ret;
*/
	return ret;
}


void
tick_http_agent()
{
HTTP_AGENT_LIST * al;

XL_INTERPRETER * xli;
	if ( get_my_xli() == 0 ) {
		xli = new_xl_interpreter();
		xli->a_type = XLA_SELF;
		setup_i(xli);
	}

	for ( al = ha_root ; al ; al = al->next ) {
		if ( lock_ha_access(al,1) < 0 )
			continue;
		if ( al->remote_url == 0 )
			continue;
		if ( al->iid < 0 )
			_initialize_remote(al);
		else if ( check_iid(al->iid) == 0 ) {
			_invalid_all(al);
			_initialize_remote(al);
		}
		unlock_ha_access(al);
	}
}
