/**********************************************************************
 
	Copyright (C) 2006-2008 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"progressive.h"
#include	"memory_debug.h"
#include	"utils.h"
#include	"task.h"
#include	"lock_level.h"
#include	"xlerror.h"
#include	"memory_debug.h"
#include	"pri_level.h"

PROGRESSIVE * progressive_list;
SEM progressive_lock;
int progressive_id;
UPLINK_INFO * uplink_info_list;
int progressive_task_flag;

void
_delete_progressive(PROGRESSIVE * inp,int dont_remove_check);
XL_SEXP *
xl_Progressive(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
XL_SEXP *
xl_Stage(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
XL_SEXP *
xl_CloseProgressive(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);

void
progressive_task();

void
init_progressive(XLISP_ENV * env)
{
	progressive_lock = new_lock(LL_PROGRESSIVE);
	set_env(env,l_string(std_cm,"Progressive"),
		get_func_prim(xl_Progressive,FO_APPLICATIVE,0,1,1));
	set_env(env,l_string(std_cm,"CloseProgressive"),
		get_func_prim(xl_CloseProgressive,FO_APPLICATIVE,0,1,1));
	set_env(env,l_string(std_cm,"Stage"),
		get_func_prim(xl_Stage,FO_APPLICATIVE,0,1,1));
}

void
_free_stage(P_STAGE * ps)
{
	if ( ps->sub_progressive )
		_delete_progressive(ps->sub_progressive,0);
	if ( ps->message )
		d_f_ree(ps->message);
	if ( ps->description )
		d_f_ree(ps->description);
	d_f_ree(ps);
}


void
_free_stages(P_STAGE * ps)
{
P_STAGE * ps1;
	for ( ; ps ; ) {
		ps1 = ps;
		ps = ps1->next;
		_free_stage(ps1);
	}
}

P_STAGE *
_new_stage(PROGRESSIVE * p,L_CHAR * description)
{
P_STAGE * ret;
P_STAGE ** psp;
int id;
	ret = d_alloc(sizeof(*ret));
	memset(ret,0,sizeof(*ret));
	id = 0;
	for ( psp = &p->stages ; *psp ; psp = &(*psp)->next ) {
		id = (*psp)->id;
	}
	ret->description = ll_copy_str(description);
	ret->parent = p;
	*psp = ret;
	ret->id = id+1;
	
	return ret;
}

void
_save_file_progressive(STREAM * st,int ind,PROGRESSIVE * pr);

char *
_get_ind(int ind)
{
static char * ind_ary;
static int ind_size;
int i;
	if ( ind_ary == 0 ) {
		ind_ary = d_alloc(ind+1);
		ind_size = ind;
	}
	else if ( ind_size < ind ) {
		ind_ary = d_re_alloc(ind_ary,ind+1);
		ind_size = ind;
	}
	for ( i = 0 ; i < ind ; i ++ )
		ind_ary[i] = ' ';
	ind_ary[i] = 0;
	return ind_ary;
}

void
_save_file_stage(STREAM * st,int ind,P_STAGE * ps)
{
	if ( ps->description )
		s_printf(st,"%sSTAGE(%i) %i %ls\n",
			_get_ind(ind),ps->dont_remove_sub_progressive,ps->id,ps->description);
	else	s_printf(st,"%sSTAGE(%i) %i\n",
			_get_ind(ind),ps->dont_remove_sub_progressive,ps->id);
	if ( ps->message )
		s_printf(st,"%s %ls\n",_get_ind(ind+1),ps->message);
	if ( ps->start_time == 0 )
		s_printf(st,"%sNot Ready\n",_get_ind(ind+1));
	else {
		if ( ps->finished_jobs >= ps->total_jobs ) {
			s_printf(st,"%sFINISHED %f/%f 100%%\n",
				_get_ind(ind+1),
				ps->finished_jobs,
				ps->total_jobs);
			s_printf(st,"%sTOTAL TIME %isec\n",
				_get_ind(ind+1),
				ps->total_time);
		}
		else if ( ps->finished_jobs ) {
		double t;
			s_printf(st,"%sPASS TIME %isec %f/%f %f%% finished\n",
				_get_ind(ind+1),
				(int)(get_xltime() - ps->start_time),
				ps->finished_jobs,
				ps->total_jobs,
				ps->finished_jobs/ps->total_jobs*100);
			s_printf(st,"%sESTIMATED TOTAL TIME %fsec\n",
				_get_ind(ind+1),
				(ps->last_update - ps->start_time)
				*(ps->total_jobs/ps->finished_jobs));
			t = (ps->last_update - ps->start_time)
				*ps->total_jobs/ps->finished_jobs
				 - (get_xltime() - ps->start_time);
			if ( t <= 0 )
				s_printf(st,"%sESTIMATED REMAIN TIME -\n",
					_get_ind(ind+1));
			else	s_printf(st,"%sESTIMATED REMAIN TIME %fsec\n",
					_get_ind(ind+1),t);
		}
		else {
			s_printf(st,"%sPASS TIME %isec %f/%f %f%% finished\n",
				_get_ind(ind+1),
				(int)(get_xltime() - ps->start_time),
				ps->finished_jobs,
				ps->total_jobs,
				ps->finished_jobs/ps->total_jobs*100);
			s_printf(st,"%sESTIMATED REMAIN TIME - sec\n",
				_get_ind(ind+1));
		}
	}
	if ( ps->sub_progressive )
		_save_file_progressive(st,ind+2,ps->sub_progressive);
}

void
_save_file_progressive(STREAM * st,int ind,PROGRESSIVE * pr)
{
P_STAGE * ps;
	if ( pr->description )
		s_printf(st,"%sPROGRESSIVE %ls\n",_get_ind(ind),pr->description);
	else	s_printf(st,"%sPROGRESSIVE\n",_get_ind(ind));
	s_printf(st,"%sTOTAL PASS TIME = %i\n",_get_ind(ind+1),
		(int)(get_xltime() - pr->start_time));
	for ( ps = pr->stages ; ps ; ps = ps->next )
		_save_file_stage(st,ind+1,ps);
}

void
_save_file(PROGRESSIVE * pr)
{
STREAM * st;

	if ( pr->file == 0 )
		return;
	st = s_open_file(n_string(std_cm,pr->file),O_CREAT|O_RDWR|O_TRUNC,0644);
	if ( st == 0 )
		return;
	_save_file_progressive(st,0,pr);
	s_close(st);
}


P_STAGE *
_get_interrested_stage(PROGRESSIVE * pr)
{
	for ( ; pr ; ) {
		if ( pr->interrested_stage == 0 )
			return 0;
		if ( pr->interrested_stage->sub_progressive == 0 )
			return pr->interrested_stage;
		pr = pr->interrested_stage->sub_progressive;
	}
	return 0;
}

PROGRESSIVE *
_search_progressive(XL_INTERPRETER * xli,int inp_flag)
{
PROGRESSIVE * ret;
	if ( inp_flag )
		xli = xli->inp_interpreter;
	for ( ret = progressive_list ; ret ; ret = ret->next )
		if ( ret->base_xli == xli )
			return ret;
	return 0;
}

PROGRESSIVE * 
_search_progressive_by_id(int id)
{
PROGRESSIVE * ret;
	for ( ret = progressive_list ; ret ; ret = ret->next )
		if ( ret->id == id )
			return ret;
	return 0;
}

PROGRESSIVE *
_get_root_progressive(PROGRESSIVE * pr)
{
	for ( ; ; ) {
		if ( pr->parent_stage == 0 )
			return pr;
		pr = pr->parent_stage->parent;
	}
}

PROGRESSIVE *
_new_progressive(L_CHAR * description,L_CHAR *attach_file,int inp_flag)
{
PROGRESSIVE * ret;
PROGRESSIVE * parent;
XL_INTERPRETER * xli;
P_STAGE * ps;
	ret = d_alloc(sizeof(*ret));
	memset(ret,0,sizeof(*ret));
	ret->description = ll_copy_str(description);
	ret->file = ll_copy_str(attach_file);
	ret->start_time = get_xltime();

	xli = get_my_xli();
	parent = _search_progressive(xli,inp_flag);
	
	if ( parent ) {
		ps = _get_interrested_stage(parent);
		if ( ps == 0 ) {
			if ( ret->description )
				d_f_ree(ret->description);
			if ( ret->file )
				d_f_ree(ret->file);
			d_f_ree(ret);
			return 0;
		}
		if ( ps->sub_progressive )
			_delete_progressive(ps->sub_progressive,0);
		ps->sub_progressive = ret;
		ret->parent_stage = ps;
	}
	else {
		if ( inp_flag )
			ret->base_xli = xli->inp_interpreter;
		else	ret->base_xli = xli;
	}
	
	progressive_id ++;
	if ( progressive_id <= 0 )
		progressive_id = 1;
	ret->id = progressive_id;

	ret->next = progressive_list;
	progressive_list = ret;
	
	_save_file(_get_root_progressive(ret));
	return ret;
}

void
_delete_progressive(PROGRESSIVE * inp,int dont_remove_check)
{
PROGRESSIVE ** pp;
	if ( dont_remove_check && inp->parent_stage && 
	     		inp->parent_stage->dont_remove_sub_progressive )
		return;
	_free_stages(inp->stages);
	for ( pp = &progressive_list ; *pp && *pp != inp ; pp = &(*pp)->next );
	if ( *pp ) {
		*pp = inp->next;
	}
	if ( inp->description ) 
		d_f_ree(inp->description);
	if ( inp->file )
		d_f_ree(inp->file);
	if ( inp->parent_stage )
		inp->parent_stage->sub_progressive = 0;
	d_f_ree(inp);
	
}

P_STAGE *
_next_stage(PROGRESSIVE * inp,double total_jobs)
{
P_STAGE * ps;
	if ( inp->interrested_stage == 0 ) {
		inp->interrested_stage = inp->stages;
	}
	else {
		ps = inp->interrested_stage;
		ps->finished_jobs = ps->total_jobs;
		ps->total_time = get_xltime() - ps->start_time;
		inp->interrested_stage = inp->interrested_stage->next;
	}
	if ( inp->interrested_stage == 0 ) {
		_save_file(_get_root_progressive(ps->parent));
		return 0;
	}
	ps = inp->interrested_stage;
	ps->total_time = 0;
	ps->total_jobs = total_jobs;
	ps->finished_jobs = 0;
	ps->start_time = get_xltime();
	_save_file(_get_root_progressive(ps->parent));
	return ps;
}

void
_set_stage_message(P_STAGE * ps,L_CHAR * msg)
{
	ps->message = ll_copy_str(msg);
	_save_file(_get_root_progressive(ps->parent));
}

void
_set_stage_finished_jobs(P_STAGE * ps,double jobs)
{
	if ( jobs > ps->total_jobs )
		ps->finished_jobs = ps->total_jobs;
	else if ( jobs < 0 ) {
		if ( ps->finished_jobs )
			ps->last_update = get_xltime();
		ps->finished_jobs = 0;
	}
	else {
		if ( ps->finished_jobs != jobs )
			ps->last_update = get_xltime();
		ps->finished_jobs = jobs;
	}
	if ( ps->finished_jobs == ps->total_jobs )
		ps->total_time = get_xltime() - ps->start_time;
	_save_file(_get_root_progressive(ps->parent));
}


UPLINK_INFO *
_search_uplink_info(int inp_flag)
{
UPLINK_INFO * ret;
XL_INTERPRETER * xli;
	xli = get_my_xli();
	if ( inp_flag )
		xli = xli->inp_interpreter;
	for ( ret = uplink_info_list ; ret ; ret = ret->next )
		if ( ret->xli == xli )
			return ret;
	ret = d_alloc(sizeof(*ret));
	memset(ret,0,sizeof(*ret));
	ret->xli = xli;
	switch ( xli->a_type ) {
	case XLA_SELF:
	case XLA_STDIO:
	case XLA_FILE:
	case XLA_ACCEPT:
		ret->uplink = 0;
		break;
	default:
		ret->uplink = 1;
		break;
	}
	ret->next = uplink_info_list;
	uplink_info_list = ret;
	
	return ret;
}

void
_insert_cq(UPLINK_INFO * up,CMD_QUE * cq,int wait_flag)
{
	cq->h.next = 0;
	if ( up->cq_head == 0 )
		up->cq_head = up->cq_tail = cq;
	else {
		up->cq_tail->h.next = cq;
		up->cq_tail = cq;
	}
	cq->h.end_flag = 0;
	if ( progressive_task_flag == 0 ) {
		progressive_task_flag = 1;
		create_task((void (*)(TKEY))progressive_task,0,PRI_FETCH);
	}
	wakeup_task((int)&uplink_info_list);
	if ( wait_flag ) {
		for ( ; cq->h.end_flag == 0 ; ) {
			sleep_task((int)cq,progressive_lock);
			lock_task(progressive_lock);
		}
	}
}

CMD_QUE *
_delete_cq(UPLINK_INFO * up)
{
CMD_QUE * ret;
	ret = up->cq_head;
	if ( ret == 0 )
		return ret;
	up->cq_head = ret->h.next;
	if ( up->cq_head == 0 )
		up->cq_tail = 0;
	return ret;
}

void
_free_cmd_que(CMD_QUE * cq)
{
	switch ( cq->h.type ) {
	case CQT_NEW_PROGRESSIVE:
		if ( cq->np.description )
			d_f_ree(cq->np.description);
		if ( cq->np.attach_file )
			d_f_ree(cq->np.attach_file);
		break;
	case CQT_CLOSE_PROGRESSIVE:
		break;
	case CQT_NEW_STAGE:
		if ( cq->ns.description )
			d_f_ree(cq->ns.description);
		break;
	case CQT_NEXT_STAGE:
		break;
	case CQT_SET_STAGE:
		if ( cq->ss.message )
			d_f_ree(cq->ss.message);
		break;
	default:
		er_panic("_free_cmd_que(1)");
	}
	d_f_ree(cq);
}

void
progressive_task()
{
XL_INTERPRETER * xli;
CMD_QUE * cq;
UPLINK_INFO * up;
int see_cnt;
int cnt;
XL_SEXP * ret,*gt;
char * buffer;
	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);
	see_cnt = 0;
	buffer = d_alloc(1000);
	for ( ; ; ) {
		lock_task(progressive_lock);
	retry:
		cq = 0;
		cnt =0;
		for ( up = uplink_info_list ; up ; up = up->next , cnt ++ ) {
			if ( cnt < see_cnt )
				continue;
			cq = _delete_cq(up);
			if ( cq )
				break;
		}
		if ( up == 0 ) {
			if ( see_cnt != -1 ) {
				see_cnt = -1;
				goto retry;
			}
			see_cnt = 0;
		}
		else	see_cnt = cnt;
		if ( cq == 0 ) {
			break;
		}
		if ( cq->h.type == CQT_SET_STAGE && cq->ss.message == 0 
				&& up->cq_head && up->cq_head->h.type == CQT_SET_STAGE ) {
			_free_cmd_que(cq);
			goto retry;
		}
		unlock_task(progressive_lock,"progressive_task");
		
		gc_push(0,0,"progressive_task");
		switch ( cq->h.type ) {
		case CQT_NEW_PROGRESSIVE:
			gt = n_get_symbol("Progressive");
			if ( cq->np.description )
				set_attribute(gt,l_string(std_cm,"description"),
					cq->np.description);
			if ( cq->np.attach_file )
				set_attribute(gt,l_string(std_cm,"attach-file"),
					cq->np.attach_file);
			break;
		case CQT_CLOSE_PROGRESSIVE:
			gt = n_get_symbol("CloseProgressive");
			sprintf(buffer,"%i",cq->h.prog_id);
			set_attribute(gt,l_string(std_cm,"prog"),l_string(std_cm,buffer));
			break;
		case CQT_NEW_STAGE:
			gt = n_get_symbol("Stage");
			set_attribute(gt,l_string(std_cm,"status"),l_string(std_cm,"define"));
			sprintf(buffer,"%i",cq->h.prog_id);
			set_attribute(gt,l_string(std_cm,"prog"),l_string(std_cm,buffer));
			if ( cq->ns.description )
				set_attribute(gt,l_string(std_cm,"description"),cq->ns.description);
			if ( cq->ns.drsp >= 0 ) {
				if ( cq->ns.drsp )
					set_attribute(gt,
						l_string(std_cm,"dont-remove-sub-progressive"),
						l_string(std_cm,"on"));
				else	set_attribute(gt,
						l_string(std_cm,"dont-remove-sub-progressive"),
						l_string(std_cm,"off"));
			}
			break;
		case CQT_NEXT_STAGE:
			gt = n_get_symbol("Stage");
			set_attribute(gt,l_string(std_cm,"status"),l_string(std_cm,"invoke"));
			sprintf(buffer,"%i",cq->h.prog_id);
			set_attribute(gt,l_string(std_cm,"prog"),l_string(std_cm,buffer));
			sprintf(buffer,"%i",cq->h.stage_id);
			set_attribute(gt,l_string(std_cm,"stage"),l_string(std_cm,buffer));
			sprintf(buffer,"%.9f",cq->xs.total_jobs);
			set_attribute(gt,l_string(std_cm,"total-jobs"),l_string(std_cm,buffer));
			break;
		case CQT_SET_STAGE:
			gt = n_get_symbol("Stage");
			set_attribute(gt,l_string(std_cm,"status"),l_string(std_cm,"set"));
			sprintf(buffer,"%i",cq->h.prog_id);
			set_attribute(gt,l_string(std_cm,"prog"),l_string(std_cm,buffer));
			sprintf(buffer,"%i",cq->h.stage_id);
			set_attribute(gt,l_string(std_cm,"stage"),l_string(std_cm,buffer));
			if ( cq->ss.finished_jobs >= 0 ) {
				sprintf(buffer,"%.9f",cq->ss.finished_jobs);
				set_attribute(gt,l_string(std_cm,"finished-jobs"),l_string(std_cm,buffer));
			}
			if ( cq->ss.message )
				set_attribute(gt,l_string(std_cm,"message"),
						l_string(std_cm,cq->ss.message));
			break;
		default:
			er_panic("progressive_task");
		}
		set_attribute(gt,l_string(std_cm,"xli"),l_string(std_cm,"lq"));
		ret = local_query(gblisp_top_env0,
				cq->h.xli,0,List(gt,-1));
		switch ( get_type(ret) ) {
		case XLT_ERROR:
print_sexp(s_stdout,ret,0);
ss_printf("\n");
			cq->h.err = -100;
			break;
		case XLT_NULL:
			cq->h.err = 0;
			break;
		case XLT_INTEGER:
			cq->h.err = ret->integer.data;
			break;
		default:
			break;
		}
		cq->h.end_flag = 1;
		wakeup_task((int)cq);
		gc_pop(0,0);
		
		lock_task(progressive_lock);
		if ( cq->h.type == CQT_SET_STAGE )
			_free_cmd_que(cq);
		unlock_task(progressive_lock,"progressive_task");
	}
	d_f_ree(buffer);
	progressive_task_flag = 0;
	unlock_task(progressive_lock,"progressive_task");
	close_self_interpreter();
}

int
access_keep(ACCESS_KEEPER * ak)
{
INTEGER64 tim;
	tim = get_xltime();
	if ( ak->check == tim ) {
		ak->count ++;
	}
	else {
		ak->avg = ak->avg*AK_RATE + ak->count*(1-AK_RATE);
		ak->count = 0;
		ak->check = tim;
	}
	ak->ignore_count ++;
	if ( ak->ignore_count >= ak->avg/AK_INTERVAL ) {
		ak->ignore_count = 0;
		return 0;
	}
	else {
		return -1;
	}
}

void
reset_access_keep(ACCESS_KEEPER * ak)
{
	ak->count = 0;
	ak->check = get_xltime();
	ak->ignore_count = 0;
	ak->avg = 0;
}

int
new_progressive(L_CHAR * description,L_CHAR * attach_file,int inp_flag)
{
PROGRESSIVE * ret;
int id;
UPLINK_INFO * up;
CMD_QUE cq;
	lock_task(progressive_lock);
	up = _search_uplink_info(inp_flag);
	if ( up->uplink ) {
		memset(&cq,0,sizeof(cq));
		cq.h.type = CQT_NEW_PROGRESSIVE;
		cq.h.xli = up->xli;
		cq.np.description = description;
		cq.np.attach_file = attach_file;
		_insert_cq(up,&cq,1);
		id = cq.h.err;
	}
	else {
		ret = _new_progressive(description,attach_file,inp_flag);
		id = ret->id;
	}
	unlock_task(progressive_lock,"new_progressive");
	return id;
}

void
close_progressive(int id,int inp_flag)
{
PROGRESSIVE * ret;
UPLINK_INFO * up;
CMD_QUE cq;
	lock_task(progressive_lock);
	up = _search_uplink_info(inp_flag);
	if ( up->uplink ) {
		memset(&cq,0,sizeof(cq));
		cq.h.type = CQT_CLOSE_PROGRESSIVE;
		cq.h.xli = up->xli;
		cq.h.prog_id = id;
		_insert_cq(up,&cq,1);
	}
	else {
		ret = _search_progressive_by_id(id);
		if ( ret == 0 )
			goto end;
		_save_file(_get_root_progressive(ret));
		_delete_progressive(ret,1);
	}
end:
	unlock_task(progressive_lock,"close_progressive");
}

int
new_stage(int id,L_CHAR * description,int drsp,int inp_flag)
{
PROGRESSIVE * p;
int ret;
P_STAGE * ps;
UPLINK_INFO * up;
CMD_QUE cq;
	ret = 0;
	lock_task(progressive_lock);
	up = _search_uplink_info(inp_flag);
	if ( up->uplink ) {
		memset(&cq,0,sizeof(cq));
		cq.h.type = CQT_NEW_STAGE;
		cq.h.xli = up->xli;
		cq.h.prog_id = id;
		cq.ns.description = description;
		cq.ns.drsp = drsp;
		_insert_cq(up,&cq,1);
		ret = cq.h.err;
	}
	else {
		p = _search_progressive_by_id(id);
		if ( p == 0 ) {
			ret = -1;
			goto end;
		}
		ps = _new_stage(p,description);
		if ( ps == 0 ) {
			ret = -2;
			goto end;
		}
		if ( drsp >= 0 )
			ps->dont_remove_sub_progressive = drsp;
		ret = ps->id;
	}
end:
	unlock_task(progressive_lock,"new_progressive");
	return ret;
}

int
next_stage(int prog_id,int sid,double total_jobs,int inp_flag)
{
PROGRESSIVE * p;
P_STAGE * ps;
int ret;
UPLINK_INFO * up;
CMD_QUE cq;
	ret = 0;
	lock_task(progressive_lock);
	up = _search_uplink_info(inp_flag);
	if ( up->uplink ) {
		reset_access_keep(&up->ak);
		memset(&cq,0,sizeof(cq));
		cq.h.type = CQT_NEXT_STAGE;
		cq.h.xli = up->xli;
		cq.h.prog_id = prog_id;
		cq.h.stage_id = sid;
		cq.xs.total_jobs = total_jobs;
		_insert_cq(up,&cq,1);
		ret = cq.h.err;
	}
	else {
		p = _search_progressive_by_id(prog_id);
		if ( p == 0 ) {
			ret = -1;
			goto end;
		}
		ps = _next_stage(p,total_jobs);
		if ( ps == 0 ) {
			if ( sid == 0 )
				goto end;
			ret = -2;
			goto end;
		}
		reset_access_keep(&ps->ak);
		if ( ps->id != sid ) {
			ret = -3;
			goto end;
		}
	}
end:
	unlock_task(progressive_lock,"new_progressive");
	return ret;
}


int
set_stage(int prog_id,L_CHAR * message,double finished_jobs,int inp_flag)
{
PROGRESSIVE * p;
P_STAGE * ps;
int ret;
UPLINK_INFO * up;
CMD_QUE *cq;
	lock_task(progressive_lock);
	up = _search_uplink_info(inp_flag);
	if ( up->uplink ) {
		if ( message == 0 && finished_jobs >= 0 ) {
			if ( access_keep(&up->ak) < 0 ) {
				ret = 0;
				goto end;
			}
		}
		cq = d_alloc(sizeof(*cq));
		memset(cq,0,sizeof(cq));
		cq->h.type = CQT_SET_STAGE;
		cq->h.xli = up->xli;
		cq->h.prog_id = prog_id;
		cq->ss.message = ll_copy_str(message);
		cq->ss.finished_jobs = finished_jobs;
		_insert_cq(up,cq,0);
		ret = 0;
	}
	else {
		p = _search_progressive_by_id(prog_id);
		if ( p == 0 ) {
			ret = -1;
			goto end;
		}
		ps = p->interrested_stage;
		if ( ps == 0 ) {
			ret = -2;
			goto end;
		}
		if ( message == 0 && finished_jobs >= 0 ) {
			if ( access_keep(&ps->ak) < 0 ) {
				ret = 0;
				goto end;
			}
		}
		if ( message )
			_set_stage_message(ps,message);
		if ( finished_jobs >= 0 )
			_set_stage_finished_jobs(ps,finished_jobs);
		ret = 0;
	}
end:
	unlock_task(progressive_lock,"new_progressive");
	return ret;
}


XL_SEXP *
xl_Progressive(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * desc;
L_CHAR * attach_file;
L_CHAR * xli_flag;
int inp_flag;
int ret;
	desc = get_sf_attribute(sf,l_string(std_cm,"description"));
	attach_file = get_sf_attribute(sf,l_string(std_cm,"attach-file"));
	
	xli_flag = get_sf_attribute(sf,l_string(std_cm,"xli"));
	if ( xli_flag && l_strcmp(xli_flag,l_string(std_cm,"lq")) == 0 )
		inp_flag = 1;
	else	inp_flag = 0;
	ret = new_progressive(desc,attach_file,inp_flag);
	if ( ret < 0 )
		goto inv_param;
	return get_integer(ret,0);
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"Progressive"),
		n_get_string("cannot generate progressive"));
/*
internal_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SYSTEM_INTERNAL,
		l_string(std_cm,"Progressive"),
		List(n_get_string("ERROR"),
			get_integer(errno,0),
			-1));
*/
}



XL_SEXP *
xl_Stage(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * desc;
int ret;
L_CHAR * id;
L_CHAR * status;
L_CHAR * sid;
L_CHAR * total_jobs;
double _total_jobs;
L_CHAR * message;
L_CHAR * finished_jobs;
double _finished_jobs;
int er;
int inp_flag;
L_CHAR * xli_flag;
L_CHAR * drsp;
int _drsp;
	xli_flag = get_sf_attribute(sf,l_string(std_cm,"xli"));
	if ( xli_flag && l_strcmp(xli_flag,l_string(std_cm,"lq")) == 0 )
		inp_flag = 1;
	else	inp_flag = 0;
	desc = get_sf_attribute(sf,l_string(std_cm,"description"));
	id = get_sf_attribute(sf,l_string(std_cm,"prog"));
	if ( id == 0 )
		goto inv_param2;
	status = get_sf_attribute(sf,l_string(std_cm,"status"));
	if ( status == 0 )
		goto inv_param3;
	if ( l_strcmp(status,l_string(std_cm,"define")) == 0 ) {
		drsp = get_sf_attribute(sf,l_string(std_cm,"dont-remove-sub-progressive"));
		if ( drsp ) { 
			if ( l_strcmp(drsp,l_string(std_cm,"on")) == 0 )
				_drsp = 1;
			else	_drsp = 0;
		}
		else	_drsp = -1;
		ret = new_stage(atoi(n_string(std_cm,id)),desc,_drsp,inp_flag);
		if ( ret < 0 )
			goto inv_param;
		return get_integer(ret,0);
	}
	else if ( l_strcmp(status,l_string(std_cm,"invoke")) == 0 ) {
		sid = get_sf_attribute(sf,l_string(std_cm,"stage"));
		if ( sid == 0 )
			goto inv_param4;
		if ( atoi(n_string(std_cm,sid)) == 0 )
			goto next;
		total_jobs = get_sf_attribute(sf,l_string(std_cm,"total-jobs"));
		if ( total_jobs == 0 )
			goto inv_param5;
		sscanf(n_string(std_cm,total_jobs),"%lf",&_total_jobs);
	next:
		er = next_stage(atoi(n_string(std_cm,id)),atoi(n_string(std_cm,sid)),_total_jobs,inp_flag);
		if ( er < 0 )
			goto inv_param6;
		return 0;
	}
	else if ( l_strcmp(status,l_string(std_cm,"set")) == 0 ) {
		message = get_sf_attribute(sf,l_string(std_cm,"message"));
		finished_jobs = get_sf_attribute(sf,l_string(std_cm,"finished-jobs"));
		if ( finished_jobs == 0 )
			_finished_jobs = -1;
		else	sscanf(n_string(std_cm,finished_jobs),"%lf",&_finished_jobs);
		er = set_stage(atoi(n_string(std_cm,id)),message,_finished_jobs,inp_flag);
		if ( er < 0 )
			goto inv_param7;
		return 0;
	}
	return 0;
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"Stage"),
		List(n_get_string("cannot generate stage"),
			get_integer(ret,0),-1));
inv_param2:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"Stage"),
		n_get_string("attribute prog is required"));
inv_param3:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"Stage"),
		n_get_string("attribute status is required"));
inv_param4:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"Stage"),
		n_get_string("attribute stage is required"));
inv_param5:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"Stage"),
		n_get_string("attribute total-jobs is required"));
inv_param6:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"Stage"),
		List(n_get_string("cannot execute next stage"),
			get_integer(er,0),-1));
inv_param7:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"Stage"),
		List(n_get_string("cannot execute set stage"),
			get_integer(er,0),-1));
/*
internal_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SYSTEM_INTERNAL,
		l_string(std_cm,"Progressive"),
		List(n_get_string("ERROR"),
			get_integer(errno,0),
			-1));
*/
}





XL_SEXP *
xl_CloseProgressive(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * id;
int inp_flag;
L_CHAR * xli_flag;
	id = get_sf_attribute(sf,l_string(std_cm,"prog"));
	if ( id == 0 )
		goto inv_param;
	xli_flag = get_sf_attribute(sf,l_string(std_cm,"xli"));
	if ( xli_flag && l_strcmp(xli_flag,l_string(std_cm,"lq")) == 0 )
		inp_flag = 1;
	else	inp_flag = 0;
	close_progressive(atoi(n_string(std_cm,id)),inp_flag);
	return 0;

inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"CloseProgressive"),
		n_get_string("attribute prog is required"));
/*
internal_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SYSTEM_INTERNAL,
		l_string(std_cm,"Progressive"),
		List(n_get_string("ERROR"),
			get_integer(errno,0),
			-1));
*/
}



void
_close_progressive_xli(XL_INTERPRETER * xli)
{
PROGRESSIVE * pr;
UPLINK_INFO * up,**upp;
	pr = _search_progressive(xli,0);
	if ( pr ) {
		_save_file(_get_root_progressive(pr));
		_delete_progressive(pr,1);
	}
	for ( upp = &uplink_info_list ; *upp ; upp = &(*upp)->next ) {
		up = *upp;
		if ( up->xli == xli ) {
			*upp = up->next;
			break;
		}
	}
	for ( ; up->cq_head ; ) {
		sleep_task((int)up,progressive_lock);
		lock_task(progressive_lock);
	}
	d_f_ree(up);
}
