/**********************************************************************
 
	Copyright (C) 2008- Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"stream.h"
#include	"server.h"
#include	"xl.h"
#include	"task.h"
#include	"pri_level.h"
#include	"lock_level.h"
#include	"memory_debug.h"
#include	"xlerror.h"
#include	"client.h"
#include	"s_buf.h"

/*
#define DEBUG
*/

typedef struct stream_routing_info {
	AL_INFO_HEADER			al_h;
	int				type;
#define SRIT_REJECT		0
#define SRIT_DIRECT		1
#define SRIT_PROXY		2
	HOST_ADDR_EXT			gateway;
} STREAM_ROUTING_INFO;


#define SR_BUF_SIZE	1000

static SEM sr_lock;

ACCESS_PERMISSION stream_routing_ap;
XL_SEXP *
xl_ActivateStreamRouting(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
XL_SEXP *
xl_StreamRouting(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);

void
init_stream_routing(XLISP_ENV * env)
{
	sr_lock = new_lock(LL_SR);
	set_env(env,l_string(std_cm,"ActivateStreamRouting"),
		get_func_prim(xl_ActivateStreamRouting,FO_APPLICATIVE,0,2,2));
	set_env(env,l_string(std_cm,"StreamRouting"),
		get_func_prim(xl_StreamRouting,FO_APPLICATIVE,0,1,1));
}


void
sr_free(AL_INFO_HEADER * h)
{
STREAM_ROUTING_INFO * info;
	info = (STREAM_ROUTING_INFO*)h;
	free_host_addr_ext(&info->gateway);
}

void
insert_stream_routing(char * src,char * dest,char * gateway,int type)
{
STREAM_ROUTING_INFO * sri;
HOST_ADDR_EXT _src,_dest;

#ifdef DEBUG
if ( gateway )
ss_printf("INSERT SR %s %s %s, %i\n",src,dest,gateway,type);
else
ss_printf("INSERT SR %s %s, %i\n",src,dest,type);
#endif
	sri = d_alloc(sizeof(*sri));
	sri->al_h.free_func = sr_free;
	sri->type = type;
	get_inet_addr(&_src,src);
	get_inet_addr(&_dest,dest);
	if ( gateway )
		get_inet_addr(&sri->gateway,gateway);
	else	sri->gateway.type = HAT_NONE;
	insert_access_list(&stream_routing_ap,&_src,&_dest, AP_ALLOW, (void*)sri);
}

STREAM *
get_target_stream(int fd)
{
	switch ( recv_streams_len ) {
	default:
		return recv_streams[fd];
	case 1:
		return recv_streams[0];
	case 0:
		if ( fd == 0 )
			return s_stdin;
		else	return s_stdout;
	}
}

int
get_result_tag_detection(char *buf,STREAM * st,char * tag)
{
int p;
int er;
int len;
int cmp_ptr;
	len = strlen(tag);
	p = 0;
	cmp_ptr = -1;
	for ( ; ; ) {
		er = s_read(st,&buf[p],1);
		if ( er <= 0 )
			break;
		if ( buf[p] == '\n' )
			return -(p+1);
		p ++;
		if ( cmp_ptr < p - len ) {
			cmp_ptr = p - len;
			if ( memcmp(tag,&buf[cmp_ptr],len) == 0 )
				return p;
		}
	}
	return -0x7fffffff;
}


int
get_return(STREAM * st)
{
char ch;
int er;
	for ( ; ; ) {
		er = s_read(st,&ch,1);
		if ( er <= 0 )
			return -1;
		if ( ch == '\n' )
			return 0;
	}
}

XL_SEXP *
get_result_tag(STREAM * st,char * tag,int tol1,int tol2,char ** ret_buf)
{
char * buf;
char *tag_buf;
int len;
int _tol;
int ptr,ptr_ret;
XL_SEXP * ret,*pp;
STREAM * st_read;
	buf = d_alloc(1000);
	len = strlen(tag);
	tag_buf = d_alloc(len+10);
	
	sprintf(tag_buf,"<%s>",tag);
	
	ptr = 0;
	for ( _tol = tol1 ; _tol ; _tol -- ) { 
		ptr_ret = get_result_tag_detection(&buf[ptr],st,tag_buf);
		if ( ptr_ret >= 0 ) {
			ptr += ptr_ret;
			goto next1;
		}
		else if ( ptr_ret == -0x7fffffff ) {
			ret = 0;
			goto end;
		}
		ptr += -ptr_ret;
	}
	ret = 0;
	goto end;
next1:
	sprintf(tag_buf,"</%s>",tag);
	for ( _tol = tol2 ; _tol ; _tol -- ) { 
		ptr_ret = get_result_tag_detection(&buf[ptr],st,tag_buf);
		if ( ptr_ret >= 0 ) {
			ptr += ptr_ret;
			goto next2;
		}
		else if ( ptr_ret == -0x7fffffff ) {
			ret = 0;
			goto end;
		}
		ptr += -ptr_ret;
	}
	ret = 0;
	goto end;
next2:
	st_read = s_open_string_read(buf, std_cm, ptr, 0);
	ret = init_parse(st_read,l_string(std_cm,"get_result_tag"), l_string(std_cm,"get_result_tag"));
	for ( pp = ret ; get_type(pp) == XLT_PAIR ; pp = cdr(pp));
	ret = car(ret);
	s_close(st_read);
	if ( get_return(st) < 0 ) {
		ret = 0;
	}
end:
	d_f_ree(tag_buf);
	buf[ptr] = 0;
	*ret_buf = buf;
	return ret;
}




STREAM * 
connect_stream_routing(int * cerr,HOST_ADDR_EXT * addr,int routing_flag,int ttl,int timeout_sec)
{
HOST_ADDR_EXT src;
ACCESS_LIST * al;
STREAM * target;
STREAM_ROUTING_INFO * sri;
XL_SEXP * ret;
char * bufp;
int log_flag;

#ifdef DEBUG
ss_printf("connect_stream_routing-1\n");
#endif

	log_flag = 1;
	switch ( addr->type ) {
	case HAT_XLPROX_V4:
		if ( addr->am.addr.d.xp_v4.v4 == 0x7f000001 )
			log_flag = 0;
		break;
	case HAT_XLPROX_DOMAIN:
		if ( strcmp(addr->domain.name,"localhost") == 0 )
			log_flag = 0;
	}


	if ( ttl <= 0 ) {
if ( log_flag )
log_printf(LOG_MESSAGE,LOG_LAYER_XL,0,"routing %s -> REJECT %s TTL-ERROR (TTL=%i)\n",get_string_inet_addr(&src),get_string_inet_addr(addr),ttl);
		*cerr = XLIE_CANNOT_OPEN_TTL;
		return 0;
	}
	ttl --;
	if ( routing_flag ) {
		if ( recv_streams ) {
			src.am.addr.d.xp_v4.v4 = s_get_socketip(get_target_stream(0));
			if ( src.am.addr.d.xp_v4.v4 == 0 )
				src.am.addr.type = HAT_NONE;
			else	src.am.addr.type = HAT_XLPROX_V4;
			src.am.addr.size = 4;
			src.am.addr.port = -1;
			src.am.addr.d.xp_v4.id = -1;
		}
		else {
			src.type = HAT_ME;
		}
	}
	else {
		src.type = HAT_ME;
	}
	al = check_permission(&stream_routing_ap,&src,addr);
	if ( al == 0 ) {
#ifdef DEBUG
ss_printf("connect_stream_routing-2\n");
#endif
		switch ( addr->type ) {
		case HAT_XLPROX_V4:
if ( log_flag )
log_printf(LOG_MESSAGE,LOG_LAYER_XL,0,"routing %s -> DIRECT %s (TTL=%i)\n",get_string_inet_addr(&src),get_string_inet_addr(addr),ttl);
			return  new_connection(
				cerr,
				0,
				addr->am.addr.d.xp_v4.v4,
				addr->am.addr.port,0,0);
		case HAT_XLPROX_DOMAIN:
if ( log_flag )
log_printf(LOG_MESSAGE,LOG_LAYER_XL,0,"routing %s -> DIRECT %s (TTL=%i)\n",get_string_inet_addr(&src),get_string_inet_addr(addr),ttl);
			return new_connection(
				cerr,
				addr->domain.name,
				0,
				addr->domain.port,0,0);
		default:
if ( log_flag )
log_printf(LOG_MESSAGE,LOG_LAYER_XL,0,"routing %s -> REJECT %s ERROR (TTL=%i)\n",get_string_inet_addr(&src),get_string_inet_addr(addr),ttl);
			*cerr = XLIE_CANNOT_OPEN_SERVICE_INVALID;
			return 0;
		}
	}
	else {
#ifdef DEBUG
ss_printf("connect_stream_routing-3 %s -> %s (%s %s)\n",
	get_string_inet_addr(&src),get_string_inet_addr(addr),
	get_string_inet_addr(&al->src),
	get_string_inet_addr(&al->dest));
#endif
		sri = (STREAM_ROUTING_INFO*)al->info;
		switch ( sri->type ) {
		case SRIT_REJECT:
if ( log_flag )
log_printf(LOG_MESSAGE,LOG_LAYER_XL,0,"routing %s -> REJECT %s (TTL=%i)\n",get_string_inet_addr(&src),get_string_inet_addr(addr),ttl);
#ifdef DEBUG
ss_printf("connect_stream_routing-4\n");
#endif
			*cerr = XLIE_CANNOT_OPEN_DENIED;
			return 0;
		case SRIT_DIRECT:
			switch ( addr->type ) {
			case HAT_XLPROX_V4:
#ifdef DEBUG
ss_printf("connect_stream_routing-5\n");
#endif
if ( log_flag )
log_printf(LOG_MESSAGE,LOG_LAYER_XL,0,"routing %s -> DIRECT %s (TTL=%i)\n",get_string_inet_addr(&src),get_string_inet_addr(addr),ttl);
				return  new_connection(
					cerr,
					0,
					addr->am.addr.d.xp_v4.v4,
					addr->am.addr.port,0,0);
			case HAT_XLPROX_DOMAIN:
#ifdef DEBUG
ss_printf("connect_stream_routing-6\n");
#endif
if ( log_flag )
log_printf(LOG_MESSAGE,LOG_LAYER_XL,0,"routing %s -> DIRECT %s (TTL=%i)\n",get_string_inet_addr(&src),get_string_inet_addr(addr),ttl);
				return new_connection(
					cerr,
					addr->domain.name,
					0,
					addr->domain.port,0,0);
			default:
#ifdef DEBUG
ss_printf("connect_stream_routing-7\n");
#endif
if ( log_flag )
log_printf(LOG_MESSAGE,LOG_LAYER_XL,0,"routing %s -> REJECT %s ERROR (TTL=%i)\n",get_string_inet_addr(&src),get_string_inet_addr(addr),ttl);
				*cerr = XLIE_CANNOT_OPEN_SERVICE_INVALID;
				return 0;
			}
		case SRIT_PROXY:
			switch ( sri->gateway.type ) {
			case HAT_XLPROX_V4:
				target = new_connection(
					cerr,
					0,
					sri->gateway.am.addr.d.xp_v4.v4,
					sri->gateway.am.addr.port,0,0);
			case HAT_XLPROX_DOMAIN:
				target = new_connection(
					cerr,
					sri->gateway.domain.name,
					0,
					sri->gateway.domain.port,0,0);
				break;
			default:
if ( log_flag )
log_printf(LOG_MESSAGE,LOG_LAYER_XL,0,"routing %s -> %s PROXY %s ERROR-1 (TTL=%i)\n",
	get_string_inet_addr(&src),get_string_inet_addr(addr),get_string_inet_addr(&sri->gateway),ttl);
				*cerr = XLIE_CANNOT_OPEN_SERVICE_INVALID;
				return 0;
			}
			break;
		default:
			er_panic("connect_stream_routing");
		}

#ifdef DEBUG
ss_printf("connect_stream_routing-200\n");
#endif

		gc_push(0,0,"stream_routing");
		if ( target == 0 ) {
if ( log_flag )
log_printf(LOG_MESSAGE,LOG_LAYER_XL,0,"routing %s -> %s PROXY %s ERROR SERVICE CONNECTION (TTL=%i)\n",
	get_string_inet_addr(&src),get_string_inet_addr(addr),get_string_inet_addr(&sri->gateway),ttl);
#ifdef DEBUG
ss_printf("routing %s -> %s PROXY %s ERROR SERVICE CONNECTION (TTL=%i)\n",
	get_string_inet_addr(&src),get_string_inet_addr(addr),get_string_inet_addr(&sri->gateway),ttl);
#endif
			*cerr = XLIE_CANNOT_OPEN_CONNECT;
			gc_pop(0,0);
			return 0;
		}
		s_printf(target,"\n");
		ret = get_result_tag(target,"Permission",3,1,&bufp);
		ret = get_el(ret,1);
		if ( get_type(ret) != XLT_STRING ) {
			*cerr = XLIE_CANNOT_OPEN_SERVICE_INVALID;
if ( log_flag )
log_printf(LOG_MESSAGE,LOG_LAYER_XL,0,"routing %s -> %s PROXY %s ERROR SERVICE INVALID (TTL=%i) (%s)\n",
	get_string_inet_addr(&src),get_string_inet_addr(addr),get_string_inet_addr(&sri->gateway),ttl,bufp);
#ifdef DEBUG
ss_printf("routing %s -> %s PROXY %s ERROR SERVICE INVALID (TTL=%i) (%s)\n",
	get_string_inet_addr(&src),get_string_inet_addr(addr),get_string_inet_addr(&sri->gateway),ttl,bufp);
#endif
			s_close(target);
			d_f_ree(bufp);
			gc_pop(0,0);
			return 0;
		}
		d_f_ree(bufp);
		if ( l_strcmp(ret->string.data,l_string(std_cm,"Allow")) == 0 ) {
		}
		else
		if ( l_strcmp(ret->string.data,l_string(std_cm,"Busy")) == 0 ) {
			*cerr = XLIE_CANNOT_OPEN_BUSY;
if ( log_flag )
log_printf(LOG_MESSAGE,LOG_LAYER_XL,0,"routing %s -> %s PROXY %s ERROR SERVICE INVALID BUSY (TTL=%i)\n",
	get_string_inet_addr(&src),get_string_inet_addr(addr),get_string_inet_addr(&sri->gateway),ttl);
			s_close(target);
			gc_pop(0,0);
			return 0;
		}
		else
		if ( l_strcmp(ret->string.data,l_string(std_cm,"Denied")) == 0 ) {
			*cerr = XLIE_CANNOT_OPEN_DENIED;
if ( log_flag )
log_printf(LOG_MESSAGE,LOG_LAYER_XL,0,"routing %s -> %s PROXY %s ERROR SERVICE INVALID Denied (TTL=%i)\n",
	get_string_inet_addr(&src),get_string_inet_addr(addr),get_string_inet_addr(&sri->gateway),ttl);
			s_close(target);
			gc_pop(0,0);
			return 0;
		}
		else {
			*cerr = XLIE_CANNOT_OPEN_SERVICE_INVALID;
if ( log_flag )
log_printf(LOG_MESSAGE,LOG_LAYER_XL,0,"routing %s -> %s PROXY %s ERROR SERVICE INVALID Unknown error (TTL=%i)\n",
	get_string_inet_addr(&src),get_string_inet_addr(addr),get_string_inet_addr(&sri->gateway),ttl);
			s_close(target);
			gc_pop(0,0);
			return 0;
		}

		s_printf(target,"(SetAgent \"xlsr\" \"user\" \"%s,%i,%i\")\n",
			get_string_inet_addr(addr),
			ttl,timeout_sec);
		ret = get_result_tag(target,"Result",2,5,&bufp);
		ret = get_el(ret,2);
		if ( get_type(ret) == XLT_ERROR ) {
			*cerr = XLIE_CANNOT_OPEN_SERVICE_INVALID;
#ifdef DEBUG
ss_printf("routing %s -> %s PROXY %s ERROR SERVICE INVALID Unknown error (TTL=%i) (%s)\n",
	get_string_inet_addr(&src),get_string_inet_addr(addr),get_string_inet_addr(&sri->gateway),ttl,bufp);
#endif
if ( log_flag )
log_printf(LOG_MESSAGE,LOG_LAYER_XL,0,"routing %s -> %s PROXY %s ERROR SERVICE INVALID Unknown error (TTL=%i) (%s)\n",
	get_string_inet_addr(&src),get_string_inet_addr(addr),get_string_inet_addr(&sri->gateway),ttl,bufp);
			s_close(target);
			d_f_ree(bufp);
			gc_pop(0,0);
			return 0;
		}
		d_f_ree(bufp);
if ( log_flag )
log_printf(LOG_MESSAGE,LOG_LAYER_XL,0,"routing %s -> %s PROXY %s (TTL=%i)\n",
	get_string_inet_addr(&src),get_string_inet_addr(addr),get_string_inet_addr(&sri->gateway),ttl);
		gc_pop(0,0);
		return target;
/*
	err_1:
log_printf(LOG_MESSAGE,LOG_LAYER_XL,0,"routing %s -> %s PROXY %s ERROR-2 (TTL=%i)\n",
	get_string_inet_addr(&src),get_string_inet_addr(addr),get_string_inet_addr(&sri->gateway),ttl);
		*cerr = XLIE_CANNOT_OPEN_DENIED;
		return 0;
*/
	}
}

int sr_end_flag;

void
forward_thread(TKEY d)
{
STREAM * target;
char * buf;
int er;
int len;
	buf = d_alloc(SR_BUF_SIZE);
	target = (STREAM*)GET_TKEY(d);
	for ( ; ; ) {
		er = s_read(get_target_stream(0),buf,SR_BUF_SIZE);
		if ( er <= 0 )
			break;
		if ( en_do(&len,s_write,target,buf,er) <= 0 )
		  	break;
	}
	lock_task(sr_lock);
	sr_end_flag = 1;
	wakeup_task((int)&sr_end_flag);
	unlock_task(sr_lock,"");
}

void
reverse_thread(TKEY d)
{
STREAM * target;
char * buf;
int er;
int len;
	buf = d_alloc(SR_BUF_SIZE);
	target = (STREAM*)GET_TKEY(d);
	for ( ; ; ) {
		er = s_read(target,buf,SR_BUF_SIZE);
		if ( er <= 0 )
			break;
		if ( en_do(&len,s_write,get_target_stream(1),buf,er) <= 0 )
		  	break;
	}
	lock_task(sr_lock);
	sr_end_flag = 1;
	wakeup_task((int)&sr_end_flag);
	unlock_task(sr_lock,"");
}

void
sr_timeout_func()
{
	lock_task(sr_lock);
	sr_end_flag = 1;
	wakeup_task((int)&sr_end_flag);
	unlock_task(sr_lock,"");
}


void
activate_stream_routing(HOST_ADDR_EXT * dest,int ttl,int timeout_sec)
{
STREAM * target;
int cerr;
	cerr = 0; 
	target = connect_stream_routing(&cerr, dest, 1, ttl, timeout_sec);
	if ( target == 0 ) {
		if ( recv_streams ) {
			switch ( recv_streams_len ) {
			default:
				s_close(recv_streams[1]);
			case 1:
				s_close(recv_streams[0]);
			case 0:
				;
			}
		}
		sync_log();
#ifdef DEBUG
ss_printf("REJECT %i\n",cerr);
#endif
		return;
	}
	sr_end_flag = 0;
	create_task(forward_thread,(int)target,PRI_FETCH);
	create_task(reverse_thread,(int)target,PRI_FETCH);

	new_tick((void (*)(int))sr_timeout_func,-timeout_sec,0);

	lock_task(sr_lock);
	for ( ; sr_end_flag == 0 ; )  {
		sleep_task((int)&sr_end_flag,sr_lock);
		lock_task(sr_lock);
	}
	unlock_task(sr_lock,"");	

	switch ( recv_streams_len ) {
	default:
		s_close(recv_streams[1]);
	case 1:
		s_close(recv_streams[0]);
	case 0:
		;
	}
	s_close(target);
	
	sync_log();

}



XL_SEXP *
xl_ActivateStreamRouting(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
XL_SEXP * user;
char * _user,* p;
char * ttl,* timeout_sec;
HOST_ADDR_EXT dest;
	user = get_el(s,1);
	if ( get_type(user) != XLT_STRING )
		goto type_missmatch;
	_user = ln_copy_str(std_cm,user->string.data);
#ifdef DEBUG
ss_printf("user %s\n",_user);
#endif
	for ( p = _user ; *p && *p != ',' ; p ++ );
	if ( *p == 0 ) {
		ttl = "1";
		timeout_sec = "3600";
		goto next1;
	}
	*p = 0;
	p ++;
	ttl = p;
	for ( ; *p && *p != ',' ; p ++ );
	if ( *p == 0 ) {
		timeout_sec = "3600";
		goto next1;
	}
	*p = 0;
	p ++;
	timeout_sec = p;
next1:
	get_inet_addr(&dest,_user);
#ifdef DEBUG
ss_printf("ACTIVATE %s %s\n",ttl,timeout_sec);
#endif
	activate_stream_routing(&dest, atoi(ttl), atoi(timeout_sec));
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"ActivateStreamRouting"),
		0);
/*
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"ActivateStreamRouting"),
		n_get_string("invalid parameter(Attribute option required)"));
no_obj:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_OBJECT,
		l_string(std_cm,"ActivateStreamRouting"),
		n_get_string("no option that name"));
*/
}




XL_SEXP *
xl_StreamRouting(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * src,*dest,*gateway,*type;
char * e_msg;
int _type;
	e_msg = "src";
	src = get_sf_attribute(sf,l_string(std_cm,"src"));
	if ( src == 0 )
		goto inv_param;
	e_msg = "dest";
	dest = get_sf_attribute(sf,l_string(std_cm,"dest"));
	if ( dest == 0 )
		goto inv_param;
	e_msg = "type";
	type = get_sf_attribute(sf,l_string(std_cm,"type"));
	if ( type == 0 )
		goto inv_param;
	gateway = 0;
	if ( l_strcmp(type,l_string(std_cm,"reject")) == 0 ) {
		_type = SRIT_REJECT;
		goto next;
	}
	else if ( l_strcmp(type,l_string(std_cm,"direct")) == 0 ) {
		_type = SRIT_DIRECT;
		goto next;
	}
	else if ( l_strcmp(type,l_string(std_cm,"proxy")) == 0 ) {
		_type = SRIT_PROXY;
	}
	else {
		goto inv_param;
	}
	e_msg = "gateway";
	gateway = get_sf_attribute(sf,l_string(std_cm,"gateway"));
	if ( gateway == 0 )
		goto inv_param;
	insert_stream_routing(n_string(std_cm,src), 
		n_string(std_cm,dest),n_string(std_cm,gateway),_type);
	return 0;
next:
	insert_stream_routing(n_string(std_cm,src), 
		n_string(std_cm,dest),0,_type);
	return 0;
/*
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"StreamRouting"),
		n_get_string(e_msg));
*/
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"StreamRouting"),
		List(n_get_string("invalid parameter"),
			n_get_string(e_msg),-1));
/*
no_obj:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_OBJECT,
		l_string(std_cm,"ActivateStreamRouting"),
		n_get_string("no option that name"));
*/
}








