/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___INCLUDE_H___
#define ___INCLUDE_H___

/* int for_each_file(char *path, int (*func)(char *)); */
#include <windows.h>

#ifndef INLINE
#ifdef MSC_VER
#define INLINE static __inline
#elif __GNUC__
#define INLINE static __inline__
#else
#define INLINE static
#endif
#endif

#ifndef _MAXNAMLEN
#define _MAXNAMLEN 260
#endif

struct dirent {
	long            d_ino; /* if dirent is valid, always 1 .otherwise 0 */
	int             d_off; /* always 0 */
	unsigned short  d_reclen; /* always sizeof(dirent) */
	char            *d_name;
};

typedef struct dir{
	HANDLE h;
	WIN32_FIND_DATA fd;
	struct  dirent de;
	unsigned char firsttime;
}DIR;

/*
struct direct {
     unsigned long d_ino;
	 unsigned short d_reclen;
	 unsigned short d_namlen;
	 char     d_name[_MAXNAMLEN + 1];
};
*/

DIR *opendir(const char *dirname);
int closedir(DIR *dirp);
struct dirent *readdir(DIR *dirp);

#define open64    open
#define lseek64    _lseeki64

#define INTEGER64 __int64

#define strcasecmp stricmp


#endif
