/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

/************************************

	machine dependent
	task system

*************************************/

#ifndef ___M_TASK_H___
#define ___M_TASK_H___

#include <windows.h>
#include <errno.h>
#define THREAD_BLOCK_SIZE       1000

#ifdef DEADLOCK_CHECK
typedef struct sem{
	HANDLE handle;
	LONG sem_count;
	struct sem * next;
	int level;
	int tid;
} sem_t;
#else
typedef struct {
	HANDLE handle;
	LONG sem_count;
} sem_t;
#endif

#ifndef DEADLOCK_CHECK
typedef sem_t _SEM;
#endif

#ifdef DEADLOCK_CHECK
typedef struct _sem {
        struct sem *    next;
        int             level;
        int             tid;
        sem_t           s;
} _SEM;

#endif

typedef _SEM * SEM;


typedef struct rw_lock {
        SEM             lock;
        int             read_cnt;
} RW_LOCK;

typedef struct sw_hash {
        struct sw_hash *        next;
        unsigned int            key;
        int                     cnt;
        sem_t                   sem;
} SW_HASH;


typedef union thread_block {
        union thread_block * next;
        RW_LOCK         rw_lock;
        _SEM            sem;
        SW_HASH         sw_hash;
} THREAD_BLOCK;


typedef struct fifo_el {
        struct fifo_el *        next;
} FIFO_EL;

typedef struct fifo {
        SEM                     lock;
        int                     length;
        struct fifo_el *        head;
        struct fifo_el *        tail;
} FIFO;


typedef void * TKEY;
int GET_TKEY(TKEY);


void * new_block();
void free_block();

int sem_init(sem_t * sem, int pshared, unsigned int value);
int sem_wait(sem_t * sem);
int sem_trywait(sem_t * sem);
int sem_post(sem_t * sem);
int sem_destroy(sem_t * sem);
int get_tid();
int getpid();

/*
#define THREAD_BLOCK_SIZE       1000

#ifdef DEADLOCK_CHECK
typedef struct sem{
	HANDLE handle;
	LONG sem_count;
	struct sem * next;
	int level;
	int tid;
} sem_t;
#else
typedef struct {
	HANDLE handle;
	LONG sem_count;
} sem_t;
#endif


#if 0
int sem_getvalue(sem_t * sem, int * sval);
#endif

typedef sem_t * SEM;

typedef struct rw_lock {
	SEM		lock;
	int		read_cnt;
} RW_LOCK;


typedef struct sw_hash {
        struct sw_hash *        next;
        unsigned int            key;
        int                     cnt;
        sem_t                   sem;
} SW_HASH;


typedef union thread_block {
        union thread_block * next;
        RW_LOCK         rw_lock;
        _SEM            sem;
        SW_HASH         sw_hash;
} THREAD_BLOCK;

typedef struct fifo_el {
	struct fifo_el *	next;
} FIFO_EL;

typedef struct fifo {
	SEM			lock;
	int			length;
	struct fifo_el *	head;
	struct fifo_el *	tail;
} FIFO;


typedef void * TKEY;
int GET_TKEY(TKEY);

int sleep(int);
int usleep(int);
*/

#endif

