/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"acrp.h"

XL_SEXP * get_op();

int *
_get_cid(L_CHAR ** ret_pri,L_CHAR ** ret_body,MAP_PATH_TABLE * mpt)
{
int len,i;
MAP_PATH_TABLE * m;
int * ret;
XL_SEXP * r;
unsigned int reg;
L_CHAR * pri;
	len = 0;
	for ( m = mpt ; m ; m = m->next, len ++ ) {
		if ( m->id < 0 ) {
			ret = 0;
			goto end;
		}
	}
	if ( len == 0 ) {
		ret = 0;
		goto end;
	}
	ret = d_alloc(sizeof(int)*(len+1),234);
	ret[0] = len;
	for ( i = 1 , m = mpt ; m ; m = m->next , i ++ )
		ret[i] = m->id;
	if ( ret_pri ) {
		m = mpt;
		pri = 0;
		for ( i = 0 ; i < ACRP_SUBID_NOS ; i ++ ) {
			if ( m->ent[i].pri == 0 )
				continue;
			if ( m->ent[i].pri[0] == 0 )
				continue;
			if ( m->ent[i].dir[0].hops < 0 )
				continue;
			if ( pri == 0 ||
					l_strcmp(pri,m->ent[i].pri)
						> 0 ) {
				pri = m->ent[i].pri;
			}
		}
		if ( pri )
			*ret_pri = ll_copy_str(pri,145);
		else	*ret_pri = 0;
	}
	if ( ret_body ) {
		*ret_body = 0;
	}
end:
	return ret;
}


int *
get_cid(L_CHAR ** ret_pri,L_CHAR ** ret_body,L_CHAR * filename)
{
int * ret;
MAP_PATH_INFO * mpi;
	mpi = get_mpi(0,filename,MPI_READ);
	if ( mpi == 0 )
		return 0;
	if ( mpi->sts != MPIS_LOCAL ) {
		ret = 0;
		goto end;
	}
	ret = _get_cid(ret_pri,ret_body,mpi->mpt);
end:
	flush_mpi(mpi);
	return ret;
}


