/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#define STREAM_LIB

#include	"stream.h"
#include	"task.h"

extern SEM stream_lock;

int
s_write(STREAM * s,void * data,int len)
{
S_TABLE * tbl;
S_FILE_THREAD t;
int ret;
	lock_task(stream_lock);
	if ( s == 0 ) {
		unlock_task(stream_lock,"s_write");
		return -1;
	}
	if ( s->h.tbl == 0 ) {
		unlock_task(stream_lock,"s_write");
		return -1;
	}
	tbl = s->h.tbl;
	_s_insert_thread(s,&t);
	unlock_task(stream_lock,"s_write");

	ret = (*tbl->write)(s,data,len);

	s_delete_thread(s,&t);

	return ret;
}


