/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"stream.h"
#include	"long_char.h"
#include	"xlerror.h"
#include	"xl.h"

XL_SEXP * xl_Parse();



void
init_Parse(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Parse"),
		get_func_prim(xl_Parse,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_Parse(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * arg;
STREAM * st;
XL_SEXP * ret;

	arg = get_el(s,1);
	switch ( get_type(arg) ) {
	case XLT_ERROR:
		return arg;
	case XLT_STRING:
		break;
	default:
		goto type_missmatch;
	}
	st = s_open_string_read(arg->string.data,&int_cm,
		l_strlen(arg->string.data)*sizeof(L_CHAR),1);
	ret = init_parse(st,
		l_string(std_cm,"Parse"),
		0);
	(*ret->h.file->cm->close)(0,ret->h.file->cm_work);
	ret->h.file->cm = &int_cm;
	ret->h.file->cm_work = (*ret->h.file->cm->open)();
	return ret;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Parse"),
		n_get_string("type missmatch"));
internal_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SYSTEM_INTERNAL,
		l_string(std_cm,"Parse"),
		n_get_string("shell argments initializing is required"));
}


