/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<math.h>
#include	"gbgraph.h"



int
lod_distance(GB_RECT * tr,GB_POINT pt)
{
REAL1 x,y,t1,t2,w,h;
	if ( inside_rect(tr,pt) == 1 )
		return 0;
	w = tr->br.x - tr->tl.x;
	h = tr->br.y - tr->tl.y;
	t1 = fabs(tr->tl.x - pt.x);
	t2 = fabs(tr->br.x - pt.x);
	if ( t1 < t2 )
		x = t1/w;
	else	x = t2/w;
	t1 = fabs(tr->tl.y - pt.y);
	t2 = fabs(tr->br.y - pt.y);
	if ( t1 < t2 )
		y = t1/h;
	else	y = t2/h;
	if ( x > y )
		return ceil(y);
	else	return ceil(x);
}


int
lod_select(int dist,int lod,int core)
{
int d;
	if ( dist <= core )
		return lod;
	d = (dist-core);
	return d*d + lod;
}