/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<string.h>
#include	<stdlib.h>
#include	"memory_debug.h"
#include	"utils.h"
#include	"gbparam.h"

int
get_url2(URL *	ret,
	L_CHAR * url,
	int no)
{
L_CHAR * buf;
L_CHAR * div;
L_CHAR * host;
L_CHAR *dir;
L_CHAR ch;
int p,len;
int er;

	er = 0;
	zero_url(ret);
	buf = ll_copy_str(url,no);
	len = l_strlen(url);
	div = nl_copy_str(std_cm,"://");
	for ( p = 0 ; p < len-3 ; p ++ )
		if ( memcmp(div,&buf[p],3*sizeof(L_CHAR)) == 0 ) {
			d_f_ree(div);
			goto match;
		}
	d_f_ree(div);
	ret->proto = 0;
	ret->server = 0;
	ret->port = 0;
	dir = buf;
	goto dir_res;
match:
	buf[p] = 0;
	ret->proto = ll_copy_str(buf,no);
	p += 3;
	host = &buf[p];
	for ( ; buf[p] && buf[p] != ':' && buf[p] != '/' ; p ++ );
	ch = buf[p];
	if ( (&buf[p]) == host ) {
		ret->server = 0;
		switch ( ch ) {
		case ':':
			er = -1;
			goto end;
		case '/':
			ret->port = 0;
			buf[p] = '/';
			dir = &buf[p];
			goto dir_res;
		case 0:
			ret->port = 0;
			ret->db = nl_copy_str(std_cm,"/");
			ret->resource = 0;
			goto end;
		}
	}
	buf[p] = 0;
	ret->server = ll_copy_str(host,no);
	switch ( ch ) {
	case 0:
		ret->port = 0;
		ret->db = nl_copy_str(std_cm,"/");
		ret->resource = 0;
		goto end;
	case ':':
		p ++;
		break;
	case '/':
		ret->port = 0;
		buf[p] = '/';
		dir = &buf[p];
		goto dir_res;
	}
port:
	ret->port = 0;
	for ( ; '0' <= buf[p] && buf[p] <= '9' ; p ++ )
		ret->port = ret->port*10 + buf[p] - '0';
	switch ( buf[p] ) {
	case 0:
		ret->db = nl_copy_str(std_cm,"/");
		ret->resource = 0;
		goto end;
	case '/':
		dir = &buf[p];
		goto dir_res;
	default:
		er = -1;
		goto end;
	}
dir_res:
	p = len = l_strlen(dir)-1;
	for ( ; p >= 0 ; p -- )
		if ( dir[p] == '/' )
			goto res;
	ret->db = 0;
	ret->resource = ll_copy_str(dir,no);
	goto end;
res:
	if ( len == p ) {
		ret->resource = 0;
		ret->db = ll_copy_str(dir,no);
	}
	else {
		ret->resource = ll_copy_str(&dir[p+1],no);
		dir[p+1] = 0;
		ret->db = ll_copy_str(dir,no);
	}
end:
	d_f_ree(buf);
	if ( ret->port == 0 && ret->proto ) {
		ret->port = get_wkp(ret->proto);
		if ( ret->port < 0 )
			ret->port = 0;
	}
	return er;
}

