/************************************

	machine dependent
	task routines

*************************************/

#if THREAD_DEBUG
#define THREAD_DEBUG_CUR
#endif

extern "C" {

#include	"task.h"
#include	"memory_debug.h"
#include	"LSemaphore.h"
#include	"LSimpleThread.h"
#include	"AppConstants.h"
#include	"utils.h"
void er_panic(char * str);
void sw_init();
void init_thread_block();

int (*int_handler)();
int task_init = 0;

void init_task(int)
{
	if ( task_init )
		return;
	task_init = 1;
	init_thread_block();
	sw_init();
/*
	create_task(lock_check_task,0,1);
*/
}

int
get_tid()
{
	return (int)LThread::GetCurrentThread();
}

#ifdef THREAD_DEBUG_CUR
class CSemaphore : public LSemaphore
{
  public:
	LThread* lock_thread;
	char lock_thread_name[256];
	char* lock_file;
	int lock_line;

	LThread* unlock_thread;
	char unlock_thread_name[256];
	char* unlock_file;
	int unlock_line;
};
#define LSemaphore CSemaphore
#endif

SEM new_lock(int)
{
	SEM ret = new LSemaphore;
	ret->Signal();
	return ret;
}

int close_lock(SEM s)
{
	delete s;
	return 0;
}


void _lock_task(SEM s, char file[], int line)
{
void DisplayAlert(char *msg);
int err;

	try {
#ifdef THREAD_DEBUG_MSG
retry:
		if ( (err = s->Wait(thMillsecDeadLock)) != noErr ) {
			if ( err == errSemaphoreTimedOut ) {
				char buffer[128];
				sprintf(buffer, "Thread Stervation - %s[tid:%x]",
					((LThread*)get_tid())->mName, get_tid());
				//DisplayAlert(buffer);
				printf("Semaphore - %x  ",s);
				printf("%s ",buffer);
				goto retry;
			} else {
				throw err;
			}
		}
#else

		if ( (err = s->Wait()) != noErr ) {
			throw err;
		}
		
#ifdef THREAD_DEBUG_CUR
		CSemaphore *cs = dynamic_cast<CSemaphore*>(s);
		if ( cs ) {
			cs->lock_thread = LThread::GetCurrentThread();
			strcpy(cs->lock_thread_name, cs->lock_thread->mName);
			cs->lock_file = file;
			cs->lock_line = line;
		}
#endif

#endif

	} catch(...) {
		er_panic("lock_task");
	}
}

void _unlock_task_f(SEM s, bool forceSwitch, char *file = 0, int line = 0)
{
	try {

#ifdef THREAD_DEBUG_CUR
		CSemaphore *cs = dynamic_cast<CSemaphore*>(s);
		if ( cs ) {
			cs->unlock_thread = LThread::GetCurrentThread();
			strcpy(cs->unlock_thread_name, cs->unlock_thread->mName);
			cs->unlock_file = file;
			cs->unlock_line = line;
		}
#endif

		s->Signal();
		if ( forceSwitch ) {
			UInt32 time = LThread::CurrentThreadTicks();
			if ( time > thTicksForceSwitch ) {
#ifdef THREAD_DEBUG_MSG
				printf("<<forcely yield : %s time = %d>>\n",
					LThread::GetCurrentThread()->mName, time);
#endif
				LThread::Yield();
			}
		}
	} catch(...) {
		er_panic("unlock_task");
	}
}

void _unlock_task(SEM s, char *msg, char *file, int line)
{
	_unlock_task_f(s, true, file, line);
}

typedef struct func_and_data
{
	void (*func)(void *);
	void *data;
} FUNC_AND_DATA;


void pass_data_to_task_func(LThread &thread,  void *fad)
{
#pragma unused(thread)
	FUNC_AND_DATA* fad2 = (FUNC_AND_DATA *)fad;
#ifdef THREAD_DEBUG_MSG
	printf("<Start! %s @%d>\n", thread.mName, TickCount()%1000);
#endif
	try {
		(*(fad2->func))(fad2->data);
	}
	catch(LException exc) {
		int err = exc.GetErrorCode();
		char msg[256];
		if ( exc.GetErrorString() ) {
			const char *msg2;
			msg2 = ((LStr255)exc.GetErrorString()).ConstTextPtr();
			sprintf(msg,"non caught exeption !!!\r %s (ID:%d)", msg2, err);
		}
		else
			sprintf(msg,"non caught exeption !!! - ID:%d", err);
		er_panic(msg);
	}
	catch(...) {
		er_panic("non caught exeption !!!");
	}
	close_thread_area();
	d_f_ree(fad2);
#ifdef THREAD_DEBUG_MSG
	printf("<Finish! %s @%d> -> (-Def)", thread.mName, TickCount()%1000);
#endif
}

int _create_task(void (*func)(), int data, int priority, char *name)
{
	FUNC_AND_DATA *fad = (FUNC_AND_DATA *)d_alloc(sizeof(FUNC_AND_DATA));
	fad->func = (void (*)(void *))func;
	fad->data = (void*)data;
	THREAD t = new LSimpleThread(pass_data_to_task_func, (void *)fad);
	t->SetPriority(priority);
	t->mName = name;
	t->Resume();
	return 0;
}


int GET_TKEY(TKEY ptr)
{
	return (int)ptr;
}


void rw_lock_init(RW_LOCK * rwl, int)
{
	rwl->lock = new_lock(0);
	rwl->cnt = 0;
}

void
read_lock(RW_LOCK * rwl)
{
	while ( rwl->cnt < 0 )
		sleep_task((int)rwl->lock ,0);
	if ( rwl->cnt == 0 )
		lock_task(rwl->lock);
	rwl->cnt++;
}

void
write_lock(RW_LOCK * rwl)
{
	lock_task(rwl->lock);
	if ( rwl->cnt != 0 )
		er_panic("write_lock");
	rwl->cnt = -1;
}

void
rwl_unlock(RW_LOCK * rwl)
{
	if ( rwl->cnt == 0 )
		er_panic("rwl_unlock");
	else if ( rwl->cnt > 0 ) {
		if ( --rwl->cnt == 0 )
			unlock_task(rwl->lock, "rwl_unlock(1)");
	} else {
		rwl->cnt = 0;
		unlock_task(rwl->lock, "rwl_unlock(2)");
		wakeup_task((int)rwl->lock);
	}
}

void
init_fifo(FIFO * f)
{
	f->head = f->tail = 0;
	f->lock = new_lock(0);
	f->length = 0;
}

void
insert_fifo(FIFO * f,FIFO_EL * e)
{
	lock_task(f->lock);
	e->next = 0;
	if ( f->head == 0 )
		f->head = f->tail = e;
	else {
		f->tail->next = e;
		f->tail = e;
	}
	f->length ++;
	unlock_task(f->lock,"insert_fifo");
}

FIFO_EL *
delete_fifo(FIFO * f)
{
FIFO_EL * ret;
	lock_task(f->lock);
	if ( f->head == 0 ) {
		ret = 0;
	}
	else {
		ret = f->head;
		f->head = ret->next;
		if ( f->head == 0 )
			f->tail = 0;
		f->length --;
	}
	unlock_task(f->lock,"delete_fifo");
	return ret;
}

void
change_pri(int tid, int pri)
{
	LThread* thread;
	if ( tid )
		thread = (LThread*)tid;
	else
		thread = LThread::GetCurrentThread();

	if ( thread )
		thread->SetPriority(pri);
}


int
get_pri(int tid)
{
	LThread* thread;
	if ( tid )
		thread = (LThread*)tid;
	else
		thread = LThread::GetCurrentThread();

	if ( thread )
		return thread->GetPriority();
	else
		return 0;
}


void
sleep_sec(int sec)
{
	try {
		LThread::GetCurrentThread()->Sleep(1000 * sec);
	}
	catch(int err) {
		char buf[256];
		sprintf(buf,"sleep_sec failure (ID=%d)",err);
		er_panic(buf);
	}
	catch(...) {
		er_panic("sleep_sec Failure");
	}
}

} //extern "C"