/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include <stdio.h>
#include "gbf.h"
#include "long_char.h"
#include "memory_debug.h"

extern int fontsize;
//#define DEBUG_PRINT

unsigned char *
gbf_write_char(L_CHAR c, VDISPLAY * disp, GBF_OFS * ofs, int * pos)
{
V_STRING_PIC p;
int w, h;
int i, j, type, len, flag;
unsigned char * pixmap, *ptr;
L_CHAR str[2]={c,0};

#ifdef DEBUG_PRINT
	printf("c = %x\t",c);
#endif
	
	if ( c == 0 ) {
		ofs->st_x = 0;
		ofs->st_y = 0;
		ofs->end_x = 0;
		ofs->end_y = 0;
		ofs->w = 0;
		ofs->type = 0;
		ofs->ofs = 0;
		return 0;
	}
	v_get_string_pic(&p, disp, str, 24, VSD_L2R);
	w = p.r.br.x - p.r.tl.x;
	h = p.r.br.y - p.r.tl.y;

#ifdef DEBUG_PRINT
	printf("(%d,%d)-(%d,%d) width = %d  ",p.r.tl.x, p.r.tl.y, p.r.br.x, p.r.br.y, p.width);
	printf("%d x %d  ", w, h);
	printf("pos = %d\n",*pos);

	for ( i = 0 ; i < h ; i++ ) {
		for ( j = 0 ; j < w ; j++ )
			printf("%c", p.pic[i*w+j] ? ' ' : 'o');
		printf("\n");
	}
#endif

	type = FT_SPACE;
	for ( i = 0 ; i < w*h ; i++ ) {
		if ( p.pic[i] != 0 && p.pic[i] != 255 ) {
			type = FT_GRAY;
			break;
		}
		if ( p.pic[i] == 0 )
			type = FT_BITMAP;
	}

	ofs->st_x = p.r.tl.x;
	ofs->st_y = p.r.tl.y;
	ofs->end_x = p.r.br.x;
	ofs->end_y = p.r.br.y;
	ofs->w = p.width;
	ofs->type = type;
	ofs->ofs = *pos;
	len = gbf_get_len(ofs);
	*pos += len;

	switch (type) {
	case FT_GRAY :
		pixmap = p.pic;
		break;
	case FT_BITMAP :
		ptr = pixmap = d_calloc(len,1);
		for ( i = 0 ; i < w*h ; ptr++ ) {
			for ( j = 7 ; j >= 0 && i < w*h ; i++, j-- )
				if ( p.pic[i] )
					*ptr |= 1 << j;
		}
		d_f_ree(p.pic);
		break;
	case FT_SPACE :
		d_f_ree(p.pic);
		pixmap = 0;
		break;
	}
	return pixmap;
}


void
gbf_load_a_font(
	VDISPLAY * disp,
	char * output_path,
	char * target_name,
	char * font_name,
	L_CHAR lcz,
	unsigned int nos)
{
char path[1000];
unsigned int i, pos, st_no, end_no, sp;
FILE * output_file;
GBF_HEADER * head;
GBF_OFS * ofs;
unsigned char ** pics;
 

 	if ( font_name == 0 )
 		return;

 	head = d_calloc(sizeof(*head),1);
 	ofs = d_alloc(sizeof(*ofs)*nos);
 	pics = d_alloc(sizeof(*pics)*nos);
 
	sprintf(path, "%s/%d/%s.gbf", output_path, fontsize, target_name);

	printf("output : %s\n", path);
	output_file = fopen(path,"w+");
	if ( output_file == 0 ) {
		perror("output");
		exit(1);
	}
	
	pos = 0;
	st_no = end_no = 1;
	for ( i = 1 ; i < nos ; i++ ) {
		pics[i] = gbf_write_char(lcz | i, disp, ofs+i, &pos);
		if ( pics[i] || ( ofs[i].w != 0 && ofs[i].w != ofs[i].end_y - ofs[i].st_y ) ) {
			if ( st_no == 1 )
				st_no = i;
			end_no = i;
		}
	}
	end_no ++;
	nos = end_no - st_no;
	sp = sizeof(GBF_HEADER) + sizeof(GBF_OFS) * nos;
	for ( i = st_no ; i < end_no ; i++ )
		ofs[i].ofs += sp;
	
	strcpy(head->signature, "GBFONT");
	strcpy(head->fontname, font_name);
	head->size = fontsize;
	head->st_no = st_no;
	head->end_no = end_no;
	head->nos = nos;
	
	printf("        range : %d-%d  nos : %d \n",st_no,end_no,nos);

	fwrite(head, sizeof(*head), 1, output_file);
	fwrite(ofs+st_no, sizeof(*ofs), nos, output_file);
	for ( i = st_no ; i < end_no ; i++ ) {
		if ( pics[i] ) {
			fwrite(pics[i], gbf_get_len(&ofs[i]), 1, output_file);
			d_f_ree(pics[i]);
		}
	}

	d_f_ree(head);
	d_f_ree(ofs);
	d_f_ree(pics);

//gbf_test(output_file);
	
	fclose(output_file);
}


void
gbf_load(int size, char * output_path)
{
VDISPLAY * disp;
VERROR er;
	fontsize = size;
	disp = v_open_disp(&er);

	gbf_load_a_font(disp, output_path, "jisx0201", 
			disp->jisx0201.fontname, LCZ_1BC_JISX0201, 256);
	gbf_load_a_font(disp, output_path, "jisx0208_1978", 
			disp->jisx0208_1978.fontname, LCZ_2BC_JISX0208_1978, 65536);
	gbf_load_a_font(disp, output_path, "jisx0208_1983", 
			disp->jisx0208_1983.fontname, LCZ_2BC_JISX0208_1983, 65536);
	gbf_load_a_font(disp, output_path, "jisx0208_1990", 
			disp->jisx0208_1990.fontname, LCZ_2BC_JISX0208_1990, 65536);
	gbf_load_a_font(disp, output_path, "jisx0212_1990", 
			disp->jisx0212_1990.fontname, LCZ_2BC_JISX0212_1990, 65536);

	gbf_load_a_font(disp, output_path, "iso8859_1", 
			disp->iso8859_1.fontname, LCZ_1BC_ISO8859_1, 256);
	gbf_load_a_font(disp, output_path, "iso8859_2", 
			disp->iso8859_2.fontname, LCZ_1BC_ISO8859_2, 256);
	gbf_load_a_font(disp, output_path, "iso8859_3", 
			disp->iso8859_3.fontname, LCZ_1BC_ISO8859_3, 256);
	gbf_load_a_font(disp, output_path, "iso8859_4", 
			disp->iso8859_4.fontname, LCZ_1BC_ISO8859_4, 256);
	gbf_load_a_font(disp, output_path, "iso8859_5", 
			disp->iso8859_5.fontname, LCZ_1BC_ISO8859_5, 256);
	gbf_load_a_font(disp, output_path, "iso8859_6", 
			disp->iso8859_6.fontname, LCZ_1BC_ISO8859_6, 256);
	gbf_load_a_font(disp, output_path, "iso8859_7", 
			disp->iso8859_7.fontname, LCZ_1BC_ISO8859_7, 256);
	gbf_load_a_font(disp, output_path, "iso8859_8", 
			disp->iso8859_8.fontname, LCZ_1BC_ISO8859_8, 256);
	gbf_load_a_font(disp, output_path, "iso8859_9", 
			disp->iso8859_9.fontname, LCZ_1BC_ISO8859_9, 256);
	gbf_load_a_font(disp, output_path, "iso8859_10", 
			disp->iso8859_10.fontname, LCZ_1BC_ISO8859_10, 256);
	gbf_load_a_font(disp, output_path, "iso8859_13", 
			disp->iso8859_13.fontname, LCZ_1BC_ISO8859_13, 256);
	gbf_load_a_font(disp, output_path, "iso8859_14", 
			disp->iso8859_14.fontname, LCZ_1BC_ISO8859_14, 256);
	gbf_load_a_font(disp, output_path, "iso8859_15", 
			disp->iso8859_15.fontname, LCZ_1BC_ISO8859_15, 256);
}
