/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<math.h>
#include	<string.h>
#include	"xl.h"
#include	"gbparam.h"
#include	"gbview.h"
#include	"win_flame.h"
#include	"pri_level.h"


extern GBVIEW_ENV env;

void exit_task();

void
_sleep_at_exit_task_wp(int flag)
{
	sleep_task((int)&env.exit_task_wp,env.wf_lock);
	if ( flag )
		lock_task(env.wf_lock);
}

void
_wakeup_at_exit_task_wp()
{
	if ( env.exit_task_wp == 0 ) {
		env.exit_task_wp = 1;
		create_task(exit_task,0,PRI_DRAW_EXIT);
	}
	wakeup_task((int)&env.exit_task_wp);
}

void
sleep_at_exit_task_wp()
{
	lock_task(env.wf_lock);
	_sleep_at_exit_task_wp(1);
	unlock_task(env.wf_lock,"sleep_at_exit_task_wp");
}

void
wakeup_at_exit_task_wp()
{
	lock_task(env.wf_lock);
	_wakeup_at_exit_task_wp();
	unlock_task(env.wf_lock,"sleep_at_exit_task_wp");
}

void
_sleep_at_redraw_wp(int flag)
{
	sleep_task((int)&env.redraw_wp,env.wf_lock);
	if ( flag )
		lock_task(env.wf_lock);
}

void
_wakeup_at_redraw_wp()
{
	wakeup_task((int)&env.redraw_wp);
}

void
sleep_at_redraw_wp()
{
	lock_task(env.wf_lock);
	_sleep_at_redraw_wp(1);
	unlock_task(env.wf_lock,"sleep_at_redraw_wp");
}

void
wakeup_at_redraw_wp()
{
	lock_task(env.wf_lock);
	_wakeup_at_redraw_wp();
	unlock_task(env.wf_lock,"sleep_at_redraw_wp");
}

void
load_task()
{
WIN_FLAME * wf;
int exe;
XL_INTERPRETER * xli;
int wid;

set_cpu_thr_type(30);
	for ( ; env.display == 0 ; )
		sleep_sec(1);


	lock_task(env.wf_lock);
	env.run_req_task_nos ++;
	unlock_task(env.wf_lock,"load_task");

	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);

start:


	wf = touch_wf();
	if ( wf == 0 ) {
		lock_task(env.wf_lock);
		if ( env.req_task_nos ) {
			unlock_task(env.wf_lock,"load_task");
			goto start;
		}
		env.run_req_task_nos --;
		unlock_task(env.wf_lock,"load_task");
		close_self_interpreter();
		return;
	}

	printf("load task start %i\n",get_tid());



retry:


ss_printf("****************** winflame %i %ls %x\n",get_tid(),
       get_url_str2(&wf->draw->h.entry),wf->flags);


	if ( wf->flags & WFF_FREE )
		goto end;

	switch ( win_flame_redraw(wf) ) {
	case 0:
		break;
	case 2:
		lock_task(env.wf_lock);
		if ( wf->flags & WFF_FREE ) {
			unlock_task(env.wf_lock,"load_task");
			goto end;
		}
		if ( _check_exit_flame() == 0 ) {
			unlock_task(env.wf_lock,"load_task");
			goto retry;
		}
		wid = wf->id;
		_win_unlock(wf);
		for ( ; _check_exit_flame() ; ) {
			_wakeup_at_exit_task_wp();
			_sleep_at_redraw_wp(1);

			if ( _get_wf_ptr(wid) != wf ) {
				unlock_task(env.wf_lock,"load_task");
				goto start;
			}
			if ( wf->flags & WFF_FREE ) {
				unlock_task(env.wf_lock,"load_task");
				goto start;
			}
		}
		if ( _get_wf_ptr(wid) != wf ) {
			unlock_task(env.wf_lock,"load_task");
			goto start;
		}
		if ( _win_lock(wf) < 0 ) {
			unlock_task(env.wf_lock,"load_task");
			goto start;
		}
		unlock_task(env.wf_lock,"load_task");
		goto retry;
	default:
		goto retry;
	}

ss_printf("****************** spiral end %i %x\n",get_tid(),wf);


end:


	win_unlock(wf);

	goto start;

}


void
exit_task()
{
WIN_FLAME * wf, * wf2;
XL_INTERPRETER * xli;
int fg;

	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);
	

set_cpu_thr_type(13);
	lock_task(env.wf_lock);
retry:
	fg = 0;
	for ( wf = env.flame ; wf ; ) {
		wf2 = wf->next;
		exit_lock_resource(wf->draw,1);
		_win_wlock(wf);
		exit_lock_resource(wf->draw,0);
		_ex_lock();
		if ( wf->flags & WFF_FREE ) {

printf("EXIT TASK\n");
			exit_win_flame(wf);
			wakeup_task((int)wf);
			_wakeup_at_exit_task_wp();
			_wakeup_at_redraw_wp();
if ( env.flame == 0 )
printf("EXIT NO FLAME!!!\n");
			_ex_unlock();
			fg = 1;
		}
		else {
			_ex_unlock();
			_win_unlock(wf);
		}
		wf = wf2;
	}
	if ( fg )
		goto retry;
	env.exit_task_wp --;
	unlock_task(env.wf_lock,"exit_task");

	close_self_interpreter();

}

void
change_task()
{
WIN_FLAME * wf;
int wfid;

set_cpu_thr_type(14);

	for ( ; ; ) {
		wf_check_resource();
		for ( wfid = get_next_wfid(0) ; wfid ; 
				wfid = get_next_wfid(wfid) ) {

			lock_task(env.wf_lock);
			wf = _get_wf_ptr(wfid);
			if ( _win_wlock(wf) < 0 ) {
				unlock_task(env.wf_lock,"change_task");
				continue;
			}
			unlock_task(env.wf_lock,"change_task");
			ex_lock(); 

			switch ( (wf->flags&(WFF_POLY|WFF_PLOT|WFF_LUSTER)) ) {
			case 0:
			case WFF_PLOT:
				change_win_flame(wf,0,WFT_PLOT);
				change_win_flame(wf,0,WFT_STD);
			}
			ex_unlock();
			win_unlock(wf);
		}
		sleep_sec(1);
	}
}
