/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"win_flame.h"
#include	"memory_debug.h"

extern GBVIEW_ENV env;

int
e2d_p_exit(WIN_FLAME * wf)
{
WIN_FLAME ** wfp;
RESOURCE * r;


	if ( !(wf->flags & WFF_FREE) ) {
		return 0;
	}
	if ( env.flame_base == wf ) {
		if ( _wf_set_current(wf,0) )
			assert_ls(LSF_CURRENT);
		else {
			env.flame_base = 0;
		}
	}
	free_mh(wf->mh);
	wf_free_si(wf);
	for ( wfp = &env.flame ; *wfp != wf ; wfp = &(*wfp)->next );
	if ( *wfp )
		*wfp = wf->next;
	wakeup_task((int)wf);
	wf_free_lock_list(wf);
	d_f_ree(wf);
	_wf_flame_redraw();
	call_gv_event(RID_INDICATED_COORD,l_string(std_cm,"hide"));
	call_gv_event(RID_HIDE_COORD,l_string(std_cm,"hide"));
	return 1;
}


int
e2d_p_move(WIN_FLAME * wf,VPOINT from,VPOINT to,VPOINT * ix)
{
	wf_move_si(wf,to.x - from.x, to.y - from.y);
	wf->flags |= WFF_PLOT_DIRTY;
	return 0;
}


int
e2d_p_change(
	WIN_FLAME_TABLE * tbl,
	WIN_FLAME * wf)
{
int i;
	switch ( wf->tbl->wf_type ) {
	case WFT_STD:
		d_f_ree(wf->pixels);
		wf->pixels = 0;
		break;
	case WFT_PLOT:
		break;
	default:
		er_panic("e2d_change not support");
	}
	wf->tbl = tbl;
	wf->draw->c.weight = W_E2D_PLOT;
	return 0;
}



int
_e2d_p_redraw(WIN_FLAME * wf)
{
int xx,yy,i;
int w,h;
MAP_HISTORY * mh;
WIN_FLAME * td, * _wf;
SURP_SET surp;
int id;
GB_RECT r;

	r.tl.x = r.tl.y = 0;
	r.br.x = env.win_width;
	r.br.y = env.win_height;

	lock_task(env.wf_lock);
set_t_msg(62);


	if ( wf->flags & WFF_RESIZE ) {
		unlock_task(env.wf_lock,"wf_redraw_rect");
		return -2;
	}
	wf->mov_x = 0;
	wf->mov_y = 0;
	wf->mov_flag = 0;

	w = env.win_width;
	h = env.win_height;

	mh = add_mh(&env.flame_base_display_map,wf->mh);
	set_surp(&surp,&r,env.flame_base_resolution);
	map_from_flame(mh,surp.ptr,surp.reso,SURP_NOS);
	id = wf->id;
	unlock_task(env.wf_lock,"wf_redraw_rect");

	cache_image(wf->id,wf->draw,0,0,0,w*h,&r,mh,&surp,1,
		WFF_PLOT_DIRTY);

	lock_task(env.wf_lock);
set_t_msg(63);
	_wf = _get_wf_ptr(id);
	if ( _wf != wf )
		goto end;

	if ( wf->flags & WFF_RESIZE ) {
		free_mh(mh);
		unlock_task(env.wf_lock,"wf_redoraw_rect");
		return -2;
	}
	if ( wf->mov_flag )
		wf_free_si(wf);
	else	regulate_si(wf);

end:
	unlock_task(env.wf_lock,"wf_redoraw_rect");
	free_mh(mh);
	return 0;
}

int
e2d_p_redraw(WIN_FLAME * wf)
{
int ret;
	ret = 0;
	lock_task(env.wf_lock);
set_t_msg(64);
	wf->draw->c.weight = W_E2D_PLOT;
	if ( wf->flags & WFF_PLOT_DIRTY ) {
		wf->flags &= ~(WFF_PLOT_DIRTY|WFF_RESIZE);
		unlock_task(env.wf_lock,"e2d_p_redraw");
		_e2d_p_redraw(wf);
		ret = 1;
	}
	else	unlock_task(env.wf_lock,"e2d_p_redraw");
	return ret;
}

int
e2d_p_dirty(WIN_FLAME * wf,GB_RECT * r,int flags,int mode)
{
int i;
	if ( r ) {
		if ( r->tl.x > r->br.x ||
				r->tl.y > r->br.y )
			goto ok;
		if ( r->tl.x >= env.win_width )
			return 0;
		if ( r->br.x <= 0 )
			return 0;
		if ( r->tl.y >= env.win_height )
			return 0;
		if ( r->br.y <= 0 )
			return 0;
	}

ok:

	wf->flags |= flags & WFF_DIRTY;
	_wakeup_wf(wf);
	return 0;
}



int
e2d_p_zoom_etc(WIN_FLAME * wf,int w,int h,int * ix_x,int * ix_y)
{
extern int null_wf_spiral;

	wf_free_si(wf);
	wf->flags |= WFF_PLOT_DIRTY;
	return 0;
}

