/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<stdlib.h>
#include	"machine/u_math.h"
#include	"memory_debug.h"
#include	"gbview.h"
#include	"gbparam.h"
#include	"gbgraph.h"
#include	"lock_level.h"
#include	"routing.h"
#include	"win_flame.h"
#include	"viewindex.h"
#include	"pri_level.h"

GBVIEW_ENV env;

#define CURRENT_SWITCH_TIMERAG	2


void ov_default();
int null_wf_spiral;
void _wf_flame_redraw();
void _wf_set_redraw();


void check_flame_task();

void
init_win_flame()
{

	env.wf_lock = new_lock(LL_WF);
	env.seq = 1;
/*
	create_task(check_flame_task,0,0);
*/
}



void
check_flame_task()
{
WIN_FLAME * wf;
	for ( ; ; ) {
		sleep_sec(1);
		lock_task(env.wf_lock);
		ss_printf("CWF\n");
		for ( wf = env.flame ; wf ; wf = wf->next ) {
			if ( wf->mh == 0 )
				ss_printf(">> * ");
			else	ss_printf(">>   ");
			ss_printf("%ls ",
				get_url_str2(&wf->draw->h.entry));
			ss_printf("%i %x %i\n",wf->lock,wf->flags,wf->pri_adj);
		}
		unlock_task(env.wf_lock,"check_flame_task");
		gv_cpu_direct();
	}
}

int
_get_env_seq()
{
int ret;
	ret = env.seq ++;
	if ( env.seq < 1 )
		env.seq = 1;
	return ret;
}


int system_wfid;


void
wf_free_si(WIN_FLAME * wf)
{
SYMBOL_INDICATE * si;


	for ( ; wf->sym_i ; ) {
		si = wf->sym_i;
		wf->sym_i = si->next;
		if ( si->data )
			d_f_ree(si->data);
		if ( si->alpha )
			d_f_ree(si->alpha);
		if ( si->ref )
			d_f_ree(si->ref);
		if ( si->rect.tl.x == si->rect.br.x )
			delete_irq(si->rno,si->code);
		d_f_ree(si);
	}
}

int
_win_lock(WIN_FLAME * wf)
{
int id;
WF_LOCK_LIST * wfl;

retry:
	if ( wf->flags & WFF_FREE )
		return -1;
	if ( wf->aboat_count )
		return -1;
	if ( wf->lock >= 0 ) {
		wf->lock ++;

		wfl = d_alloc(sizeof(*wfl));
		wfl->next = wf->lock_list;
		wfl->tid = get_tid();
		wf->lock_list  = wfl;
	}
	else {
		id = wf->id;
		sleep_task((int)wf,env.wf_lock);
		lock_task(env.wf_lock);
		if ( _get_wf_ptr(id) == 0 )
			return -1;
		goto retry;
	}
	_wakeup_at_redraw_wp();
	return 0;
}

int
_win_wlock(WIN_FLAME * wf)
{
int id;
WF_LOCK_LIST * wfl;
	for ( ; wf->lock ; ) {
		id = wf->id;
		sleep_task((int)wf,env.wf_lock);
		lock_task(env.wf_lock);
set_t_msg(4);
		if ( _get_wf_ptr(id) == 0 )
			return -1;
	}
	wf->lock = -1;

	wfl = d_alloc(sizeof(*wfl));
	wfl->next = wf->lock_list;
	wfl->tid = get_tid();
	wf->lock_list  = wfl;

	_wakeup_at_redraw_wp();
	return 0;
}

void
_win_unlock(WIN_FLAME * wf)
{
WIN_FLAME * wf2;
WF_LOCK_LIST ** wflp, * wfl;
int tid;

	tid = get_tid();
	for ( wflp = &wf->lock_list ; *wflp ; wflp = &(*wflp)->next ) {
		if ( (*wflp)->tid != tid )
			continue;
		wfl = *wflp;
		*wflp = wfl->next;
		d_f_ree(wfl);
		goto ok;
	}
	return;
ok:
	if ( wf->lock == 0 )
		er_panic("_win_unlock");
	if ( wf->lock > 0 )
		wf->lock --;
	else 	wf->lock = 0;
	if ( wf->lock == 0 ) {
		wakeup_task((int)wf);
		_wakeup_at_redraw_wp();
	}
}

void
wf_free_lock_list(WIN_FLAME * wf)
{
WF_LOCK_LIST * wfl;
	for ( ; wf->lock_list ; ) {
		wfl = wf->lock_list;
		wf->lock_list = wfl->next;
		d_f_ree(wfl);
	}
}


int
win_lock(WIN_FLAME * wf)
{
int ret;
	lock_task(env.wf_lock);
	ret = _win_lock(wf);
	unlock_task(env.wf_lock,"win_lock");
	return ret;
}

int
win_wlock(WIN_FLAME * wf)
{
int ret;
	lock_task(env.wf_lock);
set_t_msg(6);
	ret = _win_wlock(wf);
	unlock_task(env.wf_lock,"win_wlock");
	return ret;
}

void
win_unlock(WIN_FLAME * wf)
{
	lock_task(env.wf_lock);
set_t_msg(7);
	_win_unlock(wf);
	unlock_task(env.wf_lock,"win_unlock");
}

void
_ex_lock()
{
WIN_FLAME * wf;

	for ( ; env.ex_lock ; ) {
		sleep_task((int)&env.ex_lock,env.wf_lock);
		lock_task(env.wf_lock);
set_t_msg(8);
	}
	env.ex_lock = 1;
}

void
_ex_unlock()
{
	env.ex_lock = 0;
	wakeup_task((int)&env.ex_lock);
}

void
ex_lock()
{
	lock_task(env.wf_lock);
set_t_msg(9);
	_ex_lock();
	unlock_task(env.wf_lock,"ex_lock");
}

void
ex_unlock()
{
	lock_task(env.wf_lock);
set_t_msg(10);
	_ex_unlock();
	unlock_task(env.wf_lock,"ex_lock");
}


int
_check_exit_flame()
{
WIN_FLAME * wf;
int ret;
	ret = 0;
	for ( wf = env.flame ; wf ; wf = wf->next )
		if ( wf->flags & WFF_FREE )
			ret ++;
	return ret;
}

void
_wakeup_wf(WIN_FLAME * wf)
{
void load_task();

	wf->flags |= WFF_DRAW_REQUEST;
	env.req_task_nos ++;
	if ( env.run_req_task_nos < LOAD_TASK_MAX )
		create_task(load_task,0,PRI_DRAW);
}

void
_reset_task_nos()
{
	env.req_task_nos --;
	if ( env.req_task_nos < 0 )
		env.req_task_nos = 0;
}

/*
void
reset_task_nos()
{
	lock_task(env.wf_lock);
	_reset_task_nos();
	unlock_task(env.wf_lock,"reset_task_nos");
}
*/

int
_get_new_wfid()
{
WIN_FLAME * wf;
retry:
	system_wfid ++;
	if ( system_wfid <= 0 )
		system_wfid = 1;
	for ( wf = env.flame ; wf ; wf = wf->next ) {
		if ( wf->id == system_wfid )
			goto retry;
	}
	return  system_wfid;
}

int
_get_next_wfid(int id)
{
WIN_FLAME * wf;
int ret;
	ret = 0;
	for ( wf = env.flame ; wf ; wf = wf->next ) {
		if ( wf->flags & WFF_FREE )
			continue;
		if ( id >= wf->id )
			continue;
		if ( ret == 0 || ret > wf->id )
			ret = wf->id;
	}
	return ret;
}

int
get_next_wfid(int id)
{
int ret;
	lock_task(env.wf_lock);
set_t_msg(12);
	ret = _get_next_wfid(id);
	unlock_task(env.wf_lock,"get_wfid_boudary");
	return ret;
}

WIN_FLAME * 
_get_wf_ptr(WF_ID id)
{
WIN_FLAME * wf;
	for ( wf = env.flame ; wf ; wf = wf->next )
		if ( wf->id == id )
			return wf;
	return 0;
}


int
wf_check_last(WF_ID id)
{
int ret;
WIN_FLAME * wf, * wf_id;
int cnt;
	lock_task(env.wf_lock);
set_t_msg(13);
	if ( id == 0 ) {
		if ( env.flame == 0 || env.flame->next == 0 )
			ret = 1;
		else {
			cnt = 0;
			for ( wf = env.flame; wf ; wf = wf->next )
				if ( !(wf->flags & WFF_FREE) )
					cnt ++;
			if ( cnt == 0 )
				ret = 1;
			else	ret = 0;
		}
	}
	else {
		if ( env.flame == 0 )
			ret = 1;
		else  {
			wf_id = 0;
			cnt = 0;
			for ( wf = env.flame; wf ; wf = wf->next ) {
				if ( !(wf->flags & WFF_FREE) ) {
					cnt ++;
					wf_id = wf;
				}
			}
			if ( wf_id->id == id && cnt == 1 )
				ret = 1;
			else	ret = 0;
		}
	}
	unlock_task(env.wf_lock,"wf_check_last");
	return ret;
}


WF_ID
wf_get(int no)
{
WF_ID ret;
WIN_FLAME * wf;
	lock_task(env.wf_lock);
set_t_msg(14);


	for ( wf = env.flame ; wf && no > 0 ; wf = wf->next , no -- );
	if ( wf == 0 )
		ret = 0;
	else	ret = wf->id;
	unlock_task(env.wf_lock,"wf_get");
	return ret;
}

void
insert_redraw_r(VRECT * r)
{


	if ( env.redraw_r.tl.x >= env.redraw_r.br.x ||
			env.redraw_r.tl.y >= env.redraw_r.br.y ) {
		env.redraw_r = *r;
		return;
	}
	if ( env.redraw_r.tl.x > r->tl.x )
		env.redraw_r.tl.x = r->tl.x;
	if ( env.redraw_r.tl.y > r->tl.y )
		env.redraw_r.tl.y = r->tl.y;
	if ( env.redraw_r.br.x < r->br.x )
		env.redraw_r.br.x = r->br.x;
	if ( env.redraw_r.br.y < r->br.y )
		env.redraw_r.br.y = r->br.y;
	if ( env.redraw_r.tl.x < 0 )
		env.redraw_r.tl.x = 0;
	if ( env.redraw_r.tl.y < 0 )
		env.redraw_r.tl.y = 0;
	if ( env.redraw_r.br.x >= env.win_width )
		env.redraw_r.br.x = env.win_width;
	if ( env.redraw_r.br.y >= env.win_height )
		env.redraw_r.br.y = env.win_height;
}

void
insert_redraw_gbr(GB_RECT * r)
{
VRECT rr;
	rr.tl.x = r->tl.x;
	rr.tl.y = r->tl.y;
	rr.br.x = r->br.x;
	rr.br.y = r->br.y;
	insert_redraw_r(&rr);
}


void
insert_vrect(VRECT * v,int x,int y)
{
	if ( v->tl.x >= v->br.x ) {
		v->tl.x = x;
		v->br.x = x+1;
		v->tl.y = y;
		v->br.y = y+1;
		return;
	}
	if ( v->tl.x > x )
		v->tl.x = x;
	if ( v->br.x <= x )
		v->br.x = x+1;
	if ( v->tl.y > y )
		v->tl.y = y;
	if ( v->br.y <= y )
		v->br.y = y+1;
}

void
set_redraw_rect(GB_RECT *r)
{
int xx,yy;
int xmax,ymax;
int xmin,ymin;
VRECT rr;

	if ( r->tl.x >= env.win_width )
		return;
	if ( r->tl.y >= env.win_height )
		return;
	if ( r->tl.x < 0 )
		xmin = 0;
	else	xmin = r->tl.x;
	if ( r->tl.y < 0 )
		ymin = 0;
	else	ymin = r->tl.y;
	if ( r->br.x >= env.win_width )
		xmax = env.win_width;
	else	xmax = r->br.x;
	if ( r->br.y >= env.win_height )
		ymax = env.win_height;
	else	ymax = r->br.y;

	rr.tl.x = xmin;
	rr.tl.y = ymin;
	rr.br.x = xmax;
	rr.br.y = ymax;
	insert_redraw_r(&rr);
	for ( xx = xmin ; xx < xmax ; xx ++ )
		for ( yy = ymin ; yy < ymax ; yy ++ )
			env.redraw[xx + env.win_width*yy] = RP_REDRAW;
	new_tick(_wf_set_redraw,0,0);
}


int
wf_insert_si(
	int		cmd,
	WF_ID		wfid,
	int 		rno,
	int		code,
	int		sub,
	GB_RECT * 	rect,
	unsigned int *	data,
	unsigned char *	alpha,
	int		flags,
	L_CHAR * 	ref)
{
SYMBOL_INDICATE * si;
int ret;
WIN_FLAME * wf;

	if ( wfid == 0 )
		return 0;
	lock_task(env.wf_lock);
set_t_msg(15);


	wf = _get_wf_ptr(wfid);
	if ( wf == 0 ) {
		unlock_task(env.wf_lock,"wf_insert_si");
		return 0;
	}

	for ( si = wf->sym_i ; si ; si = si->next ) {
		if ( si->rno != rno || si->code != code ||
			si->sub != sub )
			continue;
		ret = 1;
		if ( cmd == ISI_INFO )
			goto end;
		if ( rect )
			si->rect = *rect;
		set_redraw_rect(&si->rect);
		if ( data ) {
			if ( si->data )
				d_f_ree(si->data);
			si->data = data;
		}
		if ( alpha ) {
			if ( si->alpha )
				d_f_ree(si->alpha);
			si->alpha = alpha;
		}
		si->flags |= SIF_DRAW|SIF_NEW|flags;
		goto end;
	}
	ret = 0;
	if ( cmd == ISI_INFO )
		goto end2;
	si = d_alloc(sizeof(*si));
	si->rno = rno;
	si->code = code;
	si->sub = sub;
	si->flags = SIF_DRAW|SIF_NEW|flags;
	si->rect = *rect;
	si->data = data;
	si->alpha = alpha;
	if ( ref )
		si->ref = ll_copy_str(ref);
	else	si->ref = 0;
	si->next = wf->sym_i;
	wf->sym_i = si;
	set_redraw_rect(&si->rect);

end:
	switch ( cmd ) {
	case ISI_INSERT:
		break;
	case ISI_INFO:
		if ( rect )
			*rect = si->rect;
		break;
	}
end2:

	unlock_task(env.wf_lock,"wf_insert_si");
	return ret;
}

int
wf_space_check_si(
	WF_ID		wfid,
	int 		rno,
	int		code,
	int		sub,
	GB_RECT * 	rect,
	int		percent)
{
SYMBOL_INDICATE * si;
int ret;
REAL1 surf1,surf2;
REAL1 x,y,x_max,y_max,xx,yy;
WIN_FLAME * wf;

	x_max = rect->br.x - rect->tl.x;
	y_max = rect->br.y - rect->tl.y;
	surf1 = x_max*y_max;
	lock_task(env.wf_lock);
set_t_msg(16);


	wf = _get_wf_ptr(wfid);
	if ( wf == 0 ) {
		ret = -1;
		goto end;
	}
	ret = -1;
	for ( si = wf->sym_i ; si ; si = si->next ) {
		if ( si->rno == rno && si->code == code &&
			si->sub == sub )
			continue;
		if ( cross_rect_rect(rect,&si->rect) == 0 )
			continue;
		x = x_max;
		xx = rect->br.x - si->rect.tl.x;
		if ( xx < x )
			x = xx;
		xx = si->rect.br.x - rect->tl.x;
		if ( xx < x )
			x = xx;
		y = y_max;
		yy = rect->br.y - si->rect.tl.y;
		if ( yy < y )
			y = yy;
		yy = si->rect.br.y - rect->tl.y;
		if ( yy < y )
			y = yy;
		if ( x*y*100 >= percent*surf1 )
			goto end;
		surf2 = (si->rect.br.x - si->rect.tl.x)*
			(si->rect.br.y - si->rect.tl.y);
		if ( x*y*100 >= percent*surf2 )
			goto end;
	}
	ret = 0;
end:
	unlock_task(env.wf_lock,"wf_insert_si");
	return ret;
}

void
regulate_si(WIN_FLAME * wf)
{
SYMBOL_INDICATE * si;
	for ( si = wf->sym_i ; si ; si = si->next ) {
		if ( !(si->flags & SIF_NEW) )
			continue;
		si->flags &= ~SIF_NEW;
		si->rect.tl.x += wf->mov_x;
		si->rect.tl.y += wf->mov_y;
		si->rect.br.x += wf->mov_x;
		si->rect.br.y += wf->mov_y;
	}
}


void
_wf_redraw_si(WIN_FLAME * wf,int ow,int oh,
	int tl_x,int tl_y,int br_x,int br_y)
{
SYMBOL_INDICATE * si;
int x,y,i;
unsigned int cc,cc1,cc2,cc3,cc4,cc5;
int k,j;
unsigned char alpha;

#define SET_ALPHA(label) \
if ( si->alpha ) {			\
	alpha = si->alpha[i];		\
	switch ( alpha ) {		\
	case 255:			\
		continue;		\
	case 0:				\
		goto label;		\
	}				\
	cc1 = env.redraw_plane[y*ow+x];			\
	if ( cc1 == C_TRANSPARENT )			\
		cc1 = C_COLOR;				\
	cc5 = 0;						\
	for ( j = 0 ; j < 3 ; j ++ ) {				\
		cc2 = (cc>>(COL_BIT*j))&COL_MASK;		\
		cc3 = (cc1>>(COL_BIT*j))&COL_MASK;		\
		cc4 = (cc2*(256-alpha) + cc3*(alpha))>>8;	\
		cc5 |= cc4<<(COL_BIT*j);			\
	}							\
	cc = cc5;						\
}

	for ( si = wf->sym_i ; si ; si = si->next ) {
		if ( si->data == 0 || si->rect.tl.x == si->rect.br.x ||
					si->rect.tl.y == si->rect.br.y )
				continue;
/*
		if ( (si->flags & SIF_DRAW) ) {
			si->flags &= ~SIF_DRAW;
			i = 0;

			for ( y = si->rect.tl.y ; y < si->rect.br.y ; y ++ )
				for ( x = si->rect.tl.x ; x < si->rect.br.x ; 
						i ++ , x ++ ) {
					if ( x < 0 )
						continue;
					if ( y < 0 )
						continue;
					if ( x >= ow )
						continue;
					if ( y >= oh )
						continue;
					cc = si->data[i];
					if ( cc == C_TRANSPARENT )
						continue;
					if ( (env.redraw[y*ow+x]&
						(RP_REDRAW|RP_DIRTY))
						== 0  )
						continue;
					SET_ALPHA(next1);
				next1:
					env.redraw_plane[y*ow+x] = cc;
				}
			continue;
		}
*/
		if ( si->rect.tl.x >= br_x )
			continue;
		if ( si->rect.tl.y >= br_y )
			continue;
		if ( si->rect.br.x < tl_x )
			continue;
		if ( si->rect.br.y < tl_y )
			continue;
		si->flags &= ~SIF_DRAW;
		i = 0;
		for ( y = si->rect.tl.y ; y < si->rect.br.y ; y ++ )
			for ( x = si->rect.tl.x ; x < si->rect.br.x ; 
					i ++ , x ++ ) {
				if ( x < tl_x )
					continue;
				if ( y < tl_y )
					continue;
				if ( x >= br_x )
					continue;
				if ( y >= br_y )
					continue;
				cc = si->data[i];
				if ( cc == C_TRANSPARENT )
					continue;
				if ( (env.redraw[y*ow+x] &
					(RP_REDRAW|RP_DIRTY)) == 0 )
					continue;
				SET_ALPHA(next2);
			next2:
				env.redraw_plane[y*ow+x] = cc;
			}
	}
}

void
wf_redraw_si(int x,int y,int w,int h)
{
WIN_FLAME * wf;
int ow,oh;

	ow = env.win_width;
	oh = env.win_height;
	for ( wf = env.flame ; wf ; wf = wf->next )
		_wf_redraw_si(wf,ow,oh,x,y,x+w,y+h);
}

void
wf_wait_stable()
{
WIN_FLAME * wf;
	for ( ; ; ) {
		lock_task(env.wf_lock);
		for ( wf = env.flame ; wf ; wf = wf->next ) {
			if ( wf->flags & WFF_FREE )
				break;
		}
		if ( wf == 0 ) {
			unlock_task(env.wf_lock,"wf_wait_stable");
			break;
		}
		_sleep_at_exit_task_wp(0);
	}
}

void
_free_win_flame(WIN_FLAME * wf)
{
	wf->flags |= WFF_FREE;
ss_printf("FREE %ls\n",get_url_str2(&wf->draw->h.entry));
	_wakeup_at_exit_task_wp();
	_wakeup_at_redraw_wp();
}


void
wf_reset_active()
{
WIN_FLAME * wf;
	lock_task(env.wf_lock);
set_t_msg(18);


	for ( wf = env.flame ; wf ; wf = wf->next )
		wf->flags &= ~WFF_ACTIVE;
	unlock_task(env.wf_lock,"wf_reset_active");
}

void
wf_free_nonactive()
{
WIN_FLAME * wf;
	lock_task(env.wf_lock);
set_t_msg(19);


	for ( wf = env.flame ; wf ; wf = wf->next ) {
		if ( !(wf->flags & WFF_ACTIVE) )
			_free_win_flame(wf);
	}
	unlock_task(env.wf_lock,"wf_free_nonactive");
}

void
free_win_flame(WF_ID wfid)
{
WIN_FLAME * wf;

	lock_task(env.wf_lock);
set_t_msg(20);

	wf = _get_wf_ptr(wfid);
	if ( wf == 0 ) {
		unlock_task(env.wf_lock,"free_win_flame");
		return;
	}
	_free_win_flame(wf);
	unlock_task(env.wf_lock,"free_win_flame");
}


void
_wf_flame_redraw()
{
int i;
VRECT rr;
	rr.tl.x = rr.tl.y = 0;
	rr.br.x = env.win_width;
	rr.br.y = env.win_height;
	insert_redraw_r(&rr);
	for ( i = 0 ; i < env.win_height*env.win_width ; i ++ )
		env.redraw[i] = RP_REDRAW;
	new_tick(_wf_set_redraw,0,0);
}


void
_wf_set_redraw()
{
	if ( env.event )
		(*env.event)(ET_REDRAW);
}

WIN_FLAME *
_wf_get_current()
{
	return env.flame_base;
}

WF_ID
wf_get_current()
{
WF_ID ret;
WIN_FLAME * wf;
	lock_task(env.wf_lock);
set_t_msg(21);


	wf = _wf_get_current();

	if ( wf )
		ret = wf->id;
	else	ret = 0;
	unlock_task(env.wf_lock,"wf_get_current");
	return ret;
}

int
_wf_set_current(WIN_FLAME * now,WIN_FLAME * target)
{
WIN_FLAME * c, * wf;
MAP_HISTORY * base, * mh;
GB_POINT center,_center[3];
REAL1 reso,_reso[3];
REAL1 rotate;
int i;
REAL1 d,dd;
GB_POINT pp1,pp2;
REAL1 s;
REAL1 _t;
unsigned int now_t;

	if ( env.flame == 0 )
		return 0;

	if ( now && env.flame == now && now->next == 0 ) {
		return 0;
	}
	if ( target && target == env.flame_base )
		return 1;
	c = 0;
	now_t = get_xltime();
	calc_pitch(0); 
	for ( wf = env.flame ; wf ; wf = wf->next ) {
		if ( wf == env.flame_base )
			continue;
		if ( wf == now )
			continue;
		if ( wf->flags & WFF_FREE )
			continue;
		if ( target && wf != target )
			continue;
		if ( target == 0 && now_t - wf->out_base_time <
					CURRENT_SWITCH_TIMERAG )
			continue;
		d = env.win_width/2;
	retry:
		_center[0].y = _center[1].y = _center[2].y
				= env.win_height/2;
		_center[0].x = env.win_width/2;
		_center[1].x = env.win_width/2 + d;
		_center[2].x = env.win_width/2 - d;
		_reso[0] = _reso[1] = _reso[2] = 1;
		map_from_flame(&env.flame_base_display_map,_center,_reso,3);
		map_from_flame(wf->mh,_center,_reso,3);
		if ( _reso[0] < 0 )
			continue;
		if ( _reso[1] >= 0 ) {
			i = 1;
			pp1.x = d;
			pp1.y = 0;
		}
		else if ( _reso[2] >= 0 ) {
			i = 2;
			pp1.x = -d;
			pp1.y = 0;
		}
		else {
			d *= 0.5;
			goto retry;
		}
		dd = distance(_center[i],_center[0]);
		if ( dd == 0 ) {
			d *= 1.2;
			goto retry;
		}
		pp2 = p_sub(_center[i],_center[0]);
		s = asin(pp2.y / dd);
/*
		if ( pp2.x > 0 )
			rotate = s;
		else	rotate = s - M_PI;
*/
		if ( pp2.x > 0 )
			rotate = -s;
		else if ( pp2.y > 0 )
			rotate = - M_PI + s;
		else	rotate = M_PI + s;
		switch ( wf->draw->c.geometory_type & GT_A_MASK ) {
		case GT_A_X_FOR|GT_A_Y_FOR:
		case GT_A_X_REV|GT_A_Y_REV:
			rotate = - rotate;
		}
		c = wf;
		center = _center[0];
		reso = d / dd;
printf("*********SET  %f %f %f %f %f\n",reso,center.x,center.y,env.flame_base_rotate,rotate);
	}
	if ( c == 0 )
		return 0;
	if ( env.flame_base == c )
		er_panic("wf_set_current");
	base = rev_mh(c->mh);
	for ( wf = env.flame ; wf ; wf = wf->next ) {
		if ( wf == c ) {
			free_mh(c->mh);
			c->mh = 0;
			c->flags &= ~WFF_SHORT_MH;
		}
		else {
			mh = add_mh(base,wf->mh);
			mh = optimize_mh(mh);
			free_mh(wf->mh);
			wf->mh = mh;
			c->flags |= WFF_SHORT_MH;
		}
		_win_flame_dirty(wf,0,WFF_DIRTY,0);
	}

	if ( env.flame_base )
		env.flame_base->out_base_time = now_t;
	env.flame_base = c;
	env.flame_base_center = center;
	env.flame_base_rotate = rotate;
	env.flame_base_resolution = reso;
	c->in_base_time = now_t;
	calc_pitch(1);
	free_mh(base);
	return 1;
}

int
wf_set_current()
{
int ret;

	lock_task(env.wf_lock);
set_t_msg(22);


	ret = _wf_set_current(0,0);
	unlock_task(env.wf_lock,"wf_set_current");
	return ret;
}

int
wf_set_current_now(WIN_FLAME * now)
{
int ret;
	lock_task(env.wf_lock);
set_t_msg(23);


	ret = _wf_set_current(now,0);
	unlock_task(env.wf_lock,"wf_set_current_now");
	return ret;
}


int
wf_set_current_target(WF_ID id)
{
int ret;
WIN_FLAME * wf;
	lock_task(env.wf_lock);
	wf = _get_wf_ptr(id);
	if ( wf )
		ret = _wf_set_current(0,wf);
	else	ret = -1;
	unlock_task(env.wf_lock,"wf_set_current_target");
	return ret;
}


void
wf_move_redraw_x(int dx)
{
int x,y;
char * dest, * src;
unsigned long * rd, * rs;
VRECT rr;
	if ( dx == 0 )
		return;
	env.redraw_r.tl.x += dx;
	if ( env.redraw_r.tl.x < 0 )
		env.redraw_r.tl.x = 0;
	if ( env.redraw_r.tl.x >= env.win_width )
		env.redraw_r.tl.x = env.win_width;
	env.redraw_r.br.x += dx;
	if ( env.redraw_r.br.x < 0 )
		env.redraw_r.br.x = 0;
	if ( env.redraw_r.br.x >= env.win_width )
		env.redraw_r.br.x = env.win_width;

	if ( dx > 0 ) {
		rr.tl.x = rr.tl.y = 0;
		rr.br.x = dx;
		rr.br.y = env.win_height;
		insert_redraw_r(&rr);

		for ( y = 0 ; y < env.win_height ; y ++ ) {
			dest = &env.redraw[(y+1)*env.win_width];
			src = &env.redraw[(y+1)*env.win_width - dx];
			for ( x = env.win_width-dx ; x > 0 ; x -- ) {
				dest --;
				src --;
				*dest = *src;
			}
			dest = &env.redraw[y*env.win_width];
			for ( x = dx ; x > 0 ; x -- )
				*dest++ = RP_REDRAW;

			rd = &env.redraw_plane[(y+1)*env.win_width];
			rs = &env.redraw_plane[(y+1)*env.win_width - dx];
			for ( x = env.win_width-dx ; x > 0 ; x -- ) {
				rs --;
				rd --;
				*rd = *rs;
			}
			rd = &env.redraw_plane[y*env.win_width];
			for ( x = dx ; x > 0 ; x -- )
				*rd ++ = BACKGROUND_COLOR;
		}

	}
	else {
		rr.tl.x = env.win_width + dx;
		rr.tl.y = 0;
		rr.br.x = env.win_width;
		rr.br.y = env.win_height;
		insert_redraw_r(&rr);
		for ( y = 0 ; y < env.win_height ; y ++ ) {
			dest = &env.redraw[y*env.win_width];
			src = &env.redraw[y*env.win_width - dx];
			for ( x = env.win_width+dx ; x > 0 ; x -- )
				*dest ++ = *src ++;
			dest = &env.redraw[(y+1)*env.win_width + dx];
			for ( x = - dx ; x > 0 ; x -- )
				*dest++ = RP_REDRAW;

			rd = &env.redraw_plane[y*env.win_width];
			rs = &env.redraw_plane[y*env.win_width - dx];
			for ( x = env.win_width+dx ; x > 0 ; x -- )
				*rd ++ = *rs ++;
			rd = &env.redraw_plane[(y+1)*env.win_width + dx];
			for ( x = - dx ; x > 0 ; x -- )
				*rd++ = BACKGROUND_COLOR;
		}
	}
}

void
wf_move_redraw_y(int dy)
{
int x,y;
char * dest, * src;
unsigned long * rd, * rs;
VRECT rr;
	if ( dy == 0 )
		return;
	env.redraw_r.tl.y += dy;
	env.redraw_r.br.y += dy;
	if ( env.redraw_r.tl.y < 0 )
		env.redraw_r.tl.y = 0;
	if ( env.redraw_r.br.y < 0 )
		env.redraw_r.br.y = 0;
	if ( env.redraw_r.br.y >= env.win_height )
		env.redraw_r.br.y = env.win_height;
	if ( env.redraw_r.tl.y >= env.win_height )
		env.redraw_r.tl.y = env.win_height;
	if ( dy > 0 ) {
		rr.tl.x = rr.tl.y = 0;
		rr.br.x = env.win_width;
		rr.br.y = dy;
		insert_redraw_r(&rr);

		for ( y = env.win_height-1 ; y-dy >= 0 ; y -- ) {
			src = &env.redraw[(y-dy)*env.win_width];
			dest = &env.redraw[y*env.win_width];
			for ( x = 0 ; x < env.win_width ; x ++ )
				*dest++ = *src++;
		}
		dest = env.redraw;
		for ( y = 0 ; y < dy ; y ++ )
			for ( x = 0 ; x < env.win_width ; x ++ )
				*dest++ = RP_REDRAW;

		for ( y = env.win_height-1 ; y-dy >= 0 ; y -- ) {
			rs = &env.redraw_plane[(y-dy)*env.win_width];
			rd = &env.redraw_plane[y*env.win_width];
			for ( x = 0 ; x < env.win_width ; x ++ )
				*rd++ = *rs++;
		}
		rd = env.redraw_plane;
		for ( y = 0 ; y < dy ; y ++ )
			for ( x = 0 ; x < env.win_width ; x ++ )
				*rd++ = BACKGROUND_COLOR;
	}
	else {
		rr.tl.x = 0;
		rr.tl.y = env.win_height + dy;
		rr.br.x = env.win_width;
		rr.br.y = env.win_height;
		insert_redraw_r(&rr);

		for ( y = 0 ; y < env.win_height + dy ; y ++ ) {
			src = &env.redraw[(y-dy)*env.win_width];
			dest = &env.redraw[y*env.win_width];
			for ( x = 0 ; x < env.win_width ; x ++ )
				*dest++ = *src++;
		}
		dest = &env.redraw[(env.win_height+dy)*env.win_width];
		for ( y = 0 ; y < - dy ; y ++ )
			for ( x = 0 ; x < env.win_width ; x ++ )
				*dest ++ = RP_REDRAW;

		for ( y = 0 ; y < env.win_height + dy ; y ++ ) {
			rs = &env.redraw_plane[(y-dy)*env.win_width];
			rd = &env.redraw_plane[y*env.win_width];
			for ( x = 0 ; x < env.win_width ; x ++ )
				*rd++ = *rs++;
		}
		rd = &env.redraw_plane[(env.win_height+dy)*env.win_width];
		for ( y = 0 ; y < - dy ; y ++ )
			for ( x = 0 ; x < env.win_width ; x ++ )
				*rd ++ = BACKGROUND_COLOR;
	}
}

void
wf_wakeup()
{
WIN_FLAME * wf;
	lock_task(env.wf_lock);
set_t_msg(24);
	for ( wf = env.flame ; wf ; wf = wf->next ) {
		_wakeup_wf(wf);
	}
	unlock_task(env.wf_lock,"wf_wakeup");
}

void
set_map_xy(int dx,int dy)
{
MAP_HISTORY * mh;
GB_POINT ptr;
	mh = &env.flame_base_display_map;
	mh->d.ln.forward.org.x += dx;
	mh->d.ln.forward.org.y += dy;

	ptr.x = -dx;
	ptr.y = -dy;
	mh->d.ln.reverse.org
		= p_add(mh->d.ln.reverse.org,
			mp_mul(mh->d.ln.reverse.matrix,ptr));
}


int
wf_move_xy(VPOINT from,VPOINT to)
{
WIN_FLAME * wf;
GB_POINT d;
int rdm;
GB_RECT r1,r2;
SELECT_INDICATE * si;
int seq;
int dx,dy;

	dx = to.x - from.x;
	dy = to.y - from.y;

set_t_msg(252);
	set_map_xy(dx,dy);
set_t_msg(252);

	for ( wf = env.flame ; wf ; wf = wf->next ) {
		if ( wf->flags & WFF_FREE )
			continue;
set_t_msg(253);
		win_flame_move(wf,from,to,0);
set_t_msg(254);
	}
	for ( si = env.si ; si ; si = si->next ) {
		si->x += dx;
		si->y += dy;
	}
set_t_msg(255);
	wf_move_redraw_x(dx);
	wf_move_redraw_y(dy);
set_t_msg(256);
	assert_ls(LSF_MOVE);
set_t_msg(257);
	wakeup_win_manage();
set_t_msg(258);

	return _get_env_seq();
}


int
wf_move_globe(VPOINT from,VPOINT to)
{
WIN_FLAME * wf;
GB_POINT d,gb_from,gb_to;
int rdm;
SELECT_INDICATE * si;
int seq;
int dx,dy;
double radius;
RESOURCE * r;
int x,y,ix;
char * rp, * _rp;
unsigned long * rpp,* _rpp;
int w,h;
int er;
GLOBE_MOVE_T gt;
VPOINT * ixp;

	w = env.win_width;
	h = env.win_height;

	new_rotate_and_center(v2gb_point(from),v2gb_point(to));

	r = env.flame_base->draw;
	radius = conv_unit(&er,
			r->h.cu.uenv,
			env.flame_base_resolution,
			reso_c_unit(&r->h.cu),
			l_string(std_cm,"dot/rad"));

	gt.ix = d_alloc(sizeof(VPOINT)*w*h);
	gt.radius = radius;
	if ( wf_make_gmatrix_index(gt.ix,
			gb_from = v2gb_point(from),
			gb_to = v2gb_point(to),radius,w,h) < 0 ) {
		d_f_ree(gt.ix);
		return 0;
	}
	get_gmatrix(gt.rm,gb_from,gb_to,radius);

	for ( wf = env.flame ; wf ; wf = wf->next ) {
		if ( wf->flags & WFF_FREE )
			continue;
		win_flame_move(wf,from,to,&gt);
	}

	_wf_purge_select();

	_rp = rp = d_alloc(w*h);
	_rpp = rpp = d_alloc(sizeof(long)*w*h);
	ixp = gt.ix;
	for ( y = 0 ; y < h ; y ++ )
		for ( x = 0 ; x < w ; x ++ , ixp ++ , rp ++ , rpp ++ ) {
			if ( ixp->x < 0 )
				goto no_data;
			ix = ixp->x + ixp->y * w;
			*rp = env.redraw[ix];
			*rpp = env.redraw_plane[ix];
			continue;
		no_data:
			*rp = RP_REDRAW;
			*rpp = BACKGROUND_COLOR;
		}
	d_f_ree(gt.ix);
	d_f_ree(env.redraw);
	env.redraw = _rp;
	d_f_ree(env.redraw_plane);
	env.redraw_plane = _rpp;
	assert_ls(LSF_MOVE);
	wakeup_win_manage();

	return _get_env_seq();
}


int
wf_move(VPOINT from,VPOINT to)
{
int ret;
	lock_task(env.wf_lock);
set_t_msg(25);
	switch ( env.flame_base_display_map.type ) {
	case 0:
		ret = 0;
		break;
	case MHT_LINEAR:
set_t_msg(250);
		ret = wf_move_xy(from,to);
set_t_msg(251);
		break;
	case MHT_PP:
set_t_msg(252);
		ret = wf_move_globe(from,to);
set_t_msg(253);
		break;
	default:
		er_panic("wf_move");
	}
	unlock_task(env.wf_lock,"wf_move");
	new_tick(_wf_set_redraw,0,0);
	return ret;
}



void
wf_get_coordinate_info(L_CHAR ** name,int * rid,GB_POINT * ptr,int ptr_len)
{
WIN_FLAME * wf;
REAL1 * reso;
int i;
MAP_HISTORY * mh;
	lock_task(env.wf_lock);
set_t_msg(26);
	for ( wf = env.flame ; wf ; wf = wf->next ) {
		if ( wf->next == 0 )
			break;
	}
	if ( wf == 0 ) {
		*rid = 0;
		unlock_task(env.wf_lock,"wf_get_coordinate_info");
		return;
	}
	reso = d_alloc(sizeof(REAL1)*ptr_len);
	for ( i = 0 ; i < ptr_len ; i ++ )
		reso[i] = 1;
	mh = add_mh(&env.flame_base_display_map,wf->mh);

	map_from_flame(mh,ptr,reso,ptr_len);
	*name = get_url_str2(&env.flame_base->draw->h.entry);
	*rid = env.flame_base->draw->h.no;

	unlock_task(env.wf_lock,"wf_get_coordinate_info");
}


void
wf_im_zoom_proc(
	unsigned long *target,
	int w,int h,
	int *index_x,
	int *index_y)
{
unsigned long *buf;
int x,y,xx,yy,i;
	buf = d_alloc(sizeof(long)*w*h);
	i = 0;
	for ( y = 0 ; y < h ; y ++ )
		for ( x = 0 ; x < w ; x ++ ) {
			xx = index_x[x];
			yy = index_y[y];
			if ( xx < 0 || yy < 0 )
				buf[i] = C_TRANSPARENT;
			else	buf[i] = target[xx + yy*w];
			buf[i] |= C_DIRTY;
			i ++;
		}
	for ( i = 0 ; i < h*w ; i ++ )
		target[i] = buf[i];
	d_f_ree(buf);
}

int
wf_zoom(GBVIEW_PLANE * p,REAL1 zoom)
{
WIN_FLAME * wf;
int i;
unsigned long * buf;
int ow,oh;
GB_RECT r;
int * index_x, * index_y;
int len;
int ret;

	lock_task(env.wf_lock);
set_t_msg(27);


	env.flame_base_resolution *= zoom;

	ow = env.win_width;
	oh = env.win_height;
	index_x = d_alloc(sizeof(int)*ow);
	index_y = d_alloc(sizeof(int)*oh);
	wf_make_zoom_index(index_x,index_y,zoom,ow,oh);
	for ( wf = env.flame ; wf ; wf = wf->next ) {
		if ( wf->flags & WFF_FREE )
			continue;
		win_flame_zoom(wf,ow,oh,index_x,index_y);
		null_wf_spiral = 1;
		wf->mov_flag = 1;
		_wakeup_wf(wf);
	}

	wf_im_zoom_proc(env.redraw_plane,ow,oh,index_x,index_y);
	calc_pitch(0);

	len = env.win_width*env.win_height;
	for ( i = 0 ; i < len ; i ++ )
		env.redraw[i] = RP_DIRTY;

	ret = _get_env_seq();
	unlock_task(env.wf_lock,"wf_zoom_in");
	assert_ls(LSF_ZOOM);
	wakeup_win_manage();

	if ( p ) {
		p->h.type = GPT_ZOOM;
		p->h.seq = ret;
		p->z.index_x = index_x;
		p->z.index_y = index_y;
	} else {
		d_f_ree(index_x);
		d_f_ree(index_y);
	}
	new_tick(_wf_set_redraw,0,0);
	return ret;
}



void
_change_redraw()
{
char * p;
int w,h;
int i,x,y,dx,dy;
	w = env.win_width;
	h = env.win_height;

	env.redraw = d_re_alloc(env.redraw,w*h);
	env.redraw_plane = d_re_alloc(env.redraw_plane,w*h*sizeof(long));
	for ( i = 0 ; i < w*h ; i ++ )
		env.redraw[i] = 0;
	env.win_height = h;
	env.win_width = w;
}

void
_wf_change_size()
{
WIN_FLAME * wf;
int ret;

	_ex_lock();

	for ( wf = env.flame ; wf ; wf = wf->next ) {
		win_flame_resize(wf);
		wf->flags |= WFF_RESIZE;
		_wakeup_wf(wf);
	}
	calc_pitch(1);
	_change_redraw();

	new_tick(_wf_set_redraw,0,0);

	_ex_unlock();
}


unsigned long
select_color(unsigned long a,int x,int y)
{
SELECT_INDICATE * si;
unsigned long b,c1,c2,c3,c4;
int i;
	for ( si = env.si ; si ; si = si->next ) {
		if ( x < si->x )
			continue;
		if ( y < si->y )
			continue;
		if ( x >= si->x + si->w )
			continue;
		if ( y >= si->y + si->h )
			continue;
		b = si->pixels[(y-si->y)*si->w + x-si->x];
		if ( b & C_TRANSPARENT )
			continue;
		if ( a & C_TRANSPARENT ) {
			a = b;
			continue;
		}
		if ( si->t == 1 ) {
			a = b;
			continue;
		}
		if ( si->t == 0 )
			continue;
		if ( a == b ) {
			c4 = 0;
			for ( i = 0 ; i < 3 ; i ++ ) {
				c1 = ((a>>(COL_BIT*i))&COL_MASK)/4
					+ 0x400*3/4;
				if ( c1 > 0x400 )
					c1 = 0x3ff;
				c4 |= (c1<<(COL_BIT*i))&
					(COL_MASK<<(COL_BIT*i));
			}
			a = c4;
		}
		else	a = b;
	}
	return a;
}


void
copy_plane(GBVIEW_PLANE * p,unsigned long * plane)
{
unsigned long * sp, * dp;
int w,h;
int y_src,y_dest,y_max,x,x_ofs;

	w = p->r.r.br.x - p->r.r.tl.x;
	h = p->r.r.br.y - p->r.r.tl.y;

	p->r.plane = d_alloc(w*h*sizeof(unsigned long));

	y_max = p->r.r.br.y;
	y_dest = 0;
	x_ofs = p->r.r.tl.x;
	for ( y_src = p->r.r.tl.y ; y_src < y_max ; y_src ++ , y_dest ++ ) {
		sp = &plane[y_src*env.win_width + x_ofs];
		dp = &p->r.plane[y_dest*w];
		for ( x = 0 ; x < w ; x ++ )
			*dp ++ = *sp ++;
	}
}


int
__wf_redraw(GBVIEW_PLANE * p,int x,int y,int w,int h)
{
unsigned long cc,cc1,cc2,cc3;
WIN_FLAME * wf;
int ow,oh;
int i,j,k;
WIN_FLAME * td;

VRECT tar,rr;
int ix;
unsigned long * sp, * dp;
char * rp;
OV_ARG a;
int ret;

	p->r.plane = 0;
	p->r.r.tl.x = p->r.r.tl.y = 0;
	p->r.r.br.x = p->r.r.br.y = -1;

	ow = env.win_width;
	oh = env.win_height;

	if ( x < 0 ) {
		w = w + x;
		x = 0;
		if ( w <= 0 )
			return 0;
	}
	if ( x >= ow )
		return 0;
	if ( x + w >= ow )
		w = ow - x;

	if ( y < 0 ) {
		h = h + y;
		y = 0;
		if ( h <= 0 )
			return 0;
	}
	if ( y >= oh )
		return 0;
	if ( y + h >= oh )
		h = oh - y;

	tar = env.redraw_r;
	if ( tar.tl.x < x )
		tar.tl.x = x;
	if ( tar.tl.y < y )
		tar.tl.y = y;
	if ( tar.br.x > x+w )
		tar.br.x = x+w;
	if ( tar.br.y > y+h )
		tar.br.y = y+h;
	x = tar.tl.x;
	y = tar.tl.y;
	w = tar.br.x - tar.tl.x;
	h = tar.br.y - tar.tl.y;

	p->h.type = GPT_REDRAW;
	p->h.seq = 0;
	if ( w <= 0 || h <= 0 ) {
		tar.tl.x = tar.br.x = 0;
		tar.tl.y = tar.br.y = 0;
		p->r.r = tar;
		p->r.plane = 0;
		return 0;
	}

	for ( i = 0 ; i < ow*oh ; i ++ ) {
		if ( env.redraw[i] == 0 )
			continue;
		env.redraw_plane[i] = C_TRANSPARENT;
	}

	a.redraw = env.redraw;
	a.dest = env.redraw_plane;
	a.d_h = oh;
	a.d_w = ow;
	a.d_x = x;
	a.d_y = y;
	a.d_x_w = w;
	a.d_y_h = h;
	for ( wf = env.flame ; wf ; wf = wf->next ) {
		if ( wf->flags & WFF_FREE )
			continue;
		win_flame_overlay(wf,&a);

	}


	wf_redraw_si(x,y,w,h);

	for ( i = y ; i < y+h ; i ++ ) {
		ix = i*ow+x;
		rp = &env.redraw[ix];
		for ( j = 0 ; j < w ; j ++ )
			*rp ++ = 0;
	}

	rr = env.redraw_r;
	if ( tar.tl.x == rr.tl.x &&
			tar.tl.y == rr.tl.y &&
			tar.br.x == rr.br.x &&
			tar.br.y == rr.br.y ) {
		env.redraw_r.tl.x = 0;
		env.redraw_r.tl.y = 0;
		env.redraw_r.br.x = env.redraw_r.br.y = 0;
		goto last_handle;
	}
	if ( tar.tl.x == rr.tl.x && tar.tl.y == rr.tl.y &&
			tar.br.y == rr.br.y ) {
		env.redraw_r.tl.x = tar.br.x;
		goto last_handle;
	}
	if ( tar.tl.y == rr.tl.y &&
			tar.br.x == rr.br.x &&
			tar.br.y == rr.br.y ) {
		env.redraw_r.br.x = tar.tl.x;
		goto last_handle;
	}
	if ( tar.tl.x == rr.tl.x &&
			tar.tl.y == rr.tl.y &&
			tar.br.x == rr.br.x ) {
		env.redraw_r.tl.y = tar.br.y;
		goto last_handle;
	}
	if ( tar.tl.x == rr.tl.x &&
			tar.br.x == rr.br.x &&
			tar.br.y == rr.br.y ) {
		env.redraw_r.br.y = tar.tl.y;
		goto last_handle;
	}
last_handle:
	p->r.r = tar;
	if ( tar.tl.x == tar.br.x ||
			tar.tl.y == tar.br.y ) {
		p->r.plane = 0;
	}
	else {
		copy_plane(p,env.redraw_plane);
	}
	p->h.seq = ret = _get_env_seq();
	return ret;
}

int
wf_redraw(GBVIEW_PLANE * p,int x,int y,int w,int h)
{
int ret;

	lock_task(env.wf_lock);
set_t_msg(28);
	_ex_lock();

	ret = __wf_redraw(p,x,y,w,h);

	_ex_unlock();
	unlock_task(env.wf_lock,"wf_redraw");
	return ret;
}


WIN_FLAME *
touch_wf()
{
WIN_FLAME * wf, * ret_wf;
void wf_check_resource();
retry:

	lock_task(env.wf_lock);

retry2:
	_reset_task_nos();
	ret_wf = 0;
	for ( wf = env.flame ; wf ; wf = wf->next ) {
		if ( !(wf->flags & WFF_DRAW_REQUEST) )
			continue;
		if ( wf->flags & WFF_FREE )
			continue;
		if ( wf->lock )
			continue;
		ret_wf = wf;

	}
	if ( ret_wf ) {
		ret_wf->flags &= ~WFF_DRAW_REQUEST;
		if ( _win_lock(ret_wf) < 0 )
			goto retry2;
		unlock_task(env.wf_lock,"touch_wf");
		return ret_wf;
	}
	if ( env.req_task_nos )
		goto retry2;
	unlock_task(env.wf_lock,"touch_wf");
	return 0;
}

WF_ID
wf_search(RESOURCE * r)
{
WIN_FLAME * wf;
WF_ID ret;

	lock_task(env.wf_lock);
set_t_msg(30);


	for ( wf = env.flame ; wf ; wf = wf->next )
		if ( wf->draw == r ) {
			ret = wf->id;
			unlock_task(env.wf_lock,"wf_search");
			return ret;
		}
	unlock_task(env.wf_lock,"wf_search");
	return 0;
}



void
wf_indicate(GBVIEW_STATUS * sts,int x,int y,int button)
{
WIN_FLAME * wf;
MAP_HISTORY * mh;
GB_POINT p,org;
REAL1 reso;
INDICATE * in;
GET_POINT_WORK w;
int i,cnt;
SYMBOL_INDICATE * si;
RESOURCE * r;
OBJ * o;
int * no_list;
int no_cnt;
int sub,code;
int id;
void wf_init_status();

	if ( sts )
		wf_init_status(sts);

	lock_task(env.wf_lock);
set_t_msg(31);
	for ( in = env.indicate ; in ; in = in->next ) {
		in->status = 0;
	}
	unlock_task(env.wf_lock,"wf_indicate");
	clear_info();
	for ( cnt = 0 ; ; cnt ++ ) {
		lock_task(env.wf_lock);
set_t_msg(32);


		i = 0;
		for ( wf = env.flame ; wf && i < cnt ; wf = wf->next , i ++ );
		if ( wf == 0 ) {
			unlock_task(env.wf_lock,"wf_indicate");
			break;
		}
		id = wf->id;
		no_cnt = 0;
		if ( button == GPB_PRESS ) {
			for ( si = wf->sym_i ; si ; si = si->next ) {
				if ( !(si->flags & SIF_ANCOR) )
					continue;
				p.x = x;
				p.y = y;
				if ( inside_rect(&si->rect,p) == 0 )
					continue;
				if ( sts && si->ref ) {
printf("REFERENCE\n");
					sts->reference 
						= ll_copy_str(si->ref);
					sts->flags |= SF_REFERENCE;

					unlock_task(env.wf_lock,"set_change");
					clear_info();
					return;
				}
				no_cnt ++;
			}
			if ( no_cnt ) {
				no_list = d_alloc(no_cnt*2*sizeof(int));
				i = 0;
				for ( si = wf->sym_i ; si ; si = si->next ) {
					if ( !(si->flags & SIF_ANCOR) )
						continue;
					p.x = x;
					p.y = y;
					if ( inside_rect(&si->rect,p) == 0 )
						continue;
					no_list[2*i] = si->rno;
					no_list[2*i+1] = si->code;
					i ++;
				}
			}
			else	no_list = 0;
		}
		else	no_list = 0;
		mh = add_mh(&env.flame_base_display_map,
			wf->mh);
		p.x = x;
		p.y = y;
		org = p;
		reso = 1;

		map_from_flame(mh,&p,&reso,1);

		free_mh(mh);


		if ( reso < 0 ) {
			unlock_task(env.wf_lock,"wf_indicate");
			continue;
		}
		w.pt = p;
		w.org = org;
		w.button = button;
		unlock_task(env.wf_lock,"wf_indicate");

		for ( i = 0 ; i < no_cnt ; i ++ ) {
			r = search_resource_by_no(no_list[2*i]);
			if ( r == 0 )
				continue;
			code = no_list[2*i+1]&MAIN_CODE;
			for ( sub = 0 ; sub < USER_SUBCODE ; sub ++ ) {
				o = search_obj(r,code|sub);
				if ( o )
					break;
			}
			if ( o == 0 )
				continue;
			indicate_info_card(r,o);
		}
		if ( no_list )
			d_f_ree(no_list);
		lock_task(env.wf_lock);
set_t_msg(33);
		if ( _get_wf_ptr(id) )
			r = wf->draw;
		else r = 0;
		unlock_task(env.wf_lock,"wf_indicate");
		if ( r ) {
			get_point_resource(r,&w);
		}
	}
}


void
wf_lock_test(char * str)
{
	printf("%s...\n",str);
	lock_task(env.wf_lock);
set_t_msg(34);
	unlock_task(env.wf_lock,"wf_lock_test");
	printf("%s...OK\n",str);
}


void
_all_dirty_out()
{
WIN_FLAME * wf;
	for ( wf = env.flame ; wf ; wf = wf->next ) {
		if ( wf->flags & WFF_FREE )
			continue;
		wf->aboat_count ++;
		_wakeup_at_redraw_wp();
		_win_wlock(wf);
		wf_free_si(wf);
		_win_flame_dirty(wf,0,WFF_DIRTY,0);
		_win_unlock(wf);
		wf->aboat_count --;
		_wakeup_at_redraw_wp();
	}
}

void
all_dirty_out()
{
	lock_task(env.wf_lock);
set_t_msg(35);
	_all_dirty_out();
	unlock_task(env.wf_lock,"all_dirty_out");
}


REAL1
get_rad(GB_POINT p)
{
double d;
	d = sqrt(p.x*p.x + p.y*p.y);
	if ( d == 0 )
		return 0;
	if ( p.x > 0 )
		return acos(-p.y/d);
	else	return -acos(-p.y/d);
}

int
wf_goto_point(
	L_CHAR * url,
	GB_POINT ptr,
	REAL1 rotate,
	REAL1 reso)
{
URL u;
WIN_FLAME * wf;
RESOURCE * c;
WF_ID ret_wf;
unsigned long * pp;
int size;
int ses;
int er;

	get_url2(&u,url);
	if ( u.proto == 0 || u.db == 0 || u.server == 0 || u.resource == 0 )
		return 0;
	lock_task(env.wf_lock);
set_t_msg(36);

	for ( wf = env.flame ; wf ; wf = wf->next )
		if ( url_cmp_str(&wf->draw->h.entry,&u) == 0 )
			break;
	if ( wf == 0 ) {
	wf_0:
		unlock_task(env.wf_lock,"wf_goto_point");
		ses = open_session();
		c = load_resource(ses,&u,Q_PRI_RADAR);
		close_session(ses);
		if ( c == 0 ) {
			fprintf(stderr,"cannot load resource \"%s\"\n",
				n_string(std_cm,url));
			goto end;
		}
		lock_task(env.wf_lock);
set_t_msg(37);
		for ( wf = env.flame ; wf ; wf = wf->next )
			_free_win_flame(wf);
		unlock_task(env.wf_lock,"goto_point");
/*
		switch ( c->c.geometory_type & GT_T_MASK ) {
		case GT_T_2D:
			break;
		case GT_T_GLOBE_SUR:
			reso = conv_unit(&er,
					c->h.cu.uenv,
					reso,
					reso_c_unit(&c->h.cu),
					l_string(std_cm,"dot/rad"));
			break;
		default:
			er_panic("wf_goto_point");
		}
*/
		new_win_flame(&ret_wf,
			c->h.visible_resolution,
			c,0,ptr,rotate,reso);
		assert_ls(LSF_ZOOM);

		goto end;
	}
/*
	switch ( wf->draw->c.geometory_type & GT_T_MASK ) {
	case GT_T_2D:
		break;
	case GT_T_GLOBE_SUR:
		reso = conv_unit(&er,
				wf->draw->h.cu.uenv,
				reso,
				reso_c_unit(&wf->draw->h.cu),
				l_string(std_cm,"dot/rad"));
		break;
	default:
		er_panic("wf_goto_point");
	}
*/
	if ( wf->flags & WFF_FREE ) {
		unlock_task(env.wf_lock,"wf_goto_point");
		return 0;
	}
	if ( wf == env.flame_base ) {
		env.flame_base_resolution = reso;
		env.flame_base_rotate = rotate;
		env.flame_base_center = ptr;
	}
	else {
	GB_POINT ptr_list[2];
	REAL1 reso_list[2];
	GB_POINT a;
		if ( wf->flags & WFF_FREE ) {
			unlock_task(env.wf_lock,"wf_goto_point");
			return 0;
		}
		a.x = sin(rotate);
		a.y = - cos(rotate);
		ptr_list[0] = ptr;
		ptr_list[1] = p_add(ptr,a);
		reso_list[0] = reso;
		reso_list[1] = reso;
		map_from_resource(wf->mh,ptr_list,reso_list,2);
		if ( reso_list[0] < 0 )
			goto wf_0;
		if ( reso_list[1] < 0 ) {
			env.flame_base_resolution = reso_list[0];
			env.flame_base_center = ptr_list[0];
			env.flame_base_rotate = rotate;
		}
		else {
			env.flame_base_resolution = reso_list[0];
			env.flame_base_center = ptr_list[0];
			env.flame_base_rotate = get_rad(
				p_sub(ptr_list[1],ptr_list[0]));
		}
	}
	calc_pitch(1);
	_all_dirty_out();
	assert_ls(LSF_ZOOM);
	unlock_task(env.wf_lock,"wf_goto_point");
end:
	return 0;
}


void
_wf_select(GBVIEW_PLANE * p,OBJ * obj)
{
SELECT_WORK sw;
WIN_FLAME * wf;
SELECT_INDICATE * si;
int xx,yy,x1,y1,i;
MAP_HISTORY * mh;
int ow,oh;
unsigned long * buf;
unsigned int cc1,cc2;
VRECT tar;
int ret;


	tar.tl.x = 0;
	tar.tl.y = 0;
	tar.br.x = -1;
	tar.br.y = -1;
	ow = env.win_width;
	oh = env.win_height;
	buf = p->r.plane;

	for ( wf = env.flame ; wf ; wf = wf->next ) {
		sw.mh = add_mh(&env.flame_base_display_map,wf->mh);
		sw.select_obj = obj;
		sw.map = 0;
		sw.color.c = 0x3ff;
		sw.color.t = 1;
		sw.color.rev_t = 0;
		sw.width = env.win_width;
		sw.height = env.win_height;
		si = d_alloc(sizeof(*si));
		sw.si = si;
		si->pixels = 0;
		select_resource(wf->draw,&sw);
		if ( si->pixels ) {
			si->t = 0.4;
			si->rev_t = 1-si->t;
			si->next = env.si;
			env.si = si;

			y1 = 0;
			for ( yy = si->y ; ; yy ++ ) {
				if ( yy < 0 )
					continue;
				if ( yy >= si->y + si->h )
					break;
				if ( yy >= env.win_height )
					break;
				x1 = 0;
				for ( xx = si->x ; ; xx ++ ) {
					if ( xx < 0 )
						continue;
					if ( xx >= si->x + si->w )
						break;
					if ( xx >= env.win_width )
						break;
					if ( (xx&1) == (yy&1) ) {
						cc1 = select_color(
							C_TRANSPARENT,
							xx,yy);
						buf[yy*ow + xx] = cc1;
						insert_vrect(&tar,
							xx,yy);
					}
					x1 ++;
				}
				y1 ++;
			}
			break;
		}
		else {
			d_f_ree(si);
		}
	}
	marge_vrect(&p->r.r,&tar);
	return;
}



int
_wf_purge_select()
{
SELECT_INDICATE * si;
int xx,yy;
VRECT rr;

	if ( env.si == 0 )
		return -1;
	for ( ; env.si ; ) {
		si = env.si;
		env.si = si->next;
		if ( si->x < 0 )
			xx = 0;
		else	xx = si->x;
		rr.tl.x = si->x;
		rr.tl.y = si->y;
		rr.br.x = si->x + si->w;
		rr.br.y = si->y + si->h;
		insert_redraw_r(&rr);
		for ( ; ; xx ++ ) {
			if ( xx >= si->x + si->w )
				break;
			if ( xx >= env.win_width )
				break;
			if ( si->y < 0 )
				yy = 0;
			else	yy = si->y;
			for ( ; ; yy ++ ) {
				if ( yy >= si->y + si->h )
					break;
				if ( yy >= env.win_height )
					break;
				env.redraw[yy*env.win_width + xx]
					= RP_REDRAW;
			}
		}

		d_f_ree(si->pixels);
		d_f_ree(si);
	}
	return 0;
}

int
wf_purge_select()
{
int ret;
	lock_task(env.wf_lock);
set_t_msg(38);
	if ( _wf_purge_select() < 0 )
		ret = 0;
	else	ret = _get_env_seq();
	unlock_task(env.wf_lock,"wf_purge_select");
	return ret;
}


void
wf_check_resource()
{
WIN_FLAME * wf;
CHECK_WORK c;
int i;

	lock_task(env.wf_lock);
set_t_msg(39);
	for ( wf = env.flame ; wf ; wf = wf->next ) {
		for ( i = 0 ; i < RT_MAX ; i ++ ) {
			c.type[i] = 0;
			c.opt[i] = 0;
		}
		c.max_coord_level = 1;
		c.coord_level = 0;
		c.resource = 0;
		c.flags = 0;
		check_resource(wf->draw,&c);
		if ( c.type[RT_PIXEL_MAP_R64] )
			wf->flags |= WFF_LUSTER;
		else	wf->flags &= ~WFF_LUSTER;
		if ( c.opt[RT_DRAW_GB] & DGF_POLY )
			wf->flags |= WFF_POLY;
		if ( c.opt[RT_DRAW_GB] & (DGF_INFO|DGF_MARK) )
			wf->flags |= WFF_PLOT;

	}
	unlock_task(env.wf_lock,"wf_check_resource");
}



WF_ID 
search_wf(RESOURCE * r)
{
WIN_FLAME * wf;
CHECK_WORK c;
int i;
WF_ID ret;
	lock_task(env.wf_lock);
set_t_msg(40);


	for ( wf = env.flame ; wf ; wf = wf->next ) {
		for ( i = 0 ; i < RT_MAX ; i ++ ) {
			c.type[i] = 0;
			c.opt[i] = 0;
		}
		c.max_coord_level = 1;
		c.coord_level = 0;
		c.resource = r;
		c.flags = 0;
		check_resource(wf->draw,&c);
		if ( c.flags & CWF_RESOURCE )
			break;
	}
	if ( wf )
		ret = wf->id;
	else	ret = 0;
	unlock_task(env.wf_lock,"search_wf");
	return ret;
}



int
min_route_wf(int ses)
{
int cnt,i;
WIN_FLAME * wf;
L_CHAR * target, * org, * t;
MAP_HISTORY * mh;
MP_ROUTE * mpr;
URL u;
int ret;

	ret = 0;
	cnt = 0;
retry:
	lock_task(env.wf_lock);
set_t_msg(41);

	wf = _wf_get_current();
	if ( wf == 0 ) {
		unlock_task(env.wf_lock,"min_route_wf");
		return ret;
	}
	org = ll_copy_str(get_url_str2(&wf->draw->h.entry));

	i = cnt;
	for ( wf = env.flame ; wf && i ; wf = wf->next , i -- ) {
		if ( wf->mh == 0 )
			continue;
	}
	if ( wf == 0 ) {
		unlock_task(env.wf_lock,"min_route_wf");
		return ret;
	}
	target = ll_copy_str(get_url_str2(&wf->draw->h.entry));
	unlock_task(env.wf_lock,"min_route_wf");

	mpr = resolve_route(org,target,RR_WM_DIRECT_NO_WAIT);
	if ( mpr == 0 ) {
		goto flush_mpr2;
	}
	if ( mpr == MP_NO_ROUTE ) {
		ret = -1;
		goto flush_mpr2;
	}
	get_url2(&u,org);
	mh = get_mh_from_route(ses,&u,mpr);
	free_url(&u);
	if ( mh == MP_MH_NO_ROUTE ) {
		ret = -1;
		goto flush_mpr;
	}

	lock_task(env.wf_lock);
set_t_msg(42);


	wf = _wf_get_current();
	if ( wf == 0 ) {
		free_mh(mh);
		unlock_task(env.wf_lock,"min_route_wf");
		goto flush_mpr;
	}
	for ( wf = env.flame ; wf ; wf = wf->next ) {
		if ( wf->mh == 0 )
			continue;
		if ( l_strcmp(target,get_url_str2(&wf->draw->h.entry)) == 0 )
			break;
	}
	if ( wf == 0 ) {
		unlock_task(env.wf_lock,"min_route_wf");
		goto flush_mpr;
	}
	free_mh(wf->mh);
	wf->mh = optimize_mh(mh);
	unlock_task(env.wf_lock,"min_route_wf");

flush_mpr:
	flush_route(mpr);
flush_mpr2:
	d_f_ree(target);
	d_f_ree(org);

	cnt ++;
	goto retry;

}

RESOURCE *
wf_get_resource(WF_ID id)
{
RESOURCE * ret;
WIN_FLAME * wf;
	lock_task(env.wf_lock);
set_t_msg(43);


	wf = _get_wf_ptr(id);
	if ( wf == 0 ) {
		unlock_task(env.wf_lock,"wf_get_resource");
		return 0;
	}
	ret = wf->draw;
	unlock_task(env.wf_lock,"wf_get_resource");
	return ret;
}


void
wakeup_wf(WF_ID wfid)
{
WIN_FLAME * wf;
	lock_task(env.wf_lock);
set_t_msg(44);


	wf = _get_wf_ptr(wfid);
	if ( wf == 0 )
		goto end;
	_wakeup_wf(wf);
end:
	unlock_task(env.wf_lock,"wakeup_wf");
}

void
wf_set_rd_mode(WF_ID wfid,int mode)
{
WIN_FLAME * wf;
	lock_task(env.wf_lock);
set_t_msg(45);

	wf = _get_wf_ptr(wfid);
	if ( wf == 0 )
		goto end;
/*
	wf->rd_mode = mode;
*/
end:
	unlock_task(env.wf_lock,"wakeup_wf");
}

REAL1
get_radian(
	GB_POINT from,
	GB_POINT to)
{
REAL1 A,B;
double d,s,c;
GB_POINT center;
	center.x = env.win_width/2;
	center.y = env.win_height/2;
	from = p_sub(from,center);
	to = p_sub(to,center);
	d = sqrt(inner(from,from) * inner(to,to));
	A = inner(from,to)/d;
	B = (to.x * from.y - from.x * to.y)/d;
	if ( A > 1 )
		A = 1;
	else if ( A < -1 )
		A = -1;
	if ( B > 1 )
		B = 1;
	else if ( B < -1 )
		B = -1;
	c = acos(A);
	s = asin(B);
	if ( c < M_PI/2 )
		return s;
	if ( s < 0 )
		return -c;
	else	return c;
}



unsigned long *
_rotate_plane(
	unsigned long * plane,
	VPOINT * index)
{
unsigned long * ret, * rp;
int x,y;
	ret = d_alloc(sizeof(long)*env.win_width*env.win_height);
	rp = ret;
	for ( y = 0 ; y < env.win_height ; y ++ )
		for ( x = 0 ; x < env.win_width ; x++ ) {
			if ( index->x < 0 )
				*rp++ = BACKGROUND_COLOR_MID;
			else	*rp++ = 
				plane[index->x + index->y * env.win_width];
			index ++;
		}
	return ret;
}

int
wf_rotate(GB_POINT from,GB_POINT to)
{
int ret;
VPOINT * index;
unsigned long * plane, * pp;
int i;
WIN_FLAME * wf;

	if ( from.x == to.x && from.y == to.y )
		return 0;
	lock_task(env.wf_lock);
set_t_msg(46);
	index = d_alloc(sizeof(VPOINT)*env.win_width*env.win_height);
	wf_make_rotate_index(index,from,to,env.win_width,env.win_height);
	plane = _rotate_plane(env.redraw_plane,index);
	d_f_ree(env.redraw_plane);
	env.redraw_plane = plane;
	for ( i = 0 ; i < env.win_width * env.win_height ; i ++ )
		env.redraw[i] = 0;
	for ( wf = env.flame ; wf ; wf = wf->next ) {
		if ( wf->flags & WFF_FREE )
			continue;
		win_flame_rotate(wf,index);
		_wakeup_wf(wf);
	}
	d_f_ree(index);
	calc_pitch(0);
	env.flame_base_rotate -= get_radian(from,to);
	calc_pitch(1);

	ret = _get_env_seq();
	unlock_task(env.wf_lock,"rotate_fix");
	new_tick(_wf_set_redraw,0,0);
	return ret;
}



RESOURCE * 
_wf_get_mh(WIN_FLAME * wf,MAP_HISTORY ** mhp)
{
	*mhp = add_mh(&env.flame_base_display_map,wf->mh);
	return wf->draw;
}

RESOURCE *
wf_get_mh(WF_ID id,MAP_HISTORY ** mhp)
{
RESOURCE * ret;
WIN_FLAME * wf;
	lock_task(env.wf_lock);
set_t_msg(47);
	wf = _get_wf_ptr(id);
	if ( wf == 0 ) {
		unlock_task(env.wf_lock,"wf_get_mh");
		return 0;
	}
	ret = _wf_get_mh(wf,mhp);
	unlock_task(env.wf_lock,"wf_get_mh");
	return ret;
}


void
wf_insert_dirty_rect(RESOURCE * r,GB_RECT * d_rect,
	int flags,
	int ofs_w,int ofs_h)
{
SURP_SET ss;
WF_ID id;
MAP_HISTORY * mh;
RESOURCE * draw;
GB_RECT rct;
RESOURCE * map;
	id = search_wf(r);
	if ( id == 0 )
		return;
	set_surp(&ss,d_rect,1);
	draw = wf_get_mh(id,&mh);
	if ( draw == 0 )
		return;
	map = get_map_between2(r,draw);
	if ( map == 0 )
		return;
	map_conv_forward(map,ss.ptr,ss.reso,SURP_NOS);
	map_from_resource(mh,ss.ptr,ss.reso,SURP_NOS);
	rct = get_surp_rect(&ss,0);

	rct.tl.x -= ofs_w;
	rct.tl.y -= ofs_h;
	rct.br.x += ofs_w;
	rct.br.y += ofs_h;
	win_flame_dirty(id,&rct,flags,0);

	free_mh(mh);
}


int
_get_wf_pri(WIN_FLAME * wf)
{
WIN_FLAME * w;
int ret;
	if ( wf->flags & WFF_LUSTER ) {
		ret = 0;
		for ( w = env.flame ; 
			!(w->flags & WFF_FREE) &&
			w && w != wf ;
			w = w->next , ret -- );
		return ret + wf->pri_adj;
	}
	if ( wf->flags & WFF_POLY )
		return 1 + wf->pri_adj;
	return 2 + wf->pri_adj;
}

int
get_wf_priadj(WF_ID id)
{
WIN_FLAME * wf;
int ret;
	lock_task(env.wf_lock);
	wf = _get_wf_ptr(id);
	if ( wf == 0 ) {
		ret = -1;
		goto end;
	}
	ret = wf->pri_adj;
end:
	unlock_task(env.wf_lock,"get_wf_pri");
	return ret;
}

void
_ind_pri()
{
WIN_FLAME * wf;
int p;
	for ( wf = env.flame ; wf ; wf = wf->next ) {
		p = _get_wf_pri(wf);
		printf("(%x:%i:%i:%i)",wf->flags,p,wf->pri_adj,wf->lock);
	}
	printf("\n");
}


void
_set_pri_adj(WIN_FLAME * wf,int adj)
{
	wf->pri_adj = adj;
	_wakeup_at_redraw_wp();
}

void
set_pri_adj(int wfid,int adj)
{
WIN_FLAME * wf;
	lock_task(env.wf_lock);
	wf = _get_wf_ptr(wfid);
	if ( wf )
		_set_pri_adj(wf,adj);
	unlock_task(env.wf_lock,"set_pri_adj");
}


int
wf_button_action(OBJ * o,char * type)
{
WIN_FLAME * wf;
RESOURCE ** rlist;
int rlist_len,i;
int ret;

	if ( o == 0 || o->h.name == 0 )
		return 0;
	lock_task(env.wf_lock);
set_t_msg(49);
	rlist_len = 0;
	for ( wf = env.flame ; wf ; wf = wf->next ) {
		if ( wf->draw->c.button_action )
			rlist_len ++;
	}
	rlist = d_alloc(sizeof(RESOURCE*)*rlist_len);
	i = 0;
	for ( wf = env.flame ; wf ; wf = wf->next ) {
		if ( wf->draw->c.button_action )
			rlist[i++] = wf->draw;
	}
	unlock_task(env.wf_lock,"wf_button_action");

	ret = 0;
	for ( i = 0 ; i < rlist_len ; i ++ ) {
		if ( do_button_action(rlist[i],
				type,
				o->h.name) ) {
			ret = 1;
			goto end1;
		}
	}
end1:
	d_f_ree(rlist);
	return ret;
}

void
wf_status(GBVIEW_STATUS * e)
{
WIN_FLAME * wf;
int n;
int ret;
RESOURCE * r;
int er;
GBVIEW_LAYER_STATUS * ls, ** lsp;


	lock_task(env.wf_lock);
set_t_msg(50);

	wf_init_status(e);

	e->width = env.win_width;
	e->height = env.win_height;
	n = 0;
	for ( wf = env.flame ; wf ; wf = wf->next , n ++ );
	e->layer_nos = n;
	e->event = env.event;

	e->display = env.display;
	if ( env.flame_base )
		e->current = env.flame_base->id;
	else	e->current = 0;

	e->flags = SF_BASE;

	if ( env.flame_base ) {
		r = env.flame_base->draw;
		e->flame_base_resolution = env.flame_base_resolution;
		e->flame_base_display_map_type
			= env.flame_base_display_map.type;
		e->flame_base_unit = ll_copy_str(r->h.cu.unit);

		e->flags |= SF_RESOLUTION|SF_MAP_TYPE|SF_UNIT;

		if ( e->flame_base_display_map_type == MHT_PP ) {
			e->pp_radius = conv_unit(&er,
				r->h.cu.uenv,
				env.flame_base_resolution,
				reso_c_unit(&r->h.cu),
				l_string(std_cm,"dot/rad"));

			e->flags |= SF_PP_RADIUS;
		}
	}
	if ( env.flame ) {
		lsp = &e->layers;
		for ( wf = env.flame ; wf ; wf = wf->next ) {
			if ( wf->flags & WFF_FREE )
				continue;
			ls = d_alloc(sizeof(*ls));
			ls->id = wf->id;
			ls->entry_url = ll_copy_str(
				get_url_str2(&wf->draw->h.entry));
			ls->target_url = ll_copy_str(
				get_url_str2(&wf->draw->h.target));
			ls->next = 0;
			*lsp = ls;
			lsp = &ls->next;
		}
	}

	unlock_task(env.wf_lock,"wf_status");
	e->infolist = copy_infolist();
	e->indicate = copy_indicate();
}



int
wf_set_status(GBVIEW_STATUS * e)
{
int ret;
int change;
	lock_task(env.wf_lock);
set_t_msg(51);
	change = 0;
	if ( e->flags & SF_WIDTH ) {
		if ( env.win_width != e->width )
			change = 1;
		env.win_width = e->width;
	}
	if ( e->flags & SF_HEIGHT ) {
		if ( env.win_height != e->height )
			change = 1;
		env.win_height = e->height;
	}
	if ( e->flags & SF_EVENT )
		env.event = e->event;
	if ( e->flags & SF_DISPLAY )
		env.display = e->display;

	if ( change )
		_wf_change_size();
	ret = _get_env_seq();
	unlock_task(env.wf_lock,"wf_set_status");
	return ret;
}


int
_wf_click(GBVIEW_PLANE * gbp,INFO_LIST * lst);

void
_wf_click_func()
{
GBVIEW_PLANE gbp;
INFO_LIST * info;
int seq;

	lock_task(env.wf_lock);
set_t_msg(52);
	info = env.click_op_list;
	env.click_op_list = 0;
	unlock_task(env.wf_lock,"_wf_click_func");
	_wf_click(&gbp,info);
	if ( env.event )
		(*env.event)(ET_CLICK,&gbp);
	free_infolist(info);
}

void
wf_click_func()
{
	new_tick(_wf_click_func,0,0);
}

int
_wf_click(GBVIEW_PLANE * gbp,INFO_LIST * lst)
{
INFO_LIST * il, * il2;
GBVIEW_STATUS sts;
int seq;
int ow,oh;
unsigned long * buf;
int i;

	wf_status(&sts);

	if ( lst )
		il2 = il = lst;
	else	il2 = il = sts.infolist;

	for ( il = il2 ; il ; il = il->next ) {
		if ( wf_button_action(il->obj,"click") )
			goto next;
	}

	if ( invoke_indicate(wf_click_func) ) {
		lock_task(env.wf_lock);
set_t_msg(53);
		if ( env.click_op_list )
			free_infolist(env.click_op_list);
		sts.infolist = 0;
		env.click_op_list = il2;
		unlock_task(env.wf_lock,"_wf_click");

		wf_free_status(&sts);
		return 0;
	}

next:

	lock_task(env.wf_lock);
set_t_msg(54);
	ow = env.win_width;
	oh = env.win_height;
	gbp->r.r.tl.x = gbp->r.r.br.x = 0;
	gbp->r.r.tl.y = gbp->r.r.br.y = -1;
	gbp->r.plane = buf = d_alloc(sizeof(unsigned long)*ow*oh);
	gbp->h.type = GPT_REDRAW;
	for ( i = 0 ; i < ow*oh ; i ++ , buf ++ )
		*buf = C_TRANSPARENT;
	for ( il = il2 ; il ; il = il->next )
		_wf_select(gbp,il->obj);
	buf = gbp->r.plane;
	gbp->r.plane = 0;
/*
printf("CLICK TAR %i %i - %i %i\n",
gbp->r.r.tl.x,
gbp->r.r.tl.y,
gbp->r.r.br.x,
gbp->r.r.br.y);
*/
	if ( gbp->r.r.tl.x >= gbp->r.r.br.x ) {
		gbp->h.seq = seq = 0;
		gbp->h.type = 0;
		gbp->r.plane = 0;
		d_f_ree(buf);
	}
	else {
		copy_plane(gbp,buf);
		d_f_ree(buf);
		gbp->h.seq = seq = _get_env_seq();
	}

	unlock_task(env.wf_lock,"_wf_click");

	return seq;
}


int
wf_click(GBVIEW_STATUS * sts,GBVIEW_PLANE * p,int x,int y)
{

printf("CLICK 1\n");
	wf_indicate(sts,x,y,GPB_PRESS);
	return _wf_click(p,0);
}

unsigned int
_wf_insert_time(WIN_FLAME * wf)
{
	return wf->insert_time;
}

unsigned int
wf_insert_time(int wfid)
{
WIN_FLAME * wf;
unsigned int ret;
	lock_task(env.wf_lock);
	wf = _get_wf_ptr(wfid);
	if ( wf == 0 )
		ret = 0;
	else	ret = _wf_insert_time(wf);
	unlock_task(env.wf_lock,"wf_insert_time");
	return ret;
}
